goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__47162 = arguments.length;
switch (G__47162) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47164 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47164 = (function (f,blockable,meta47165){
this.f = f;
this.blockable = blockable;
this.meta47165 = meta47165;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47164.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47166,meta47165__$1){
var self__ = this;
var _47166__$1 = this;
return (new cljs.core.async.t_cljs$core$async47164(self__.f,self__.blockable,meta47165__$1));
}));

(cljs.core.async.t_cljs$core$async47164.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47166){
var self__ = this;
var _47166__$1 = this;
return self__.meta47165;
}));

(cljs.core.async.t_cljs$core$async47164.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47164.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47164.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async47164.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async47164.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta47165","meta47165",638188807,null)], null);
}));

(cljs.core.async.t_cljs$core$async47164.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47164.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47164");

(cljs.core.async.t_cljs$core$async47164.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async47164");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47164.
 */
cljs.core.async.__GT_t_cljs$core$async47164 = (function cljs$core$async$__GT_t_cljs$core$async47164(f__$1,blockable__$1,meta47165){
return (new cljs.core.async.t_cljs$core$async47164(f__$1,blockable__$1,meta47165));
});

}

return (new cljs.core.async.t_cljs$core$async47164(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__47180 = arguments.length;
switch (G__47180) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__47184 = arguments.length;
switch (G__47184) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__47187 = arguments.length;
switch (G__47187) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_49311 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49311) : fn1.call(null,val_49311));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49311) : fn1.call(null,val_49311));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__47190 = arguments.length;
switch (G__47190) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5752__auto__)){
var ret = temp__5752__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5752__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5752__auto__)){
var retb = temp__5752__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4648__auto___49319 = n;
var x_49320 = (0);
while(true){
if((x_49320 < n__4648__auto___49319)){
(a[x_49320] = x_49320);

var G__49321 = (x_49320 + (1));
x_49320 = G__49321;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47193 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47193 = (function (flag,meta47194){
this.flag = flag;
this.meta47194 = meta47194;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47193.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47195,meta47194__$1){
var self__ = this;
var _47195__$1 = this;
return (new cljs.core.async.t_cljs$core$async47193(self__.flag,meta47194__$1));
}));

(cljs.core.async.t_cljs$core$async47193.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47195){
var self__ = this;
var _47195__$1 = this;
return self__.meta47194;
}));

(cljs.core.async.t_cljs$core$async47193.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47193.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47193.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47193.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async47193.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta47194","meta47194",-922373474,null)], null);
}));

(cljs.core.async.t_cljs$core$async47193.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47193.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47193");

(cljs.core.async.t_cljs$core$async47193.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async47193");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47193.
 */
cljs.core.async.__GT_t_cljs$core$async47193 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async47193(flag__$1,meta47194){
return (new cljs.core.async.t_cljs$core$async47193(flag__$1,meta47194));
});

}

return (new cljs.core.async.t_cljs$core$async47193(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47198 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47198 = (function (flag,cb,meta47199){
this.flag = flag;
this.cb = cb;
this.meta47199 = meta47199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47200,meta47199__$1){
var self__ = this;
var _47200__$1 = this;
return (new cljs.core.async.t_cljs$core$async47198(self__.flag,self__.cb,meta47199__$1));
}));

(cljs.core.async.t_cljs$core$async47198.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47200){
var self__ = this;
var _47200__$1 = this;
return self__.meta47199;
}));

(cljs.core.async.t_cljs$core$async47198.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47198.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47198.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47198.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async47198.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta47199","meta47199",1176147084,null)], null);
}));

(cljs.core.async.t_cljs$core$async47198.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47198");

(cljs.core.async.t_cljs$core$async47198.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async47198");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47198.
 */
cljs.core.async.__GT_t_cljs$core$async47198 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async47198(flag__$1,cb__$1,meta47199){
return (new cljs.core.async.t_cljs$core$async47198(flag__$1,cb__$1,meta47199));
});

}

return (new cljs.core.async.t_cljs$core$async47198(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47202_SHARP_){
var G__47205 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47202_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47205) : fret.call(null,G__47205));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47203_SHARP_){
var G__47206 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47203_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47206) : fret.call(null,G__47206));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4160__auto__ = wport;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return port;
}
})()], null));
} else {
var G__49339 = (i + (1));
i = G__49339;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4160__auto__ = ret;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5754__auto__ = (function (){var and__4149__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4149__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5754__auto__)){
var got = temp__5754__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___49343 = arguments.length;
var i__4772__auto___49344 = (0);
while(true){
if((i__4772__auto___49344 < len__4771__auto___49343)){
args__4777__auto__.push((arguments[i__4772__auto___49344]));

var G__49345 = (i__4772__auto___49344 + (1));
i__4772__auto___49344 = G__49345;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__47211){
var map__47212 = p__47211;
var map__47212__$1 = cljs.core.__destructure_map(map__47212);
var opts = map__47212__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq47208){
var G__47209 = cljs.core.first(seq47208);
var seq47208__$1 = cljs.core.next(seq47208);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47209,seq47208__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__47215 = arguments.length;
switch (G__47215) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__47046__auto___49349 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47241){
var state_val_47242 = (state_47241[(1)]);
if((state_val_47242 === (7))){
var inst_47237 = (state_47241[(2)]);
var state_47241__$1 = state_47241;
var statearr_47244_49350 = state_47241__$1;
(statearr_47244_49350[(2)] = inst_47237);

(statearr_47244_49350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (1))){
var state_47241__$1 = state_47241;
var statearr_47245_49351 = state_47241__$1;
(statearr_47245_49351[(2)] = null);

(statearr_47245_49351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (4))){
var inst_47219 = (state_47241[(7)]);
var inst_47219__$1 = (state_47241[(2)]);
var inst_47221 = (inst_47219__$1 == null);
var state_47241__$1 = (function (){var statearr_47247 = state_47241;
(statearr_47247[(7)] = inst_47219__$1);

return statearr_47247;
})();
if(cljs.core.truth_(inst_47221)){
var statearr_47248_49353 = state_47241__$1;
(statearr_47248_49353[(1)] = (5));

} else {
var statearr_47249_49354 = state_47241__$1;
(statearr_47249_49354[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (13))){
var state_47241__$1 = state_47241;
var statearr_47250_49355 = state_47241__$1;
(statearr_47250_49355[(2)] = null);

(statearr_47250_49355[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (6))){
var inst_47219 = (state_47241[(7)]);
var state_47241__$1 = state_47241;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47241__$1,(11),to,inst_47219);
} else {
if((state_val_47242 === (3))){
var inst_47239 = (state_47241[(2)]);
var state_47241__$1 = state_47241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47241__$1,inst_47239);
} else {
if((state_val_47242 === (12))){
var state_47241__$1 = state_47241;
var statearr_47252_49356 = state_47241__$1;
(statearr_47252_49356[(2)] = null);

(statearr_47252_49356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (2))){
var state_47241__$1 = state_47241;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47241__$1,(4),from);
} else {
if((state_val_47242 === (11))){
var inst_47230 = (state_47241[(2)]);
var state_47241__$1 = state_47241;
if(cljs.core.truth_(inst_47230)){
var statearr_47253_49361 = state_47241__$1;
(statearr_47253_49361[(1)] = (12));

} else {
var statearr_47254_49362 = state_47241__$1;
(statearr_47254_49362[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (9))){
var state_47241__$1 = state_47241;
var statearr_47255_49363 = state_47241__$1;
(statearr_47255_49363[(2)] = null);

(statearr_47255_49363[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (5))){
var state_47241__$1 = state_47241;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47256_49364 = state_47241__$1;
(statearr_47256_49364[(1)] = (8));

} else {
var statearr_47257_49369 = state_47241__$1;
(statearr_47257_49369[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (14))){
var inst_47235 = (state_47241[(2)]);
var state_47241__$1 = state_47241;
var statearr_47258_49371 = state_47241__$1;
(statearr_47258_49371[(2)] = inst_47235);

(statearr_47258_49371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (10))){
var inst_47227 = (state_47241[(2)]);
var state_47241__$1 = state_47241;
var statearr_47260_49372 = state_47241__$1;
(statearr_47260_49372[(2)] = inst_47227);

(statearr_47260_49372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47242 === (8))){
var inst_47224 = cljs.core.async.close_BANG_(to);
var state_47241__$1 = state_47241;
var statearr_47261_49373 = state_47241__$1;
(statearr_47261_49373[(2)] = inst_47224);

(statearr_47261_49373[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_47262 = [null,null,null,null,null,null,null,null];
(statearr_47262[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_47262[(1)] = (1));

return statearr_47262;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_47241){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47241);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47263){var ex__46360__auto__ = e47263;
var statearr_47264_49376 = state_47241;
(statearr_47264_49376[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47241[(4)]))){
var statearr_47265_49377 = state_47241;
(statearr_47265_49377[(1)] = cljs.core.first((state_47241[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49378 = state_47241;
state_47241 = G__49378;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_47241){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_47241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47266 = f__47047__auto__();
(statearr_47266[(6)] = c__47046__auto___49349);

return statearr_47266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__47269){
var vec__47270 = p__47269;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47270,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47270,(1),null);
var job = vec__47270;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__47046__auto___49383 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47277){
var state_val_47278 = (state_47277[(1)]);
if((state_val_47278 === (1))){
var state_47277__$1 = state_47277;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47277__$1,(2),res,v);
} else {
if((state_val_47278 === (2))){
var inst_47274 = (state_47277[(2)]);
var inst_47275 = cljs.core.async.close_BANG_(res);
var state_47277__$1 = (function (){var statearr_47280 = state_47277;
(statearr_47280[(7)] = inst_47274);

return statearr_47280;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47277__$1,inst_47275);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0 = (function (){
var statearr_47282 = [null,null,null,null,null,null,null,null];
(statearr_47282[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__);

(statearr_47282[(1)] = (1));

return statearr_47282;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1 = (function (state_47277){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47277);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47283){var ex__46360__auto__ = e47283;
var statearr_47284_49386 = state_47277;
(statearr_47284_49386[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47277[(4)]))){
var statearr_47285_49387 = state_47277;
(statearr_47285_49387[(1)] = cljs.core.first((state_47277[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49388 = state_47277;
state_47277 = G__49388;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = function(state_47277){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1.call(this,state_47277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47286 = f__47047__auto__();
(statearr_47286[(6)] = c__47046__auto___49383);

return statearr_47286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__47287){
var vec__47288 = p__47287;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47288,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47288,(1),null);
var job = vec__47288;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4648__auto___49391 = n;
var __49392 = (0);
while(true){
if((__49392 < n__4648__auto___49391)){
var G__47292_49393 = type;
var G__47292_49394__$1 = (((G__47292_49393 instanceof cljs.core.Keyword))?G__47292_49393.fqn:null);
switch (G__47292_49394__$1) {
case "compute":
var c__47046__auto___49396 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49392,c__47046__auto___49396,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async){
return (function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = ((function (__49392,c__47046__auto___49396,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async){
return (function (state_47305){
var state_val_47306 = (state_47305[(1)]);
if((state_val_47306 === (1))){
var state_47305__$1 = state_47305;
var statearr_47308_49397 = state_47305__$1;
(statearr_47308_49397[(2)] = null);

(statearr_47308_49397[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47306 === (2))){
var state_47305__$1 = state_47305;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47305__$1,(4),jobs);
} else {
if((state_val_47306 === (3))){
var inst_47303 = (state_47305[(2)]);
var state_47305__$1 = state_47305;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47305__$1,inst_47303);
} else {
if((state_val_47306 === (4))){
var inst_47295 = (state_47305[(2)]);
var inst_47296 = process(inst_47295);
var state_47305__$1 = state_47305;
if(cljs.core.truth_(inst_47296)){
var statearr_47310_49402 = state_47305__$1;
(statearr_47310_49402[(1)] = (5));

} else {
var statearr_47311_49403 = state_47305__$1;
(statearr_47311_49403[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47306 === (5))){
var state_47305__$1 = state_47305;
var statearr_47312_49404 = state_47305__$1;
(statearr_47312_49404[(2)] = null);

(statearr_47312_49404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47306 === (6))){
var state_47305__$1 = state_47305;
var statearr_47313_49405 = state_47305__$1;
(statearr_47313_49405[(2)] = null);

(statearr_47313_49405[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47306 === (7))){
var inst_47301 = (state_47305[(2)]);
var state_47305__$1 = state_47305;
var statearr_47314_49411 = state_47305__$1;
(statearr_47314_49411[(2)] = inst_47301);

(statearr_47314_49411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49392,c__47046__auto___49396,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async))
;
return ((function (__49392,switch__46356__auto__,c__47046__auto___49396,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0 = (function (){
var statearr_47315 = [null,null,null,null,null,null,null];
(statearr_47315[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__);

(statearr_47315[(1)] = (1));

return statearr_47315;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1 = (function (state_47305){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47305);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47317){var ex__46360__auto__ = e47317;
var statearr_47318_49412 = state_47305;
(statearr_47318_49412[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47305[(4)]))){
var statearr_47319_49413 = state_47305;
(statearr_47319_49413[(1)] = cljs.core.first((state_47305[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49414 = state_47305;
state_47305 = G__49414;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = function(state_47305){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1.call(this,state_47305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__;
})()
;})(__49392,switch__46356__auto__,c__47046__auto___49396,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async))
})();
var state__47048__auto__ = (function (){var statearr_47322 = f__47047__auto__();
(statearr_47322[(6)] = c__47046__auto___49396);

return statearr_47322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
});})(__49392,c__47046__auto___49396,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async))
);


break;
case "async":
var c__47046__auto___49415 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49392,c__47046__auto___49415,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async){
return (function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = ((function (__49392,c__47046__auto___49415,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async){
return (function (state_47340){
var state_val_47341 = (state_47340[(1)]);
if((state_val_47341 === (1))){
var state_47340__$1 = state_47340;
var statearr_47343_49417 = state_47340__$1;
(statearr_47343_49417[(2)] = null);

(statearr_47343_49417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (2))){
var state_47340__$1 = state_47340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47340__$1,(4),jobs);
} else {
if((state_val_47341 === (3))){
var inst_47338 = (state_47340[(2)]);
var state_47340__$1 = state_47340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47340__$1,inst_47338);
} else {
if((state_val_47341 === (4))){
var inst_47328 = (state_47340[(2)]);
var inst_47329 = async(inst_47328);
var state_47340__$1 = state_47340;
if(cljs.core.truth_(inst_47329)){
var statearr_47346_49419 = state_47340__$1;
(statearr_47346_49419[(1)] = (5));

} else {
var statearr_47347_49420 = state_47340__$1;
(statearr_47347_49420[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (5))){
var state_47340__$1 = state_47340;
var statearr_47348_49421 = state_47340__$1;
(statearr_47348_49421[(2)] = null);

(statearr_47348_49421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (6))){
var state_47340__$1 = state_47340;
var statearr_47349_49423 = state_47340__$1;
(statearr_47349_49423[(2)] = null);

(statearr_47349_49423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (7))){
var inst_47335 = (state_47340[(2)]);
var state_47340__$1 = state_47340;
var statearr_47350_49424 = state_47340__$1;
(statearr_47350_49424[(2)] = inst_47335);

(statearr_47350_49424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49392,c__47046__auto___49415,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async))
;
return ((function (__49392,switch__46356__auto__,c__47046__auto___49415,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0 = (function (){
var statearr_47353 = [null,null,null,null,null,null,null];
(statearr_47353[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__);

(statearr_47353[(1)] = (1));

return statearr_47353;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1 = (function (state_47340){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47340);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47354){var ex__46360__auto__ = e47354;
var statearr_47355_49426 = state_47340;
(statearr_47355_49426[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47340[(4)]))){
var statearr_47356_49427 = state_47340;
(statearr_47356_49427[(1)] = cljs.core.first((state_47340[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49428 = state_47340;
state_47340 = G__49428;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = function(state_47340){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1.call(this,state_47340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__;
})()
;})(__49392,switch__46356__auto__,c__47046__auto___49415,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async))
})();
var state__47048__auto__ = (function (){var statearr_47362 = f__47047__auto__();
(statearr_47362[(6)] = c__47046__auto___49415);

return statearr_47362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
});})(__49392,c__47046__auto___49415,G__47292_49393,G__47292_49394__$1,n__4648__auto___49391,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47292_49394__$1)].join('')));

}

var G__49429 = (__49392 + (1));
__49392 = G__49429;
continue;
} else {
}
break;
}

var c__47046__auto___49430 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47393){
var state_val_47394 = (state_47393[(1)]);
if((state_val_47394 === (7))){
var inst_47389 = (state_47393[(2)]);
var state_47393__$1 = state_47393;
var statearr_47395_49434 = state_47393__$1;
(statearr_47395_49434[(2)] = inst_47389);

(statearr_47395_49434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (1))){
var state_47393__$1 = state_47393;
var statearr_47396_49435 = state_47393__$1;
(statearr_47396_49435[(2)] = null);

(statearr_47396_49435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (4))){
var inst_47374 = (state_47393[(7)]);
var inst_47374__$1 = (state_47393[(2)]);
var inst_47375 = (inst_47374__$1 == null);
var state_47393__$1 = (function (){var statearr_47399 = state_47393;
(statearr_47399[(7)] = inst_47374__$1);

return statearr_47399;
})();
if(cljs.core.truth_(inst_47375)){
var statearr_47400_49440 = state_47393__$1;
(statearr_47400_49440[(1)] = (5));

} else {
var statearr_47401_49441 = state_47393__$1;
(statearr_47401_49441[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (6))){
var inst_47379 = (state_47393[(8)]);
var inst_47374 = (state_47393[(7)]);
var inst_47379__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_47380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47381 = [inst_47374,inst_47379__$1];
var inst_47382 = (new cljs.core.PersistentVector(null,2,(5),inst_47380,inst_47381,null));
var state_47393__$1 = (function (){var statearr_47404 = state_47393;
(statearr_47404[(8)] = inst_47379__$1);

return statearr_47404;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47393__$1,(8),jobs,inst_47382);
} else {
if((state_val_47394 === (3))){
var inst_47391 = (state_47393[(2)]);
var state_47393__$1 = state_47393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47393__$1,inst_47391);
} else {
if((state_val_47394 === (2))){
var state_47393__$1 = state_47393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47393__$1,(4),from);
} else {
if((state_val_47394 === (9))){
var inst_47386 = (state_47393[(2)]);
var state_47393__$1 = (function (){var statearr_47406 = state_47393;
(statearr_47406[(9)] = inst_47386);

return statearr_47406;
})();
var statearr_47407_49442 = state_47393__$1;
(statearr_47407_49442[(2)] = null);

(statearr_47407_49442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (5))){
var inst_47377 = cljs.core.async.close_BANG_(jobs);
var state_47393__$1 = state_47393;
var statearr_47408_49443 = state_47393__$1;
(statearr_47408_49443[(2)] = inst_47377);

(statearr_47408_49443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (8))){
var inst_47379 = (state_47393[(8)]);
var inst_47384 = (state_47393[(2)]);
var state_47393__$1 = (function (){var statearr_47409 = state_47393;
(statearr_47409[(10)] = inst_47384);

return statearr_47409;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47393__$1,(9),results,inst_47379);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0 = (function (){
var statearr_47410 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47410[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__);

(statearr_47410[(1)] = (1));

return statearr_47410;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1 = (function (state_47393){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47393);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47411){var ex__46360__auto__ = e47411;
var statearr_47412_49444 = state_47393;
(statearr_47412_49444[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47393[(4)]))){
var statearr_47413_49445 = state_47393;
(statearr_47413_49445[(1)] = cljs.core.first((state_47393[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49447 = state_47393;
state_47393 = G__49447;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = function(state_47393){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1.call(this,state_47393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47418 = f__47047__auto__();
(statearr_47418[(6)] = c__47046__auto___49430);

return statearr_47418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


var c__47046__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47459){
var state_val_47460 = (state_47459[(1)]);
if((state_val_47460 === (7))){
var inst_47455 = (state_47459[(2)]);
var state_47459__$1 = state_47459;
var statearr_47464_49449 = state_47459__$1;
(statearr_47464_49449[(2)] = inst_47455);

(statearr_47464_49449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (20))){
var state_47459__$1 = state_47459;
var statearr_47465_49450 = state_47459__$1;
(statearr_47465_49450[(2)] = null);

(statearr_47465_49450[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (1))){
var state_47459__$1 = state_47459;
var statearr_47466_49451 = state_47459__$1;
(statearr_47466_49451[(2)] = null);

(statearr_47466_49451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (4))){
var inst_47421 = (state_47459[(7)]);
var inst_47421__$1 = (state_47459[(2)]);
var inst_47422 = (inst_47421__$1 == null);
var state_47459__$1 = (function (){var statearr_47467 = state_47459;
(statearr_47467[(7)] = inst_47421__$1);

return statearr_47467;
})();
if(cljs.core.truth_(inst_47422)){
var statearr_47468_49452 = state_47459__$1;
(statearr_47468_49452[(1)] = (5));

} else {
var statearr_47469_49453 = state_47459__$1;
(statearr_47469_49453[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (15))){
var inst_47434 = (state_47459[(8)]);
var state_47459__$1 = state_47459;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47459__$1,(18),to,inst_47434);
} else {
if((state_val_47460 === (21))){
var inst_47450 = (state_47459[(2)]);
var state_47459__$1 = state_47459;
var statearr_47471_49455 = state_47459__$1;
(statearr_47471_49455[(2)] = inst_47450);

(statearr_47471_49455[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (13))){
var inst_47452 = (state_47459[(2)]);
var state_47459__$1 = (function (){var statearr_47472 = state_47459;
(statearr_47472[(9)] = inst_47452);

return statearr_47472;
})();
var statearr_47473_49461 = state_47459__$1;
(statearr_47473_49461[(2)] = null);

(statearr_47473_49461[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (6))){
var inst_47421 = (state_47459[(7)]);
var state_47459__$1 = state_47459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47459__$1,(11),inst_47421);
} else {
if((state_val_47460 === (17))){
var inst_47445 = (state_47459[(2)]);
var state_47459__$1 = state_47459;
if(cljs.core.truth_(inst_47445)){
var statearr_47477_49466 = state_47459__$1;
(statearr_47477_49466[(1)] = (19));

} else {
var statearr_47478_49467 = state_47459__$1;
(statearr_47478_49467[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (3))){
var inst_47457 = (state_47459[(2)]);
var state_47459__$1 = state_47459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47459__$1,inst_47457);
} else {
if((state_val_47460 === (12))){
var inst_47431 = (state_47459[(10)]);
var state_47459__$1 = state_47459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47459__$1,(14),inst_47431);
} else {
if((state_val_47460 === (2))){
var state_47459__$1 = state_47459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47459__$1,(4),results);
} else {
if((state_val_47460 === (19))){
var state_47459__$1 = state_47459;
var statearr_47482_49471 = state_47459__$1;
(statearr_47482_49471[(2)] = null);

(statearr_47482_49471[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (11))){
var inst_47431 = (state_47459[(2)]);
var state_47459__$1 = (function (){var statearr_47484 = state_47459;
(statearr_47484[(10)] = inst_47431);

return statearr_47484;
})();
var statearr_47485_49475 = state_47459__$1;
(statearr_47485_49475[(2)] = null);

(statearr_47485_49475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (9))){
var state_47459__$1 = state_47459;
var statearr_47486_49476 = state_47459__$1;
(statearr_47486_49476[(2)] = null);

(statearr_47486_49476[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (5))){
var state_47459__$1 = state_47459;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47488_49477 = state_47459__$1;
(statearr_47488_49477[(1)] = (8));

} else {
var statearr_47489_49481 = state_47459__$1;
(statearr_47489_49481[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (14))){
var inst_47434 = (state_47459[(8)]);
var inst_47434__$1 = (state_47459[(2)]);
var inst_47438 = (inst_47434__$1 == null);
var inst_47439 = cljs.core.not(inst_47438);
var state_47459__$1 = (function (){var statearr_47493 = state_47459;
(statearr_47493[(8)] = inst_47434__$1);

return statearr_47493;
})();
if(inst_47439){
var statearr_47494_49482 = state_47459__$1;
(statearr_47494_49482[(1)] = (15));

} else {
var statearr_47495_49483 = state_47459__$1;
(statearr_47495_49483[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (16))){
var state_47459__$1 = state_47459;
var statearr_47496_49488 = state_47459__$1;
(statearr_47496_49488[(2)] = false);

(statearr_47496_49488[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (10))){
var inst_47428 = (state_47459[(2)]);
var state_47459__$1 = state_47459;
var statearr_47498_49492 = state_47459__$1;
(statearr_47498_49492[(2)] = inst_47428);

(statearr_47498_49492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (18))){
var inst_47442 = (state_47459[(2)]);
var state_47459__$1 = state_47459;
var statearr_47501_49493 = state_47459__$1;
(statearr_47501_49493[(2)] = inst_47442);

(statearr_47501_49493[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47460 === (8))){
var inst_47425 = cljs.core.async.close_BANG_(to);
var state_47459__$1 = state_47459;
var statearr_47503_49494 = state_47459__$1;
(statearr_47503_49494[(2)] = inst_47425);

(statearr_47503_49494[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0 = (function (){
var statearr_47505 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47505[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__);

(statearr_47505[(1)] = (1));

return statearr_47505;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1 = (function (state_47459){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47459);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47506){var ex__46360__auto__ = e47506;
var statearr_47507_49498 = state_47459;
(statearr_47507_49498[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47459[(4)]))){
var statearr_47510_49502 = state_47459;
(statearr_47510_49502[(1)] = cljs.core.first((state_47459[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49503 = state_47459;
state_47459 = G__49503;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__ = function(state_47459){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1.call(this,state_47459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46357__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47512 = f__47047__auto__();
(statearr_47512[(6)] = c__47046__auto__);

return statearr_47512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));

return c__47046__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__47517 = arguments.length;
switch (G__47517) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__47525 = arguments.length;
switch (G__47525) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__47534 = arguments.length;
switch (G__47534) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__47046__auto___49519 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47565){
var state_val_47566 = (state_47565[(1)]);
if((state_val_47566 === (7))){
var inst_47561 = (state_47565[(2)]);
var state_47565__$1 = state_47565;
var statearr_47570_49520 = state_47565__$1;
(statearr_47570_49520[(2)] = inst_47561);

(statearr_47570_49520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (1))){
var state_47565__$1 = state_47565;
var statearr_47571_49521 = state_47565__$1;
(statearr_47571_49521[(2)] = null);

(statearr_47571_49521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (4))){
var inst_47541 = (state_47565[(7)]);
var inst_47541__$1 = (state_47565[(2)]);
var inst_47542 = (inst_47541__$1 == null);
var state_47565__$1 = (function (){var statearr_47573 = state_47565;
(statearr_47573[(7)] = inst_47541__$1);

return statearr_47573;
})();
if(cljs.core.truth_(inst_47542)){
var statearr_47574_49522 = state_47565__$1;
(statearr_47574_49522[(1)] = (5));

} else {
var statearr_47576_49523 = state_47565__$1;
(statearr_47576_49523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (13))){
var state_47565__$1 = state_47565;
var statearr_47579_49524 = state_47565__$1;
(statearr_47579_49524[(2)] = null);

(statearr_47579_49524[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (6))){
var inst_47541 = (state_47565[(7)]);
var inst_47547 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47541) : p.call(null,inst_47541));
var state_47565__$1 = state_47565;
if(cljs.core.truth_(inst_47547)){
var statearr_47580_49525 = state_47565__$1;
(statearr_47580_49525[(1)] = (9));

} else {
var statearr_47581_49526 = state_47565__$1;
(statearr_47581_49526[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (3))){
var inst_47563 = (state_47565[(2)]);
var state_47565__$1 = state_47565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47565__$1,inst_47563);
} else {
if((state_val_47566 === (12))){
var state_47565__$1 = state_47565;
var statearr_47583_49527 = state_47565__$1;
(statearr_47583_49527[(2)] = null);

(statearr_47583_49527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (2))){
var state_47565__$1 = state_47565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47565__$1,(4),ch);
} else {
if((state_val_47566 === (11))){
var inst_47541 = (state_47565[(7)]);
var inst_47551 = (state_47565[(2)]);
var state_47565__$1 = state_47565;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47565__$1,(8),inst_47551,inst_47541);
} else {
if((state_val_47566 === (9))){
var state_47565__$1 = state_47565;
var statearr_47587_49528 = state_47565__$1;
(statearr_47587_49528[(2)] = tc);

(statearr_47587_49528[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (5))){
var inst_47544 = cljs.core.async.close_BANG_(tc);
var inst_47545 = cljs.core.async.close_BANG_(fc);
var state_47565__$1 = (function (){var statearr_47589 = state_47565;
(statearr_47589[(8)] = inst_47544);

return statearr_47589;
})();
var statearr_47590_49530 = state_47565__$1;
(statearr_47590_49530[(2)] = inst_47545);

(statearr_47590_49530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (14))){
var inst_47559 = (state_47565[(2)]);
var state_47565__$1 = state_47565;
var statearr_47592_49532 = state_47565__$1;
(statearr_47592_49532[(2)] = inst_47559);

(statearr_47592_49532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (10))){
var state_47565__$1 = state_47565;
var statearr_47595_49534 = state_47565__$1;
(statearr_47595_49534[(2)] = fc);

(statearr_47595_49534[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47566 === (8))){
var inst_47553 = (state_47565[(2)]);
var state_47565__$1 = state_47565;
if(cljs.core.truth_(inst_47553)){
var statearr_47596_49539 = state_47565__$1;
(statearr_47596_49539[(1)] = (12));

} else {
var statearr_47597_49540 = state_47565__$1;
(statearr_47597_49540[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_47599 = [null,null,null,null,null,null,null,null,null];
(statearr_47599[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_47599[(1)] = (1));

return statearr_47599;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_47565){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47565);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47602){var ex__46360__auto__ = e47602;
var statearr_47603_49544 = state_47565;
(statearr_47603_49544[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47565[(4)]))){
var statearr_47605_49546 = state_47565;
(statearr_47605_49546[(1)] = cljs.core.first((state_47565[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49547 = state_47565;
state_47565 = G__49547;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_47565){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_47565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47607 = f__47047__auto__();
(statearr_47607[(6)] = c__47046__auto___49519);

return statearr_47607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__47046__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47633){
var state_val_47634 = (state_47633[(1)]);
if((state_val_47634 === (7))){
var inst_47629 = (state_47633[(2)]);
var state_47633__$1 = state_47633;
var statearr_47638_49549 = state_47633__$1;
(statearr_47638_49549[(2)] = inst_47629);

(statearr_47638_49549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47634 === (1))){
var inst_47611 = init;
var inst_47612 = inst_47611;
var state_47633__$1 = (function (){var statearr_47639 = state_47633;
(statearr_47639[(7)] = inst_47612);

return statearr_47639;
})();
var statearr_47641_49550 = state_47633__$1;
(statearr_47641_49550[(2)] = null);

(statearr_47641_49550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47634 === (4))){
var inst_47615 = (state_47633[(8)]);
var inst_47615__$1 = (state_47633[(2)]);
var inst_47616 = (inst_47615__$1 == null);
var state_47633__$1 = (function (){var statearr_47642 = state_47633;
(statearr_47642[(8)] = inst_47615__$1);

return statearr_47642;
})();
if(cljs.core.truth_(inst_47616)){
var statearr_47645_49552 = state_47633__$1;
(statearr_47645_49552[(1)] = (5));

} else {
var statearr_47647_49554 = state_47633__$1;
(statearr_47647_49554[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47634 === (6))){
var inst_47612 = (state_47633[(7)]);
var inst_47619 = (state_47633[(9)]);
var inst_47615 = (state_47633[(8)]);
var inst_47619__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_47612,inst_47615) : f.call(null,inst_47612,inst_47615));
var inst_47620 = cljs.core.reduced_QMARK_(inst_47619__$1);
var state_47633__$1 = (function (){var statearr_47649 = state_47633;
(statearr_47649[(9)] = inst_47619__$1);

return statearr_47649;
})();
if(inst_47620){
var statearr_47650_49560 = state_47633__$1;
(statearr_47650_49560[(1)] = (8));

} else {
var statearr_47652_49564 = state_47633__$1;
(statearr_47652_49564[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47634 === (3))){
var inst_47631 = (state_47633[(2)]);
var state_47633__$1 = state_47633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47633__$1,inst_47631);
} else {
if((state_val_47634 === (2))){
var state_47633__$1 = state_47633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47633__$1,(4),ch);
} else {
if((state_val_47634 === (9))){
var inst_47619 = (state_47633[(9)]);
var inst_47612 = inst_47619;
var state_47633__$1 = (function (){var statearr_47656 = state_47633;
(statearr_47656[(7)] = inst_47612);

return statearr_47656;
})();
var statearr_47657_49567 = state_47633__$1;
(statearr_47657_49567[(2)] = null);

(statearr_47657_49567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47634 === (5))){
var inst_47612 = (state_47633[(7)]);
var state_47633__$1 = state_47633;
var statearr_47659_49568 = state_47633__$1;
(statearr_47659_49568[(2)] = inst_47612);

(statearr_47659_49568[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47634 === (10))){
var inst_47627 = (state_47633[(2)]);
var state_47633__$1 = state_47633;
var statearr_47661_49577 = state_47633__$1;
(statearr_47661_49577[(2)] = inst_47627);

(statearr_47661_49577[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47634 === (8))){
var inst_47619 = (state_47633[(9)]);
var inst_47623 = cljs.core.deref(inst_47619);
var state_47633__$1 = state_47633;
var statearr_47663_49588 = state_47633__$1;
(statearr_47663_49588[(2)] = inst_47623);

(statearr_47663_49588[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__46357__auto__ = null;
var cljs$core$async$reduce_$_state_machine__46357__auto____0 = (function (){
var statearr_47667 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47667[(0)] = cljs$core$async$reduce_$_state_machine__46357__auto__);

(statearr_47667[(1)] = (1));

return statearr_47667;
});
var cljs$core$async$reduce_$_state_machine__46357__auto____1 = (function (state_47633){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47633);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47668){var ex__46360__auto__ = e47668;
var statearr_47670_49589 = state_47633;
(statearr_47670_49589[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47633[(4)]))){
var statearr_47671_49590 = state_47633;
(statearr_47671_49590[(1)] = cljs.core.first((state_47633[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49591 = state_47633;
state_47633 = G__49591;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__46357__auto__ = function(state_47633){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__46357__auto____1.call(this,state_47633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__46357__auto____0;
cljs$core$async$reduce_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__46357__auto____1;
return cljs$core$async$reduce_$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47674 = f__47047__auto__();
(statearr_47674[(6)] = c__47046__auto__);

return statearr_47674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));

return c__47046__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__47046__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47682){
var state_val_47683 = (state_47682[(1)]);
if((state_val_47683 === (1))){
var inst_47677 = cljs.core.async.reduce(f__$1,init,ch);
var state_47682__$1 = state_47682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47682__$1,(2),inst_47677);
} else {
if((state_val_47683 === (2))){
var inst_47679 = (state_47682[(2)]);
var inst_47680 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_47679) : f__$1.call(null,inst_47679));
var state_47682__$1 = state_47682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47682__$1,inst_47680);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__46357__auto__ = null;
var cljs$core$async$transduce_$_state_machine__46357__auto____0 = (function (){
var statearr_47689 = [null,null,null,null,null,null,null];
(statearr_47689[(0)] = cljs$core$async$transduce_$_state_machine__46357__auto__);

(statearr_47689[(1)] = (1));

return statearr_47689;
});
var cljs$core$async$transduce_$_state_machine__46357__auto____1 = (function (state_47682){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47682);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47693){var ex__46360__auto__ = e47693;
var statearr_47694_49592 = state_47682;
(statearr_47694_49592[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47682[(4)]))){
var statearr_47695_49599 = state_47682;
(statearr_47695_49599[(1)] = cljs.core.first((state_47682[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49600 = state_47682;
state_47682 = G__49600;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__46357__auto__ = function(state_47682){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__46357__auto____1.call(this,state_47682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__46357__auto____0;
cljs$core$async$transduce_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__46357__auto____1;
return cljs$core$async$transduce_$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47700 = f__47047__auto__();
(statearr_47700[(6)] = c__47046__auto__);

return statearr_47700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));

return c__47046__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__47705 = arguments.length;
switch (G__47705) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__47046__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_47736){
var state_val_47738 = (state_47736[(1)]);
if((state_val_47738 === (7))){
var inst_47718 = (state_47736[(2)]);
var state_47736__$1 = state_47736;
var statearr_47742_49612 = state_47736__$1;
(statearr_47742_49612[(2)] = inst_47718);

(statearr_47742_49612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (1))){
var inst_47710 = cljs.core.seq(coll);
var inst_47711 = inst_47710;
var state_47736__$1 = (function (){var statearr_47743 = state_47736;
(statearr_47743[(7)] = inst_47711);

return statearr_47743;
})();
var statearr_47744_49614 = state_47736__$1;
(statearr_47744_49614[(2)] = null);

(statearr_47744_49614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (4))){
var inst_47711 = (state_47736[(7)]);
var inst_47715 = cljs.core.first(inst_47711);
var state_47736__$1 = state_47736;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47736__$1,(7),ch,inst_47715);
} else {
if((state_val_47738 === (13))){
var inst_47730 = (state_47736[(2)]);
var state_47736__$1 = state_47736;
var statearr_47746_49615 = state_47736__$1;
(statearr_47746_49615[(2)] = inst_47730);

(statearr_47746_49615[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (6))){
var inst_47721 = (state_47736[(2)]);
var state_47736__$1 = state_47736;
if(cljs.core.truth_(inst_47721)){
var statearr_47750_49626 = state_47736__$1;
(statearr_47750_49626[(1)] = (8));

} else {
var statearr_47751_49627 = state_47736__$1;
(statearr_47751_49627[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (3))){
var inst_47734 = (state_47736[(2)]);
var state_47736__$1 = state_47736;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47736__$1,inst_47734);
} else {
if((state_val_47738 === (12))){
var state_47736__$1 = state_47736;
var statearr_47753_49628 = state_47736__$1;
(statearr_47753_49628[(2)] = null);

(statearr_47753_49628[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (2))){
var inst_47711 = (state_47736[(7)]);
var state_47736__$1 = state_47736;
if(cljs.core.truth_(inst_47711)){
var statearr_47754_49629 = state_47736__$1;
(statearr_47754_49629[(1)] = (4));

} else {
var statearr_47755_49630 = state_47736__$1;
(statearr_47755_49630[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (11))){
var inst_47727 = cljs.core.async.close_BANG_(ch);
var state_47736__$1 = state_47736;
var statearr_47759_49635 = state_47736__$1;
(statearr_47759_49635[(2)] = inst_47727);

(statearr_47759_49635[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (9))){
var state_47736__$1 = state_47736;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47760_49636 = state_47736__$1;
(statearr_47760_49636[(1)] = (11));

} else {
var statearr_47761_49637 = state_47736__$1;
(statearr_47761_49637[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (5))){
var inst_47711 = (state_47736[(7)]);
var state_47736__$1 = state_47736;
var statearr_47763_49639 = state_47736__$1;
(statearr_47763_49639[(2)] = inst_47711);

(statearr_47763_49639[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (10))){
var inst_47732 = (state_47736[(2)]);
var state_47736__$1 = state_47736;
var statearr_47766_49640 = state_47736__$1;
(statearr_47766_49640[(2)] = inst_47732);

(statearr_47766_49640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47738 === (8))){
var inst_47711 = (state_47736[(7)]);
var inst_47723 = cljs.core.next(inst_47711);
var inst_47711__$1 = inst_47723;
var state_47736__$1 = (function (){var statearr_47768 = state_47736;
(statearr_47768[(7)] = inst_47711__$1);

return statearr_47768;
})();
var statearr_47769_49646 = state_47736__$1;
(statearr_47769_49646[(2)] = null);

(statearr_47769_49646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_47771 = [null,null,null,null,null,null,null,null];
(statearr_47771[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_47771[(1)] = (1));

return statearr_47771;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_47736){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_47736);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e47773){var ex__46360__auto__ = e47773;
var statearr_47776_49653 = state_47736;
(statearr_47776_49653[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_47736[(4)]))){
var statearr_47779_49654 = state_47736;
(statearr_47779_49654[(1)] = cljs.core.first((state_47736[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49659 = state_47736;
state_47736 = G__49659;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_47736){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_47736);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_47780 = f__47047__auto__();
(statearr_47780[(6)] = c__47046__auto__);

return statearr_47780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));

return c__47046__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47787 = arguments.length;
switch (G__47787) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_49661 = (function (_){
var x__4463__auto__ = (((_ == null))?null:_);
var m__4464__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4464__auto__.call(null,_));
} else {
var m__4461__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4461__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_49661(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_49662 = (function (m,ch,close_QMARK_){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4464__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4461__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_49662(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_49680 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_49680(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_49681 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_49681(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47826 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47826 = (function (ch,cs,meta47827){
this.ch = ch;
this.cs = cs;
this.meta47827 = meta47827;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47828,meta47827__$1){
var self__ = this;
var _47828__$1 = this;
return (new cljs.core.async.t_cljs$core$async47826(self__.ch,self__.cs,meta47827__$1));
}));

(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47828){
var self__ = this;
var _47828__$1 = this;
return self__.meta47827;
}));

(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async47826.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async47826.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47827","meta47827",26076045,null)], null);
}));

(cljs.core.async.t_cljs$core$async47826.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47826.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47826");

(cljs.core.async.t_cljs$core$async47826.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async47826");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47826.
 */
cljs.core.async.__GT_t_cljs$core$async47826 = (function cljs$core$async$mult_$___GT_t_cljs$core$async47826(ch__$1,cs__$1,meta47827){
return (new cljs.core.async.t_cljs$core$async47826(ch__$1,cs__$1,meta47827));
});

}

return (new cljs.core.async.t_cljs$core$async47826(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__47046__auto___49721 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48012){
var state_val_48013 = (state_48012[(1)]);
if((state_val_48013 === (7))){
var inst_48005 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48018_49735 = state_48012__$1;
(statearr_48018_49735[(2)] = inst_48005);

(statearr_48018_49735[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (20))){
var inst_47898 = (state_48012[(7)]);
var inst_47910 = cljs.core.first(inst_47898);
var inst_47911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47910,(0),null);
var inst_47912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47910,(1),null);
var state_48012__$1 = (function (){var statearr_48020 = state_48012;
(statearr_48020[(8)] = inst_47911);

return statearr_48020;
})();
if(cljs.core.truth_(inst_47912)){
var statearr_48021_49736 = state_48012__$1;
(statearr_48021_49736[(1)] = (22));

} else {
var statearr_48022_49737 = state_48012__$1;
(statearr_48022_49737[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (27))){
var inst_47944 = (state_48012[(9)]);
var inst_47954 = (state_48012[(10)]);
var inst_47863 = (state_48012[(11)]);
var inst_47946 = (state_48012[(12)]);
var inst_47954__$1 = cljs.core._nth(inst_47944,inst_47946);
var inst_47956 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47954__$1,inst_47863,done);
var state_48012__$1 = (function (){var statearr_48024 = state_48012;
(statearr_48024[(10)] = inst_47954__$1);

return statearr_48024;
})();
if(cljs.core.truth_(inst_47956)){
var statearr_48025_49747 = state_48012__$1;
(statearr_48025_49747[(1)] = (30));

} else {
var statearr_48026_49748 = state_48012__$1;
(statearr_48026_49748[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (1))){
var state_48012__$1 = state_48012;
var statearr_48027_49749 = state_48012__$1;
(statearr_48027_49749[(2)] = null);

(statearr_48027_49749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (24))){
var inst_47898 = (state_48012[(7)]);
var inst_47917 = (state_48012[(2)]);
var inst_47918 = cljs.core.next(inst_47898);
var inst_47872 = inst_47918;
var inst_47873 = null;
var inst_47874 = (0);
var inst_47875 = (0);
var state_48012__$1 = (function (){var statearr_48035 = state_48012;
(statearr_48035[(13)] = inst_47873);

(statearr_48035[(14)] = inst_47872);

(statearr_48035[(15)] = inst_47917);

(statearr_48035[(16)] = inst_47875);

(statearr_48035[(17)] = inst_47874);

return statearr_48035;
})();
var statearr_48037_49758 = state_48012__$1;
(statearr_48037_49758[(2)] = null);

(statearr_48037_49758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (39))){
var state_48012__$1 = state_48012;
var statearr_48041_49764 = state_48012__$1;
(statearr_48041_49764[(2)] = null);

(statearr_48041_49764[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (4))){
var inst_47863 = (state_48012[(11)]);
var inst_47863__$1 = (state_48012[(2)]);
var inst_47864 = (inst_47863__$1 == null);
var state_48012__$1 = (function (){var statearr_48046 = state_48012;
(statearr_48046[(11)] = inst_47863__$1);

return statearr_48046;
})();
if(cljs.core.truth_(inst_47864)){
var statearr_48047_49772 = state_48012__$1;
(statearr_48047_49772[(1)] = (5));

} else {
var statearr_48048_49773 = state_48012__$1;
(statearr_48048_49773[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (15))){
var inst_47873 = (state_48012[(13)]);
var inst_47872 = (state_48012[(14)]);
var inst_47875 = (state_48012[(16)]);
var inst_47874 = (state_48012[(17)]);
var inst_47893 = (state_48012[(2)]);
var inst_47895 = (inst_47875 + (1));
var tmp48038 = inst_47873;
var tmp48039 = inst_47872;
var tmp48040 = inst_47874;
var inst_47872__$1 = tmp48039;
var inst_47873__$1 = tmp48038;
var inst_47874__$1 = tmp48040;
var inst_47875__$1 = inst_47895;
var state_48012__$1 = (function (){var statearr_48053 = state_48012;
(statearr_48053[(13)] = inst_47873__$1);

(statearr_48053[(14)] = inst_47872__$1);

(statearr_48053[(16)] = inst_47875__$1);

(statearr_48053[(18)] = inst_47893);

(statearr_48053[(17)] = inst_47874__$1);

return statearr_48053;
})();
var statearr_48054_49785 = state_48012__$1;
(statearr_48054_49785[(2)] = null);

(statearr_48054_49785[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (21))){
var inst_47921 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48058_49790 = state_48012__$1;
(statearr_48058_49790[(2)] = inst_47921);

(statearr_48058_49790[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (31))){
var inst_47954 = (state_48012[(10)]);
var inst_47959 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47954);
var state_48012__$1 = state_48012;
var statearr_48063_49793 = state_48012__$1;
(statearr_48063_49793[(2)] = inst_47959);

(statearr_48063_49793[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (32))){
var inst_47943 = (state_48012[(19)]);
var inst_47945 = (state_48012[(20)]);
var inst_47944 = (state_48012[(9)]);
var inst_47946 = (state_48012[(12)]);
var inst_47961 = (state_48012[(2)]);
var inst_47962 = (inst_47946 + (1));
var tmp48055 = inst_47943;
var tmp48056 = inst_47945;
var tmp48057 = inst_47944;
var inst_47943__$1 = tmp48055;
var inst_47944__$1 = tmp48057;
var inst_47945__$1 = tmp48056;
var inst_47946__$1 = inst_47962;
var state_48012__$1 = (function (){var statearr_48064 = state_48012;
(statearr_48064[(19)] = inst_47943__$1);

(statearr_48064[(20)] = inst_47945__$1);

(statearr_48064[(9)] = inst_47944__$1);

(statearr_48064[(21)] = inst_47961);

(statearr_48064[(12)] = inst_47946__$1);

return statearr_48064;
})();
var statearr_48066_49796 = state_48012__$1;
(statearr_48066_49796[(2)] = null);

(statearr_48066_49796[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (40))){
var inst_47974 = (state_48012[(22)]);
var inst_47981 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47974);
var state_48012__$1 = state_48012;
var statearr_48067_49799 = state_48012__$1;
(statearr_48067_49799[(2)] = inst_47981);

(statearr_48067_49799[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (33))){
var inst_47965 = (state_48012[(23)]);
var inst_47967 = cljs.core.chunked_seq_QMARK_(inst_47965);
var state_48012__$1 = state_48012;
if(inst_47967){
var statearr_48068_49800 = state_48012__$1;
(statearr_48068_49800[(1)] = (36));

} else {
var statearr_48069_49801 = state_48012__$1;
(statearr_48069_49801[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (13))){
var inst_47887 = (state_48012[(24)]);
var inst_47890 = cljs.core.async.close_BANG_(inst_47887);
var state_48012__$1 = state_48012;
var statearr_48074_49805 = state_48012__$1;
(statearr_48074_49805[(2)] = inst_47890);

(statearr_48074_49805[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (22))){
var inst_47911 = (state_48012[(8)]);
var inst_47914 = cljs.core.async.close_BANG_(inst_47911);
var state_48012__$1 = state_48012;
var statearr_48079_49808 = state_48012__$1;
(statearr_48079_49808[(2)] = inst_47914);

(statearr_48079_49808[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (36))){
var inst_47965 = (state_48012[(23)]);
var inst_47969 = cljs.core.chunk_first(inst_47965);
var inst_47970 = cljs.core.chunk_rest(inst_47965);
var inst_47971 = cljs.core.count(inst_47969);
var inst_47943 = inst_47970;
var inst_47944 = inst_47969;
var inst_47945 = inst_47971;
var inst_47946 = (0);
var state_48012__$1 = (function (){var statearr_48080 = state_48012;
(statearr_48080[(19)] = inst_47943);

(statearr_48080[(20)] = inst_47945);

(statearr_48080[(9)] = inst_47944);

(statearr_48080[(12)] = inst_47946);

return statearr_48080;
})();
var statearr_48084_49810 = state_48012__$1;
(statearr_48084_49810[(2)] = null);

(statearr_48084_49810[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (41))){
var inst_47965 = (state_48012[(23)]);
var inst_47983 = (state_48012[(2)]);
var inst_47984 = cljs.core.next(inst_47965);
var inst_47943 = inst_47984;
var inst_47944 = null;
var inst_47945 = (0);
var inst_47946 = (0);
var state_48012__$1 = (function (){var statearr_48086 = state_48012;
(statearr_48086[(19)] = inst_47943);

(statearr_48086[(20)] = inst_47945);

(statearr_48086[(9)] = inst_47944);

(statearr_48086[(12)] = inst_47946);

(statearr_48086[(25)] = inst_47983);

return statearr_48086;
})();
var statearr_48090_49818 = state_48012__$1;
(statearr_48090_49818[(2)] = null);

(statearr_48090_49818[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (43))){
var state_48012__$1 = state_48012;
var statearr_48092_49820 = state_48012__$1;
(statearr_48092_49820[(2)] = null);

(statearr_48092_49820[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (29))){
var inst_47993 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48093_49822 = state_48012__$1;
(statearr_48093_49822[(2)] = inst_47993);

(statearr_48093_49822[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (44))){
var inst_48002 = (state_48012[(2)]);
var state_48012__$1 = (function (){var statearr_48094 = state_48012;
(statearr_48094[(26)] = inst_48002);

return statearr_48094;
})();
var statearr_48098_49825 = state_48012__$1;
(statearr_48098_49825[(2)] = null);

(statearr_48098_49825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (6))){
var inst_47931 = (state_48012[(27)]);
var inst_47930 = cljs.core.deref(cs);
var inst_47931__$1 = cljs.core.keys(inst_47930);
var inst_47936 = cljs.core.count(inst_47931__$1);
var inst_47937 = cljs.core.reset_BANG_(dctr,inst_47936);
var inst_47942 = cljs.core.seq(inst_47931__$1);
var inst_47943 = inst_47942;
var inst_47944 = null;
var inst_47945 = (0);
var inst_47946 = (0);
var state_48012__$1 = (function (){var statearr_48100 = state_48012;
(statearr_48100[(19)] = inst_47943);

(statearr_48100[(20)] = inst_47945);

(statearr_48100[(28)] = inst_47937);

(statearr_48100[(9)] = inst_47944);

(statearr_48100[(12)] = inst_47946);

(statearr_48100[(27)] = inst_47931__$1);

return statearr_48100;
})();
var statearr_48101_49826 = state_48012__$1;
(statearr_48101_49826[(2)] = null);

(statearr_48101_49826[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (28))){
var inst_47943 = (state_48012[(19)]);
var inst_47965 = (state_48012[(23)]);
var inst_47965__$1 = cljs.core.seq(inst_47943);
var state_48012__$1 = (function (){var statearr_48102 = state_48012;
(statearr_48102[(23)] = inst_47965__$1);

return statearr_48102;
})();
if(inst_47965__$1){
var statearr_48103_49828 = state_48012__$1;
(statearr_48103_49828[(1)] = (33));

} else {
var statearr_48104_49829 = state_48012__$1;
(statearr_48104_49829[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (25))){
var inst_47945 = (state_48012[(20)]);
var inst_47946 = (state_48012[(12)]);
var inst_47951 = (inst_47946 < inst_47945);
var inst_47952 = inst_47951;
var state_48012__$1 = state_48012;
if(cljs.core.truth_(inst_47952)){
var statearr_48105_49834 = state_48012__$1;
(statearr_48105_49834[(1)] = (27));

} else {
var statearr_48106_49835 = state_48012__$1;
(statearr_48106_49835[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (34))){
var state_48012__$1 = state_48012;
var statearr_48111_49840 = state_48012__$1;
(statearr_48111_49840[(2)] = null);

(statearr_48111_49840[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (17))){
var state_48012__$1 = state_48012;
var statearr_48112_49842 = state_48012__$1;
(statearr_48112_49842[(2)] = null);

(statearr_48112_49842[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (3))){
var inst_48007 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48012__$1,inst_48007);
} else {
if((state_val_48013 === (12))){
var inst_47926 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48114_49847 = state_48012__$1;
(statearr_48114_49847[(2)] = inst_47926);

(statearr_48114_49847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (2))){
var state_48012__$1 = state_48012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48012__$1,(4),ch);
} else {
if((state_val_48013 === (23))){
var state_48012__$1 = state_48012;
var statearr_48115_49853 = state_48012__$1;
(statearr_48115_49853[(2)] = null);

(statearr_48115_49853[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (35))){
var inst_47991 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48116_49854 = state_48012__$1;
(statearr_48116_49854[(2)] = inst_47991);

(statearr_48116_49854[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (19))){
var inst_47898 = (state_48012[(7)]);
var inst_47902 = cljs.core.chunk_first(inst_47898);
var inst_47903 = cljs.core.chunk_rest(inst_47898);
var inst_47904 = cljs.core.count(inst_47902);
var inst_47872 = inst_47903;
var inst_47873 = inst_47902;
var inst_47874 = inst_47904;
var inst_47875 = (0);
var state_48012__$1 = (function (){var statearr_48117 = state_48012;
(statearr_48117[(13)] = inst_47873);

(statearr_48117[(14)] = inst_47872);

(statearr_48117[(16)] = inst_47875);

(statearr_48117[(17)] = inst_47874);

return statearr_48117;
})();
var statearr_48118_49858 = state_48012__$1;
(statearr_48118_49858[(2)] = null);

(statearr_48118_49858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (11))){
var inst_47872 = (state_48012[(14)]);
var inst_47898 = (state_48012[(7)]);
var inst_47898__$1 = cljs.core.seq(inst_47872);
var state_48012__$1 = (function (){var statearr_48119 = state_48012;
(statearr_48119[(7)] = inst_47898__$1);

return statearr_48119;
})();
if(inst_47898__$1){
var statearr_48120_49864 = state_48012__$1;
(statearr_48120_49864[(1)] = (16));

} else {
var statearr_48121_49865 = state_48012__$1;
(statearr_48121_49865[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (9))){
var inst_47928 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48122_49866 = state_48012__$1;
(statearr_48122_49866[(2)] = inst_47928);

(statearr_48122_49866[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (5))){
var inst_47870 = cljs.core.deref(cs);
var inst_47871 = cljs.core.seq(inst_47870);
var inst_47872 = inst_47871;
var inst_47873 = null;
var inst_47874 = (0);
var inst_47875 = (0);
var state_48012__$1 = (function (){var statearr_48123 = state_48012;
(statearr_48123[(13)] = inst_47873);

(statearr_48123[(14)] = inst_47872);

(statearr_48123[(16)] = inst_47875);

(statearr_48123[(17)] = inst_47874);

return statearr_48123;
})();
var statearr_48124_49872 = state_48012__$1;
(statearr_48124_49872[(2)] = null);

(statearr_48124_49872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (14))){
var state_48012__$1 = state_48012;
var statearr_48127_49877 = state_48012__$1;
(statearr_48127_49877[(2)] = null);

(statearr_48127_49877[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (45))){
var inst_47999 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48128_49878 = state_48012__$1;
(statearr_48128_49878[(2)] = inst_47999);

(statearr_48128_49878[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (26))){
var inst_47931 = (state_48012[(27)]);
var inst_47995 = (state_48012[(2)]);
var inst_47996 = cljs.core.seq(inst_47931);
var state_48012__$1 = (function (){var statearr_48129 = state_48012;
(statearr_48129[(29)] = inst_47995);

return statearr_48129;
})();
if(inst_47996){
var statearr_48130_49881 = state_48012__$1;
(statearr_48130_49881[(1)] = (42));

} else {
var statearr_48131_49882 = state_48012__$1;
(statearr_48131_49882[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (16))){
var inst_47898 = (state_48012[(7)]);
var inst_47900 = cljs.core.chunked_seq_QMARK_(inst_47898);
var state_48012__$1 = state_48012;
if(inst_47900){
var statearr_48132_49883 = state_48012__$1;
(statearr_48132_49883[(1)] = (19));

} else {
var statearr_48133_49884 = state_48012__$1;
(statearr_48133_49884[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (38))){
var inst_47987 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48134_49890 = state_48012__$1;
(statearr_48134_49890[(2)] = inst_47987);

(statearr_48134_49890[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (30))){
var state_48012__$1 = state_48012;
var statearr_48135_49896 = state_48012__$1;
(statearr_48135_49896[(2)] = null);

(statearr_48135_49896[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (10))){
var inst_47873 = (state_48012[(13)]);
var inst_47875 = (state_48012[(16)]);
var inst_47885 = cljs.core._nth(inst_47873,inst_47875);
var inst_47887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47885,(0),null);
var inst_47888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47885,(1),null);
var state_48012__$1 = (function (){var statearr_48136 = state_48012;
(statearr_48136[(24)] = inst_47887);

return statearr_48136;
})();
if(cljs.core.truth_(inst_47888)){
var statearr_48137_49902 = state_48012__$1;
(statearr_48137_49902[(1)] = (13));

} else {
var statearr_48138_49903 = state_48012__$1;
(statearr_48138_49903[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (18))){
var inst_47924 = (state_48012[(2)]);
var state_48012__$1 = state_48012;
var statearr_48139_49908 = state_48012__$1;
(statearr_48139_49908[(2)] = inst_47924);

(statearr_48139_49908[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (42))){
var state_48012__$1 = state_48012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48012__$1,(45),dchan);
} else {
if((state_val_48013 === (37))){
var inst_47965 = (state_48012[(23)]);
var inst_47863 = (state_48012[(11)]);
var inst_47974 = (state_48012[(22)]);
var inst_47974__$1 = cljs.core.first(inst_47965);
var inst_47978 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47974__$1,inst_47863,done);
var state_48012__$1 = (function (){var statearr_48140 = state_48012;
(statearr_48140[(22)] = inst_47974__$1);

return statearr_48140;
})();
if(cljs.core.truth_(inst_47978)){
var statearr_48141_49913 = state_48012__$1;
(statearr_48141_49913[(1)] = (39));

} else {
var statearr_48142_49914 = state_48012__$1;
(statearr_48142_49914[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48013 === (8))){
var inst_47875 = (state_48012[(16)]);
var inst_47874 = (state_48012[(17)]);
var inst_47877 = (inst_47875 < inst_47874);
var inst_47878 = inst_47877;
var state_48012__$1 = state_48012;
if(cljs.core.truth_(inst_47878)){
var statearr_48143_49917 = state_48012__$1;
(statearr_48143_49917[(1)] = (10));

} else {
var statearr_48144_49918 = state_48012__$1;
(statearr_48144_49918[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__46357__auto__ = null;
var cljs$core$async$mult_$_state_machine__46357__auto____0 = (function (){
var statearr_48145 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48145[(0)] = cljs$core$async$mult_$_state_machine__46357__auto__);

(statearr_48145[(1)] = (1));

return statearr_48145;
});
var cljs$core$async$mult_$_state_machine__46357__auto____1 = (function (state_48012){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48012);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48146){var ex__46360__auto__ = e48146;
var statearr_48147_49930 = state_48012;
(statearr_48147_49930[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48012[(4)]))){
var statearr_48148_49931 = state_48012;
(statearr_48148_49931[(1)] = cljs.core.first((state_48012[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49934 = state_48012;
state_48012 = G__49934;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__46357__auto__ = function(state_48012){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__46357__auto____1.call(this,state_48012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__46357__auto____0;
cljs$core$async$mult_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__46357__auto____1;
return cljs$core$async$mult_$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48149 = f__47047__auto__();
(statearr_48149[(6)] = c__47046__auto___49721);

return statearr_48149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__48151 = arguments.length;
switch (G__48151) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_49942 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_49942(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_49948 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_49948(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_49958 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_49958(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_49972 = (function (m,state_map){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4464__auto__.call(null,m,state_map));
} else {
var m__4461__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4461__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_49972(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_49974 = (function (m,mode){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4464__auto__.call(null,m,mode));
} else {
var m__4461__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4461__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_49974(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___49975 = arguments.length;
var i__4772__auto___49976 = (0);
while(true){
if((i__4772__auto___49976 < len__4771__auto___49975)){
args__4777__auto__.push((arguments[i__4772__auto___49976]));

var G__49977 = (i__4772__auto___49976 + (1));
i__4772__auto___49976 = G__49977;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((3) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4778__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__48164){
var map__48165 = p__48164;
var map__48165__$1 = cljs.core.__destructure_map(map__48165);
var opts = map__48165__$1;
var statearr_48166_49988 = state;
(statearr_48166_49988[(1)] = cont_block);


var temp__5754__auto__ = cljs.core.async.do_alts((function (val){
var statearr_48167_49989 = state;
(statearr_48167_49989[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5754__auto__)){
var cb = temp__5754__auto__;
var statearr_48168_49990 = state;
(statearr_48168_49990[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq48158){
var G__48159 = cljs.core.first(seq48158);
var seq48158__$1 = cljs.core.next(seq48158);
var G__48160 = cljs.core.first(seq48158__$1);
var seq48158__$2 = cljs.core.next(seq48158__$1);
var G__48161 = cljs.core.first(seq48158__$2);
var seq48158__$3 = cljs.core.next(seq48158__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48159,G__48160,G__48161,seq48158__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48178 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48178 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta48179){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta48179 = meta48179;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48180,meta48179__$1){
var self__ = this;
var _48180__$1 = this;
return (new cljs.core.async.t_cljs$core$async48178(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta48179__$1));
}));

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48180){
var self__ = this;
var _48180__$1 = this;
return self__.meta48179;
}));

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48178.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48178.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta48179","meta48179",-155877204,null)], null);
}));

(cljs.core.async.t_cljs$core$async48178.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48178.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48178");

(cljs.core.async.t_cljs$core$async48178.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48178");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48178.
 */
cljs.core.async.__GT_t_cljs$core$async48178 = (function cljs$core$async$mix_$___GT_t_cljs$core$async48178(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48179){
return (new cljs.core.async.t_cljs$core$async48178(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48179));
});

}

return (new cljs.core.async.t_cljs$core$async48178(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47046__auto___50048 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48277){
var state_val_48278 = (state_48277[(1)]);
if((state_val_48278 === (7))){
var inst_48273 = (state_48277[(2)]);
var state_48277__$1 = state_48277;
var statearr_48279_50050 = state_48277__$1;
(statearr_48279_50050[(2)] = inst_48273);

(statearr_48279_50050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (20))){
var inst_48267 = (state_48277[(2)]);
var state_48277__$1 = state_48277;
var statearr_48284_50051 = state_48277__$1;
(statearr_48284_50051[(2)] = inst_48267);

(statearr_48284_50051[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (1))){
var inst_48213 = calc_state();
var inst_48214 = cljs.core.__destructure_map(inst_48213);
var inst_48215 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48214,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48214,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48214,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_48221 = inst_48213;
var state_48277__$1 = (function (){var statearr_48285 = state_48277;
(statearr_48285[(7)] = inst_48217);

(statearr_48285[(8)] = inst_48221);

(statearr_48285[(9)] = inst_48215);

(statearr_48285[(10)] = inst_48216);

return statearr_48285;
})();
var statearr_48286_50058 = state_48277__$1;
(statearr_48286_50058[(2)] = null);

(statearr_48286_50058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (4))){
var inst_48234 = (state_48277[(11)]);
var inst_48233 = (state_48277[(12)]);
var inst_48232 = (state_48277[(2)]);
var inst_48233__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48232,(0),null);
var inst_48234__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48232,(1),null);
var inst_48235 = (inst_48233__$1 == null);
var inst_48236 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48234__$1,change);
var inst_48237 = ((inst_48235) || (inst_48236));
var state_48277__$1 = (function (){var statearr_48287 = state_48277;
(statearr_48287[(11)] = inst_48234__$1);

(statearr_48287[(12)] = inst_48233__$1);

return statearr_48287;
})();
if(cljs.core.truth_(inst_48237)){
var statearr_48288_50063 = state_48277__$1;
(statearr_48288_50063[(1)] = (5));

} else {
var statearr_48289_50064 = state_48277__$1;
(statearr_48289_50064[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (15))){
var inst_48224 = (state_48277[(13)]);
var inst_48221 = inst_48224;
var state_48277__$1 = (function (){var statearr_48290 = state_48277;
(statearr_48290[(8)] = inst_48221);

return statearr_48290;
})();
var statearr_48291_50065 = state_48277__$1;
(statearr_48291_50065[(2)] = null);

(statearr_48291_50065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (13))){
var inst_48259 = (state_48277[(2)]);
var state_48277__$1 = state_48277;
if(cljs.core.truth_(inst_48259)){
var statearr_48292_50066 = state_48277__$1;
(statearr_48292_50066[(1)] = (14));

} else {
var statearr_48293_50067 = state_48277__$1;
(statearr_48293_50067[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (6))){
var inst_48234 = (state_48277[(11)]);
var inst_48251 = (state_48277[(14)]);
var inst_48225 = (state_48277[(15)]);
var inst_48251__$1 = (inst_48225.cljs$core$IFn$_invoke$arity$1 ? inst_48225.cljs$core$IFn$_invoke$arity$1(inst_48234) : inst_48225.call(null,inst_48234));
var state_48277__$1 = (function (){var statearr_48295 = state_48277;
(statearr_48295[(14)] = inst_48251__$1);

return statearr_48295;
})();
if(cljs.core.truth_(inst_48251__$1)){
var statearr_48299_50069 = state_48277__$1;
(statearr_48299_50069[(1)] = (11));

} else {
var statearr_48300_50070 = state_48277__$1;
(statearr_48300_50070[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (17))){
var inst_48262 = (state_48277[(2)]);
var state_48277__$1 = state_48277;
if(cljs.core.truth_(inst_48262)){
var statearr_48301_50071 = state_48277__$1;
(statearr_48301_50071[(1)] = (18));

} else {
var statearr_48302_50072 = state_48277__$1;
(statearr_48302_50072[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (3))){
var inst_48275 = (state_48277[(2)]);
var state_48277__$1 = state_48277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48277__$1,inst_48275);
} else {
if((state_val_48278 === (12))){
var inst_48234 = (state_48277[(11)]);
var inst_48225 = (state_48277[(15)]);
var inst_48226 = (state_48277[(16)]);
var inst_48254 = cljs.core.empty_QMARK_(inst_48225);
var inst_48255 = (inst_48226.cljs$core$IFn$_invoke$arity$1 ? inst_48226.cljs$core$IFn$_invoke$arity$1(inst_48234) : inst_48226.call(null,inst_48234));
var inst_48256 = cljs.core.not(inst_48255);
var inst_48257 = ((inst_48254) && (inst_48256));
var state_48277__$1 = state_48277;
var statearr_48306_50073 = state_48277__$1;
(statearr_48306_50073[(2)] = inst_48257);

(statearr_48306_50073[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (2))){
var inst_48224 = (state_48277[(13)]);
var inst_48221 = (state_48277[(8)]);
var inst_48224__$1 = cljs.core.__destructure_map(inst_48221);
var inst_48225 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48224__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48224__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48224__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48277__$1 = (function (){var statearr_48308 = state_48277;
(statearr_48308[(13)] = inst_48224__$1);

(statearr_48308[(15)] = inst_48225);

(statearr_48308[(16)] = inst_48226);

return statearr_48308;
})();
return cljs.core.async.ioc_alts_BANG_(state_48277__$1,(4),inst_48227);
} else {
if((state_val_48278 === (19))){
var state_48277__$1 = state_48277;
var statearr_48309_50075 = state_48277__$1;
(statearr_48309_50075[(2)] = null);

(statearr_48309_50075[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (11))){
var inst_48251 = (state_48277[(14)]);
var state_48277__$1 = state_48277;
var statearr_48310_50076 = state_48277__$1;
(statearr_48310_50076[(2)] = inst_48251);

(statearr_48310_50076[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (9))){
var state_48277__$1 = state_48277;
var statearr_48311_50077 = state_48277__$1;
(statearr_48311_50077[(2)] = null);

(statearr_48311_50077[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (5))){
var inst_48233 = (state_48277[(12)]);
var inst_48242 = (inst_48233 == null);
var state_48277__$1 = state_48277;
if(cljs.core.truth_(inst_48242)){
var statearr_48312_50081 = state_48277__$1;
(statearr_48312_50081[(1)] = (8));

} else {
var statearr_48313_50082 = state_48277__$1;
(statearr_48313_50082[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (14))){
var inst_48233 = (state_48277[(12)]);
var state_48277__$1 = state_48277;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48277__$1,(17),out,inst_48233);
} else {
if((state_val_48278 === (16))){
var inst_48271 = (state_48277[(2)]);
var state_48277__$1 = state_48277;
var statearr_48314_50083 = state_48277__$1;
(statearr_48314_50083[(2)] = inst_48271);

(statearr_48314_50083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (10))){
var inst_48247 = (state_48277[(2)]);
var inst_48248 = calc_state();
var inst_48221 = inst_48248;
var state_48277__$1 = (function (){var statearr_48315 = state_48277;
(statearr_48315[(17)] = inst_48247);

(statearr_48315[(8)] = inst_48221);

return statearr_48315;
})();
var statearr_48316_50086 = state_48277__$1;
(statearr_48316_50086[(2)] = null);

(statearr_48316_50086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (18))){
var inst_48224 = (state_48277[(13)]);
var inst_48221 = inst_48224;
var state_48277__$1 = (function (){var statearr_48317 = state_48277;
(statearr_48317[(8)] = inst_48221);

return statearr_48317;
})();
var statearr_48318_50089 = state_48277__$1;
(statearr_48318_50089[(2)] = null);

(statearr_48318_50089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48278 === (8))){
var inst_48234 = (state_48277[(11)]);
var inst_48244 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_48234);
var state_48277__$1 = state_48277;
var statearr_48321_50090 = state_48277__$1;
(statearr_48321_50090[(2)] = inst_48244);

(statearr_48321_50090[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__46357__auto__ = null;
var cljs$core$async$mix_$_state_machine__46357__auto____0 = (function (){
var statearr_48322 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48322[(0)] = cljs$core$async$mix_$_state_machine__46357__auto__);

(statearr_48322[(1)] = (1));

return statearr_48322;
});
var cljs$core$async$mix_$_state_machine__46357__auto____1 = (function (state_48277){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48277);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48323){var ex__46360__auto__ = e48323;
var statearr_48324_50094 = state_48277;
(statearr_48324_50094[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48277[(4)]))){
var statearr_48325_50095 = state_48277;
(statearr_48325_50095[(1)] = cljs.core.first((state_48277[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50098 = state_48277;
state_48277 = G__50098;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__46357__auto__ = function(state_48277){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__46357__auto____1.call(this,state_48277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__46357__auto____0;
cljs$core$async$mix_$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__46357__auto____1;
return cljs$core$async$mix_$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48328 = f__47047__auto__();
(statearr_48328[(6)] = c__47046__auto___50048);

return statearr_48328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_50103 = (function (p,v,ch,close_QMARK_){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4464__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4461__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_50103(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_50106 = (function (p,v,ch){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4464__auto__.call(null,p,v,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4461__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_50106(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_50108 = (function() {
var G__50109 = null;
var G__50109__1 = (function (p){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4464__auto__.call(null,p));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4461__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__50109__2 = (function (p,v){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4464__auto__.call(null,p,v));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4461__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__50109 = function(p,v){
switch(arguments.length){
case 1:
return G__50109__1.call(this,p);
case 2:
return G__50109__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__50109.cljs$core$IFn$_invoke$arity$1 = G__50109__1;
G__50109.cljs$core$IFn$_invoke$arity$2 = G__50109__2;
return G__50109;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__48340 = arguments.length;
switch (G__48340) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50108(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50108(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__48350 = arguments.length;
switch (G__48350) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__48348_SHARP_){
if(cljs.core.truth_((p1__48348_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__48348_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__48348_SHARP_.call(null,topic)))){
return p1__48348_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__48348_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48351 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48351 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48352){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48352 = meta48352;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48353,meta48352__$1){
var self__ = this;
var _48353__$1 = this;
return (new cljs.core.async.t_cljs$core$async48351(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48352__$1));
}));

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48353){
var self__ = this;
var _48353__$1 = this;
return self__.meta48352;
}));

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5754__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5754__auto__)){
var m = temp__5754__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async48351.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async48351.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48352","meta48352",-2050572666,null)], null);
}));

(cljs.core.async.t_cljs$core$async48351.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48351.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48351");

(cljs.core.async.t_cljs$core$async48351.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48351");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48351.
 */
cljs.core.async.__GT_t_cljs$core$async48351 = (function cljs$core$async$__GT_t_cljs$core$async48351(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48352){
return (new cljs.core.async.t_cljs$core$async48351(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48352));
});

}

return (new cljs.core.async.t_cljs$core$async48351(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47046__auto___50147 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48433){
var state_val_48434 = (state_48433[(1)]);
if((state_val_48434 === (7))){
var inst_48429 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48437_50150 = state_48433__$1;
(statearr_48437_50150[(2)] = inst_48429);

(statearr_48437_50150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (20))){
var state_48433__$1 = state_48433;
var statearr_48438_50152 = state_48433__$1;
(statearr_48438_50152[(2)] = null);

(statearr_48438_50152[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (1))){
var state_48433__$1 = state_48433;
var statearr_48439_50154 = state_48433__$1;
(statearr_48439_50154[(2)] = null);

(statearr_48439_50154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (24))){
var inst_48412 = (state_48433[(7)]);
var inst_48421 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_48412);
var state_48433__$1 = state_48433;
var statearr_48440_50157 = state_48433__$1;
(statearr_48440_50157[(2)] = inst_48421);

(statearr_48440_50157[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (4))){
var inst_48364 = (state_48433[(8)]);
var inst_48364__$1 = (state_48433[(2)]);
var inst_48365 = (inst_48364__$1 == null);
var state_48433__$1 = (function (){var statearr_48444 = state_48433;
(statearr_48444[(8)] = inst_48364__$1);

return statearr_48444;
})();
if(cljs.core.truth_(inst_48365)){
var statearr_48445_50158 = state_48433__$1;
(statearr_48445_50158[(1)] = (5));

} else {
var statearr_48446_50159 = state_48433__$1;
(statearr_48446_50159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (15))){
var inst_48406 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48447_50160 = state_48433__$1;
(statearr_48447_50160[(2)] = inst_48406);

(statearr_48447_50160[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (21))){
var inst_48426 = (state_48433[(2)]);
var state_48433__$1 = (function (){var statearr_48448 = state_48433;
(statearr_48448[(9)] = inst_48426);

return statearr_48448;
})();
var statearr_48449_50161 = state_48433__$1;
(statearr_48449_50161[(2)] = null);

(statearr_48449_50161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (13))){
var inst_48388 = (state_48433[(10)]);
var inst_48390 = cljs.core.chunked_seq_QMARK_(inst_48388);
var state_48433__$1 = state_48433;
if(inst_48390){
var statearr_48450_50162 = state_48433__$1;
(statearr_48450_50162[(1)] = (16));

} else {
var statearr_48451_50163 = state_48433__$1;
(statearr_48451_50163[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (22))){
var inst_48418 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
if(cljs.core.truth_(inst_48418)){
var statearr_48452_50166 = state_48433__$1;
(statearr_48452_50166[(1)] = (23));

} else {
var statearr_48453_50167 = state_48433__$1;
(statearr_48453_50167[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (6))){
var inst_48364 = (state_48433[(8)]);
var inst_48412 = (state_48433[(7)]);
var inst_48414 = (state_48433[(11)]);
var inst_48412__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_48364) : topic_fn.call(null,inst_48364));
var inst_48413 = cljs.core.deref(mults);
var inst_48414__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48413,inst_48412__$1);
var state_48433__$1 = (function (){var statearr_48454 = state_48433;
(statearr_48454[(7)] = inst_48412__$1);

(statearr_48454[(11)] = inst_48414__$1);

return statearr_48454;
})();
if(cljs.core.truth_(inst_48414__$1)){
var statearr_48455_50173 = state_48433__$1;
(statearr_48455_50173[(1)] = (19));

} else {
var statearr_48456_50174 = state_48433__$1;
(statearr_48456_50174[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (25))){
var inst_48423 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48457_50180 = state_48433__$1;
(statearr_48457_50180[(2)] = inst_48423);

(statearr_48457_50180[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (17))){
var inst_48388 = (state_48433[(10)]);
var inst_48397 = cljs.core.first(inst_48388);
var inst_48398 = cljs.core.async.muxch_STAR_(inst_48397);
var inst_48399 = cljs.core.async.close_BANG_(inst_48398);
var inst_48400 = cljs.core.next(inst_48388);
var inst_48374 = inst_48400;
var inst_48375 = null;
var inst_48376 = (0);
var inst_48377 = (0);
var state_48433__$1 = (function (){var statearr_48458 = state_48433;
(statearr_48458[(12)] = inst_48399);

(statearr_48458[(13)] = inst_48377);

(statearr_48458[(14)] = inst_48375);

(statearr_48458[(15)] = inst_48374);

(statearr_48458[(16)] = inst_48376);

return statearr_48458;
})();
var statearr_48459_50189 = state_48433__$1;
(statearr_48459_50189[(2)] = null);

(statearr_48459_50189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (3))){
var inst_48431 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48433__$1,inst_48431);
} else {
if((state_val_48434 === (12))){
var inst_48408 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48460_50196 = state_48433__$1;
(statearr_48460_50196[(2)] = inst_48408);

(statearr_48460_50196[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (2))){
var state_48433__$1 = state_48433;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48433__$1,(4),ch);
} else {
if((state_val_48434 === (23))){
var state_48433__$1 = state_48433;
var statearr_48461_50197 = state_48433__$1;
(statearr_48461_50197[(2)] = null);

(statearr_48461_50197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (19))){
var inst_48364 = (state_48433[(8)]);
var inst_48414 = (state_48433[(11)]);
var inst_48416 = cljs.core.async.muxch_STAR_(inst_48414);
var state_48433__$1 = state_48433;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48433__$1,(22),inst_48416,inst_48364);
} else {
if((state_val_48434 === (11))){
var inst_48374 = (state_48433[(15)]);
var inst_48388 = (state_48433[(10)]);
var inst_48388__$1 = cljs.core.seq(inst_48374);
var state_48433__$1 = (function (){var statearr_48462 = state_48433;
(statearr_48462[(10)] = inst_48388__$1);

return statearr_48462;
})();
if(inst_48388__$1){
var statearr_48463_50201 = state_48433__$1;
(statearr_48463_50201[(1)] = (13));

} else {
var statearr_48464_50205 = state_48433__$1;
(statearr_48464_50205[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (9))){
var inst_48410 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48465_50206 = state_48433__$1;
(statearr_48465_50206[(2)] = inst_48410);

(statearr_48465_50206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (5))){
var inst_48371 = cljs.core.deref(mults);
var inst_48372 = cljs.core.vals(inst_48371);
var inst_48373 = cljs.core.seq(inst_48372);
var inst_48374 = inst_48373;
var inst_48375 = null;
var inst_48376 = (0);
var inst_48377 = (0);
var state_48433__$1 = (function (){var statearr_48466 = state_48433;
(statearr_48466[(13)] = inst_48377);

(statearr_48466[(14)] = inst_48375);

(statearr_48466[(15)] = inst_48374);

(statearr_48466[(16)] = inst_48376);

return statearr_48466;
})();
var statearr_48467_50211 = state_48433__$1;
(statearr_48467_50211[(2)] = null);

(statearr_48467_50211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (14))){
var state_48433__$1 = state_48433;
var statearr_48471_50212 = state_48433__$1;
(statearr_48471_50212[(2)] = null);

(statearr_48471_50212[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (16))){
var inst_48388 = (state_48433[(10)]);
var inst_48392 = cljs.core.chunk_first(inst_48388);
var inst_48393 = cljs.core.chunk_rest(inst_48388);
var inst_48394 = cljs.core.count(inst_48392);
var inst_48374 = inst_48393;
var inst_48375 = inst_48392;
var inst_48376 = inst_48394;
var inst_48377 = (0);
var state_48433__$1 = (function (){var statearr_48472 = state_48433;
(statearr_48472[(13)] = inst_48377);

(statearr_48472[(14)] = inst_48375);

(statearr_48472[(15)] = inst_48374);

(statearr_48472[(16)] = inst_48376);

return statearr_48472;
})();
var statearr_48473_50217 = state_48433__$1;
(statearr_48473_50217[(2)] = null);

(statearr_48473_50217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (10))){
var inst_48377 = (state_48433[(13)]);
var inst_48375 = (state_48433[(14)]);
var inst_48374 = (state_48433[(15)]);
var inst_48376 = (state_48433[(16)]);
var inst_48382 = cljs.core._nth(inst_48375,inst_48377);
var inst_48383 = cljs.core.async.muxch_STAR_(inst_48382);
var inst_48384 = cljs.core.async.close_BANG_(inst_48383);
var inst_48385 = (inst_48377 + (1));
var tmp48468 = inst_48375;
var tmp48469 = inst_48374;
var tmp48470 = inst_48376;
var inst_48374__$1 = tmp48469;
var inst_48375__$1 = tmp48468;
var inst_48376__$1 = tmp48470;
var inst_48377__$1 = inst_48385;
var state_48433__$1 = (function (){var statearr_48474 = state_48433;
(statearr_48474[(17)] = inst_48384);

(statearr_48474[(13)] = inst_48377__$1);

(statearr_48474[(14)] = inst_48375__$1);

(statearr_48474[(15)] = inst_48374__$1);

(statearr_48474[(16)] = inst_48376__$1);

return statearr_48474;
})();
var statearr_48475_50229 = state_48433__$1;
(statearr_48475_50229[(2)] = null);

(statearr_48475_50229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (18))){
var inst_48403 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48476_50230 = state_48433__$1;
(statearr_48476_50230[(2)] = inst_48403);

(statearr_48476_50230[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48434 === (8))){
var inst_48377 = (state_48433[(13)]);
var inst_48376 = (state_48433[(16)]);
var inst_48379 = (inst_48377 < inst_48376);
var inst_48380 = inst_48379;
var state_48433__$1 = state_48433;
if(cljs.core.truth_(inst_48380)){
var statearr_48477_50237 = state_48433__$1;
(statearr_48477_50237[(1)] = (10));

} else {
var statearr_48478_50238 = state_48433__$1;
(statearr_48478_50238[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_48479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48479[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_48479[(1)] = (1));

return statearr_48479;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_48433){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48433);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48480){var ex__46360__auto__ = e48480;
var statearr_48481_50239 = state_48433;
(statearr_48481_50239[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48433[(4)]))){
var statearr_48482_50240 = state_48433;
(statearr_48482_50240[(1)] = cljs.core.first((state_48433[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50241 = state_48433;
state_48433 = G__50241;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_48433){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_48433);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48484 = f__47047__auto__();
(statearr_48484[(6)] = c__47046__auto___50147);

return statearr_48484;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__48486 = arguments.length;
switch (G__48486) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__48491 = arguments.length;
switch (G__48491) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__48497 = arguments.length;
switch (G__48497) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__47046__auto___50259 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48540){
var state_val_48541 = (state_48540[(1)]);
if((state_val_48541 === (7))){
var state_48540__$1 = state_48540;
var statearr_48542_50260 = state_48540__$1;
(statearr_48542_50260[(2)] = null);

(statearr_48542_50260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (1))){
var state_48540__$1 = state_48540;
var statearr_48543_50261 = state_48540__$1;
(statearr_48543_50261[(2)] = null);

(statearr_48543_50261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (4))){
var inst_48501 = (state_48540[(7)]);
var inst_48500 = (state_48540[(8)]);
var inst_48503 = (inst_48501 < inst_48500);
var state_48540__$1 = state_48540;
if(cljs.core.truth_(inst_48503)){
var statearr_48558_50270 = state_48540__$1;
(statearr_48558_50270[(1)] = (6));

} else {
var statearr_48559_50271 = state_48540__$1;
(statearr_48559_50271[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (15))){
var inst_48526 = (state_48540[(9)]);
var inst_48531 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_48526);
var state_48540__$1 = state_48540;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48540__$1,(17),out,inst_48531);
} else {
if((state_val_48541 === (13))){
var inst_48526 = (state_48540[(9)]);
var inst_48526__$1 = (state_48540[(2)]);
var inst_48527 = cljs.core.some(cljs.core.nil_QMARK_,inst_48526__$1);
var state_48540__$1 = (function (){var statearr_48566 = state_48540;
(statearr_48566[(9)] = inst_48526__$1);

return statearr_48566;
})();
if(cljs.core.truth_(inst_48527)){
var statearr_48567_50274 = state_48540__$1;
(statearr_48567_50274[(1)] = (14));

} else {
var statearr_48568_50275 = state_48540__$1;
(statearr_48568_50275[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (6))){
var state_48540__$1 = state_48540;
var statearr_48569_50276 = state_48540__$1;
(statearr_48569_50276[(2)] = null);

(statearr_48569_50276[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (17))){
var inst_48533 = (state_48540[(2)]);
var state_48540__$1 = (function (){var statearr_48591 = state_48540;
(statearr_48591[(10)] = inst_48533);

return statearr_48591;
})();
var statearr_48592_50279 = state_48540__$1;
(statearr_48592_50279[(2)] = null);

(statearr_48592_50279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (3))){
var inst_48538 = (state_48540[(2)]);
var state_48540__$1 = state_48540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48540__$1,inst_48538);
} else {
if((state_val_48541 === (12))){
var _ = (function (){var statearr_48593 = state_48540;
(statearr_48593[(4)] = cljs.core.rest((state_48540[(4)])));

return statearr_48593;
})();
var state_48540__$1 = state_48540;
var ex48590 = (state_48540__$1[(2)]);
var statearr_48596_50282 = state_48540__$1;
(statearr_48596_50282[(5)] = ex48590);


if((ex48590 instanceof Object)){
var statearr_48597_50283 = state_48540__$1;
(statearr_48597_50283[(1)] = (11));

(statearr_48597_50283[(5)] = null);

} else {
throw ex48590;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (2))){
var inst_48499 = cljs.core.reset_BANG_(dctr,cnt);
var inst_48500 = cnt;
var inst_48501 = (0);
var state_48540__$1 = (function (){var statearr_48599 = state_48540;
(statearr_48599[(7)] = inst_48501);

(statearr_48599[(8)] = inst_48500);

(statearr_48599[(11)] = inst_48499);

return statearr_48599;
})();
var statearr_48600_50286 = state_48540__$1;
(statearr_48600_50286[(2)] = null);

(statearr_48600_50286[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (11))){
var inst_48505 = (state_48540[(2)]);
var inst_48506 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_48540__$1 = (function (){var statearr_48601 = state_48540;
(statearr_48601[(12)] = inst_48505);

return statearr_48601;
})();
var statearr_48602_50293 = state_48540__$1;
(statearr_48602_50293[(2)] = inst_48506);

(statearr_48602_50293[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (9))){
var inst_48501 = (state_48540[(7)]);
var _ = (function (){var statearr_48606 = state_48540;
(statearr_48606[(4)] = cljs.core.cons((12),(state_48540[(4)])));

return statearr_48606;
})();
var inst_48512 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_48501) : chs__$1.call(null,inst_48501));
var inst_48513 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_48501) : done.call(null,inst_48501));
var inst_48514 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_48512,inst_48513);
var ___$1 = (function (){var statearr_48607 = state_48540;
(statearr_48607[(4)] = cljs.core.rest((state_48540[(4)])));

return statearr_48607;
})();
var state_48540__$1 = state_48540;
var statearr_48608_50298 = state_48540__$1;
(statearr_48608_50298[(2)] = inst_48514);

(statearr_48608_50298[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (5))){
var inst_48524 = (state_48540[(2)]);
var state_48540__$1 = (function (){var statearr_48609 = state_48540;
(statearr_48609[(13)] = inst_48524);

return statearr_48609;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48540__$1,(13),dchan);
} else {
if((state_val_48541 === (14))){
var inst_48529 = cljs.core.async.close_BANG_(out);
var state_48540__$1 = state_48540;
var statearr_48610_50300 = state_48540__$1;
(statearr_48610_50300[(2)] = inst_48529);

(statearr_48610_50300[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (16))){
var inst_48536 = (state_48540[(2)]);
var state_48540__$1 = state_48540;
var statearr_48611_50301 = state_48540__$1;
(statearr_48611_50301[(2)] = inst_48536);

(statearr_48611_50301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (10))){
var inst_48501 = (state_48540[(7)]);
var inst_48517 = (state_48540[(2)]);
var inst_48518 = (inst_48501 + (1));
var inst_48501__$1 = inst_48518;
var state_48540__$1 = (function (){var statearr_48612 = state_48540;
(statearr_48612[(14)] = inst_48517);

(statearr_48612[(7)] = inst_48501__$1);

return statearr_48612;
})();
var statearr_48613_50304 = state_48540__$1;
(statearr_48613_50304[(2)] = null);

(statearr_48613_50304[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48541 === (8))){
var inst_48522 = (state_48540[(2)]);
var state_48540__$1 = state_48540;
var statearr_48614_50307 = state_48540__$1;
(statearr_48614_50307[(2)] = inst_48522);

(statearr_48614_50307[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_48615 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48615[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_48615[(1)] = (1));

return statearr_48615;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_48540){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48540);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48616){var ex__46360__auto__ = e48616;
var statearr_48617_50309 = state_48540;
(statearr_48617_50309[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48540[(4)]))){
var statearr_48618_50310 = state_48540;
(statearr_48618_50310[(1)] = cljs.core.first((state_48540[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50314 = state_48540;
state_48540 = G__50314;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_48540){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_48540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48619 = f__47047__auto__();
(statearr_48619[(6)] = c__47046__auto___50259);

return statearr_48619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__48622 = arguments.length;
switch (G__48622) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47046__auto___50319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48654){
var state_val_48655 = (state_48654[(1)]);
if((state_val_48655 === (7))){
var inst_48633 = (state_48654[(7)]);
var inst_48634 = (state_48654[(8)]);
var inst_48633__$1 = (state_48654[(2)]);
var inst_48634__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48633__$1,(0),null);
var inst_48635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48633__$1,(1),null);
var inst_48636 = (inst_48634__$1 == null);
var state_48654__$1 = (function (){var statearr_48656 = state_48654;
(statearr_48656[(7)] = inst_48633__$1);

(statearr_48656[(8)] = inst_48634__$1);

(statearr_48656[(9)] = inst_48635);

return statearr_48656;
})();
if(cljs.core.truth_(inst_48636)){
var statearr_48657_50324 = state_48654__$1;
(statearr_48657_50324[(1)] = (8));

} else {
var statearr_48658_50325 = state_48654__$1;
(statearr_48658_50325[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48655 === (1))){
var inst_48623 = cljs.core.vec(chs);
var inst_48624 = inst_48623;
var state_48654__$1 = (function (){var statearr_48659 = state_48654;
(statearr_48659[(10)] = inst_48624);

return statearr_48659;
})();
var statearr_48660_50330 = state_48654__$1;
(statearr_48660_50330[(2)] = null);

(statearr_48660_50330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48655 === (4))){
var inst_48624 = (state_48654[(10)]);
var state_48654__$1 = state_48654;
return cljs.core.async.ioc_alts_BANG_(state_48654__$1,(7),inst_48624);
} else {
if((state_val_48655 === (6))){
var inst_48650 = (state_48654[(2)]);
var state_48654__$1 = state_48654;
var statearr_48661_50331 = state_48654__$1;
(statearr_48661_50331[(2)] = inst_48650);

(statearr_48661_50331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48655 === (3))){
var inst_48652 = (state_48654[(2)]);
var state_48654__$1 = state_48654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48654__$1,inst_48652);
} else {
if((state_val_48655 === (2))){
var inst_48624 = (state_48654[(10)]);
var inst_48626 = cljs.core.count(inst_48624);
var inst_48627 = (inst_48626 > (0));
var state_48654__$1 = state_48654;
if(cljs.core.truth_(inst_48627)){
var statearr_48663_50332 = state_48654__$1;
(statearr_48663_50332[(1)] = (4));

} else {
var statearr_48664_50337 = state_48654__$1;
(statearr_48664_50337[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48655 === (11))){
var inst_48624 = (state_48654[(10)]);
var inst_48643 = (state_48654[(2)]);
var tmp48662 = inst_48624;
var inst_48624__$1 = tmp48662;
var state_48654__$1 = (function (){var statearr_48665 = state_48654;
(statearr_48665[(10)] = inst_48624__$1);

(statearr_48665[(11)] = inst_48643);

return statearr_48665;
})();
var statearr_48666_50338 = state_48654__$1;
(statearr_48666_50338[(2)] = null);

(statearr_48666_50338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48655 === (9))){
var inst_48634 = (state_48654[(8)]);
var state_48654__$1 = state_48654;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48654__$1,(11),out,inst_48634);
} else {
if((state_val_48655 === (5))){
var inst_48648 = cljs.core.async.close_BANG_(out);
var state_48654__$1 = state_48654;
var statearr_48678_50346 = state_48654__$1;
(statearr_48678_50346[(2)] = inst_48648);

(statearr_48678_50346[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48655 === (10))){
var inst_48646 = (state_48654[(2)]);
var state_48654__$1 = state_48654;
var statearr_48679_50349 = state_48654__$1;
(statearr_48679_50349[(2)] = inst_48646);

(statearr_48679_50349[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48655 === (8))){
var inst_48633 = (state_48654[(7)]);
var inst_48634 = (state_48654[(8)]);
var inst_48624 = (state_48654[(10)]);
var inst_48635 = (state_48654[(9)]);
var inst_48638 = (function (){var cs = inst_48624;
var vec__48629 = inst_48633;
var v = inst_48634;
var c = inst_48635;
return (function (p1__48620_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__48620_SHARP_);
});
})();
var inst_48639 = cljs.core.filterv(inst_48638,inst_48624);
var inst_48624__$1 = inst_48639;
var state_48654__$1 = (function (){var statearr_48680 = state_48654;
(statearr_48680[(10)] = inst_48624__$1);

return statearr_48680;
})();
var statearr_48681_50353 = state_48654__$1;
(statearr_48681_50353[(2)] = null);

(statearr_48681_50353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_48682 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48682[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_48682[(1)] = (1));

return statearr_48682;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_48654){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48654);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48683){var ex__46360__auto__ = e48683;
var statearr_48684_50361 = state_48654;
(statearr_48684_50361[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48654[(4)]))){
var statearr_48685_50363 = state_48654;
(statearr_48685_50363[(1)] = cljs.core.first((state_48654[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50365 = state_48654;
state_48654 = G__50365;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_48654){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_48654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48686 = f__47047__auto__();
(statearr_48686[(6)] = c__47046__auto___50319);

return statearr_48686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__48688 = arguments.length;
switch (G__48688) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47046__auto___50373 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48712){
var state_val_48713 = (state_48712[(1)]);
if((state_val_48713 === (7))){
var inst_48694 = (state_48712[(7)]);
var inst_48694__$1 = (state_48712[(2)]);
var inst_48695 = (inst_48694__$1 == null);
var inst_48696 = cljs.core.not(inst_48695);
var state_48712__$1 = (function (){var statearr_48715 = state_48712;
(statearr_48715[(7)] = inst_48694__$1);

return statearr_48715;
})();
if(inst_48696){
var statearr_48717_50374 = state_48712__$1;
(statearr_48717_50374[(1)] = (8));

} else {
var statearr_48718_50375 = state_48712__$1;
(statearr_48718_50375[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (1))){
var inst_48689 = (0);
var state_48712__$1 = (function (){var statearr_48719 = state_48712;
(statearr_48719[(8)] = inst_48689);

return statearr_48719;
})();
var statearr_48720_50377 = state_48712__$1;
(statearr_48720_50377[(2)] = null);

(statearr_48720_50377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (4))){
var state_48712__$1 = state_48712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48712__$1,(7),ch);
} else {
if((state_val_48713 === (6))){
var inst_48707 = (state_48712[(2)]);
var state_48712__$1 = state_48712;
var statearr_48723_50378 = state_48712__$1;
(statearr_48723_50378[(2)] = inst_48707);

(statearr_48723_50378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (3))){
var inst_48709 = (state_48712[(2)]);
var inst_48710 = cljs.core.async.close_BANG_(out);
var state_48712__$1 = (function (){var statearr_48724 = state_48712;
(statearr_48724[(9)] = inst_48709);

return statearr_48724;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48712__$1,inst_48710);
} else {
if((state_val_48713 === (2))){
var inst_48689 = (state_48712[(8)]);
var inst_48691 = (inst_48689 < n);
var state_48712__$1 = state_48712;
if(cljs.core.truth_(inst_48691)){
var statearr_48726_50379 = state_48712__$1;
(statearr_48726_50379[(1)] = (4));

} else {
var statearr_48728_50380 = state_48712__$1;
(statearr_48728_50380[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (11))){
var inst_48689 = (state_48712[(8)]);
var inst_48699 = (state_48712[(2)]);
var inst_48700 = (inst_48689 + (1));
var inst_48689__$1 = inst_48700;
var state_48712__$1 = (function (){var statearr_48729 = state_48712;
(statearr_48729[(8)] = inst_48689__$1);

(statearr_48729[(10)] = inst_48699);

return statearr_48729;
})();
var statearr_48730_50382 = state_48712__$1;
(statearr_48730_50382[(2)] = null);

(statearr_48730_50382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (9))){
var state_48712__$1 = state_48712;
var statearr_48731_50383 = state_48712__$1;
(statearr_48731_50383[(2)] = null);

(statearr_48731_50383[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (5))){
var state_48712__$1 = state_48712;
var statearr_48733_50384 = state_48712__$1;
(statearr_48733_50384[(2)] = null);

(statearr_48733_50384[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (10))){
var inst_48704 = (state_48712[(2)]);
var state_48712__$1 = state_48712;
var statearr_48735_50385 = state_48712__$1;
(statearr_48735_50385[(2)] = inst_48704);

(statearr_48735_50385[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48713 === (8))){
var inst_48694 = (state_48712[(7)]);
var state_48712__$1 = state_48712;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48712__$1,(11),out,inst_48694);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_48736 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48736[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_48736[(1)] = (1));

return statearr_48736;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_48712){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48712);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48737){var ex__46360__auto__ = e48737;
var statearr_48738_50387 = state_48712;
(statearr_48738_50387[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48712[(4)]))){
var statearr_48739_50388 = state_48712;
(statearr_48739_50388[(1)] = cljs.core.first((state_48712[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50393 = state_48712;
state_48712 = G__50393;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_48712){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_48712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48740 = f__47047__auto__();
(statearr_48740[(6)] = c__47046__auto___50373);

return statearr_48740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48742 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48742 = (function (f,ch,meta48743){
this.f = f;
this.ch = ch;
this.meta48743 = meta48743;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48744,meta48743__$1){
var self__ = this;
var _48744__$1 = this;
return (new cljs.core.async.t_cljs$core$async48742(self__.f,self__.ch,meta48743__$1));
}));

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48744){
var self__ = this;
var _48744__$1 = this;
return self__.meta48743;
}));

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48745 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48745 = (function (f,ch,meta48743,_,fn1,meta48746){
this.f = f;
this.ch = ch;
this.meta48743 = meta48743;
this._ = _;
this.fn1 = fn1;
this.meta48746 = meta48746;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48745.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48747,meta48746__$1){
var self__ = this;
var _48747__$1 = this;
return (new cljs.core.async.t_cljs$core$async48745(self__.f,self__.ch,self__.meta48743,self__._,self__.fn1,meta48746__$1));
}));

(cljs.core.async.t_cljs$core$async48745.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48747){
var self__ = this;
var _48747__$1 = this;
return self__.meta48746;
}));

(cljs.core.async.t_cljs$core$async48745.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48745.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async48745.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async48745.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__48741_SHARP_){
var G__48751 = (((p1__48741_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__48741_SHARP_) : self__.f.call(null,p1__48741_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__48751) : f1.call(null,G__48751));
});
}));

(cljs.core.async.t_cljs$core$async48745.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48743","meta48743",-623031684,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48742","cljs.core.async/t_cljs$core$async48742",116494499,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48746","meta48746",340606027,null)], null);
}));

(cljs.core.async.t_cljs$core$async48745.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48745.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48745");

(cljs.core.async.t_cljs$core$async48745.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48745");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48745.
 */
cljs.core.async.__GT_t_cljs$core$async48745 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48745(f__$1,ch__$1,meta48743__$1,___$2,fn1__$1,meta48746){
return (new cljs.core.async.t_cljs$core$async48745(f__$1,ch__$1,meta48743__$1,___$2,fn1__$1,meta48746));
});

}

return (new cljs.core.async.t_cljs$core$async48745(self__.f,self__.ch,self__.meta48743,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4149__auto__ = ret;
if(cljs.core.truth_(and__4149__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4149__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__48762 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__48762) : self__.f.call(null,G__48762));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48742.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async48742.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48743","meta48743",-623031684,null)], null);
}));

(cljs.core.async.t_cljs$core$async48742.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48742.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48742");

(cljs.core.async.t_cljs$core$async48742.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48742");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48742.
 */
cljs.core.async.__GT_t_cljs$core$async48742 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48742(f__$1,ch__$1,meta48743){
return (new cljs.core.async.t_cljs$core$async48742(f__$1,ch__$1,meta48743));
});

}

return (new cljs.core.async.t_cljs$core$async48742(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48776 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48776 = (function (f,ch,meta48777){
this.f = f;
this.ch = ch;
this.meta48777 = meta48777;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48778,meta48777__$1){
var self__ = this;
var _48778__$1 = this;
return (new cljs.core.async.t_cljs$core$async48776(self__.f,self__.ch,meta48777__$1));
}));

(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48778){
var self__ = this;
var _48778__$1 = this;
return self__.meta48777;
}));

(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48776.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async48776.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48777","meta48777",-1235567256,null)], null);
}));

(cljs.core.async.t_cljs$core$async48776.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48776.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48776");

(cljs.core.async.t_cljs$core$async48776.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48776");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48776.
 */
cljs.core.async.__GT_t_cljs$core$async48776 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48776(f__$1,ch__$1,meta48777){
return (new cljs.core.async.t_cljs$core$async48776(f__$1,ch__$1,meta48777));
});

}

return (new cljs.core.async.t_cljs$core$async48776(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48798 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48798 = (function (p,ch,meta48799){
this.p = p;
this.ch = ch;
this.meta48799 = meta48799;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48800,meta48799__$1){
var self__ = this;
var _48800__$1 = this;
return (new cljs.core.async.t_cljs$core$async48798(self__.p,self__.ch,meta48799__$1));
}));

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48800){
var self__ = this;
var _48800__$1 = this;
return self__.meta48799;
}));

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48798.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async48798.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48799","meta48799",-1591211545,null)], null);
}));

(cljs.core.async.t_cljs$core$async48798.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48798.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48798");

(cljs.core.async.t_cljs$core$async48798.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async48798");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48798.
 */
cljs.core.async.__GT_t_cljs$core$async48798 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48798(p__$1,ch__$1,meta48799){
return (new cljs.core.async.t_cljs$core$async48798(p__$1,ch__$1,meta48799));
});

}

return (new cljs.core.async.t_cljs$core$async48798(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__48802 = arguments.length;
switch (G__48802) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47046__auto___50451 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48823){
var state_val_48824 = (state_48823[(1)]);
if((state_val_48824 === (7))){
var inst_48819 = (state_48823[(2)]);
var state_48823__$1 = state_48823;
var statearr_48825_50453 = state_48823__$1;
(statearr_48825_50453[(2)] = inst_48819);

(statearr_48825_50453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (1))){
var state_48823__$1 = state_48823;
var statearr_48826_50455 = state_48823__$1;
(statearr_48826_50455[(2)] = null);

(statearr_48826_50455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (4))){
var inst_48805 = (state_48823[(7)]);
var inst_48805__$1 = (state_48823[(2)]);
var inst_48806 = (inst_48805__$1 == null);
var state_48823__$1 = (function (){var statearr_48829 = state_48823;
(statearr_48829[(7)] = inst_48805__$1);

return statearr_48829;
})();
if(cljs.core.truth_(inst_48806)){
var statearr_48830_50457 = state_48823__$1;
(statearr_48830_50457[(1)] = (5));

} else {
var statearr_48831_50458 = state_48823__$1;
(statearr_48831_50458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (6))){
var inst_48805 = (state_48823[(7)]);
var inst_48810 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_48805) : p.call(null,inst_48805));
var state_48823__$1 = state_48823;
if(cljs.core.truth_(inst_48810)){
var statearr_48832_50460 = state_48823__$1;
(statearr_48832_50460[(1)] = (8));

} else {
var statearr_48833_50462 = state_48823__$1;
(statearr_48833_50462[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (3))){
var inst_48821 = (state_48823[(2)]);
var state_48823__$1 = state_48823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48823__$1,inst_48821);
} else {
if((state_val_48824 === (2))){
var state_48823__$1 = state_48823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48823__$1,(4),ch);
} else {
if((state_val_48824 === (11))){
var inst_48813 = (state_48823[(2)]);
var state_48823__$1 = state_48823;
var statearr_48834_50464 = state_48823__$1;
(statearr_48834_50464[(2)] = inst_48813);

(statearr_48834_50464[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (9))){
var state_48823__$1 = state_48823;
var statearr_48836_50465 = state_48823__$1;
(statearr_48836_50465[(2)] = null);

(statearr_48836_50465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (5))){
var inst_48808 = cljs.core.async.close_BANG_(out);
var state_48823__$1 = state_48823;
var statearr_48847_50466 = state_48823__$1;
(statearr_48847_50466[(2)] = inst_48808);

(statearr_48847_50466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (10))){
var inst_48816 = (state_48823[(2)]);
var state_48823__$1 = (function (){var statearr_48848 = state_48823;
(statearr_48848[(8)] = inst_48816);

return statearr_48848;
})();
var statearr_48849_50467 = state_48823__$1;
(statearr_48849_50467[(2)] = null);

(statearr_48849_50467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48824 === (8))){
var inst_48805 = (state_48823[(7)]);
var state_48823__$1 = state_48823;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48823__$1,(11),out,inst_48805);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_48851 = [null,null,null,null,null,null,null,null,null];
(statearr_48851[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_48851[(1)] = (1));

return statearr_48851;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_48823){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48823);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48852){var ex__46360__auto__ = e48852;
var statearr_48854_50473 = state_48823;
(statearr_48854_50473[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48823[(4)]))){
var statearr_48855_50474 = state_48823;
(statearr_48855_50474[(1)] = cljs.core.first((state_48823[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50479 = state_48823;
state_48823 = G__50479;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_48823){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_48823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48856 = f__47047__auto__();
(statearr_48856[(6)] = c__47046__auto___50451);

return statearr_48856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48858 = arguments.length;
switch (G__48858) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__47046__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_48920){
var state_val_48921 = (state_48920[(1)]);
if((state_val_48921 === (7))){
var inst_48916 = (state_48920[(2)]);
var state_48920__$1 = state_48920;
var statearr_48924_50487 = state_48920__$1;
(statearr_48924_50487[(2)] = inst_48916);

(statearr_48924_50487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (20))){
var inst_48886 = (state_48920[(7)]);
var inst_48897 = (state_48920[(2)]);
var inst_48898 = cljs.core.next(inst_48886);
var inst_48872 = inst_48898;
var inst_48873 = null;
var inst_48874 = (0);
var inst_48875 = (0);
var state_48920__$1 = (function (){var statearr_48925 = state_48920;
(statearr_48925[(8)] = inst_48897);

(statearr_48925[(9)] = inst_48872);

(statearr_48925[(10)] = inst_48874);

(statearr_48925[(11)] = inst_48875);

(statearr_48925[(12)] = inst_48873);

return statearr_48925;
})();
var statearr_48927_50491 = state_48920__$1;
(statearr_48927_50491[(2)] = null);

(statearr_48927_50491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (1))){
var state_48920__$1 = state_48920;
var statearr_48928_50496 = state_48920__$1;
(statearr_48928_50496[(2)] = null);

(statearr_48928_50496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (4))){
var inst_48861 = (state_48920[(13)]);
var inst_48861__$1 = (state_48920[(2)]);
var inst_48862 = (inst_48861__$1 == null);
var state_48920__$1 = (function (){var statearr_48929 = state_48920;
(statearr_48929[(13)] = inst_48861__$1);

return statearr_48929;
})();
if(cljs.core.truth_(inst_48862)){
var statearr_48930_50511 = state_48920__$1;
(statearr_48930_50511[(1)] = (5));

} else {
var statearr_48931_50512 = state_48920__$1;
(statearr_48931_50512[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (15))){
var state_48920__$1 = state_48920;
var statearr_48935_50513 = state_48920__$1;
(statearr_48935_50513[(2)] = null);

(statearr_48935_50513[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (21))){
var state_48920__$1 = state_48920;
var statearr_48936_50524 = state_48920__$1;
(statearr_48936_50524[(2)] = null);

(statearr_48936_50524[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (13))){
var inst_48872 = (state_48920[(9)]);
var inst_48874 = (state_48920[(10)]);
var inst_48875 = (state_48920[(11)]);
var inst_48873 = (state_48920[(12)]);
var inst_48882 = (state_48920[(2)]);
var inst_48883 = (inst_48875 + (1));
var tmp48932 = inst_48872;
var tmp48933 = inst_48874;
var tmp48934 = inst_48873;
var inst_48872__$1 = tmp48932;
var inst_48873__$1 = tmp48934;
var inst_48874__$1 = tmp48933;
var inst_48875__$1 = inst_48883;
var state_48920__$1 = (function (){var statearr_48946 = state_48920;
(statearr_48946[(14)] = inst_48882);

(statearr_48946[(9)] = inst_48872__$1);

(statearr_48946[(10)] = inst_48874__$1);

(statearr_48946[(11)] = inst_48875__$1);

(statearr_48946[(12)] = inst_48873__$1);

return statearr_48946;
})();
var statearr_48947_50530 = state_48920__$1;
(statearr_48947_50530[(2)] = null);

(statearr_48947_50530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (22))){
var state_48920__$1 = state_48920;
var statearr_48948_50535 = state_48920__$1;
(statearr_48948_50535[(2)] = null);

(statearr_48948_50535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (6))){
var inst_48861 = (state_48920[(13)]);
var inst_48870 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48861) : f.call(null,inst_48861));
var inst_48871 = cljs.core.seq(inst_48870);
var inst_48872 = inst_48871;
var inst_48873 = null;
var inst_48874 = (0);
var inst_48875 = (0);
var state_48920__$1 = (function (){var statearr_48949 = state_48920;
(statearr_48949[(9)] = inst_48872);

(statearr_48949[(10)] = inst_48874);

(statearr_48949[(11)] = inst_48875);

(statearr_48949[(12)] = inst_48873);

return statearr_48949;
})();
var statearr_48951_50543 = state_48920__$1;
(statearr_48951_50543[(2)] = null);

(statearr_48951_50543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (17))){
var inst_48886 = (state_48920[(7)]);
var inst_48890 = cljs.core.chunk_first(inst_48886);
var inst_48891 = cljs.core.chunk_rest(inst_48886);
var inst_48892 = cljs.core.count(inst_48890);
var inst_48872 = inst_48891;
var inst_48873 = inst_48890;
var inst_48874 = inst_48892;
var inst_48875 = (0);
var state_48920__$1 = (function (){var statearr_48952 = state_48920;
(statearr_48952[(9)] = inst_48872);

(statearr_48952[(10)] = inst_48874);

(statearr_48952[(11)] = inst_48875);

(statearr_48952[(12)] = inst_48873);

return statearr_48952;
})();
var statearr_48953_50546 = state_48920__$1;
(statearr_48953_50546[(2)] = null);

(statearr_48953_50546[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (3))){
var inst_48918 = (state_48920[(2)]);
var state_48920__$1 = state_48920;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48920__$1,inst_48918);
} else {
if((state_val_48921 === (12))){
var inst_48906 = (state_48920[(2)]);
var state_48920__$1 = state_48920;
var statearr_48954_50548 = state_48920__$1;
(statearr_48954_50548[(2)] = inst_48906);

(statearr_48954_50548[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (2))){
var state_48920__$1 = state_48920;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48920__$1,(4),in$);
} else {
if((state_val_48921 === (23))){
var inst_48914 = (state_48920[(2)]);
var state_48920__$1 = state_48920;
var statearr_48955_50550 = state_48920__$1;
(statearr_48955_50550[(2)] = inst_48914);

(statearr_48955_50550[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (19))){
var inst_48901 = (state_48920[(2)]);
var state_48920__$1 = state_48920;
var statearr_48956_50552 = state_48920__$1;
(statearr_48956_50552[(2)] = inst_48901);

(statearr_48956_50552[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (11))){
var inst_48872 = (state_48920[(9)]);
var inst_48886 = (state_48920[(7)]);
var inst_48886__$1 = cljs.core.seq(inst_48872);
var state_48920__$1 = (function (){var statearr_48957 = state_48920;
(statearr_48957[(7)] = inst_48886__$1);

return statearr_48957;
})();
if(inst_48886__$1){
var statearr_48958_50553 = state_48920__$1;
(statearr_48958_50553[(1)] = (14));

} else {
var statearr_48959_50554 = state_48920__$1;
(statearr_48959_50554[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (9))){
var inst_48908 = (state_48920[(2)]);
var inst_48909 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_48920__$1 = (function (){var statearr_48960 = state_48920;
(statearr_48960[(15)] = inst_48908);

return statearr_48960;
})();
if(cljs.core.truth_(inst_48909)){
var statearr_48961_50555 = state_48920__$1;
(statearr_48961_50555[(1)] = (21));

} else {
var statearr_48962_50556 = state_48920__$1;
(statearr_48962_50556[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (5))){
var inst_48864 = cljs.core.async.close_BANG_(out);
var state_48920__$1 = state_48920;
var statearr_48963_50557 = state_48920__$1;
(statearr_48963_50557[(2)] = inst_48864);

(statearr_48963_50557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (14))){
var inst_48886 = (state_48920[(7)]);
var inst_48888 = cljs.core.chunked_seq_QMARK_(inst_48886);
var state_48920__$1 = state_48920;
if(inst_48888){
var statearr_48968_50558 = state_48920__$1;
(statearr_48968_50558[(1)] = (17));

} else {
var statearr_48971_50559 = state_48920__$1;
(statearr_48971_50559[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (16))){
var inst_48904 = (state_48920[(2)]);
var state_48920__$1 = state_48920;
var statearr_48972_50561 = state_48920__$1;
(statearr_48972_50561[(2)] = inst_48904);

(statearr_48972_50561[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48921 === (10))){
var inst_48875 = (state_48920[(11)]);
var inst_48873 = (state_48920[(12)]);
var inst_48880 = cljs.core._nth(inst_48873,inst_48875);
var state_48920__$1 = state_48920;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48920__$1,(13),out,inst_48880);
} else {
if((state_val_48921 === (18))){
var inst_48886 = (state_48920[(7)]);
var inst_48895 = cljs.core.first(inst_48886);
var state_48920__$1 = state_48920;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48920__$1,(20),out,inst_48895);
} else {
if((state_val_48921 === (8))){
var inst_48874 = (state_48920[(10)]);
var inst_48875 = (state_48920[(11)]);
var inst_48877 = (inst_48875 < inst_48874);
var inst_48878 = inst_48877;
var state_48920__$1 = state_48920;
if(cljs.core.truth_(inst_48878)){
var statearr_48981_50565 = state_48920__$1;
(statearr_48981_50565[(1)] = (10));

} else {
var statearr_48984_50566 = state_48920__$1;
(statearr_48984_50566[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__46357__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__46357__auto____0 = (function (){
var statearr_48987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48987[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__46357__auto__);

(statearr_48987[(1)] = (1));

return statearr_48987;
});
var cljs$core$async$mapcat_STAR__$_state_machine__46357__auto____1 = (function (state_48920){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_48920);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e48988){var ex__46360__auto__ = e48988;
var statearr_48989_50568 = state_48920;
(statearr_48989_50568[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_48920[(4)]))){
var statearr_48990_50569 = state_48920;
(statearr_48990_50569[(1)] = cljs.core.first((state_48920[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50570 = state_48920;
state_48920 = G__50570;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__46357__auto__ = function(state_48920){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__46357__auto____1.call(this,state_48920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__46357__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__46357__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_48992 = f__47047__auto__();
(statearr_48992[(6)] = c__47046__auto__);

return statearr_48992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));

return c__47046__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48995 = arguments.length;
switch (G__48995) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__49004 = arguments.length;
switch (G__49004) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__49016 = arguments.length;
switch (G__49016) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47046__auto___50614 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_49051){
var state_val_49052 = (state_49051[(1)]);
if((state_val_49052 === (7))){
var inst_49046 = (state_49051[(2)]);
var state_49051__$1 = state_49051;
var statearr_49054_50621 = state_49051__$1;
(statearr_49054_50621[(2)] = inst_49046);

(statearr_49054_50621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49052 === (1))){
var inst_49021 = null;
var state_49051__$1 = (function (){var statearr_49055 = state_49051;
(statearr_49055[(7)] = inst_49021);

return statearr_49055;
})();
var statearr_49056_50630 = state_49051__$1;
(statearr_49056_50630[(2)] = null);

(statearr_49056_50630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49052 === (4))){
var inst_49031 = (state_49051[(8)]);
var inst_49031__$1 = (state_49051[(2)]);
var inst_49032 = (inst_49031__$1 == null);
var inst_49033 = cljs.core.not(inst_49032);
var state_49051__$1 = (function (){var statearr_49059 = state_49051;
(statearr_49059[(8)] = inst_49031__$1);

return statearr_49059;
})();
if(inst_49033){
var statearr_49060_50644 = state_49051__$1;
(statearr_49060_50644[(1)] = (5));

} else {
var statearr_49061_50645 = state_49051__$1;
(statearr_49061_50645[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49052 === (6))){
var state_49051__$1 = state_49051;
var statearr_49065_50652 = state_49051__$1;
(statearr_49065_50652[(2)] = null);

(statearr_49065_50652[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49052 === (3))){
var inst_49048 = (state_49051[(2)]);
var inst_49049 = cljs.core.async.close_BANG_(out);
var state_49051__$1 = (function (){var statearr_49068 = state_49051;
(statearr_49068[(9)] = inst_49048);

return statearr_49068;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49051__$1,inst_49049);
} else {
if((state_val_49052 === (2))){
var state_49051__$1 = state_49051;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49051__$1,(4),ch);
} else {
if((state_val_49052 === (11))){
var inst_49031 = (state_49051[(8)]);
var inst_49040 = (state_49051[(2)]);
var inst_49021 = inst_49031;
var state_49051__$1 = (function (){var statearr_49069 = state_49051;
(statearr_49069[(10)] = inst_49040);

(statearr_49069[(7)] = inst_49021);

return statearr_49069;
})();
var statearr_49070_50678 = state_49051__$1;
(statearr_49070_50678[(2)] = null);

(statearr_49070_50678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49052 === (9))){
var inst_49031 = (state_49051[(8)]);
var state_49051__$1 = state_49051;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49051__$1,(11),out,inst_49031);
} else {
if((state_val_49052 === (5))){
var inst_49031 = (state_49051[(8)]);
var inst_49021 = (state_49051[(7)]);
var inst_49035 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49031,inst_49021);
var state_49051__$1 = state_49051;
if(inst_49035){
var statearr_49076_50679 = state_49051__$1;
(statearr_49076_50679[(1)] = (8));

} else {
var statearr_49077_50685 = state_49051__$1;
(statearr_49077_50685[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49052 === (10))){
var inst_49043 = (state_49051[(2)]);
var state_49051__$1 = state_49051;
var statearr_49079_50690 = state_49051__$1;
(statearr_49079_50690[(2)] = inst_49043);

(statearr_49079_50690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49052 === (8))){
var inst_49021 = (state_49051[(7)]);
var tmp49072 = inst_49021;
var inst_49021__$1 = tmp49072;
var state_49051__$1 = (function (){var statearr_49080 = state_49051;
(statearr_49080[(7)] = inst_49021__$1);

return statearr_49080;
})();
var statearr_49081_50702 = state_49051__$1;
(statearr_49081_50702[(2)] = null);

(statearr_49081_50702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_49082 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49082[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_49082[(1)] = (1));

return statearr_49082;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_49051){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_49051);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e49083){var ex__46360__auto__ = e49083;
var statearr_49084_50711 = state_49051;
(statearr_49084_50711[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_49051[(4)]))){
var statearr_49085_50713 = state_49051;
(statearr_49085_50713[(1)] = cljs.core.first((state_49051[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50720 = state_49051;
state_49051 = G__50720;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_49051){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_49051);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_49087 = f__47047__auto__();
(statearr_49087[(6)] = c__47046__auto___50614);

return statearr_49087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__49096 = arguments.length;
switch (G__49096) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47046__auto___50740 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_49137){
var state_val_49138 = (state_49137[(1)]);
if((state_val_49138 === (7))){
var inst_49133 = (state_49137[(2)]);
var state_49137__$1 = state_49137;
var statearr_49141_50749 = state_49137__$1;
(statearr_49141_50749[(2)] = inst_49133);

(statearr_49141_50749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (1))){
var inst_49098 = (new Array(n));
var inst_49099 = inst_49098;
var inst_49100 = (0);
var state_49137__$1 = (function (){var statearr_49142 = state_49137;
(statearr_49142[(7)] = inst_49099);

(statearr_49142[(8)] = inst_49100);

return statearr_49142;
})();
var statearr_49143_50772 = state_49137__$1;
(statearr_49143_50772[(2)] = null);

(statearr_49143_50772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (4))){
var inst_49103 = (state_49137[(9)]);
var inst_49103__$1 = (state_49137[(2)]);
var inst_49104 = (inst_49103__$1 == null);
var inst_49105 = cljs.core.not(inst_49104);
var state_49137__$1 = (function (){var statearr_49145 = state_49137;
(statearr_49145[(9)] = inst_49103__$1);

return statearr_49145;
})();
if(inst_49105){
var statearr_49146_50793 = state_49137__$1;
(statearr_49146_50793[(1)] = (5));

} else {
var statearr_49147_50798 = state_49137__$1;
(statearr_49147_50798[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (15))){
var inst_49127 = (state_49137[(2)]);
var state_49137__$1 = state_49137;
var statearr_49149_50814 = state_49137__$1;
(statearr_49149_50814[(2)] = inst_49127);

(statearr_49149_50814[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (13))){
var state_49137__$1 = state_49137;
var statearr_49150_50824 = state_49137__$1;
(statearr_49150_50824[(2)] = null);

(statearr_49150_50824[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (6))){
var inst_49100 = (state_49137[(8)]);
var inst_49123 = (inst_49100 > (0));
var state_49137__$1 = state_49137;
if(cljs.core.truth_(inst_49123)){
var statearr_49151_50828 = state_49137__$1;
(statearr_49151_50828[(1)] = (12));

} else {
var statearr_49152_50829 = state_49137__$1;
(statearr_49152_50829[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (3))){
var inst_49135 = (state_49137[(2)]);
var state_49137__$1 = state_49137;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49137__$1,inst_49135);
} else {
if((state_val_49138 === (12))){
var inst_49099 = (state_49137[(7)]);
var inst_49125 = cljs.core.vec(inst_49099);
var state_49137__$1 = state_49137;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49137__$1,(15),out,inst_49125);
} else {
if((state_val_49138 === (2))){
var state_49137__$1 = state_49137;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49137__$1,(4),ch);
} else {
if((state_val_49138 === (11))){
var inst_49115 = (state_49137[(2)]);
var inst_49116 = (new Array(n));
var inst_49099 = inst_49116;
var inst_49100 = (0);
var state_49137__$1 = (function (){var statearr_49153 = state_49137;
(statearr_49153[(7)] = inst_49099);

(statearr_49153[(8)] = inst_49100);

(statearr_49153[(10)] = inst_49115);

return statearr_49153;
})();
var statearr_49154_50848 = state_49137__$1;
(statearr_49154_50848[(2)] = null);

(statearr_49154_50848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (9))){
var inst_49099 = (state_49137[(7)]);
var inst_49113 = cljs.core.vec(inst_49099);
var state_49137__$1 = state_49137;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49137__$1,(11),out,inst_49113);
} else {
if((state_val_49138 === (5))){
var inst_49099 = (state_49137[(7)]);
var inst_49103 = (state_49137[(9)]);
var inst_49100 = (state_49137[(8)]);
var inst_49108 = (state_49137[(11)]);
var inst_49107 = (inst_49099[inst_49100] = inst_49103);
var inst_49108__$1 = (inst_49100 + (1));
var inst_49109 = (inst_49108__$1 < n);
var state_49137__$1 = (function (){var statearr_49155 = state_49137;
(statearr_49155[(12)] = inst_49107);

(statearr_49155[(11)] = inst_49108__$1);

return statearr_49155;
})();
if(cljs.core.truth_(inst_49109)){
var statearr_49156_50880 = state_49137__$1;
(statearr_49156_50880[(1)] = (8));

} else {
var statearr_49161_50883 = state_49137__$1;
(statearr_49161_50883[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (14))){
var inst_49130 = (state_49137[(2)]);
var inst_49131 = cljs.core.async.close_BANG_(out);
var state_49137__$1 = (function (){var statearr_49163 = state_49137;
(statearr_49163[(13)] = inst_49130);

return statearr_49163;
})();
var statearr_49164_50888 = state_49137__$1;
(statearr_49164_50888[(2)] = inst_49131);

(statearr_49164_50888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (10))){
var inst_49121 = (state_49137[(2)]);
var state_49137__$1 = state_49137;
var statearr_49165_50896 = state_49137__$1;
(statearr_49165_50896[(2)] = inst_49121);

(statearr_49165_50896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49138 === (8))){
var inst_49099 = (state_49137[(7)]);
var inst_49108 = (state_49137[(11)]);
var tmp49162 = inst_49099;
var inst_49099__$1 = tmp49162;
var inst_49100 = inst_49108;
var state_49137__$1 = (function (){var statearr_49167 = state_49137;
(statearr_49167[(7)] = inst_49099__$1);

(statearr_49167[(8)] = inst_49100);

return statearr_49167;
})();
var statearr_49168_50910 = state_49137__$1;
(statearr_49168_50910[(2)] = null);

(statearr_49168_50910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_49169 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49169[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_49169[(1)] = (1));

return statearr_49169;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_49137){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_49137);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e49176){var ex__46360__auto__ = e49176;
var statearr_49177_50917 = state_49137;
(statearr_49177_50917[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_49137[(4)]))){
var statearr_49178_50918 = state_49137;
(statearr_49178_50918[(1)] = cljs.core.first((state_49137[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50924 = state_49137;
state_49137 = G__50924;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_49137){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_49137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_49182 = f__47047__auto__();
(statearr_49182[(6)] = c__47046__auto___50740);

return statearr_49182;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__49188 = arguments.length;
switch (G__49188) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47046__auto___50936 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47047__auto__ = (function (){var switch__46356__auto__ = (function (state_49242){
var state_val_49243 = (state_49242[(1)]);
if((state_val_49243 === (7))){
var inst_49238 = (state_49242[(2)]);
var state_49242__$1 = state_49242;
var statearr_49244_50940 = state_49242__$1;
(statearr_49244_50940[(2)] = inst_49238);

(statearr_49244_50940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (1))){
var inst_49195 = [];
var inst_49196 = inst_49195;
var inst_49197 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_49242__$1 = (function (){var statearr_49246 = state_49242;
(statearr_49246[(7)] = inst_49197);

(statearr_49246[(8)] = inst_49196);

return statearr_49246;
})();
var statearr_49247_50946 = state_49242__$1;
(statearr_49247_50946[(2)] = null);

(statearr_49247_50946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (4))){
var inst_49200 = (state_49242[(9)]);
var inst_49200__$1 = (state_49242[(2)]);
var inst_49201 = (inst_49200__$1 == null);
var inst_49202 = cljs.core.not(inst_49201);
var state_49242__$1 = (function (){var statearr_49249 = state_49242;
(statearr_49249[(9)] = inst_49200__$1);

return statearr_49249;
})();
if(inst_49202){
var statearr_49250_50948 = state_49242__$1;
(statearr_49250_50948[(1)] = (5));

} else {
var statearr_49251_50949 = state_49242__$1;
(statearr_49251_50949[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (15))){
var inst_49232 = (state_49242[(2)]);
var state_49242__$1 = state_49242;
var statearr_49252_50951 = state_49242__$1;
(statearr_49252_50951[(2)] = inst_49232);

(statearr_49252_50951[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (13))){
var state_49242__$1 = state_49242;
var statearr_49253_50959 = state_49242__$1;
(statearr_49253_50959[(2)] = null);

(statearr_49253_50959[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (6))){
var inst_49196 = (state_49242[(8)]);
var inst_49227 = inst_49196.length;
var inst_49228 = (inst_49227 > (0));
var state_49242__$1 = state_49242;
if(cljs.core.truth_(inst_49228)){
var statearr_49254_50961 = state_49242__$1;
(statearr_49254_50961[(1)] = (12));

} else {
var statearr_49255_50962 = state_49242__$1;
(statearr_49255_50962[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (3))){
var inst_49240 = (state_49242[(2)]);
var state_49242__$1 = state_49242;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49242__$1,inst_49240);
} else {
if((state_val_49243 === (12))){
var inst_49196 = (state_49242[(8)]);
var inst_49230 = cljs.core.vec(inst_49196);
var state_49242__$1 = state_49242;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49242__$1,(15),out,inst_49230);
} else {
if((state_val_49243 === (2))){
var state_49242__$1 = state_49242;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49242__$1,(4),ch);
} else {
if((state_val_49243 === (11))){
var inst_49200 = (state_49242[(9)]);
var inst_49204 = (state_49242[(10)]);
var inst_49214 = (state_49242[(2)]);
var inst_49215 = [];
var inst_49222 = inst_49215.push(inst_49200);
var inst_49196 = inst_49215;
var inst_49197 = inst_49204;
var state_49242__$1 = (function (){var statearr_49266 = state_49242;
(statearr_49266[(11)] = inst_49214);

(statearr_49266[(7)] = inst_49197);

(statearr_49266[(12)] = inst_49222);

(statearr_49266[(8)] = inst_49196);

return statearr_49266;
})();
var statearr_49267_50964 = state_49242__$1;
(statearr_49267_50964[(2)] = null);

(statearr_49267_50964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (9))){
var inst_49196 = (state_49242[(8)]);
var inst_49212 = cljs.core.vec(inst_49196);
var state_49242__$1 = state_49242;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49242__$1,(11),out,inst_49212);
} else {
if((state_val_49243 === (5))){
var inst_49200 = (state_49242[(9)]);
var inst_49197 = (state_49242[(7)]);
var inst_49204 = (state_49242[(10)]);
var inst_49204__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_49200) : f.call(null,inst_49200));
var inst_49205 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49204__$1,inst_49197);
var inst_49206 = cljs.core.keyword_identical_QMARK_(inst_49197,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_49207 = ((inst_49205) || (inst_49206));
var state_49242__$1 = (function (){var statearr_49268 = state_49242;
(statearr_49268[(10)] = inst_49204__$1);

return statearr_49268;
})();
if(cljs.core.truth_(inst_49207)){
var statearr_49270_50968 = state_49242__$1;
(statearr_49270_50968[(1)] = (8));

} else {
var statearr_49271_50969 = state_49242__$1;
(statearr_49271_50969[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (14))){
var inst_49235 = (state_49242[(2)]);
var inst_49236 = cljs.core.async.close_BANG_(out);
var state_49242__$1 = (function (){var statearr_49273 = state_49242;
(statearr_49273[(13)] = inst_49235);

return statearr_49273;
})();
var statearr_49274_50973 = state_49242__$1;
(statearr_49274_50973[(2)] = inst_49236);

(statearr_49274_50973[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (10))){
var inst_49225 = (state_49242[(2)]);
var state_49242__$1 = state_49242;
var statearr_49275_50974 = state_49242__$1;
(statearr_49275_50974[(2)] = inst_49225);

(statearr_49275_50974[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49243 === (8))){
var inst_49200 = (state_49242[(9)]);
var inst_49204 = (state_49242[(10)]);
var inst_49196 = (state_49242[(8)]);
var inst_49209 = inst_49196.push(inst_49200);
var tmp49272 = inst_49196;
var inst_49196__$1 = tmp49272;
var inst_49197 = inst_49204;
var state_49242__$1 = (function (){var statearr_49277 = state_49242;
(statearr_49277[(14)] = inst_49209);

(statearr_49277[(7)] = inst_49197);

(statearr_49277[(8)] = inst_49196__$1);

return statearr_49277;
})();
var statearr_49278_50977 = state_49242__$1;
(statearr_49278_50977[(2)] = null);

(statearr_49278_50977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46357__auto__ = null;
var cljs$core$async$state_machine__46357__auto____0 = (function (){
var statearr_49280 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49280[(0)] = cljs$core$async$state_machine__46357__auto__);

(statearr_49280[(1)] = (1));

return statearr_49280;
});
var cljs$core$async$state_machine__46357__auto____1 = (function (state_49242){
while(true){
var ret_value__46358__auto__ = (function (){try{while(true){
var result__46359__auto__ = switch__46356__auto__(state_49242);
if(cljs.core.keyword_identical_QMARK_(result__46359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46359__auto__;
}
break;
}
}catch (e49281){var ex__46360__auto__ = e49281;
var statearr_49282_50986 = state_49242;
(statearr_49282_50986[(2)] = ex__46360__auto__);


if(cljs.core.seq((state_49242[(4)]))){
var statearr_49288_50987 = state_49242;
(statearr_49288_50987[(1)] = cljs.core.first((state_49242[(4)])));

} else {
throw ex__46360__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46358__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50989 = state_49242;
state_49242 = G__50989;
continue;
} else {
return ret_value__46358__auto__;
}
break;
}
});
cljs$core$async$state_machine__46357__auto__ = function(state_49242){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46357__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46357__auto____1.call(this,state_49242);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46357__auto____0;
cljs$core$async$state_machine__46357__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46357__auto____1;
return cljs$core$async$state_machine__46357__auto__;
})()
})();
var state__47048__auto__ = (function (){var statearr_49289 = f__47047__auto__();
(statearr_49289[(6)] = c__47046__auto___50936);

return statearr_49289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47048__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
