goog.provide('cljs_http.core');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5754__auto__ = (function (){var fexpr__43663 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__43663.cljs$core$IFn$_invoke$arity$1 ? fexpr__43663.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__43663.call(null,channel));
})();
if(cljs.core.truth_(temp__5754__auto__)){
var req = temp__5754__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return new cljs.core.Keyword(null,"jsonp","jsonp",226119588).cljs$core$IFn$_invoke$arity$1(req).cancel(new cljs.core.Keyword(null,"request","request",1772954723).cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__43668){
var vec__43669 = p__43668;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43669,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43669,(1),null);
return xhr.headers.set(k,v);
}),formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__43672 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"array-buffer","array-buffer",519008380),G__43672)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"blob","blob",1636965233),G__43672)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"document","document",-1329188687),G__43672)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),G__43672)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"default","default",-1987822328),G__43672)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__43672)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43672)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__43673){
var map__43674 = p__43673;
var map__43674__$1 = (((((!((map__43674 == null))))?(((((map__43674.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43674.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43674):map__43674);
var request = map__43674__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43674__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43674__$1,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094));
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43674__$1,new cljs.core.Keyword(null,"response-type","response-type",-1493770458));
var timeout = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"timeout","timeout",-318625318).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__43676 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__43676,default_headers);

cljs_http.core.apply_response_type_BANG_(G__43676,response_type);

G__43676.setTimeoutInterval(timeout);

G__43676.setWithCredentials(send_credentials);

return G__43676;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[new cljs.core.Keyword(null,"no-error","no-error",1984610064),new cljs.core.Keyword(null,"abort","abort",521193198),new cljs.core.Keyword(null,"access-denied","access-denied",959449406),new cljs.core.Keyword(null,"custom-error","custom-error",-1565161123),new cljs.core.Keyword(null,"http-error","http-error",-1040049553),new cljs.core.Keyword(null,"ff-silent-error","ff-silent-error",189390514),new cljs.core.Keyword(null,"file-not-found","file-not-found",-65398940),new cljs.core.Keyword(null,"offline","offline",-107631935),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"timeout","timeout",-318625318)]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__43679){
var map__43680 = p__43679;
var map__43680__$1 = (((((!((map__43680 == null))))?(((((map__43680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43680.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43680):map__43680);
var request = map__43680__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43680__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43680__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43680__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43680__$1,new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43680__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43680__$1,new cljs.core.Keyword(null,"progress","progress",244323547));
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4126__auto__ = request_method;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"get","get",1683182755);
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,(function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"status","status",-1997798413),target.getStatus(),new cljs.core.Keyword(null,"success","success",1890645906),target.isSuccess(),new cljs.core.Keyword(null,"body","body",-2049205669),target.getResponse(),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs_http.util.parse_headers(target.getAllResponseHeaders()),new cljs.core.Keyword(null,"trace-redirects","trace-redirects",-1149427907),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),new cljs.core.Keyword(null,"error-code","error-code",180497232),(function (){var G__43686 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__43686) : cljs_http.core.error_kw.call(null,G__43686));
})(),new cljs.core.Keyword(null,"error-text","error-text",2021893718),target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));

if(cljs.core.truth_(progress)){
var listener_43748 = (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"direction","direction",-633359395),direction,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"total","total",1916810418),evt.total], null):null)], 0)));
});
var G__43688_43749 = xhr;
G__43688_43749.setProgressEventsEnabled(true);

G__43688_43749.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_43748,new cljs.core.Keyword(null,"upload","upload",-255769218)));

G__43688_43749.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_43748,new cljs.core.Keyword(null,"download","download",-300081668)));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__41419__auto___43754 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41420__auto__ = (function (){var switch__41349__auto__ = (function (state_43700){
var state_val_43701 = (state_43700[(1)]);
if((state_val_43701 === (1))){
var state_43700__$1 = state_43700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43700__$1,(2),cancel);
} else {
if((state_val_43701 === (2))){
var inst_43690 = (state_43700[(2)]);
var inst_43691 = xhr.isComplete();
var inst_43692 = cljs.core.not(inst_43691);
var state_43700__$1 = (function (){var statearr_43703 = state_43700;
(statearr_43703[(7)] = inst_43690);

return statearr_43703;
})();
if(inst_43692){
var statearr_43704_43759 = state_43700__$1;
(statearr_43704_43759[(1)] = (3));

} else {
var statearr_43705_43760 = state_43700__$1;
(statearr_43705_43760[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (3))){
var inst_43694 = xhr.abort();
var state_43700__$1 = state_43700;
var statearr_43706_43761 = state_43700__$1;
(statearr_43706_43761[(2)] = inst_43694);

(statearr_43706_43761[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (4))){
var state_43700__$1 = state_43700;
var statearr_43707_43764 = state_43700__$1;
(statearr_43707_43764[(2)] = null);

(statearr_43707_43764[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43701 === (5))){
var inst_43697 = (state_43700[(2)]);
var state_43700__$1 = state_43700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43700__$1,inst_43697);
} else {
return null;
}
}
}
}
}
});
return (function() {
var cljs_http$core$xhr_$_state_machine__41350__auto__ = null;
var cljs_http$core$xhr_$_state_machine__41350__auto____0 = (function (){
var statearr_43708 = [null,null,null,null,null,null,null,null];
(statearr_43708[(0)] = cljs_http$core$xhr_$_state_machine__41350__auto__);

(statearr_43708[(1)] = (1));

return statearr_43708;
});
var cljs_http$core$xhr_$_state_machine__41350__auto____1 = (function (state_43700){
while(true){
var ret_value__41351__auto__ = (function (){try{while(true){
var result__41352__auto__ = switch__41349__auto__(state_43700);
if(cljs.core.keyword_identical_QMARK_(result__41352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41352__auto__;
}
break;
}
}catch (e43709){var ex__41353__auto__ = e43709;
var statearr_43710_43771 = state_43700;
(statearr_43710_43771[(2)] = ex__41353__auto__);


if(cljs.core.seq((state_43700[(4)]))){
var statearr_43711_43772 = state_43700;
(statearr_43711_43772[(1)] = cljs.core.first((state_43700[(4)])));

} else {
throw ex__41353__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43776 = state_43700;
state_43700 = G__43776;
continue;
} else {
return ret_value__41351__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__41350__auto__ = function(state_43700){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__41350__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__41350__auto____1.call(this,state_43700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__41350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__41350__auto____0;
cljs_http$core$xhr_$_state_machine__41350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__41350__auto____1;
return cljs_http$core$xhr_$_state_machine__41350__auto__;
})()
})();
var state__41421__auto__ = (function (){var statearr_43712 = f__41420__auto__();
(statearr_43712[(6)] = c__41419__auto___43754);

return statearr_43712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41421__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__43713){
var map__43714 = p__43713;
var map__43714__$1 = (((((!((map__43714 == null))))?(((((map__43714.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43714.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43714):map__43714);
var request = map__43714__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43714__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318));
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43714__$1,new cljs.core.Keyword(null,"callback-name","callback-name",336964714));
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43714__$1,new cljs.core.Keyword(null,"cancel","cancel",-1964088360));
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43714__$1,new cljs.core.Keyword(null,"keywordize-keys?","keywordize-keys?",-254545987),true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_43779 = jsonp.send(null,(function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"success","success",1890645906),true,new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}),(function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jsonp","jsonp",226119588),jsonp,new cljs.core.Keyword(null,"request","request",1772954723),req_43779], null));

if(cljs.core.truth_(cancel)){
var c__41419__auto___43785 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41420__auto__ = (function (){var switch__41349__auto__ = (function (state_43723){
var state_val_43724 = (state_43723[(1)]);
if((state_val_43724 === (1))){
var state_43723__$1 = state_43723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43723__$1,(2),cancel);
} else {
if((state_val_43724 === (2))){
var inst_43720 = (state_43723[(2)]);
var inst_43721 = jsonp.cancel(req_43779);
var state_43723__$1 = (function (){var statearr_43726 = state_43723;
(statearr_43726[(7)] = inst_43720);

return statearr_43726;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_43723__$1,inst_43721);
} else {
return null;
}
}
});
return (function() {
var cljs_http$core$jsonp_$_state_machine__41350__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__41350__auto____0 = (function (){
var statearr_43728 = [null,null,null,null,null,null,null,null];
(statearr_43728[(0)] = cljs_http$core$jsonp_$_state_machine__41350__auto__);

(statearr_43728[(1)] = (1));

return statearr_43728;
});
var cljs_http$core$jsonp_$_state_machine__41350__auto____1 = (function (state_43723){
while(true){
var ret_value__41351__auto__ = (function (){try{while(true){
var result__41352__auto__ = switch__41349__auto__(state_43723);
if(cljs.core.keyword_identical_QMARK_(result__41352__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41352__auto__;
}
break;
}
}catch (e43729){var ex__41353__auto__ = e43729;
var statearr_43730_43790 = state_43723;
(statearr_43730_43790[(2)] = ex__41353__auto__);


if(cljs.core.seq((state_43723[(4)]))){
var statearr_43734_43791 = state_43723;
(statearr_43734_43791[(1)] = cljs.core.first((state_43723[(4)])));

} else {
throw ex__41353__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41351__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43792 = state_43723;
state_43723 = G__43792;
continue;
} else {
return ret_value__41351__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__41350__auto__ = function(state_43723){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__41350__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__41350__auto____1.call(this,state_43723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__41350__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__41350__auto____0;
cljs_http$core$jsonp_$_state_machine__41350__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__41350__auto____1;
return cljs_http$core$jsonp_$_state_machine__41350__auto__;
})()
})();
var state__41421__auto__ = (function (){var statearr_43737 = f__41420__auto__();
(statearr_43737[(6)] = c__41419__auto___43785);

return statearr_43737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41421__auto__);
}));

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__43738){
var map__43739 = p__43738;
var map__43739__$1 = (((((!((map__43739 == null))))?(((((map__43739.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__43739.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__43739):map__43739);
var request = map__43739__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43739__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,new cljs.core.Keyword(null,"jsonp","jsonp",226119588))){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});

//# sourceMappingURL=cljs_http.core.js.map
