goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28389 = arguments.length;
switch (G__28389) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28390 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28390 = (function (f,blockable,meta28391){
this.f = f;
this.blockable = blockable;
this.meta28391 = meta28391;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28390.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28392,meta28391__$1){
var self__ = this;
var _28392__$1 = this;
return (new cljs.core.async.t_cljs$core$async28390(self__.f,self__.blockable,meta28391__$1));
}));

(cljs.core.async.t_cljs$core$async28390.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28392){
var self__ = this;
var _28392__$1 = this;
return self__.meta28391;
}));

(cljs.core.async.t_cljs$core$async28390.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28390.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28390.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28390.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28390.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28391","meta28391",-1266027561,null)], null);
}));

(cljs.core.async.t_cljs$core$async28390.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28390.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28390");

(cljs.core.async.t_cljs$core$async28390.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28390");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28390.
 */
cljs.core.async.__GT_t_cljs$core$async28390 = (function cljs$core$async$__GT_t_cljs$core$async28390(f__$1,blockable__$1,meta28391){
return (new cljs.core.async.t_cljs$core$async28390(f__$1,blockable__$1,meta28391));
});

}

return (new cljs.core.async.t_cljs$core$async28390(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28400 = arguments.length;
switch (G__28400) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28402 = arguments.length;
switch (G__28402) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28414 = arguments.length;
switch (G__28414) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_30541 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30541) : fn1.call(null,val_30541));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_30541) : fn1.call(null,val_30541));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28422 = arguments.length;
switch (G__28422) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___30565 = n;
var x_30571 = (0);
while(true){
if((x_30571 < n__4613__auto___30565)){
(a[x_30571] = x_30571);

var G__30574 = (x_30571 + (1));
x_30571 = G__30574;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28436 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28436 = (function (flag,meta28437){
this.flag = flag;
this.meta28437 = meta28437;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28436.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28438,meta28437__$1){
var self__ = this;
var _28438__$1 = this;
return (new cljs.core.async.t_cljs$core$async28436(self__.flag,meta28437__$1));
}));

(cljs.core.async.t_cljs$core$async28436.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28438){
var self__ = this;
var _28438__$1 = this;
return self__.meta28437;
}));

(cljs.core.async.t_cljs$core$async28436.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28436.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28436.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28436.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28436.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28437","meta28437",1515167435,null)], null);
}));

(cljs.core.async.t_cljs$core$async28436.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28436.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28436");

(cljs.core.async.t_cljs$core$async28436.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28436");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28436.
 */
cljs.core.async.__GT_t_cljs$core$async28436 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28436(flag__$1,meta28437){
return (new cljs.core.async.t_cljs$core$async28436(flag__$1,meta28437));
});

}

return (new cljs.core.async.t_cljs$core$async28436(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28442 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28442 = (function (flag,cb,meta28443){
this.flag = flag;
this.cb = cb;
this.meta28443 = meta28443;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28442.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28444,meta28443__$1){
var self__ = this;
var _28444__$1 = this;
return (new cljs.core.async.t_cljs$core$async28442(self__.flag,self__.cb,meta28443__$1));
}));

(cljs.core.async.t_cljs$core$async28442.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28444){
var self__ = this;
var _28444__$1 = this;
return self__.meta28443;
}));

(cljs.core.async.t_cljs$core$async28442.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28442.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28442.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28442.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28442.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28443","meta28443",96041593,null)], null);
}));

(cljs.core.async.t_cljs$core$async28442.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28442.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28442");

(cljs.core.async.t_cljs$core$async28442.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28442");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28442.
 */
cljs.core.async.__GT_t_cljs$core$async28442 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28442(flag__$1,cb__$1,meta28443){
return (new cljs.core.async.t_cljs$core$async28442(flag__$1,cb__$1,meta28443));
});

}

return (new cljs.core.async.t_cljs$core$async28442(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28452_SHARP_){
var G__28455 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28452_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28455) : fret.call(null,G__28455));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28453_SHARP_){
var G__28459 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28453_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28459) : fret.call(null,G__28459));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__30614 = (i + (1));
i = G__30614;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___30623 = arguments.length;
var i__4737__auto___30628 = (0);
while(true){
if((i__4737__auto___30628 < len__4736__auto___30623)){
args__4742__auto__.push((arguments[i__4737__auto___30628]));

var G__30629 = (i__4737__auto___30628 + (1));
i__4737__auto___30628 = G__30629;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28467){
var map__28468 = p__28467;
var map__28468__$1 = (((((!((map__28468 == null))))?(((((map__28468.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28468.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28468):map__28468);
var opts = map__28468__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28464){
var G__28465 = cljs.core.first(seq28464);
var seq28464__$1 = cljs.core.next(seq28464);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28465,seq28464__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28485 = arguments.length;
switch (G__28485) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28309__auto___30639 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_28530){
var state_val_28531 = (state_28530[(1)]);
if((state_val_28531 === (7))){
var inst_28526 = (state_28530[(2)]);
var state_28530__$1 = state_28530;
var statearr_28538_30646 = state_28530__$1;
(statearr_28538_30646[(2)] = inst_28526);

(statearr_28538_30646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (1))){
var state_28530__$1 = state_28530;
var statearr_28539_30647 = state_28530__$1;
(statearr_28539_30647[(2)] = null);

(statearr_28539_30647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (4))){
var inst_28507 = (state_28530[(7)]);
var inst_28507__$1 = (state_28530[(2)]);
var inst_28510 = (inst_28507__$1 == null);
var state_28530__$1 = (function (){var statearr_28544 = state_28530;
(statearr_28544[(7)] = inst_28507__$1);

return statearr_28544;
})();
if(cljs.core.truth_(inst_28510)){
var statearr_28545_30649 = state_28530__$1;
(statearr_28545_30649[(1)] = (5));

} else {
var statearr_28546_30650 = state_28530__$1;
(statearr_28546_30650[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (13))){
var state_28530__$1 = state_28530;
var statearr_28547_30654 = state_28530__$1;
(statearr_28547_30654[(2)] = null);

(statearr_28547_30654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (6))){
var inst_28507 = (state_28530[(7)]);
var state_28530__$1 = state_28530;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28530__$1,(11),to,inst_28507);
} else {
if((state_val_28531 === (3))){
var inst_28528 = (state_28530[(2)]);
var state_28530__$1 = state_28530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28530__$1,inst_28528);
} else {
if((state_val_28531 === (12))){
var state_28530__$1 = state_28530;
var statearr_28551_30655 = state_28530__$1;
(statearr_28551_30655[(2)] = null);

(statearr_28551_30655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (2))){
var state_28530__$1 = state_28530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28530__$1,(4),from);
} else {
if((state_val_28531 === (11))){
var inst_28519 = (state_28530[(2)]);
var state_28530__$1 = state_28530;
if(cljs.core.truth_(inst_28519)){
var statearr_28552_30656 = state_28530__$1;
(statearr_28552_30656[(1)] = (12));

} else {
var statearr_28553_30657 = state_28530__$1;
(statearr_28553_30657[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (9))){
var state_28530__$1 = state_28530;
var statearr_28554_30658 = state_28530__$1;
(statearr_28554_30658[(2)] = null);

(statearr_28554_30658[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (5))){
var state_28530__$1 = state_28530;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28555_30659 = state_28530__$1;
(statearr_28555_30659[(1)] = (8));

} else {
var statearr_28556_30660 = state_28530__$1;
(statearr_28556_30660[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (14))){
var inst_28524 = (state_28530[(2)]);
var state_28530__$1 = state_28530;
var statearr_28557_30661 = state_28530__$1;
(statearr_28557_30661[(2)] = inst_28524);

(statearr_28557_30661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (10))){
var inst_28516 = (state_28530[(2)]);
var state_28530__$1 = state_28530;
var statearr_28558_30662 = state_28530__$1;
(statearr_28558_30662[(2)] = inst_28516);

(statearr_28558_30662[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28531 === (8))){
var inst_28513 = cljs.core.async.close_BANG_(to);
var state_28530__$1 = state_28530;
var statearr_28559_30664 = state_28530__$1;
(statearr_28559_30664[(2)] = inst_28513);

(statearr_28559_30664[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_28560 = [null,null,null,null,null,null,null,null];
(statearr_28560[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_28560[(1)] = (1));

return statearr_28560;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_28530){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28530);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28561){var ex__28256__auto__ = e28561;
var statearr_28562_30670 = state_28530;
(statearr_28562_30670[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28530[(4)]))){
var statearr_28563_30672 = state_28530;
(statearr_28563_30672[(1)] = cljs.core.first((state_28530[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30675 = state_28530;
state_28530 = G__30675;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_28530){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_28530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_28564 = f__28310__auto__();
(statearr_28564[(6)] = c__28309__auto___30639);

return statearr_28564;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28568){
var vec__28569 = p__28568;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28569,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28569,(1),null);
var job = vec__28569;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28309__auto___30683 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_28576){
var state_val_28577 = (state_28576[(1)]);
if((state_val_28577 === (1))){
var state_28576__$1 = state_28576;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28576__$1,(2),res,v);
} else {
if((state_val_28577 === (2))){
var inst_28573 = (state_28576[(2)]);
var inst_28574 = cljs.core.async.close_BANG_(res);
var state_28576__$1 = (function (){var statearr_28578 = state_28576;
(statearr_28578[(7)] = inst_28573);

return statearr_28578;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28576__$1,inst_28574);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0 = (function (){
var statearr_28579 = [null,null,null,null,null,null,null,null];
(statearr_28579[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__);

(statearr_28579[(1)] = (1));

return statearr_28579;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1 = (function (state_28576){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28576);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28581){var ex__28256__auto__ = e28581;
var statearr_28582_30686 = state_28576;
(statearr_28582_30686[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28576[(4)]))){
var statearr_28583_30688 = state_28576;
(statearr_28583_30688[(1)] = cljs.core.first((state_28576[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30689 = state_28576;
state_28576 = G__30689;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = function(state_28576){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1.call(this,state_28576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_28584 = f__28310__auto__();
(statearr_28584[(6)] = c__28309__auto___30683);

return statearr_28584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28585){
var vec__28586 = p__28585;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28586,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28586,(1),null);
var job = vec__28586;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___30696 = n;
var __30697 = (0);
while(true){
if((__30697 < n__4613__auto___30696)){
var G__28590_30698 = type;
var G__28590_30699__$1 = (((G__28590_30698 instanceof cljs.core.Keyword))?G__28590_30698.fqn:null);
switch (G__28590_30699__$1) {
case "compute":
var c__28309__auto___30706 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30697,c__28309__auto___30706,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async){
return (function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = ((function (__30697,c__28309__auto___30706,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async){
return (function (state_28603){
var state_val_28604 = (state_28603[(1)]);
if((state_val_28604 === (1))){
var state_28603__$1 = state_28603;
var statearr_28605_30708 = state_28603__$1;
(statearr_28605_30708[(2)] = null);

(statearr_28605_30708[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28604 === (2))){
var state_28603__$1 = state_28603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28603__$1,(4),jobs);
} else {
if((state_val_28604 === (3))){
var inst_28601 = (state_28603[(2)]);
var state_28603__$1 = state_28603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28603__$1,inst_28601);
} else {
if((state_val_28604 === (4))){
var inst_28593 = (state_28603[(2)]);
var inst_28594 = process(inst_28593);
var state_28603__$1 = state_28603;
if(cljs.core.truth_(inst_28594)){
var statearr_28607_30713 = state_28603__$1;
(statearr_28607_30713[(1)] = (5));

} else {
var statearr_28608_30714 = state_28603__$1;
(statearr_28608_30714[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28604 === (5))){
var state_28603__$1 = state_28603;
var statearr_28614_30716 = state_28603__$1;
(statearr_28614_30716[(2)] = null);

(statearr_28614_30716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28604 === (6))){
var state_28603__$1 = state_28603;
var statearr_28616_30717 = state_28603__$1;
(statearr_28616_30717[(2)] = null);

(statearr_28616_30717[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28604 === (7))){
var inst_28599 = (state_28603[(2)]);
var state_28603__$1 = state_28603;
var statearr_28622_30719 = state_28603__$1;
(statearr_28622_30719[(2)] = inst_28599);

(statearr_28622_30719[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30697,c__28309__auto___30706,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async))
;
return ((function (__30697,switch__28252__auto__,c__28309__auto___30706,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0 = (function (){
var statearr_28630 = [null,null,null,null,null,null,null];
(statearr_28630[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__);

(statearr_28630[(1)] = (1));

return statearr_28630;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1 = (function (state_28603){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28603);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28633){var ex__28256__auto__ = e28633;
var statearr_28638_30723 = state_28603;
(statearr_28638_30723[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28603[(4)]))){
var statearr_28639_30724 = state_28603;
(statearr_28639_30724[(1)] = cljs.core.first((state_28603[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30725 = state_28603;
state_28603 = G__30725;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = function(state_28603){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1.call(this,state_28603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__;
})()
;})(__30697,switch__28252__auto__,c__28309__auto___30706,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async))
})();
var state__28311__auto__ = (function (){var statearr_28641 = f__28310__auto__();
(statearr_28641[(6)] = c__28309__auto___30706);

return statearr_28641;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
});})(__30697,c__28309__auto___30706,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async))
);


break;
case "async":
var c__28309__auto___30727 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__30697,c__28309__auto___30727,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async){
return (function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = ((function (__30697,c__28309__auto___30727,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async){
return (function (state_28657){
var state_val_28658 = (state_28657[(1)]);
if((state_val_28658 === (1))){
var state_28657__$1 = state_28657;
var statearr_28660_30729 = state_28657__$1;
(statearr_28660_30729[(2)] = null);

(statearr_28660_30729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (2))){
var state_28657__$1 = state_28657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28657__$1,(4),jobs);
} else {
if((state_val_28658 === (3))){
var inst_28655 = (state_28657[(2)]);
var state_28657__$1 = state_28657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28657__$1,inst_28655);
} else {
if((state_val_28658 === (4))){
var inst_28647 = (state_28657[(2)]);
var inst_28648 = async(inst_28647);
var state_28657__$1 = state_28657;
if(cljs.core.truth_(inst_28648)){
var statearr_28661_30736 = state_28657__$1;
(statearr_28661_30736[(1)] = (5));

} else {
var statearr_28664_30737 = state_28657__$1;
(statearr_28664_30737[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (5))){
var state_28657__$1 = state_28657;
var statearr_28667_30739 = state_28657__$1;
(statearr_28667_30739[(2)] = null);

(statearr_28667_30739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (6))){
var state_28657__$1 = state_28657;
var statearr_28668_30741 = state_28657__$1;
(statearr_28668_30741[(2)] = null);

(statearr_28668_30741[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28658 === (7))){
var inst_28653 = (state_28657[(2)]);
var state_28657__$1 = state_28657;
var statearr_28669_30743 = state_28657__$1;
(statearr_28669_30743[(2)] = inst_28653);

(statearr_28669_30743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__30697,c__28309__auto___30727,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async))
;
return ((function (__30697,switch__28252__auto__,c__28309__auto___30727,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0 = (function (){
var statearr_28672 = [null,null,null,null,null,null,null];
(statearr_28672[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__);

(statearr_28672[(1)] = (1));

return statearr_28672;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1 = (function (state_28657){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28657);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28674){var ex__28256__auto__ = e28674;
var statearr_28676_30747 = state_28657;
(statearr_28676_30747[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28657[(4)]))){
var statearr_28677_30750 = state_28657;
(statearr_28677_30750[(1)] = cljs.core.first((state_28657[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30752 = state_28657;
state_28657 = G__30752;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = function(state_28657){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1.call(this,state_28657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__;
})()
;})(__30697,switch__28252__auto__,c__28309__auto___30727,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async))
})();
var state__28311__auto__ = (function (){var statearr_28678 = f__28310__auto__();
(statearr_28678[(6)] = c__28309__auto___30727);

return statearr_28678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
});})(__30697,c__28309__auto___30727,G__28590_30698,G__28590_30699__$1,n__4613__auto___30696,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28590_30699__$1)].join('')));

}

var G__30753 = (__30697 + (1));
__30697 = G__30753;
continue;
} else {
}
break;
}

var c__28309__auto___30754 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_28700){
var state_val_28701 = (state_28700[(1)]);
if((state_val_28701 === (7))){
var inst_28696 = (state_28700[(2)]);
var state_28700__$1 = state_28700;
var statearr_28719_30761 = state_28700__$1;
(statearr_28719_30761[(2)] = inst_28696);

(statearr_28719_30761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (1))){
var state_28700__$1 = state_28700;
var statearr_28724_30766 = state_28700__$1;
(statearr_28724_30766[(2)] = null);

(statearr_28724_30766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (4))){
var inst_28681 = (state_28700[(7)]);
var inst_28681__$1 = (state_28700[(2)]);
var inst_28682 = (inst_28681__$1 == null);
var state_28700__$1 = (function (){var statearr_28725 = state_28700;
(statearr_28725[(7)] = inst_28681__$1);

return statearr_28725;
})();
if(cljs.core.truth_(inst_28682)){
var statearr_28726_30780 = state_28700__$1;
(statearr_28726_30780[(1)] = (5));

} else {
var statearr_28727_30783 = state_28700__$1;
(statearr_28727_30783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (6))){
var inst_28686 = (state_28700[(8)]);
var inst_28681 = (state_28700[(7)]);
var inst_28686__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28688 = [inst_28681,inst_28686__$1];
var inst_28689 = (new cljs.core.PersistentVector(null,2,(5),inst_28687,inst_28688,null));
var state_28700__$1 = (function (){var statearr_28728 = state_28700;
(statearr_28728[(8)] = inst_28686__$1);

return statearr_28728;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28700__$1,(8),jobs,inst_28689);
} else {
if((state_val_28701 === (3))){
var inst_28698 = (state_28700[(2)]);
var state_28700__$1 = state_28700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28700__$1,inst_28698);
} else {
if((state_val_28701 === (2))){
var state_28700__$1 = state_28700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28700__$1,(4),from);
} else {
if((state_val_28701 === (9))){
var inst_28693 = (state_28700[(2)]);
var state_28700__$1 = (function (){var statearr_28734 = state_28700;
(statearr_28734[(9)] = inst_28693);

return statearr_28734;
})();
var statearr_28739_30820 = state_28700__$1;
(statearr_28739_30820[(2)] = null);

(statearr_28739_30820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (5))){
var inst_28684 = cljs.core.async.close_BANG_(jobs);
var state_28700__$1 = state_28700;
var statearr_28743_30834 = state_28700__$1;
(statearr_28743_30834[(2)] = inst_28684);

(statearr_28743_30834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28701 === (8))){
var inst_28686 = (state_28700[(8)]);
var inst_28691 = (state_28700[(2)]);
var state_28700__$1 = (function (){var statearr_28748 = state_28700;
(statearr_28748[(10)] = inst_28691);

return statearr_28748;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28700__$1,(9),results,inst_28686);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0 = (function (){
var statearr_28754 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28754[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__);

(statearr_28754[(1)] = (1));

return statearr_28754;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1 = (function (state_28700){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28700);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28755){var ex__28256__auto__ = e28755;
var statearr_28756_30842 = state_28700;
(statearr_28756_30842[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28700[(4)]))){
var statearr_28757_30844 = state_28700;
(statearr_28757_30844[(1)] = cljs.core.first((state_28700[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30846 = state_28700;
state_28700 = G__30846;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = function(state_28700){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1.call(this,state_28700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_28758 = f__28310__auto__();
(statearr_28758[(6)] = c__28309__auto___30754);

return statearr_28758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


var c__28309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_28818){
var state_val_28819 = (state_28818[(1)]);
if((state_val_28819 === (7))){
var inst_28810 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
var statearr_28820_30851 = state_28818__$1;
(statearr_28820_30851[(2)] = inst_28810);

(statearr_28820_30851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (20))){
var state_28818__$1 = state_28818;
var statearr_28822_30852 = state_28818__$1;
(statearr_28822_30852[(2)] = null);

(statearr_28822_30852[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (1))){
var state_28818__$1 = state_28818;
var statearr_28823_30854 = state_28818__$1;
(statearr_28823_30854[(2)] = null);

(statearr_28823_30854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (4))){
var inst_28761 = (state_28818[(7)]);
var inst_28761__$1 = (state_28818[(2)]);
var inst_28762 = (inst_28761__$1 == null);
var state_28818__$1 = (function (){var statearr_28824 = state_28818;
(statearr_28824[(7)] = inst_28761__$1);

return statearr_28824;
})();
if(cljs.core.truth_(inst_28762)){
var statearr_28825_30857 = state_28818__$1;
(statearr_28825_30857[(1)] = (5));

} else {
var statearr_28826_30860 = state_28818__$1;
(statearr_28826_30860[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (15))){
var inst_28783 = (state_28818[(8)]);
var state_28818__$1 = state_28818;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28818__$1,(18),to,inst_28783);
} else {
if((state_val_28819 === (21))){
var inst_28804 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
var statearr_28827_30865 = state_28818__$1;
(statearr_28827_30865[(2)] = inst_28804);

(statearr_28827_30865[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (13))){
var inst_28807 = (state_28818[(2)]);
var state_28818__$1 = (function (){var statearr_28828 = state_28818;
(statearr_28828[(9)] = inst_28807);

return statearr_28828;
})();
var statearr_28829_30868 = state_28818__$1;
(statearr_28829_30868[(2)] = null);

(statearr_28829_30868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (6))){
var inst_28761 = (state_28818[(7)]);
var state_28818__$1 = state_28818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28818__$1,(11),inst_28761);
} else {
if((state_val_28819 === (17))){
var inst_28799 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
if(cljs.core.truth_(inst_28799)){
var statearr_28837_30870 = state_28818__$1;
(statearr_28837_30870[(1)] = (19));

} else {
var statearr_28838_30872 = state_28818__$1;
(statearr_28838_30872[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (3))){
var inst_28812 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28818__$1,inst_28812);
} else {
if((state_val_28819 === (12))){
var inst_28776 = (state_28818[(10)]);
var state_28818__$1 = state_28818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28818__$1,(14),inst_28776);
} else {
if((state_val_28819 === (2))){
var state_28818__$1 = state_28818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28818__$1,(4),results);
} else {
if((state_val_28819 === (19))){
var state_28818__$1 = state_28818;
var statearr_28839_30874 = state_28818__$1;
(statearr_28839_30874[(2)] = null);

(statearr_28839_30874[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (11))){
var inst_28776 = (state_28818[(2)]);
var state_28818__$1 = (function (){var statearr_28840 = state_28818;
(statearr_28840[(10)] = inst_28776);

return statearr_28840;
})();
var statearr_28841_30876 = state_28818__$1;
(statearr_28841_30876[(2)] = null);

(statearr_28841_30876[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (9))){
var state_28818__$1 = state_28818;
var statearr_28842_30878 = state_28818__$1;
(statearr_28842_30878[(2)] = null);

(statearr_28842_30878[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (5))){
var state_28818__$1 = state_28818;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28843_30881 = state_28818__$1;
(statearr_28843_30881[(1)] = (8));

} else {
var statearr_28844_30882 = state_28818__$1;
(statearr_28844_30882[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (14))){
var inst_28783 = (state_28818[(8)]);
var inst_28783__$1 = (state_28818[(2)]);
var inst_28792 = (inst_28783__$1 == null);
var inst_28793 = cljs.core.not(inst_28792);
var state_28818__$1 = (function (){var statearr_28845 = state_28818;
(statearr_28845[(8)] = inst_28783__$1);

return statearr_28845;
})();
if(inst_28793){
var statearr_28852_30885 = state_28818__$1;
(statearr_28852_30885[(1)] = (15));

} else {
var statearr_28853_30886 = state_28818__$1;
(statearr_28853_30886[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (16))){
var state_28818__$1 = state_28818;
var statearr_28854_30887 = state_28818__$1;
(statearr_28854_30887[(2)] = false);

(statearr_28854_30887[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (10))){
var inst_28772 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
var statearr_28855_30890 = state_28818__$1;
(statearr_28855_30890[(2)] = inst_28772);

(statearr_28855_30890[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (18))){
var inst_28796 = (state_28818[(2)]);
var state_28818__$1 = state_28818;
var statearr_28856_30891 = state_28818__$1;
(statearr_28856_30891[(2)] = inst_28796);

(statearr_28856_30891[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28819 === (8))){
var inst_28769 = cljs.core.async.close_BANG_(to);
var state_28818__$1 = state_28818;
var statearr_28861_30894 = state_28818__$1;
(statearr_28861_30894[(2)] = inst_28769);

(statearr_28861_30894[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0 = (function (){
var statearr_28866 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28866[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__);

(statearr_28866[(1)] = (1));

return statearr_28866;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1 = (function (state_28818){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28818);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28867){var ex__28256__auto__ = e28867;
var statearr_28868_30898 = state_28818;
(statearr_28868_30898[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28818[(4)]))){
var statearr_28873_30900 = state_28818;
(statearr_28873_30900[(1)] = cljs.core.first((state_28818[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30902 = state_28818;
state_28818 = G__30902;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__ = function(state_28818){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1.call(this,state_28818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28253__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_28875 = f__28310__auto__();
(statearr_28875[(6)] = c__28309__auto__);

return statearr_28875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));

return c__28309__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28878 = arguments.length;
switch (G__28878) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28883 = arguments.length;
switch (G__28883) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28891 = arguments.length;
switch (G__28891) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28309__auto___30933 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_28923){
var state_val_28924 = (state_28923[(1)]);
if((state_val_28924 === (7))){
var inst_28919 = (state_28923[(2)]);
var state_28923__$1 = state_28923;
var statearr_28925_30935 = state_28923__$1;
(statearr_28925_30935[(2)] = inst_28919);

(statearr_28925_30935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (1))){
var state_28923__$1 = state_28923;
var statearr_28926_30937 = state_28923__$1;
(statearr_28926_30937[(2)] = null);

(statearr_28926_30937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (4))){
var inst_28897 = (state_28923[(7)]);
var inst_28897__$1 = (state_28923[(2)]);
var inst_28898 = (inst_28897__$1 == null);
var state_28923__$1 = (function (){var statearr_28927 = state_28923;
(statearr_28927[(7)] = inst_28897__$1);

return statearr_28927;
})();
if(cljs.core.truth_(inst_28898)){
var statearr_28928_30942 = state_28923__$1;
(statearr_28928_30942[(1)] = (5));

} else {
var statearr_28929_30943 = state_28923__$1;
(statearr_28929_30943[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (13))){
var state_28923__$1 = state_28923;
var statearr_28930_30949 = state_28923__$1;
(statearr_28930_30949[(2)] = null);

(statearr_28930_30949[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (6))){
var inst_28897 = (state_28923[(7)]);
var inst_28903 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28897) : p.call(null,inst_28897));
var state_28923__$1 = state_28923;
if(cljs.core.truth_(inst_28903)){
var statearr_28931_30951 = state_28923__$1;
(statearr_28931_30951[(1)] = (9));

} else {
var statearr_28932_30952 = state_28923__$1;
(statearr_28932_30952[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (3))){
var inst_28921 = (state_28923[(2)]);
var state_28923__$1 = state_28923;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28923__$1,inst_28921);
} else {
if((state_val_28924 === (12))){
var state_28923__$1 = state_28923;
var statearr_28933_30956 = state_28923__$1;
(statearr_28933_30956[(2)] = null);

(statearr_28933_30956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (2))){
var state_28923__$1 = state_28923;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28923__$1,(4),ch);
} else {
if((state_val_28924 === (11))){
var inst_28897 = (state_28923[(7)]);
var inst_28907 = (state_28923[(2)]);
var state_28923__$1 = state_28923;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28923__$1,(8),inst_28907,inst_28897);
} else {
if((state_val_28924 === (9))){
var state_28923__$1 = state_28923;
var statearr_28934_30960 = state_28923__$1;
(statearr_28934_30960[(2)] = tc);

(statearr_28934_30960[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (5))){
var inst_28900 = cljs.core.async.close_BANG_(tc);
var inst_28901 = cljs.core.async.close_BANG_(fc);
var state_28923__$1 = (function (){var statearr_28936 = state_28923;
(statearr_28936[(8)] = inst_28900);

return statearr_28936;
})();
var statearr_28937_30961 = state_28923__$1;
(statearr_28937_30961[(2)] = inst_28901);

(statearr_28937_30961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (14))){
var inst_28917 = (state_28923[(2)]);
var state_28923__$1 = state_28923;
var statearr_28942_30965 = state_28923__$1;
(statearr_28942_30965[(2)] = inst_28917);

(statearr_28942_30965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (10))){
var state_28923__$1 = state_28923;
var statearr_28943_30966 = state_28923__$1;
(statearr_28943_30966[(2)] = fc);

(statearr_28943_30966[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28924 === (8))){
var inst_28909 = (state_28923[(2)]);
var state_28923__$1 = state_28923;
if(cljs.core.truth_(inst_28909)){
var statearr_28945_30967 = state_28923__$1;
(statearr_28945_30967[(1)] = (12));

} else {
var statearr_28946_30968 = state_28923__$1;
(statearr_28946_30968[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_28947 = [null,null,null,null,null,null,null,null,null];
(statearr_28947[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_28947[(1)] = (1));

return statearr_28947;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_28923){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28923);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28948){var ex__28256__auto__ = e28948;
var statearr_28949_30973 = state_28923;
(statearr_28949_30973[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28923[(4)]))){
var statearr_28950_30974 = state_28923;
(statearr_28950_30974[(1)] = cljs.core.first((state_28923[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30976 = state_28923;
state_28923 = G__30976;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_28923){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_28923);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_28951 = f__28310__auto__();
(statearr_28951[(6)] = c__28309__auto___30933);

return statearr_28951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_28979){
var state_val_28980 = (state_28979[(1)]);
if((state_val_28980 === (7))){
var inst_28975 = (state_28979[(2)]);
var state_28979__$1 = state_28979;
var statearr_28981_30981 = state_28979__$1;
(statearr_28981_30981[(2)] = inst_28975);

(statearr_28981_30981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28980 === (1))){
var inst_28958 = init;
var inst_28959 = inst_28958;
var state_28979__$1 = (function (){var statearr_28985 = state_28979;
(statearr_28985[(7)] = inst_28959);

return statearr_28985;
})();
var statearr_28986_30985 = state_28979__$1;
(statearr_28986_30985[(2)] = null);

(statearr_28986_30985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28980 === (4))){
var inst_28962 = (state_28979[(8)]);
var inst_28962__$1 = (state_28979[(2)]);
var inst_28963 = (inst_28962__$1 == null);
var state_28979__$1 = (function (){var statearr_28987 = state_28979;
(statearr_28987[(8)] = inst_28962__$1);

return statearr_28987;
})();
if(cljs.core.truth_(inst_28963)){
var statearr_28988_30991 = state_28979__$1;
(statearr_28988_30991[(1)] = (5));

} else {
var statearr_28989_30992 = state_28979__$1;
(statearr_28989_30992[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28980 === (6))){
var inst_28959 = (state_28979[(7)]);
var inst_28962 = (state_28979[(8)]);
var inst_28966 = (state_28979[(9)]);
var inst_28966__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_28959,inst_28962) : f.call(null,inst_28959,inst_28962));
var inst_28967 = cljs.core.reduced_QMARK_(inst_28966__$1);
var state_28979__$1 = (function (){var statearr_28990 = state_28979;
(statearr_28990[(9)] = inst_28966__$1);

return statearr_28990;
})();
if(inst_28967){
var statearr_28991_31000 = state_28979__$1;
(statearr_28991_31000[(1)] = (8));

} else {
var statearr_28992_31001 = state_28979__$1;
(statearr_28992_31001[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28980 === (3))){
var inst_28977 = (state_28979[(2)]);
var state_28979__$1 = state_28979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28979__$1,inst_28977);
} else {
if((state_val_28980 === (2))){
var state_28979__$1 = state_28979;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28979__$1,(4),ch);
} else {
if((state_val_28980 === (9))){
var inst_28966 = (state_28979[(9)]);
var inst_28959 = inst_28966;
var state_28979__$1 = (function (){var statearr_28993 = state_28979;
(statearr_28993[(7)] = inst_28959);

return statearr_28993;
})();
var statearr_28994_31006 = state_28979__$1;
(statearr_28994_31006[(2)] = null);

(statearr_28994_31006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28980 === (5))){
var inst_28959 = (state_28979[(7)]);
var state_28979__$1 = state_28979;
var statearr_28995_31007 = state_28979__$1;
(statearr_28995_31007[(2)] = inst_28959);

(statearr_28995_31007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28980 === (10))){
var inst_28973 = (state_28979[(2)]);
var state_28979__$1 = state_28979;
var statearr_28996_31008 = state_28979__$1;
(statearr_28996_31008[(2)] = inst_28973);

(statearr_28996_31008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28980 === (8))){
var inst_28966 = (state_28979[(9)]);
var inst_28969 = cljs.core.deref(inst_28966);
var state_28979__$1 = state_28979;
var statearr_28997_31012 = state_28979__$1;
(statearr_28997_31012[(2)] = inst_28969);

(statearr_28997_31012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28253__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28253__auto____0 = (function (){
var statearr_28998 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28998[(0)] = cljs$core$async$reduce_$_state_machine__28253__auto__);

(statearr_28998[(1)] = (1));

return statearr_28998;
});
var cljs$core$async$reduce_$_state_machine__28253__auto____1 = (function (state_28979){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_28979);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e28999){var ex__28256__auto__ = e28999;
var statearr_29000_31014 = state_28979;
(statearr_29000_31014[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_28979[(4)]))){
var statearr_29001_31016 = state_28979;
(statearr_29001_31016[(1)] = cljs.core.first((state_28979[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31022 = state_28979;
state_28979 = G__31022;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28253__auto__ = function(state_28979){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28253__auto____1.call(this,state_28979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28253__auto____0;
cljs$core$async$reduce_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28253__auto____1;
return cljs$core$async$reduce_$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_29005 = f__28310__auto__();
(statearr_29005[(6)] = c__28309__auto__);

return statearr_29005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));

return c__28309__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_29012){
var state_val_29013 = (state_29012[(1)]);
if((state_val_29013 === (1))){
var inst_29007 = cljs.core.async.reduce(f__$1,init,ch);
var state_29012__$1 = state_29012;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29012__$1,(2),inst_29007);
} else {
if((state_val_29013 === (2))){
var inst_29009 = (state_29012[(2)]);
var inst_29010 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_29009) : f__$1.call(null,inst_29009));
var state_29012__$1 = state_29012;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29012__$1,inst_29010);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28253__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28253__auto____0 = (function (){
var statearr_29017 = [null,null,null,null,null,null,null];
(statearr_29017[(0)] = cljs$core$async$transduce_$_state_machine__28253__auto__);

(statearr_29017[(1)] = (1));

return statearr_29017;
});
var cljs$core$async$transduce_$_state_machine__28253__auto____1 = (function (state_29012){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_29012);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e29019){var ex__28256__auto__ = e29019;
var statearr_29020_31028 = state_29012;
(statearr_29020_31028[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_29012[(4)]))){
var statearr_29021_31029 = state_29012;
(statearr_29021_31029[(1)] = cljs.core.first((state_29012[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31032 = state_29012;
state_29012 = G__31032;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28253__auto__ = function(state_29012){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28253__auto____1.call(this,state_29012);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28253__auto____0;
cljs$core$async$transduce_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28253__auto____1;
return cljs$core$async$transduce_$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_29026 = f__28310__auto__();
(statearr_29026[(6)] = c__28309__auto__);

return statearr_29026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));

return c__28309__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__29030 = arguments.length;
switch (G__29030) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_29059){
var state_val_29060 = (state_29059[(1)]);
if((state_val_29060 === (7))){
var inst_29041 = (state_29059[(2)]);
var state_29059__$1 = state_29059;
var statearr_29065_31045 = state_29059__$1;
(statearr_29065_31045[(2)] = inst_29041);

(statearr_29065_31045[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (1))){
var inst_29032 = cljs.core.seq(coll);
var inst_29036 = inst_29032;
var state_29059__$1 = (function (){var statearr_29066 = state_29059;
(statearr_29066[(7)] = inst_29036);

return statearr_29066;
})();
var statearr_29068_31049 = state_29059__$1;
(statearr_29068_31049[(2)] = null);

(statearr_29068_31049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (4))){
var inst_29036 = (state_29059[(7)]);
var inst_29039 = cljs.core.first(inst_29036);
var state_29059__$1 = state_29059;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29059__$1,(7),ch,inst_29039);
} else {
if((state_val_29060 === (13))){
var inst_29053 = (state_29059[(2)]);
var state_29059__$1 = state_29059;
var statearr_29069_31051 = state_29059__$1;
(statearr_29069_31051[(2)] = inst_29053);

(statearr_29069_31051[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (6))){
var inst_29044 = (state_29059[(2)]);
var state_29059__$1 = state_29059;
if(cljs.core.truth_(inst_29044)){
var statearr_29072_31061 = state_29059__$1;
(statearr_29072_31061[(1)] = (8));

} else {
var statearr_29073_31062 = state_29059__$1;
(statearr_29073_31062[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (3))){
var inst_29057 = (state_29059[(2)]);
var state_29059__$1 = state_29059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29059__$1,inst_29057);
} else {
if((state_val_29060 === (12))){
var state_29059__$1 = state_29059;
var statearr_29074_31064 = state_29059__$1;
(statearr_29074_31064[(2)] = null);

(statearr_29074_31064[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (2))){
var inst_29036 = (state_29059[(7)]);
var state_29059__$1 = state_29059;
if(cljs.core.truth_(inst_29036)){
var statearr_29075_31066 = state_29059__$1;
(statearr_29075_31066[(1)] = (4));

} else {
var statearr_29076_31067 = state_29059__$1;
(statearr_29076_31067[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (11))){
var inst_29050 = cljs.core.async.close_BANG_(ch);
var state_29059__$1 = state_29059;
var statearr_29078_31068 = state_29059__$1;
(statearr_29078_31068[(2)] = inst_29050);

(statearr_29078_31068[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (9))){
var state_29059__$1 = state_29059;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29079_31070 = state_29059__$1;
(statearr_29079_31070[(1)] = (11));

} else {
var statearr_29080_31074 = state_29059__$1;
(statearr_29080_31074[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (5))){
var inst_29036 = (state_29059[(7)]);
var state_29059__$1 = state_29059;
var statearr_29081_31075 = state_29059__$1;
(statearr_29081_31075[(2)] = inst_29036);

(statearr_29081_31075[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (10))){
var inst_29055 = (state_29059[(2)]);
var state_29059__$1 = state_29059;
var statearr_29082_31076 = state_29059__$1;
(statearr_29082_31076[(2)] = inst_29055);

(statearr_29082_31076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29060 === (8))){
var inst_29036 = (state_29059[(7)]);
var inst_29046 = cljs.core.next(inst_29036);
var inst_29036__$1 = inst_29046;
var state_29059__$1 = (function (){var statearr_29084 = state_29059;
(statearr_29084[(7)] = inst_29036__$1);

return statearr_29084;
})();
var statearr_29086_31079 = state_29059__$1;
(statearr_29086_31079[(2)] = null);

(statearr_29086_31079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_29089 = [null,null,null,null,null,null,null,null];
(statearr_29089[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_29089[(1)] = (1));

return statearr_29089;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_29059){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_29059);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e29090){var ex__28256__auto__ = e29090;
var statearr_29092_31080 = state_29059;
(statearr_29092_31080[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_29059[(4)]))){
var statearr_29093_31086 = state_29059;
(statearr_29093_31086[(1)] = cljs.core.first((state_29059[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31093 = state_29059;
state_29059 = G__31093;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_29059){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_29059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_29095 = f__28310__auto__();
(statearr_29095[(6)] = c__28309__auto__);

return statearr_29095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));

return c__28309__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__29105 = arguments.length;
switch (G__29105) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_31103 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_31103(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_31108 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_31108(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_31111 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_31111(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_31116 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_31116(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29126 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29126 = (function (ch,cs,meta29127){
this.ch = ch;
this.cs = cs;
this.meta29127 = meta29127;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29128,meta29127__$1){
var self__ = this;
var _29128__$1 = this;
return (new cljs.core.async.t_cljs$core$async29126(self__.ch,self__.cs,meta29127__$1));
}));

(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29128){
var self__ = this;
var _29128__$1 = this;
return self__.meta29127;
}));

(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29126.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29126.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29127","meta29127",-1016417847,null)], null);
}));

(cljs.core.async.t_cljs$core$async29126.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29126.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29126");

(cljs.core.async.t_cljs$core$async29126.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29126");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29126.
 */
cljs.core.async.__GT_t_cljs$core$async29126 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29126(ch__$1,cs__$1,meta29127){
return (new cljs.core.async.t_cljs$core$async29126(ch__$1,cs__$1,meta29127));
});

}

return (new cljs.core.async.t_cljs$core$async29126(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28309__auto___31130 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_29283){
var state_val_29284 = (state_29283[(1)]);
if((state_val_29284 === (7))){
var inst_29279 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29285_31131 = state_29283__$1;
(statearr_29285_31131[(2)] = inst_29279);

(statearr_29285_31131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (20))){
var inst_29179 = (state_29283[(7)]);
var inst_29191 = cljs.core.first(inst_29179);
var inst_29192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29191,(0),null);
var inst_29193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29191,(1),null);
var state_29283__$1 = (function (){var statearr_29288 = state_29283;
(statearr_29288[(8)] = inst_29192);

return statearr_29288;
})();
if(cljs.core.truth_(inst_29193)){
var statearr_29289_31134 = state_29283__$1;
(statearr_29289_31134[(1)] = (22));

} else {
var statearr_29290_31135 = state_29283__$1;
(statearr_29290_31135[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (27))){
var inst_29231 = (state_29283[(9)]);
var inst_29224 = (state_29283[(10)]);
var inst_29226 = (state_29283[(11)]);
var inst_29142 = (state_29283[(12)]);
var inst_29231__$1 = cljs.core._nth(inst_29224,inst_29226);
var inst_29232 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29231__$1,inst_29142,done);
var state_29283__$1 = (function (){var statearr_29294 = state_29283;
(statearr_29294[(9)] = inst_29231__$1);

return statearr_29294;
})();
if(cljs.core.truth_(inst_29232)){
var statearr_29295_31141 = state_29283__$1;
(statearr_29295_31141[(1)] = (30));

} else {
var statearr_29296_31142 = state_29283__$1;
(statearr_29296_31142[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (1))){
var state_29283__$1 = state_29283;
var statearr_29297_31143 = state_29283__$1;
(statearr_29297_31143[(2)] = null);

(statearr_29297_31143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (24))){
var inst_29179 = (state_29283[(7)]);
var inst_29198 = (state_29283[(2)]);
var inst_29199 = cljs.core.next(inst_29179);
var inst_29151 = inst_29199;
var inst_29152 = null;
var inst_29153 = (0);
var inst_29154 = (0);
var state_29283__$1 = (function (){var statearr_29298 = state_29283;
(statearr_29298[(13)] = inst_29152);

(statearr_29298[(14)] = inst_29153);

(statearr_29298[(15)] = inst_29154);

(statearr_29298[(16)] = inst_29151);

(statearr_29298[(17)] = inst_29198);

return statearr_29298;
})();
var statearr_29299_31146 = state_29283__$1;
(statearr_29299_31146[(2)] = null);

(statearr_29299_31146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (39))){
var state_29283__$1 = state_29283;
var statearr_29303_31147 = state_29283__$1;
(statearr_29303_31147[(2)] = null);

(statearr_29303_31147[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (4))){
var inst_29142 = (state_29283[(12)]);
var inst_29142__$1 = (state_29283[(2)]);
var inst_29143 = (inst_29142__$1 == null);
var state_29283__$1 = (function (){var statearr_29304 = state_29283;
(statearr_29304[(12)] = inst_29142__$1);

return statearr_29304;
})();
if(cljs.core.truth_(inst_29143)){
var statearr_29305_31148 = state_29283__$1;
(statearr_29305_31148[(1)] = (5));

} else {
var statearr_29306_31150 = state_29283__$1;
(statearr_29306_31150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (15))){
var inst_29152 = (state_29283[(13)]);
var inst_29153 = (state_29283[(14)]);
var inst_29154 = (state_29283[(15)]);
var inst_29151 = (state_29283[(16)]);
var inst_29175 = (state_29283[(2)]);
var inst_29176 = (inst_29154 + (1));
var tmp29300 = inst_29152;
var tmp29301 = inst_29153;
var tmp29302 = inst_29151;
var inst_29151__$1 = tmp29302;
var inst_29152__$1 = tmp29300;
var inst_29153__$1 = tmp29301;
var inst_29154__$1 = inst_29176;
var state_29283__$1 = (function (){var statearr_29307 = state_29283;
(statearr_29307[(13)] = inst_29152__$1);

(statearr_29307[(14)] = inst_29153__$1);

(statearr_29307[(15)] = inst_29154__$1);

(statearr_29307[(16)] = inst_29151__$1);

(statearr_29307[(18)] = inst_29175);

return statearr_29307;
})();
var statearr_29308_31157 = state_29283__$1;
(statearr_29308_31157[(2)] = null);

(statearr_29308_31157[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (21))){
var inst_29202 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29312_31158 = state_29283__$1;
(statearr_29312_31158[(2)] = inst_29202);

(statearr_29312_31158[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (31))){
var inst_29231 = (state_29283[(9)]);
var inst_29235 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29231);
var state_29283__$1 = state_29283;
var statearr_29315_31159 = state_29283__$1;
(statearr_29315_31159[(2)] = inst_29235);

(statearr_29315_31159[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (32))){
var inst_29223 = (state_29283[(19)]);
var inst_29224 = (state_29283[(10)]);
var inst_29226 = (state_29283[(11)]);
var inst_29225 = (state_29283[(20)]);
var inst_29237 = (state_29283[(2)]);
var inst_29240 = (inst_29226 + (1));
var tmp29309 = inst_29223;
var tmp29310 = inst_29224;
var tmp29311 = inst_29225;
var inst_29223__$1 = tmp29309;
var inst_29224__$1 = tmp29310;
var inst_29225__$1 = tmp29311;
var inst_29226__$1 = inst_29240;
var state_29283__$1 = (function (){var statearr_29317 = state_29283;
(statearr_29317[(19)] = inst_29223__$1);

(statearr_29317[(10)] = inst_29224__$1);

(statearr_29317[(11)] = inst_29226__$1);

(statearr_29317[(21)] = inst_29237);

(statearr_29317[(20)] = inst_29225__$1);

return statearr_29317;
})();
var statearr_29318_31160 = state_29283__$1;
(statearr_29318_31160[(2)] = null);

(statearr_29318_31160[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (40))){
var inst_29252 = (state_29283[(22)]);
var inst_29256 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29252);
var state_29283__$1 = state_29283;
var statearr_29320_31161 = state_29283__$1;
(statearr_29320_31161[(2)] = inst_29256);

(statearr_29320_31161[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (33))){
var inst_29243 = (state_29283[(23)]);
var inst_29245 = cljs.core.chunked_seq_QMARK_(inst_29243);
var state_29283__$1 = state_29283;
if(inst_29245){
var statearr_29323_31162 = state_29283__$1;
(statearr_29323_31162[(1)] = (36));

} else {
var statearr_29324_31163 = state_29283__$1;
(statearr_29324_31163[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (13))){
var inst_29166 = (state_29283[(24)]);
var inst_29172 = cljs.core.async.close_BANG_(inst_29166);
var state_29283__$1 = state_29283;
var statearr_29327_31164 = state_29283__$1;
(statearr_29327_31164[(2)] = inst_29172);

(statearr_29327_31164[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (22))){
var inst_29192 = (state_29283[(8)]);
var inst_29195 = cljs.core.async.close_BANG_(inst_29192);
var state_29283__$1 = state_29283;
var statearr_29328_31165 = state_29283__$1;
(statearr_29328_31165[(2)] = inst_29195);

(statearr_29328_31165[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (36))){
var inst_29243 = (state_29283[(23)]);
var inst_29247 = cljs.core.chunk_first(inst_29243);
var inst_29248 = cljs.core.chunk_rest(inst_29243);
var inst_29249 = cljs.core.count(inst_29247);
var inst_29223 = inst_29248;
var inst_29224 = inst_29247;
var inst_29225 = inst_29249;
var inst_29226 = (0);
var state_29283__$1 = (function (){var statearr_29330 = state_29283;
(statearr_29330[(19)] = inst_29223);

(statearr_29330[(10)] = inst_29224);

(statearr_29330[(11)] = inst_29226);

(statearr_29330[(20)] = inst_29225);

return statearr_29330;
})();
var statearr_29332_31166 = state_29283__$1;
(statearr_29332_31166[(2)] = null);

(statearr_29332_31166[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (41))){
var inst_29243 = (state_29283[(23)]);
var inst_29258 = (state_29283[(2)]);
var inst_29259 = cljs.core.next(inst_29243);
var inst_29223 = inst_29259;
var inst_29224 = null;
var inst_29225 = (0);
var inst_29226 = (0);
var state_29283__$1 = (function (){var statearr_29333 = state_29283;
(statearr_29333[(19)] = inst_29223);

(statearr_29333[(25)] = inst_29258);

(statearr_29333[(10)] = inst_29224);

(statearr_29333[(11)] = inst_29226);

(statearr_29333[(20)] = inst_29225);

return statearr_29333;
})();
var statearr_29334_31167 = state_29283__$1;
(statearr_29334_31167[(2)] = null);

(statearr_29334_31167[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (43))){
var state_29283__$1 = state_29283;
var statearr_29335_31168 = state_29283__$1;
(statearr_29335_31168[(2)] = null);

(statearr_29335_31168[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (29))){
var inst_29267 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29336_31183 = state_29283__$1;
(statearr_29336_31183[(2)] = inst_29267);

(statearr_29336_31183[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (44))){
var inst_29276 = (state_29283[(2)]);
var state_29283__$1 = (function (){var statearr_29337 = state_29283;
(statearr_29337[(26)] = inst_29276);

return statearr_29337;
})();
var statearr_29338_31194 = state_29283__$1;
(statearr_29338_31194[(2)] = null);

(statearr_29338_31194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (6))){
var inst_29215 = (state_29283[(27)]);
var inst_29214 = cljs.core.deref(cs);
var inst_29215__$1 = cljs.core.keys(inst_29214);
var inst_29216 = cljs.core.count(inst_29215__$1);
var inst_29217 = cljs.core.reset_BANG_(dctr,inst_29216);
var inst_29222 = cljs.core.seq(inst_29215__$1);
var inst_29223 = inst_29222;
var inst_29224 = null;
var inst_29225 = (0);
var inst_29226 = (0);
var state_29283__$1 = (function (){var statearr_29339 = state_29283;
(statearr_29339[(19)] = inst_29223);

(statearr_29339[(10)] = inst_29224);

(statearr_29339[(11)] = inst_29226);

(statearr_29339[(28)] = inst_29217);

(statearr_29339[(20)] = inst_29225);

(statearr_29339[(27)] = inst_29215__$1);

return statearr_29339;
})();
var statearr_29340_31223 = state_29283__$1;
(statearr_29340_31223[(2)] = null);

(statearr_29340_31223[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (28))){
var inst_29223 = (state_29283[(19)]);
var inst_29243 = (state_29283[(23)]);
var inst_29243__$1 = cljs.core.seq(inst_29223);
var state_29283__$1 = (function (){var statearr_29341 = state_29283;
(statearr_29341[(23)] = inst_29243__$1);

return statearr_29341;
})();
if(inst_29243__$1){
var statearr_29342_31251 = state_29283__$1;
(statearr_29342_31251[(1)] = (33));

} else {
var statearr_29343_31252 = state_29283__$1;
(statearr_29343_31252[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (25))){
var inst_29226 = (state_29283[(11)]);
var inst_29225 = (state_29283[(20)]);
var inst_29228 = (inst_29226 < inst_29225);
var inst_29229 = inst_29228;
var state_29283__$1 = state_29283;
if(cljs.core.truth_(inst_29229)){
var statearr_29344_31255 = state_29283__$1;
(statearr_29344_31255[(1)] = (27));

} else {
var statearr_29345_31256 = state_29283__$1;
(statearr_29345_31256[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (34))){
var state_29283__$1 = state_29283;
var statearr_29346_31257 = state_29283__$1;
(statearr_29346_31257[(2)] = null);

(statearr_29346_31257[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (17))){
var state_29283__$1 = state_29283;
var statearr_29347_31258 = state_29283__$1;
(statearr_29347_31258[(2)] = null);

(statearr_29347_31258[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (3))){
var inst_29281 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29283__$1,inst_29281);
} else {
if((state_val_29284 === (12))){
var inst_29210 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29349_31260 = state_29283__$1;
(statearr_29349_31260[(2)] = inst_29210);

(statearr_29349_31260[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (2))){
var state_29283__$1 = state_29283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29283__$1,(4),ch);
} else {
if((state_val_29284 === (23))){
var state_29283__$1 = state_29283;
var statearr_29350_31263 = state_29283__$1;
(statearr_29350_31263[(2)] = null);

(statearr_29350_31263[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (35))){
var inst_29265 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29351_31267 = state_29283__$1;
(statearr_29351_31267[(2)] = inst_29265);

(statearr_29351_31267[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (19))){
var inst_29179 = (state_29283[(7)]);
var inst_29183 = cljs.core.chunk_first(inst_29179);
var inst_29184 = cljs.core.chunk_rest(inst_29179);
var inst_29185 = cljs.core.count(inst_29183);
var inst_29151 = inst_29184;
var inst_29152 = inst_29183;
var inst_29153 = inst_29185;
var inst_29154 = (0);
var state_29283__$1 = (function (){var statearr_29353 = state_29283;
(statearr_29353[(13)] = inst_29152);

(statearr_29353[(14)] = inst_29153);

(statearr_29353[(15)] = inst_29154);

(statearr_29353[(16)] = inst_29151);

return statearr_29353;
})();
var statearr_29354_31274 = state_29283__$1;
(statearr_29354_31274[(2)] = null);

(statearr_29354_31274[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (11))){
var inst_29151 = (state_29283[(16)]);
var inst_29179 = (state_29283[(7)]);
var inst_29179__$1 = cljs.core.seq(inst_29151);
var state_29283__$1 = (function (){var statearr_29355 = state_29283;
(statearr_29355[(7)] = inst_29179__$1);

return statearr_29355;
})();
if(inst_29179__$1){
var statearr_29356_31277 = state_29283__$1;
(statearr_29356_31277[(1)] = (16));

} else {
var statearr_29357_31280 = state_29283__$1;
(statearr_29357_31280[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (9))){
var inst_29212 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29358_31285 = state_29283__$1;
(statearr_29358_31285[(2)] = inst_29212);

(statearr_29358_31285[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (5))){
var inst_29149 = cljs.core.deref(cs);
var inst_29150 = cljs.core.seq(inst_29149);
var inst_29151 = inst_29150;
var inst_29152 = null;
var inst_29153 = (0);
var inst_29154 = (0);
var state_29283__$1 = (function (){var statearr_29359 = state_29283;
(statearr_29359[(13)] = inst_29152);

(statearr_29359[(14)] = inst_29153);

(statearr_29359[(15)] = inst_29154);

(statearr_29359[(16)] = inst_29151);

return statearr_29359;
})();
var statearr_29361_31287 = state_29283__$1;
(statearr_29361_31287[(2)] = null);

(statearr_29361_31287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (14))){
var state_29283__$1 = state_29283;
var statearr_29365_31289 = state_29283__$1;
(statearr_29365_31289[(2)] = null);

(statearr_29365_31289[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (45))){
var inst_29273 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29366_31294 = state_29283__$1;
(statearr_29366_31294[(2)] = inst_29273);

(statearr_29366_31294[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (26))){
var inst_29215 = (state_29283[(27)]);
var inst_29269 = (state_29283[(2)]);
var inst_29270 = cljs.core.seq(inst_29215);
var state_29283__$1 = (function (){var statearr_29368 = state_29283;
(statearr_29368[(29)] = inst_29269);

return statearr_29368;
})();
if(inst_29270){
var statearr_29369_31301 = state_29283__$1;
(statearr_29369_31301[(1)] = (42));

} else {
var statearr_29370_31302 = state_29283__$1;
(statearr_29370_31302[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (16))){
var inst_29179 = (state_29283[(7)]);
var inst_29181 = cljs.core.chunked_seq_QMARK_(inst_29179);
var state_29283__$1 = state_29283;
if(inst_29181){
var statearr_29371_31304 = state_29283__$1;
(statearr_29371_31304[(1)] = (19));

} else {
var statearr_29372_31305 = state_29283__$1;
(statearr_29372_31305[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (38))){
var inst_29262 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29373_31307 = state_29283__$1;
(statearr_29373_31307[(2)] = inst_29262);

(statearr_29373_31307[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (30))){
var state_29283__$1 = state_29283;
var statearr_29374_31309 = state_29283__$1;
(statearr_29374_31309[(2)] = null);

(statearr_29374_31309[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (10))){
var inst_29152 = (state_29283[(13)]);
var inst_29154 = (state_29283[(15)]);
var inst_29165 = cljs.core._nth(inst_29152,inst_29154);
var inst_29166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29165,(0),null);
var inst_29170 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29165,(1),null);
var state_29283__$1 = (function (){var statearr_29375 = state_29283;
(statearr_29375[(24)] = inst_29166);

return statearr_29375;
})();
if(cljs.core.truth_(inst_29170)){
var statearr_29376_31312 = state_29283__$1;
(statearr_29376_31312[(1)] = (13));

} else {
var statearr_29377_31314 = state_29283__$1;
(statearr_29377_31314[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (18))){
var inst_29205 = (state_29283[(2)]);
var state_29283__$1 = state_29283;
var statearr_29381_31316 = state_29283__$1;
(statearr_29381_31316[(2)] = inst_29205);

(statearr_29381_31316[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (42))){
var state_29283__$1 = state_29283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29283__$1,(45),dchan);
} else {
if((state_val_29284 === (37))){
var inst_29243 = (state_29283[(23)]);
var inst_29142 = (state_29283[(12)]);
var inst_29252 = (state_29283[(22)]);
var inst_29252__$1 = cljs.core.first(inst_29243);
var inst_29253 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29252__$1,inst_29142,done);
var state_29283__$1 = (function (){var statearr_29386 = state_29283;
(statearr_29386[(22)] = inst_29252__$1);

return statearr_29386;
})();
if(cljs.core.truth_(inst_29253)){
var statearr_29387_31321 = state_29283__$1;
(statearr_29387_31321[(1)] = (39));

} else {
var statearr_29390_31325 = state_29283__$1;
(statearr_29390_31325[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29284 === (8))){
var inst_29153 = (state_29283[(14)]);
var inst_29154 = (state_29283[(15)]);
var inst_29159 = (inst_29154 < inst_29153);
var inst_29160 = inst_29159;
var state_29283__$1 = state_29283;
if(cljs.core.truth_(inst_29160)){
var statearr_29392_31327 = state_29283__$1;
(statearr_29392_31327[(1)] = (10));

} else {
var statearr_29393_31328 = state_29283__$1;
(statearr_29393_31328[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28253__auto__ = null;
var cljs$core$async$mult_$_state_machine__28253__auto____0 = (function (){
var statearr_29396 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29396[(0)] = cljs$core$async$mult_$_state_machine__28253__auto__);

(statearr_29396[(1)] = (1));

return statearr_29396;
});
var cljs$core$async$mult_$_state_machine__28253__auto____1 = (function (state_29283){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_29283);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e29397){var ex__28256__auto__ = e29397;
var statearr_29398_31332 = state_29283;
(statearr_29398_31332[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_29283[(4)]))){
var statearr_29399_31333 = state_29283;
(statearr_29399_31333[(1)] = cljs.core.first((state_29283[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31335 = state_29283;
state_29283 = G__31335;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28253__auto__ = function(state_29283){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28253__auto____1.call(this,state_29283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28253__auto____0;
cljs$core$async$mult_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28253__auto____1;
return cljs$core$async$mult_$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_29403 = f__28310__auto__();
(statearr_29403[(6)] = c__28309__auto___31130);

return statearr_29403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29405 = arguments.length;
switch (G__29405) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_31363 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_31363(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_31370 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_31370(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_31372 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_31372(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_31377 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_31377(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_31390 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_31390(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31415 = arguments.length;
var i__4737__auto___31416 = (0);
while(true){
if((i__4737__auto___31416 < len__4736__auto___31415)){
args__4742__auto__.push((arguments[i__4737__auto___31416]));

var G__31429 = (i__4737__auto___31416 + (1));
i__4737__auto___31416 = G__31429;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29437){
var map__29438 = p__29437;
var map__29438__$1 = (((((!((map__29438 == null))))?(((((map__29438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29438.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29438):map__29438);
var opts = map__29438__$1;
var statearr_29443_31473 = state;
(statearr_29443_31473[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29444_31475 = state;
(statearr_29444_31475[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_29445_31477 = state;
(statearr_29445_31477[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29433){
var G__29434 = cljs.core.first(seq29433);
var seq29433__$1 = cljs.core.next(seq29433);
var G__29435 = cljs.core.first(seq29433__$1);
var seq29433__$2 = cljs.core.next(seq29433__$1);
var G__29436 = cljs.core.first(seq29433__$2);
var seq29433__$3 = cljs.core.next(seq29433__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29434,G__29435,G__29436,seq29433__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29452 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29452 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29453){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29453 = meta29453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29454,meta29453__$1){
var self__ = this;
var _29454__$1 = this;
return (new cljs.core.async.t_cljs$core$async29452(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29453__$1));
}));

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29454){
var self__ = this;
var _29454__$1 = this;
return self__.meta29453;
}));

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29452.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29453","meta29453",-252395104,null)], null);
}));

(cljs.core.async.t_cljs$core$async29452.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29452.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29452");

(cljs.core.async.t_cljs$core$async29452.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29452");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29452.
 */
cljs.core.async.__GT_t_cljs$core$async29452 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29452(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29453){
return (new cljs.core.async.t_cljs$core$async29452(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29453));
});

}

return (new cljs.core.async.t_cljs$core$async29452(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28309__auto___31515 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_29580){
var state_val_29581 = (state_29580[(1)]);
if((state_val_29581 === (7))){
var inst_29489 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
var statearr_29582_31521 = state_29580__$1;
(statearr_29582_31521[(2)] = inst_29489);

(statearr_29582_31521[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (20))){
var inst_29504 = (state_29580[(7)]);
var state_29580__$1 = state_29580;
var statearr_29583_31523 = state_29580__$1;
(statearr_29583_31523[(2)] = inst_29504);

(statearr_29583_31523[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (27))){
var state_29580__$1 = state_29580;
var statearr_29584_31525 = state_29580__$1;
(statearr_29584_31525[(2)] = null);

(statearr_29584_31525[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (1))){
var inst_29475 = (state_29580[(8)]);
var inst_29475__$1 = calc_state();
var inst_29477 = (inst_29475__$1 == null);
var inst_29478 = cljs.core.not(inst_29477);
var state_29580__$1 = (function (){var statearr_29585 = state_29580;
(statearr_29585[(8)] = inst_29475__$1);

return statearr_29585;
})();
if(inst_29478){
var statearr_29586_31533 = state_29580__$1;
(statearr_29586_31533[(1)] = (2));

} else {
var statearr_29587_31534 = state_29580__$1;
(statearr_29587_31534[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (24))){
var inst_29554 = (state_29580[(9)]);
var inst_29531 = (state_29580[(10)]);
var inst_29540 = (state_29580[(11)]);
var inst_29554__$1 = (inst_29531.cljs$core$IFn$_invoke$arity$1 ? inst_29531.cljs$core$IFn$_invoke$arity$1(inst_29540) : inst_29531.call(null,inst_29540));
var state_29580__$1 = (function (){var statearr_29588 = state_29580;
(statearr_29588[(9)] = inst_29554__$1);

return statearr_29588;
})();
if(cljs.core.truth_(inst_29554__$1)){
var statearr_29589_31537 = state_29580__$1;
(statearr_29589_31537[(1)] = (29));

} else {
var statearr_29592_31540 = state_29580__$1;
(statearr_29592_31540[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (4))){
var inst_29492 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
if(cljs.core.truth_(inst_29492)){
var statearr_29593_31542 = state_29580__$1;
(statearr_29593_31542[(1)] = (8));

} else {
var statearr_29594_31543 = state_29580__$1;
(statearr_29594_31543[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (15))){
var inst_29525 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
if(cljs.core.truth_(inst_29525)){
var statearr_29598_31545 = state_29580__$1;
(statearr_29598_31545[(1)] = (19));

} else {
var statearr_29599_31547 = state_29580__$1;
(statearr_29599_31547[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (21))){
var inst_29530 = (state_29580[(12)]);
var inst_29530__$1 = (state_29580[(2)]);
var inst_29531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29530__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29532 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29530__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29530__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29580__$1 = (function (){var statearr_29600 = state_29580;
(statearr_29600[(12)] = inst_29530__$1);

(statearr_29600[(13)] = inst_29532);

(statearr_29600[(10)] = inst_29531);

return statearr_29600;
})();
return cljs.core.async.ioc_alts_BANG_(state_29580__$1,(22),inst_29533);
} else {
if((state_val_29581 === (31))){
var inst_29562 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
if(cljs.core.truth_(inst_29562)){
var statearr_29602_31551 = state_29580__$1;
(statearr_29602_31551[(1)] = (32));

} else {
var statearr_29604_31552 = state_29580__$1;
(statearr_29604_31552[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (32))){
var inst_29539 = (state_29580[(14)]);
var state_29580__$1 = state_29580;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29580__$1,(35),out,inst_29539);
} else {
if((state_val_29581 === (33))){
var inst_29530 = (state_29580[(12)]);
var inst_29504 = inst_29530;
var state_29580__$1 = (function (){var statearr_29605 = state_29580;
(statearr_29605[(7)] = inst_29504);

return statearr_29605;
})();
var statearr_29606_31555 = state_29580__$1;
(statearr_29606_31555[(2)] = null);

(statearr_29606_31555[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (13))){
var inst_29504 = (state_29580[(7)]);
var inst_29514 = inst_29504.cljs$lang$protocol_mask$partition0$;
var inst_29515 = (inst_29514 & (64));
var inst_29516 = inst_29504.cljs$core$ISeq$;
var inst_29517 = (cljs.core.PROTOCOL_SENTINEL === inst_29516);
var inst_29518 = ((inst_29515) || (inst_29517));
var state_29580__$1 = state_29580;
if(cljs.core.truth_(inst_29518)){
var statearr_29607_31558 = state_29580__$1;
(statearr_29607_31558[(1)] = (16));

} else {
var statearr_29608_31559 = state_29580__$1;
(statearr_29608_31559[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (22))){
var inst_29539 = (state_29580[(14)]);
var inst_29540 = (state_29580[(11)]);
var inst_29538 = (state_29580[(2)]);
var inst_29539__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29538,(0),null);
var inst_29540__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29538,(1),null);
var inst_29541 = (inst_29539__$1 == null);
var inst_29542 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29540__$1,change);
var inst_29543 = ((inst_29541) || (inst_29542));
var state_29580__$1 = (function (){var statearr_29609 = state_29580;
(statearr_29609[(14)] = inst_29539__$1);

(statearr_29609[(11)] = inst_29540__$1);

return statearr_29609;
})();
if(cljs.core.truth_(inst_29543)){
var statearr_29610_31562 = state_29580__$1;
(statearr_29610_31562[(1)] = (23));

} else {
var statearr_29611_31564 = state_29580__$1;
(statearr_29611_31564[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (36))){
var inst_29530 = (state_29580[(12)]);
var inst_29504 = inst_29530;
var state_29580__$1 = (function (){var statearr_29612 = state_29580;
(statearr_29612[(7)] = inst_29504);

return statearr_29612;
})();
var statearr_29613_31566 = state_29580__$1;
(statearr_29613_31566[(2)] = null);

(statearr_29613_31566[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (29))){
var inst_29554 = (state_29580[(9)]);
var state_29580__$1 = state_29580;
var statearr_29614_31568 = state_29580__$1;
(statearr_29614_31568[(2)] = inst_29554);

(statearr_29614_31568[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (6))){
var state_29580__$1 = state_29580;
var statearr_29619_31570 = state_29580__$1;
(statearr_29619_31570[(2)] = false);

(statearr_29619_31570[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (28))){
var inst_29550 = (state_29580[(2)]);
var inst_29551 = calc_state();
var inst_29504 = inst_29551;
var state_29580__$1 = (function (){var statearr_29621 = state_29580;
(statearr_29621[(15)] = inst_29550);

(statearr_29621[(7)] = inst_29504);

return statearr_29621;
})();
var statearr_29622_31572 = state_29580__$1;
(statearr_29622_31572[(2)] = null);

(statearr_29622_31572[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (25))){
var inst_29576 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
var statearr_29623_31573 = state_29580__$1;
(statearr_29623_31573[(2)] = inst_29576);

(statearr_29623_31573[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (34))){
var inst_29574 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
var statearr_29624_31575 = state_29580__$1;
(statearr_29624_31575[(2)] = inst_29574);

(statearr_29624_31575[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (17))){
var state_29580__$1 = state_29580;
var statearr_29626_31577 = state_29580__$1;
(statearr_29626_31577[(2)] = false);

(statearr_29626_31577[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (3))){
var state_29580__$1 = state_29580;
var statearr_29627_31578 = state_29580__$1;
(statearr_29627_31578[(2)] = false);

(statearr_29627_31578[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (12))){
var inst_29578 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29580__$1,inst_29578);
} else {
if((state_val_29581 === (2))){
var inst_29475 = (state_29580[(8)]);
var inst_29480 = inst_29475.cljs$lang$protocol_mask$partition0$;
var inst_29481 = (inst_29480 & (64));
var inst_29482 = inst_29475.cljs$core$ISeq$;
var inst_29484 = (cljs.core.PROTOCOL_SENTINEL === inst_29482);
var inst_29485 = ((inst_29481) || (inst_29484));
var state_29580__$1 = state_29580;
if(cljs.core.truth_(inst_29485)){
var statearr_29632_31583 = state_29580__$1;
(statearr_29632_31583[(1)] = (5));

} else {
var statearr_29633_31585 = state_29580__$1;
(statearr_29633_31585[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (23))){
var inst_29539 = (state_29580[(14)]);
var inst_29545 = (inst_29539 == null);
var state_29580__$1 = state_29580;
if(cljs.core.truth_(inst_29545)){
var statearr_29634_31587 = state_29580__$1;
(statearr_29634_31587[(1)] = (26));

} else {
var statearr_29635_31588 = state_29580__$1;
(statearr_29635_31588[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (35))){
var inst_29565 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
if(cljs.core.truth_(inst_29565)){
var statearr_29636_31590 = state_29580__$1;
(statearr_29636_31590[(1)] = (36));

} else {
var statearr_29637_31591 = state_29580__$1;
(statearr_29637_31591[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (19))){
var inst_29504 = (state_29580[(7)]);
var inst_29527 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29504);
var state_29580__$1 = state_29580;
var statearr_29638_31592 = state_29580__$1;
(statearr_29638_31592[(2)] = inst_29527);

(statearr_29638_31592[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (11))){
var inst_29504 = (state_29580[(7)]);
var inst_29511 = (inst_29504 == null);
var inst_29512 = cljs.core.not(inst_29511);
var state_29580__$1 = state_29580;
if(inst_29512){
var statearr_29639_31593 = state_29580__$1;
(statearr_29639_31593[(1)] = (13));

} else {
var statearr_29640_31594 = state_29580__$1;
(statearr_29640_31594[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (9))){
var inst_29475 = (state_29580[(8)]);
var state_29580__$1 = state_29580;
var statearr_29641_31595 = state_29580__$1;
(statearr_29641_31595[(2)] = inst_29475);

(statearr_29641_31595[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (5))){
var state_29580__$1 = state_29580;
var statearr_29642_31596 = state_29580__$1;
(statearr_29642_31596[(2)] = true);

(statearr_29642_31596[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (14))){
var state_29580__$1 = state_29580;
var statearr_29643_31599 = state_29580__$1;
(statearr_29643_31599[(2)] = false);

(statearr_29643_31599[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (26))){
var inst_29540 = (state_29580[(11)]);
var inst_29547 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29540);
var state_29580__$1 = state_29580;
var statearr_29644_31600 = state_29580__$1;
(statearr_29644_31600[(2)] = inst_29547);

(statearr_29644_31600[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (16))){
var state_29580__$1 = state_29580;
var statearr_29645_31601 = state_29580__$1;
(statearr_29645_31601[(2)] = true);

(statearr_29645_31601[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (38))){
var inst_29570 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
var statearr_29646_31603 = state_29580__$1;
(statearr_29646_31603[(2)] = inst_29570);

(statearr_29646_31603[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (30))){
var inst_29532 = (state_29580[(13)]);
var inst_29531 = (state_29580[(10)]);
var inst_29540 = (state_29580[(11)]);
var inst_29557 = cljs.core.empty_QMARK_(inst_29531);
var inst_29558 = (inst_29532.cljs$core$IFn$_invoke$arity$1 ? inst_29532.cljs$core$IFn$_invoke$arity$1(inst_29540) : inst_29532.call(null,inst_29540));
var inst_29559 = cljs.core.not(inst_29558);
var inst_29560 = ((inst_29557) && (inst_29559));
var state_29580__$1 = state_29580;
var statearr_29647_31607 = state_29580__$1;
(statearr_29647_31607[(2)] = inst_29560);

(statearr_29647_31607[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (10))){
var inst_29475 = (state_29580[(8)]);
var inst_29497 = (state_29580[(2)]);
var inst_29498 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29497,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29502 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29497,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29497,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29504 = inst_29475;
var state_29580__$1 = (function (){var statearr_29651 = state_29580;
(statearr_29651[(16)] = inst_29503);

(statearr_29651[(17)] = inst_29502);

(statearr_29651[(7)] = inst_29504);

(statearr_29651[(18)] = inst_29498);

return statearr_29651;
})();
var statearr_29652_31611 = state_29580__$1;
(statearr_29652_31611[(2)] = null);

(statearr_29652_31611[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (18))){
var inst_29522 = (state_29580[(2)]);
var state_29580__$1 = state_29580;
var statearr_29653_31612 = state_29580__$1;
(statearr_29653_31612[(2)] = inst_29522);

(statearr_29653_31612[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (37))){
var state_29580__$1 = state_29580;
var statearr_29654_31613 = state_29580__$1;
(statearr_29654_31613[(2)] = null);

(statearr_29654_31613[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29581 === (8))){
var inst_29475 = (state_29580[(8)]);
var inst_29494 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29475);
var state_29580__$1 = state_29580;
var statearr_29655_31614 = state_29580__$1;
(statearr_29655_31614[(2)] = inst_29494);

(statearr_29655_31614[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28253__auto__ = null;
var cljs$core$async$mix_$_state_machine__28253__auto____0 = (function (){
var statearr_29656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29656[(0)] = cljs$core$async$mix_$_state_machine__28253__auto__);

(statearr_29656[(1)] = (1));

return statearr_29656;
});
var cljs$core$async$mix_$_state_machine__28253__auto____1 = (function (state_29580){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_29580);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e29657){var ex__28256__auto__ = e29657;
var statearr_29658_31619 = state_29580;
(statearr_29658_31619[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_29580[(4)]))){
var statearr_29659_31620 = state_29580;
(statearr_29659_31620[(1)] = cljs.core.first((state_29580[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31621 = state_29580;
state_29580 = G__31621;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28253__auto__ = function(state_29580){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28253__auto____1.call(this,state_29580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28253__auto____0;
cljs$core$async$mix_$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28253__auto____1;
return cljs$core$async$mix_$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_29661 = f__28310__auto__();
(statearr_29661[(6)] = c__28309__auto___31515);

return statearr_29661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_31627 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_31627(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_31633 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_31633(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_31637 = (function() {
var G__31638 = null;
var G__31638__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__31638__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__31638 = function(p,v){
switch(arguments.length){
case 1:
return G__31638__1.call(this,p);
case 2:
return G__31638__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__31638.cljs$core$IFn$_invoke$arity$1 = G__31638__1;
G__31638.cljs$core$IFn$_invoke$arity$2 = G__31638__2;
return G__31638;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29673 = arguments.length;
switch (G__29673) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31637(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_31637(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29676 = arguments.length;
switch (G__29676) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29674_SHARP_){
if(cljs.core.truth_((p1__29674_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29674_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29674_SHARP_.call(null,topic)))){
return p1__29674_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29674_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29683 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29683 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29684){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29684 = meta29684;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29685,meta29684__$1){
var self__ = this;
var _29685__$1 = this;
return (new cljs.core.async.t_cljs$core$async29683(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29684__$1));
}));

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29685){
var self__ = this;
var _29685__$1 = this;
return self__.meta29684;
}));

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29683.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29683.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29684","meta29684",1028294089,null)], null);
}));

(cljs.core.async.t_cljs$core$async29683.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29683.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29683");

(cljs.core.async.t_cljs$core$async29683.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29683");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29683.
 */
cljs.core.async.__GT_t_cljs$core$async29683 = (function cljs$core$async$__GT_t_cljs$core$async29683(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29684){
return (new cljs.core.async.t_cljs$core$async29683(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29684));
});

}

return (new cljs.core.async.t_cljs$core$async29683(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28309__auto___31673 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_29783){
var state_val_29784 = (state_29783[(1)]);
if((state_val_29784 === (7))){
var inst_29778 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
var statearr_29785_31674 = state_29783__$1;
(statearr_29785_31674[(2)] = inst_29778);

(statearr_29785_31674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (20))){
var state_29783__$1 = state_29783;
var statearr_29786_31684 = state_29783__$1;
(statearr_29786_31684[(2)] = null);

(statearr_29786_31684[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (1))){
var state_29783__$1 = state_29783;
var statearr_29787_31686 = state_29783__$1;
(statearr_29787_31686[(2)] = null);

(statearr_29787_31686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (24))){
var inst_29758 = (state_29783[(7)]);
var inst_29770 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_29758);
var state_29783__$1 = state_29783;
var statearr_29792_31695 = state_29783__$1;
(statearr_29792_31695[(2)] = inst_29770);

(statearr_29792_31695[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (4))){
var inst_29702 = (state_29783[(8)]);
var inst_29702__$1 = (state_29783[(2)]);
var inst_29704 = (inst_29702__$1 == null);
var state_29783__$1 = (function (){var statearr_29793 = state_29783;
(statearr_29793[(8)] = inst_29702__$1);

return statearr_29793;
})();
if(cljs.core.truth_(inst_29704)){
var statearr_29794_31710 = state_29783__$1;
(statearr_29794_31710[(1)] = (5));

} else {
var statearr_29795_31712 = state_29783__$1;
(statearr_29795_31712[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (15))){
var inst_29752 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
var statearr_29799_31714 = state_29783__$1;
(statearr_29799_31714[(2)] = inst_29752);

(statearr_29799_31714[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (21))){
var inst_29775 = (state_29783[(2)]);
var state_29783__$1 = (function (){var statearr_29800 = state_29783;
(statearr_29800[(9)] = inst_29775);

return statearr_29800;
})();
var statearr_29801_31716 = state_29783__$1;
(statearr_29801_31716[(2)] = null);

(statearr_29801_31716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (13))){
var inst_29734 = (state_29783[(10)]);
var inst_29736 = cljs.core.chunked_seq_QMARK_(inst_29734);
var state_29783__$1 = state_29783;
if(inst_29736){
var statearr_29802_31718 = state_29783__$1;
(statearr_29802_31718[(1)] = (16));

} else {
var statearr_29803_31719 = state_29783__$1;
(statearr_29803_31719[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (22))){
var inst_29767 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
if(cljs.core.truth_(inst_29767)){
var statearr_29807_31721 = state_29783__$1;
(statearr_29807_31721[(1)] = (23));

} else {
var statearr_29812_31723 = state_29783__$1;
(statearr_29812_31723[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (6))){
var inst_29702 = (state_29783[(8)]);
var inst_29758 = (state_29783[(7)]);
var inst_29761 = (state_29783[(11)]);
var inst_29758__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29702) : topic_fn.call(null,inst_29702));
var inst_29760 = cljs.core.deref(mults);
var inst_29761__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29760,inst_29758__$1);
var state_29783__$1 = (function (){var statearr_29814 = state_29783;
(statearr_29814[(7)] = inst_29758__$1);

(statearr_29814[(11)] = inst_29761__$1);

return statearr_29814;
})();
if(cljs.core.truth_(inst_29761__$1)){
var statearr_29815_31726 = state_29783__$1;
(statearr_29815_31726[(1)] = (19));

} else {
var statearr_29819_31727 = state_29783__$1;
(statearr_29819_31727[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (25))){
var inst_29772 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
var statearr_29820_31729 = state_29783__$1;
(statearr_29820_31729[(2)] = inst_29772);

(statearr_29820_31729[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (17))){
var inst_29734 = (state_29783[(10)]);
var inst_29743 = cljs.core.first(inst_29734);
var inst_29744 = cljs.core.async.muxch_STAR_(inst_29743);
var inst_29745 = cljs.core.async.close_BANG_(inst_29744);
var inst_29746 = cljs.core.next(inst_29734);
var inst_29714 = inst_29746;
var inst_29715 = null;
var inst_29716 = (0);
var inst_29717 = (0);
var state_29783__$1 = (function (){var statearr_29821 = state_29783;
(statearr_29821[(12)] = inst_29714);

(statearr_29821[(13)] = inst_29717);

(statearr_29821[(14)] = inst_29715);

(statearr_29821[(15)] = inst_29716);

(statearr_29821[(16)] = inst_29745);

return statearr_29821;
})();
var statearr_29822_31733 = state_29783__$1;
(statearr_29822_31733[(2)] = null);

(statearr_29822_31733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (3))){
var inst_29780 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29783__$1,inst_29780);
} else {
if((state_val_29784 === (12))){
var inst_29754 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
var statearr_29823_31742 = state_29783__$1;
(statearr_29823_31742[(2)] = inst_29754);

(statearr_29823_31742[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (2))){
var state_29783__$1 = state_29783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29783__$1,(4),ch);
} else {
if((state_val_29784 === (23))){
var state_29783__$1 = state_29783;
var statearr_29824_31749 = state_29783__$1;
(statearr_29824_31749[(2)] = null);

(statearr_29824_31749[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (19))){
var inst_29702 = (state_29783[(8)]);
var inst_29761 = (state_29783[(11)]);
var inst_29765 = cljs.core.async.muxch_STAR_(inst_29761);
var state_29783__$1 = state_29783;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29783__$1,(22),inst_29765,inst_29702);
} else {
if((state_val_29784 === (11))){
var inst_29714 = (state_29783[(12)]);
var inst_29734 = (state_29783[(10)]);
var inst_29734__$1 = cljs.core.seq(inst_29714);
var state_29783__$1 = (function (){var statearr_29827 = state_29783;
(statearr_29827[(10)] = inst_29734__$1);

return statearr_29827;
})();
if(inst_29734__$1){
var statearr_29828_31758 = state_29783__$1;
(statearr_29828_31758[(1)] = (13));

} else {
var statearr_29829_31759 = state_29783__$1;
(statearr_29829_31759[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (9))){
var inst_29756 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
var statearr_29832_31760 = state_29783__$1;
(statearr_29832_31760[(2)] = inst_29756);

(statearr_29832_31760[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (5))){
var inst_29711 = cljs.core.deref(mults);
var inst_29712 = cljs.core.vals(inst_29711);
var inst_29713 = cljs.core.seq(inst_29712);
var inst_29714 = inst_29713;
var inst_29715 = null;
var inst_29716 = (0);
var inst_29717 = (0);
var state_29783__$1 = (function (){var statearr_29838 = state_29783;
(statearr_29838[(12)] = inst_29714);

(statearr_29838[(13)] = inst_29717);

(statearr_29838[(14)] = inst_29715);

(statearr_29838[(15)] = inst_29716);

return statearr_29838;
})();
var statearr_29839_31767 = state_29783__$1;
(statearr_29839_31767[(2)] = null);

(statearr_29839_31767[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (14))){
var state_29783__$1 = state_29783;
var statearr_29843_31768 = state_29783__$1;
(statearr_29843_31768[(2)] = null);

(statearr_29843_31768[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (16))){
var inst_29734 = (state_29783[(10)]);
var inst_29738 = cljs.core.chunk_first(inst_29734);
var inst_29739 = cljs.core.chunk_rest(inst_29734);
var inst_29740 = cljs.core.count(inst_29738);
var inst_29714 = inst_29739;
var inst_29715 = inst_29738;
var inst_29716 = inst_29740;
var inst_29717 = (0);
var state_29783__$1 = (function (){var statearr_29844 = state_29783;
(statearr_29844[(12)] = inst_29714);

(statearr_29844[(13)] = inst_29717);

(statearr_29844[(14)] = inst_29715);

(statearr_29844[(15)] = inst_29716);

return statearr_29844;
})();
var statearr_29847_31773 = state_29783__$1;
(statearr_29847_31773[(2)] = null);

(statearr_29847_31773[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (10))){
var inst_29714 = (state_29783[(12)]);
var inst_29717 = (state_29783[(13)]);
var inst_29715 = (state_29783[(14)]);
var inst_29716 = (state_29783[(15)]);
var inst_29728 = cljs.core._nth(inst_29715,inst_29717);
var inst_29729 = cljs.core.async.muxch_STAR_(inst_29728);
var inst_29730 = cljs.core.async.close_BANG_(inst_29729);
var inst_29731 = (inst_29717 + (1));
var tmp29840 = inst_29714;
var tmp29841 = inst_29715;
var tmp29842 = inst_29716;
var inst_29714__$1 = tmp29840;
var inst_29715__$1 = tmp29841;
var inst_29716__$1 = tmp29842;
var inst_29717__$1 = inst_29731;
var state_29783__$1 = (function (){var statearr_29848 = state_29783;
(statearr_29848[(12)] = inst_29714__$1);

(statearr_29848[(13)] = inst_29717__$1);

(statearr_29848[(14)] = inst_29715__$1);

(statearr_29848[(15)] = inst_29716__$1);

(statearr_29848[(17)] = inst_29730);

return statearr_29848;
})();
var statearr_29849_31778 = state_29783__$1;
(statearr_29849_31778[(2)] = null);

(statearr_29849_31778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (18))){
var inst_29749 = (state_29783[(2)]);
var state_29783__$1 = state_29783;
var statearr_29851_31779 = state_29783__$1;
(statearr_29851_31779[(2)] = inst_29749);

(statearr_29851_31779[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29784 === (8))){
var inst_29717 = (state_29783[(13)]);
var inst_29716 = (state_29783[(15)]);
var inst_29725 = (inst_29717 < inst_29716);
var inst_29726 = inst_29725;
var state_29783__$1 = state_29783;
if(cljs.core.truth_(inst_29726)){
var statearr_29852_31782 = state_29783__$1;
(statearr_29852_31782[(1)] = (10));

} else {
var statearr_29853_31784 = state_29783__$1;
(statearr_29853_31784[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_29856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29856[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_29856[(1)] = (1));

return statearr_29856;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_29783){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_29783);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e29857){var ex__28256__auto__ = e29857;
var statearr_29858_31785 = state_29783;
(statearr_29858_31785[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_29783[(4)]))){
var statearr_29859_31786 = state_29783;
(statearr_29859_31786[(1)] = cljs.core.first((state_29783[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31787 = state_29783;
state_29783 = G__31787;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_29783){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_29783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_29860 = f__28310__auto__();
(statearr_29860[(6)] = c__28309__auto___31673);

return statearr_29860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29864 = arguments.length;
switch (G__29864) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29866 = arguments.length;
switch (G__29866) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29869 = arguments.length;
switch (G__29869) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28309__auto___31795 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_29919){
var state_val_29920 = (state_29919[(1)]);
if((state_val_29920 === (7))){
var state_29919__$1 = state_29919;
var statearr_29921_31797 = state_29919__$1;
(statearr_29921_31797[(2)] = null);

(statearr_29921_31797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (1))){
var state_29919__$1 = state_29919;
var statearr_29922_31798 = state_29919__$1;
(statearr_29922_31798[(2)] = null);

(statearr_29922_31798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (4))){
var inst_29876 = (state_29919[(7)]);
var inst_29877 = (state_29919[(8)]);
var inst_29879 = (inst_29877 < inst_29876);
var state_29919__$1 = state_29919;
if(cljs.core.truth_(inst_29879)){
var statearr_29923_31799 = state_29919__$1;
(statearr_29923_31799[(1)] = (6));

} else {
var statearr_29924_31800 = state_29919__$1;
(statearr_29924_31800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (15))){
var inst_29905 = (state_29919[(9)]);
var inst_29910 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_29905);
var state_29919__$1 = state_29919;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29919__$1,(17),out,inst_29910);
} else {
if((state_val_29920 === (13))){
var inst_29905 = (state_29919[(9)]);
var inst_29905__$1 = (state_29919[(2)]);
var inst_29906 = cljs.core.some(cljs.core.nil_QMARK_,inst_29905__$1);
var state_29919__$1 = (function (){var statearr_29925 = state_29919;
(statearr_29925[(9)] = inst_29905__$1);

return statearr_29925;
})();
if(cljs.core.truth_(inst_29906)){
var statearr_29926_31801 = state_29919__$1;
(statearr_29926_31801[(1)] = (14));

} else {
var statearr_29927_31802 = state_29919__$1;
(statearr_29927_31802[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (6))){
var state_29919__$1 = state_29919;
var statearr_29928_31803 = state_29919__$1;
(statearr_29928_31803[(2)] = null);

(statearr_29928_31803[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (17))){
var inst_29912 = (state_29919[(2)]);
var state_29919__$1 = (function (){var statearr_29930 = state_29919;
(statearr_29930[(10)] = inst_29912);

return statearr_29930;
})();
var statearr_29931_31804 = state_29919__$1;
(statearr_29931_31804[(2)] = null);

(statearr_29931_31804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (3))){
var inst_29917 = (state_29919[(2)]);
var state_29919__$1 = state_29919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29919__$1,inst_29917);
} else {
if((state_val_29920 === (12))){
var _ = (function (){var statearr_29932 = state_29919;
(statearr_29932[(4)] = cljs.core.rest((state_29919[(4)])));

return statearr_29932;
})();
var state_29919__$1 = state_29919;
var ex29929 = (state_29919__$1[(2)]);
var statearr_29933_31805 = state_29919__$1;
(statearr_29933_31805[(5)] = ex29929);


if((ex29929 instanceof Object)){
var statearr_29934_31806 = state_29919__$1;
(statearr_29934_31806[(1)] = (11));

(statearr_29934_31806[(5)] = null);

} else {
throw ex29929;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (2))){
var inst_29875 = cljs.core.reset_BANG_(dctr,cnt);
var inst_29876 = cnt;
var inst_29877 = (0);
var state_29919__$1 = (function (){var statearr_29937 = state_29919;
(statearr_29937[(7)] = inst_29876);

(statearr_29937[(11)] = inst_29875);

(statearr_29937[(8)] = inst_29877);

return statearr_29937;
})();
var statearr_29938_31807 = state_29919__$1;
(statearr_29938_31807[(2)] = null);

(statearr_29938_31807[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (11))){
var inst_29884 = (state_29919[(2)]);
var inst_29885 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_29919__$1 = (function (){var statearr_29939 = state_29919;
(statearr_29939[(12)] = inst_29884);

return statearr_29939;
})();
var statearr_29940_31808 = state_29919__$1;
(statearr_29940_31808[(2)] = inst_29885);

(statearr_29940_31808[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (9))){
var inst_29877 = (state_29919[(8)]);
var _ = (function (){var statearr_29941 = state_29919;
(statearr_29941[(4)] = cljs.core.cons((12),(state_29919[(4)])));

return statearr_29941;
})();
var inst_29891 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_29877) : chs__$1.call(null,inst_29877));
var inst_29892 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_29877) : done.call(null,inst_29877));
var inst_29893 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_29891,inst_29892);
var ___$1 = (function (){var statearr_29942 = state_29919;
(statearr_29942[(4)] = cljs.core.rest((state_29919[(4)])));

return statearr_29942;
})();
var state_29919__$1 = state_29919;
var statearr_29943_31809 = state_29919__$1;
(statearr_29943_31809[(2)] = inst_29893);

(statearr_29943_31809[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (5))){
var inst_29903 = (state_29919[(2)]);
var state_29919__$1 = (function (){var statearr_29945 = state_29919;
(statearr_29945[(13)] = inst_29903);

return statearr_29945;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29919__$1,(13),dchan);
} else {
if((state_val_29920 === (14))){
var inst_29908 = cljs.core.async.close_BANG_(out);
var state_29919__$1 = state_29919;
var statearr_29946_31810 = state_29919__$1;
(statearr_29946_31810[(2)] = inst_29908);

(statearr_29946_31810[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (16))){
var inst_29915 = (state_29919[(2)]);
var state_29919__$1 = state_29919;
var statearr_29947_31811 = state_29919__$1;
(statearr_29947_31811[(2)] = inst_29915);

(statearr_29947_31811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (10))){
var inst_29877 = (state_29919[(8)]);
var inst_29896 = (state_29919[(2)]);
var inst_29897 = (inst_29877 + (1));
var inst_29877__$1 = inst_29897;
var state_29919__$1 = (function (){var statearr_29948 = state_29919;
(statearr_29948[(14)] = inst_29896);

(statearr_29948[(8)] = inst_29877__$1);

return statearr_29948;
})();
var statearr_29949_31812 = state_29919__$1;
(statearr_29949_31812[(2)] = null);

(statearr_29949_31812[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29920 === (8))){
var inst_29901 = (state_29919[(2)]);
var state_29919__$1 = state_29919;
var statearr_29950_31813 = state_29919__$1;
(statearr_29950_31813[(2)] = inst_29901);

(statearr_29950_31813[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_29951 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29951[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_29951[(1)] = (1));

return statearr_29951;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_29919){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_29919);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e29952){var ex__28256__auto__ = e29952;
var statearr_29953_31814 = state_29919;
(statearr_29953_31814[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_29919[(4)]))){
var statearr_29954_31815 = state_29919;
(statearr_29954_31815[(1)] = cljs.core.first((state_29919[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31816 = state_29919;
state_29919 = G__31816;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_29919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_29919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_29955 = f__28310__auto__();
(statearr_29955[(6)] = c__28309__auto___31795);

return statearr_29955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29961 = arguments.length;
switch (G__29961) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28309__auto___31818 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30001){
var state_val_30002 = (state_30001[(1)]);
if((state_val_30002 === (7))){
var inst_29976 = (state_30001[(7)]);
var inst_29977 = (state_30001[(8)]);
var inst_29976__$1 = (state_30001[(2)]);
var inst_29977__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29976__$1,(0),null);
var inst_29978 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29976__$1,(1),null);
var inst_29979 = (inst_29977__$1 == null);
var state_30001__$1 = (function (){var statearr_30004 = state_30001;
(statearr_30004[(7)] = inst_29976__$1);

(statearr_30004[(9)] = inst_29978);

(statearr_30004[(8)] = inst_29977__$1);

return statearr_30004;
})();
if(cljs.core.truth_(inst_29979)){
var statearr_30006_31819 = state_30001__$1;
(statearr_30006_31819[(1)] = (8));

} else {
var statearr_30007_31820 = state_30001__$1;
(statearr_30007_31820[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30002 === (1))){
var inst_29966 = cljs.core.vec(chs);
var inst_29967 = inst_29966;
var state_30001__$1 = (function (){var statearr_30008 = state_30001;
(statearr_30008[(10)] = inst_29967);

return statearr_30008;
})();
var statearr_30009_31821 = state_30001__$1;
(statearr_30009_31821[(2)] = null);

(statearr_30009_31821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30002 === (4))){
var inst_29967 = (state_30001[(10)]);
var state_30001__$1 = state_30001;
return cljs.core.async.ioc_alts_BANG_(state_30001__$1,(7),inst_29967);
} else {
if((state_val_30002 === (6))){
var inst_29997 = (state_30001[(2)]);
var state_30001__$1 = state_30001;
var statearr_30010_31822 = state_30001__$1;
(statearr_30010_31822[(2)] = inst_29997);

(statearr_30010_31822[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30002 === (3))){
var inst_29999 = (state_30001[(2)]);
var state_30001__$1 = state_30001;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30001__$1,inst_29999);
} else {
if((state_val_30002 === (2))){
var inst_29967 = (state_30001[(10)]);
var inst_29969 = cljs.core.count(inst_29967);
var inst_29970 = (inst_29969 > (0));
var state_30001__$1 = state_30001;
if(cljs.core.truth_(inst_29970)){
var statearr_30016_31823 = state_30001__$1;
(statearr_30016_31823[(1)] = (4));

} else {
var statearr_30018_31824 = state_30001__$1;
(statearr_30018_31824[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30002 === (11))){
var inst_29967 = (state_30001[(10)]);
var inst_29986 = (state_30001[(2)]);
var tmp30015 = inst_29967;
var inst_29967__$1 = tmp30015;
var state_30001__$1 = (function (){var statearr_30019 = state_30001;
(statearr_30019[(11)] = inst_29986);

(statearr_30019[(10)] = inst_29967__$1);

return statearr_30019;
})();
var statearr_30020_31825 = state_30001__$1;
(statearr_30020_31825[(2)] = null);

(statearr_30020_31825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30002 === (9))){
var inst_29977 = (state_30001[(8)]);
var state_30001__$1 = state_30001;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30001__$1,(11),out,inst_29977);
} else {
if((state_val_30002 === (5))){
var inst_29995 = cljs.core.async.close_BANG_(out);
var state_30001__$1 = state_30001;
var statearr_30021_31826 = state_30001__$1;
(statearr_30021_31826[(2)] = inst_29995);

(statearr_30021_31826[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30002 === (10))){
var inst_29993 = (state_30001[(2)]);
var state_30001__$1 = state_30001;
var statearr_30022_31827 = state_30001__$1;
(statearr_30022_31827[(2)] = inst_29993);

(statearr_30022_31827[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30002 === (8))){
var inst_29976 = (state_30001[(7)]);
var inst_29978 = (state_30001[(9)]);
var inst_29977 = (state_30001[(8)]);
var inst_29967 = (state_30001[(10)]);
var inst_29981 = (function (){var cs = inst_29967;
var vec__29972 = inst_29976;
var v = inst_29977;
var c = inst_29978;
return (function (p1__29956_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__29956_SHARP_);
});
})();
var inst_29982 = cljs.core.filterv(inst_29981,inst_29967);
var inst_29967__$1 = inst_29982;
var state_30001__$1 = (function (){var statearr_30023 = state_30001;
(statearr_30023[(10)] = inst_29967__$1);

return statearr_30023;
})();
var statearr_30024_31828 = state_30001__$1;
(statearr_30024_31828[(2)] = null);

(statearr_30024_31828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_30025 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30025[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_30025[(1)] = (1));

return statearr_30025;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_30001){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30001);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30026){var ex__28256__auto__ = e30026;
var statearr_30027_31829 = state_30001;
(statearr_30027_31829[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30001[(4)]))){
var statearr_30028_31830 = state_30001;
(statearr_30028_31830[(1)] = cljs.core.first((state_30001[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31831 = state_30001;
state_30001 = G__31831;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_30001){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_30001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30029 = f__28310__auto__();
(statearr_30029[(6)] = c__28309__auto___31818);

return statearr_30029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__30032 = arguments.length;
switch (G__30032) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28309__auto___31833 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30061){
var state_val_30062 = (state_30061[(1)]);
if((state_val_30062 === (7))){
var inst_30041 = (state_30061[(7)]);
var inst_30041__$1 = (state_30061[(2)]);
var inst_30044 = (inst_30041__$1 == null);
var inst_30045 = cljs.core.not(inst_30044);
var state_30061__$1 = (function (){var statearr_30063 = state_30061;
(statearr_30063[(7)] = inst_30041__$1);

return statearr_30063;
})();
if(inst_30045){
var statearr_30064_31834 = state_30061__$1;
(statearr_30064_31834[(1)] = (8));

} else {
var statearr_30065_31835 = state_30061__$1;
(statearr_30065_31835[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (1))){
var inst_30036 = (0);
var state_30061__$1 = (function (){var statearr_30066 = state_30061;
(statearr_30066[(8)] = inst_30036);

return statearr_30066;
})();
var statearr_30067_31836 = state_30061__$1;
(statearr_30067_31836[(2)] = null);

(statearr_30067_31836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (4))){
var state_30061__$1 = state_30061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30061__$1,(7),ch);
} else {
if((state_val_30062 === (6))){
var inst_30056 = (state_30061[(2)]);
var state_30061__$1 = state_30061;
var statearr_30068_31837 = state_30061__$1;
(statearr_30068_31837[(2)] = inst_30056);

(statearr_30068_31837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (3))){
var inst_30058 = (state_30061[(2)]);
var inst_30059 = cljs.core.async.close_BANG_(out);
var state_30061__$1 = (function (){var statearr_30069 = state_30061;
(statearr_30069[(9)] = inst_30058);

return statearr_30069;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30061__$1,inst_30059);
} else {
if((state_val_30062 === (2))){
var inst_30036 = (state_30061[(8)]);
var inst_30038 = (inst_30036 < n);
var state_30061__$1 = state_30061;
if(cljs.core.truth_(inst_30038)){
var statearr_30070_31838 = state_30061__$1;
(statearr_30070_31838[(1)] = (4));

} else {
var statearr_30071_31839 = state_30061__$1;
(statearr_30071_31839[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (11))){
var inst_30036 = (state_30061[(8)]);
var inst_30048 = (state_30061[(2)]);
var inst_30049 = (inst_30036 + (1));
var inst_30036__$1 = inst_30049;
var state_30061__$1 = (function (){var statearr_30072 = state_30061;
(statearr_30072[(8)] = inst_30036__$1);

(statearr_30072[(10)] = inst_30048);

return statearr_30072;
})();
var statearr_30073_31840 = state_30061__$1;
(statearr_30073_31840[(2)] = null);

(statearr_30073_31840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (9))){
var state_30061__$1 = state_30061;
var statearr_30074_31841 = state_30061__$1;
(statearr_30074_31841[(2)] = null);

(statearr_30074_31841[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (5))){
var state_30061__$1 = state_30061;
var statearr_30075_31842 = state_30061__$1;
(statearr_30075_31842[(2)] = null);

(statearr_30075_31842[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (10))){
var inst_30053 = (state_30061[(2)]);
var state_30061__$1 = state_30061;
var statearr_30076_31843 = state_30061__$1;
(statearr_30076_31843[(2)] = inst_30053);

(statearr_30076_31843[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30062 === (8))){
var inst_30041 = (state_30061[(7)]);
var state_30061__$1 = state_30061;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30061__$1,(11),out,inst_30041);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_30080 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30080[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_30080[(1)] = (1));

return statearr_30080;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_30061){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30061);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30081){var ex__28256__auto__ = e30081;
var statearr_30082_31844 = state_30061;
(statearr_30082_31844[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30061[(4)]))){
var statearr_30083_31845 = state_30061;
(statearr_30083_31845[(1)] = cljs.core.first((state_30061[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31846 = state_30061;
state_30061 = G__31846;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_30061){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_30061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30087 = f__28310__auto__();
(statearr_30087[(6)] = c__28309__auto___31833);

return statearr_30087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30089 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30089 = (function (f,ch,meta30090){
this.f = f;
this.ch = ch;
this.meta30090 = meta30090;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30091,meta30090__$1){
var self__ = this;
var _30091__$1 = this;
return (new cljs.core.async.t_cljs$core$async30089(self__.f,self__.ch,meta30090__$1));
}));

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30091){
var self__ = this;
var _30091__$1 = this;
return self__.meta30090;
}));

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30098 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30098 = (function (f,ch,meta30090,_,fn1,meta30099){
this.f = f;
this.ch = ch;
this.meta30090 = meta30090;
this._ = _;
this.fn1 = fn1;
this.meta30099 = meta30099;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30098.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30100,meta30099__$1){
var self__ = this;
var _30100__$1 = this;
return (new cljs.core.async.t_cljs$core$async30098(self__.f,self__.ch,self__.meta30090,self__._,self__.fn1,meta30099__$1));
}));

(cljs.core.async.t_cljs$core$async30098.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30100){
var self__ = this;
var _30100__$1 = this;
return self__.meta30099;
}));

(cljs.core.async.t_cljs$core$async30098.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30098.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30098.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30098.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__30088_SHARP_){
var G__30101 = (((p1__30088_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30088_SHARP_) : self__.f.call(null,p1__30088_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30101) : f1.call(null,G__30101));
});
}));

(cljs.core.async.t_cljs$core$async30098.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30090","meta30090",1644630031,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30089","cljs.core.async/t_cljs$core$async30089",2011609315,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30099","meta30099",-1580717184,null)], null);
}));

(cljs.core.async.t_cljs$core$async30098.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30098.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30098");

(cljs.core.async.t_cljs$core$async30098.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30098");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30098.
 */
cljs.core.async.__GT_t_cljs$core$async30098 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30098(f__$1,ch__$1,meta30090__$1,___$2,fn1__$1,meta30099){
return (new cljs.core.async.t_cljs$core$async30098(f__$1,ch__$1,meta30090__$1,___$2,fn1__$1,meta30099));
});

}

return (new cljs.core.async.t_cljs$core$async30098(self__.f,self__.ch,self__.meta30090,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30106 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30106) : self__.f.call(null,G__30106));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30089.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30089.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30090","meta30090",1644630031,null)], null);
}));

(cljs.core.async.t_cljs$core$async30089.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30089.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30089");

(cljs.core.async.t_cljs$core$async30089.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30089");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30089.
 */
cljs.core.async.__GT_t_cljs$core$async30089 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30089(f__$1,ch__$1,meta30090){
return (new cljs.core.async.t_cljs$core$async30089(f__$1,ch__$1,meta30090));
});

}

return (new cljs.core.async.t_cljs$core$async30089(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30107 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30107 = (function (f,ch,meta30108){
this.f = f;
this.ch = ch;
this.meta30108 = meta30108;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30109,meta30108__$1){
var self__ = this;
var _30109__$1 = this;
return (new cljs.core.async.t_cljs$core$async30107(self__.f,self__.ch,meta30108__$1));
}));

(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30109){
var self__ = this;
var _30109__$1 = this;
return self__.meta30108;
}));

(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30107.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30107.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30108","meta30108",391656225,null)], null);
}));

(cljs.core.async.t_cljs$core$async30107.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30107.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30107");

(cljs.core.async.t_cljs$core$async30107.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30107");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30107.
 */
cljs.core.async.__GT_t_cljs$core$async30107 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30107(f__$1,ch__$1,meta30108){
return (new cljs.core.async.t_cljs$core$async30107(f__$1,ch__$1,meta30108));
});

}

return (new cljs.core.async.t_cljs$core$async30107(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30114 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30114 = (function (p,ch,meta30115){
this.p = p;
this.ch = ch;
this.meta30115 = meta30115;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30116,meta30115__$1){
var self__ = this;
var _30116__$1 = this;
return (new cljs.core.async.t_cljs$core$async30114(self__.p,self__.ch,meta30115__$1));
}));

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30116){
var self__ = this;
var _30116__$1 = this;
return self__.meta30115;
}));

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30114.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30114.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30115","meta30115",282928346,null)], null);
}));

(cljs.core.async.t_cljs$core$async30114.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30114.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30114");

(cljs.core.async.t_cljs$core$async30114.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30114");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30114.
 */
cljs.core.async.__GT_t_cljs$core$async30114 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30114(p__$1,ch__$1,meta30115){
return (new cljs.core.async.t_cljs$core$async30114(p__$1,ch__$1,meta30115));
});

}

return (new cljs.core.async.t_cljs$core$async30114(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30118 = arguments.length;
switch (G__30118) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28309__auto___31848 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30139){
var state_val_30140 = (state_30139[(1)]);
if((state_val_30140 === (7))){
var inst_30135 = (state_30139[(2)]);
var state_30139__$1 = state_30139;
var statearr_30141_31849 = state_30139__$1;
(statearr_30141_31849[(2)] = inst_30135);

(statearr_30141_31849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (1))){
var state_30139__$1 = state_30139;
var statearr_30142_31850 = state_30139__$1;
(statearr_30142_31850[(2)] = null);

(statearr_30142_31850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (4))){
var inst_30121 = (state_30139[(7)]);
var inst_30121__$1 = (state_30139[(2)]);
var inst_30122 = (inst_30121__$1 == null);
var state_30139__$1 = (function (){var statearr_30143 = state_30139;
(statearr_30143[(7)] = inst_30121__$1);

return statearr_30143;
})();
if(cljs.core.truth_(inst_30122)){
var statearr_30144_31851 = state_30139__$1;
(statearr_30144_31851[(1)] = (5));

} else {
var statearr_30145_31852 = state_30139__$1;
(statearr_30145_31852[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (6))){
var inst_30121 = (state_30139[(7)]);
var inst_30126 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30121) : p.call(null,inst_30121));
var state_30139__$1 = state_30139;
if(cljs.core.truth_(inst_30126)){
var statearr_30146_31853 = state_30139__$1;
(statearr_30146_31853[(1)] = (8));

} else {
var statearr_30147_31854 = state_30139__$1;
(statearr_30147_31854[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (3))){
var inst_30137 = (state_30139[(2)]);
var state_30139__$1 = state_30139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30139__$1,inst_30137);
} else {
if((state_val_30140 === (2))){
var state_30139__$1 = state_30139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30139__$1,(4),ch);
} else {
if((state_val_30140 === (11))){
var inst_30129 = (state_30139[(2)]);
var state_30139__$1 = state_30139;
var statearr_30148_31855 = state_30139__$1;
(statearr_30148_31855[(2)] = inst_30129);

(statearr_30148_31855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (9))){
var state_30139__$1 = state_30139;
var statearr_30149_31856 = state_30139__$1;
(statearr_30149_31856[(2)] = null);

(statearr_30149_31856[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (5))){
var inst_30124 = cljs.core.async.close_BANG_(out);
var state_30139__$1 = state_30139;
var statearr_30150_31857 = state_30139__$1;
(statearr_30150_31857[(2)] = inst_30124);

(statearr_30150_31857[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (10))){
var inst_30132 = (state_30139[(2)]);
var state_30139__$1 = (function (){var statearr_30151 = state_30139;
(statearr_30151[(8)] = inst_30132);

return statearr_30151;
})();
var statearr_30152_31858 = state_30139__$1;
(statearr_30152_31858[(2)] = null);

(statearr_30152_31858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30140 === (8))){
var inst_30121 = (state_30139[(7)]);
var state_30139__$1 = state_30139;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30139__$1,(11),out,inst_30121);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_30153 = [null,null,null,null,null,null,null,null,null];
(statearr_30153[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_30153[(1)] = (1));

return statearr_30153;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_30139){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30139);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30154){var ex__28256__auto__ = e30154;
var statearr_30155_31859 = state_30139;
(statearr_30155_31859[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30139[(4)]))){
var statearr_30156_31860 = state_30139;
(statearr_30156_31860[(1)] = cljs.core.first((state_30139[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31861 = state_30139;
state_30139 = G__31861;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_30139){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_30139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30157 = f__28310__auto__();
(statearr_30157[(6)] = c__28309__auto___31848);

return statearr_30157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30161 = arguments.length;
switch (G__30161) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28309__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30228){
var state_val_30229 = (state_30228[(1)]);
if((state_val_30229 === (7))){
var inst_30224 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
var statearr_30234_31863 = state_30228__$1;
(statearr_30234_31863[(2)] = inst_30224);

(statearr_30234_31863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (20))){
var inst_30194 = (state_30228[(7)]);
var inst_30205 = (state_30228[(2)]);
var inst_30206 = cljs.core.next(inst_30194);
var inst_30180 = inst_30206;
var inst_30181 = null;
var inst_30182 = (0);
var inst_30183 = (0);
var state_30228__$1 = (function (){var statearr_30235 = state_30228;
(statearr_30235[(8)] = inst_30180);

(statearr_30235[(9)] = inst_30205);

(statearr_30235[(10)] = inst_30182);

(statearr_30235[(11)] = inst_30183);

(statearr_30235[(12)] = inst_30181);

return statearr_30235;
})();
var statearr_30236_31864 = state_30228__$1;
(statearr_30236_31864[(2)] = null);

(statearr_30236_31864[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (1))){
var state_30228__$1 = state_30228;
var statearr_30237_31865 = state_30228__$1;
(statearr_30237_31865[(2)] = null);

(statearr_30237_31865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (4))){
var inst_30169 = (state_30228[(13)]);
var inst_30169__$1 = (state_30228[(2)]);
var inst_30170 = (inst_30169__$1 == null);
var state_30228__$1 = (function (){var statearr_30238 = state_30228;
(statearr_30238[(13)] = inst_30169__$1);

return statearr_30238;
})();
if(cljs.core.truth_(inst_30170)){
var statearr_30239_31866 = state_30228__$1;
(statearr_30239_31866[(1)] = (5));

} else {
var statearr_30240_31867 = state_30228__$1;
(statearr_30240_31867[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (15))){
var state_30228__$1 = state_30228;
var statearr_30244_31868 = state_30228__$1;
(statearr_30244_31868[(2)] = null);

(statearr_30244_31868[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (21))){
var state_30228__$1 = state_30228;
var statearr_30245_31869 = state_30228__$1;
(statearr_30245_31869[(2)] = null);

(statearr_30245_31869[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (13))){
var inst_30180 = (state_30228[(8)]);
var inst_30182 = (state_30228[(10)]);
var inst_30183 = (state_30228[(11)]);
var inst_30181 = (state_30228[(12)]);
var inst_30190 = (state_30228[(2)]);
var inst_30191 = (inst_30183 + (1));
var tmp30241 = inst_30180;
var tmp30242 = inst_30182;
var tmp30243 = inst_30181;
var inst_30180__$1 = tmp30241;
var inst_30181__$1 = tmp30243;
var inst_30182__$1 = tmp30242;
var inst_30183__$1 = inst_30191;
var state_30228__$1 = (function (){var statearr_30247 = state_30228;
(statearr_30247[(14)] = inst_30190);

(statearr_30247[(8)] = inst_30180__$1);

(statearr_30247[(10)] = inst_30182__$1);

(statearr_30247[(11)] = inst_30183__$1);

(statearr_30247[(12)] = inst_30181__$1);

return statearr_30247;
})();
var statearr_30248_31870 = state_30228__$1;
(statearr_30248_31870[(2)] = null);

(statearr_30248_31870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (22))){
var state_30228__$1 = state_30228;
var statearr_30249_31871 = state_30228__$1;
(statearr_30249_31871[(2)] = null);

(statearr_30249_31871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (6))){
var inst_30169 = (state_30228[(13)]);
var inst_30178 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30169) : f.call(null,inst_30169));
var inst_30179 = cljs.core.seq(inst_30178);
var inst_30180 = inst_30179;
var inst_30181 = null;
var inst_30182 = (0);
var inst_30183 = (0);
var state_30228__$1 = (function (){var statearr_30250 = state_30228;
(statearr_30250[(8)] = inst_30180);

(statearr_30250[(10)] = inst_30182);

(statearr_30250[(11)] = inst_30183);

(statearr_30250[(12)] = inst_30181);

return statearr_30250;
})();
var statearr_30251_31872 = state_30228__$1;
(statearr_30251_31872[(2)] = null);

(statearr_30251_31872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (17))){
var inst_30194 = (state_30228[(7)]);
var inst_30198 = cljs.core.chunk_first(inst_30194);
var inst_30199 = cljs.core.chunk_rest(inst_30194);
var inst_30200 = cljs.core.count(inst_30198);
var inst_30180 = inst_30199;
var inst_30181 = inst_30198;
var inst_30182 = inst_30200;
var inst_30183 = (0);
var state_30228__$1 = (function (){var statearr_30252 = state_30228;
(statearr_30252[(8)] = inst_30180);

(statearr_30252[(10)] = inst_30182);

(statearr_30252[(11)] = inst_30183);

(statearr_30252[(12)] = inst_30181);

return statearr_30252;
})();
var statearr_30253_31873 = state_30228__$1;
(statearr_30253_31873[(2)] = null);

(statearr_30253_31873[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (3))){
var inst_30226 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30228__$1,inst_30226);
} else {
if((state_val_30229 === (12))){
var inst_30214 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
var statearr_30254_31874 = state_30228__$1;
(statearr_30254_31874[(2)] = inst_30214);

(statearr_30254_31874[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (2))){
var state_30228__$1 = state_30228;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30228__$1,(4),in$);
} else {
if((state_val_30229 === (23))){
var inst_30222 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
var statearr_30255_31875 = state_30228__$1;
(statearr_30255_31875[(2)] = inst_30222);

(statearr_30255_31875[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (19))){
var inst_30209 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
var statearr_30256_31876 = state_30228__$1;
(statearr_30256_31876[(2)] = inst_30209);

(statearr_30256_31876[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (11))){
var inst_30180 = (state_30228[(8)]);
var inst_30194 = (state_30228[(7)]);
var inst_30194__$1 = cljs.core.seq(inst_30180);
var state_30228__$1 = (function (){var statearr_30257 = state_30228;
(statearr_30257[(7)] = inst_30194__$1);

return statearr_30257;
})();
if(inst_30194__$1){
var statearr_30258_31877 = state_30228__$1;
(statearr_30258_31877[(1)] = (14));

} else {
var statearr_30259_31878 = state_30228__$1;
(statearr_30259_31878[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (9))){
var inst_30216 = (state_30228[(2)]);
var inst_30217 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30228__$1 = (function (){var statearr_30260 = state_30228;
(statearr_30260[(15)] = inst_30216);

return statearr_30260;
})();
if(cljs.core.truth_(inst_30217)){
var statearr_30261_31879 = state_30228__$1;
(statearr_30261_31879[(1)] = (21));

} else {
var statearr_30262_31880 = state_30228__$1;
(statearr_30262_31880[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (5))){
var inst_30172 = cljs.core.async.close_BANG_(out);
var state_30228__$1 = state_30228;
var statearr_30263_31881 = state_30228__$1;
(statearr_30263_31881[(2)] = inst_30172);

(statearr_30263_31881[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (14))){
var inst_30194 = (state_30228[(7)]);
var inst_30196 = cljs.core.chunked_seq_QMARK_(inst_30194);
var state_30228__$1 = state_30228;
if(inst_30196){
var statearr_30264_31882 = state_30228__$1;
(statearr_30264_31882[(1)] = (17));

} else {
var statearr_30265_31883 = state_30228__$1;
(statearr_30265_31883[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (16))){
var inst_30212 = (state_30228[(2)]);
var state_30228__$1 = state_30228;
var statearr_30266_31884 = state_30228__$1;
(statearr_30266_31884[(2)] = inst_30212);

(statearr_30266_31884[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30229 === (10))){
var inst_30183 = (state_30228[(11)]);
var inst_30181 = (state_30228[(12)]);
var inst_30188 = cljs.core._nth(inst_30181,inst_30183);
var state_30228__$1 = state_30228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30228__$1,(13),out,inst_30188);
} else {
if((state_val_30229 === (18))){
var inst_30194 = (state_30228[(7)]);
var inst_30203 = cljs.core.first(inst_30194);
var state_30228__$1 = state_30228;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30228__$1,(20),out,inst_30203);
} else {
if((state_val_30229 === (8))){
var inst_30182 = (state_30228[(10)]);
var inst_30183 = (state_30228[(11)]);
var inst_30185 = (inst_30183 < inst_30182);
var inst_30186 = inst_30185;
var state_30228__$1 = state_30228;
if(cljs.core.truth_(inst_30186)){
var statearr_30267_31885 = state_30228__$1;
(statearr_30267_31885[(1)] = (10));

} else {
var statearr_30268_31886 = state_30228__$1;
(statearr_30268_31886[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28253__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28253__auto____0 = (function (){
var statearr_30269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30269[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28253__auto__);

(statearr_30269[(1)] = (1));

return statearr_30269;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28253__auto____1 = (function (state_30228){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30228);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30274){var ex__28256__auto__ = e30274;
var statearr_30275_31887 = state_30228;
(statearr_30275_31887[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30228[(4)]))){
var statearr_30276_31888 = state_30228;
(statearr_30276_31888[(1)] = cljs.core.first((state_30228[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31889 = state_30228;
state_30228 = G__31889;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28253__auto__ = function(state_30228){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28253__auto____1.call(this,state_30228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28253__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28253__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30277 = f__28310__auto__();
(statearr_30277[(6)] = c__28309__auto__);

return statearr_30277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));

return c__28309__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30279 = arguments.length;
switch (G__30279) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30281 = arguments.length;
switch (G__30281) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30284 = arguments.length;
switch (G__30284) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28309__auto___31893 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30308){
var state_val_30309 = (state_30308[(1)]);
if((state_val_30309 === (7))){
var inst_30303 = (state_30308[(2)]);
var state_30308__$1 = state_30308;
var statearr_30310_31894 = state_30308__$1;
(statearr_30310_31894[(2)] = inst_30303);

(statearr_30310_31894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30309 === (1))){
var inst_30285 = null;
var state_30308__$1 = (function (){var statearr_30311 = state_30308;
(statearr_30311[(7)] = inst_30285);

return statearr_30311;
})();
var statearr_30312_31895 = state_30308__$1;
(statearr_30312_31895[(2)] = null);

(statearr_30312_31895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30309 === (4))){
var inst_30288 = (state_30308[(8)]);
var inst_30288__$1 = (state_30308[(2)]);
var inst_30289 = (inst_30288__$1 == null);
var inst_30290 = cljs.core.not(inst_30289);
var state_30308__$1 = (function (){var statearr_30313 = state_30308;
(statearr_30313[(8)] = inst_30288__$1);

return statearr_30313;
})();
if(inst_30290){
var statearr_30314_31896 = state_30308__$1;
(statearr_30314_31896[(1)] = (5));

} else {
var statearr_30315_31897 = state_30308__$1;
(statearr_30315_31897[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30309 === (6))){
var state_30308__$1 = state_30308;
var statearr_30316_31898 = state_30308__$1;
(statearr_30316_31898[(2)] = null);

(statearr_30316_31898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30309 === (3))){
var inst_30305 = (state_30308[(2)]);
var inst_30306 = cljs.core.async.close_BANG_(out);
var state_30308__$1 = (function (){var statearr_30317 = state_30308;
(statearr_30317[(9)] = inst_30305);

return statearr_30317;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30308__$1,inst_30306);
} else {
if((state_val_30309 === (2))){
var state_30308__$1 = state_30308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30308__$1,(4),ch);
} else {
if((state_val_30309 === (11))){
var inst_30288 = (state_30308[(8)]);
var inst_30297 = (state_30308[(2)]);
var inst_30285 = inst_30288;
var state_30308__$1 = (function (){var statearr_30318 = state_30308;
(statearr_30318[(7)] = inst_30285);

(statearr_30318[(10)] = inst_30297);

return statearr_30318;
})();
var statearr_30319_31899 = state_30308__$1;
(statearr_30319_31899[(2)] = null);

(statearr_30319_31899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30309 === (9))){
var inst_30288 = (state_30308[(8)]);
var state_30308__$1 = state_30308;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30308__$1,(11),out,inst_30288);
} else {
if((state_val_30309 === (5))){
var inst_30285 = (state_30308[(7)]);
var inst_30288 = (state_30308[(8)]);
var inst_30292 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30288,inst_30285);
var state_30308__$1 = state_30308;
if(inst_30292){
var statearr_30321_31900 = state_30308__$1;
(statearr_30321_31900[(1)] = (8));

} else {
var statearr_30322_31901 = state_30308__$1;
(statearr_30322_31901[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30309 === (10))){
var inst_30300 = (state_30308[(2)]);
var state_30308__$1 = state_30308;
var statearr_30323_31902 = state_30308__$1;
(statearr_30323_31902[(2)] = inst_30300);

(statearr_30323_31902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30309 === (8))){
var inst_30285 = (state_30308[(7)]);
var tmp30320 = inst_30285;
var inst_30285__$1 = tmp30320;
var state_30308__$1 = (function (){var statearr_30324 = state_30308;
(statearr_30324[(7)] = inst_30285__$1);

return statearr_30324;
})();
var statearr_30325_31903 = state_30308__$1;
(statearr_30325_31903[(2)] = null);

(statearr_30325_31903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_30326 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30326[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_30326[(1)] = (1));

return statearr_30326;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_30308){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30308);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30327){var ex__28256__auto__ = e30327;
var statearr_30328_31904 = state_30308;
(statearr_30328_31904[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30308[(4)]))){
var statearr_30329_31905 = state_30308;
(statearr_30329_31905[(1)] = cljs.core.first((state_30308[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31906 = state_30308;
state_30308 = G__31906;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_30308){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_30308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30330 = f__28310__auto__();
(statearr_30330[(6)] = c__28309__auto___31893);

return statearr_30330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30332 = arguments.length;
switch (G__30332) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28309__auto___31908 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30373){
var state_val_30374 = (state_30373[(1)]);
if((state_val_30374 === (7))){
var inst_30369 = (state_30373[(2)]);
var state_30373__$1 = state_30373;
var statearr_30375_31909 = state_30373__$1;
(statearr_30375_31909[(2)] = inst_30369);

(statearr_30375_31909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (1))){
var inst_30333 = (new Array(n));
var inst_30334 = inst_30333;
var inst_30335 = (0);
var state_30373__$1 = (function (){var statearr_30376 = state_30373;
(statearr_30376[(7)] = inst_30335);

(statearr_30376[(8)] = inst_30334);

return statearr_30376;
})();
var statearr_30377_31910 = state_30373__$1;
(statearr_30377_31910[(2)] = null);

(statearr_30377_31910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (4))){
var inst_30338 = (state_30373[(9)]);
var inst_30338__$1 = (state_30373[(2)]);
var inst_30339 = (inst_30338__$1 == null);
var inst_30340 = cljs.core.not(inst_30339);
var state_30373__$1 = (function (){var statearr_30378 = state_30373;
(statearr_30378[(9)] = inst_30338__$1);

return statearr_30378;
})();
if(inst_30340){
var statearr_30379_31911 = state_30373__$1;
(statearr_30379_31911[(1)] = (5));

} else {
var statearr_30380_31912 = state_30373__$1;
(statearr_30380_31912[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (15))){
var inst_30363 = (state_30373[(2)]);
var state_30373__$1 = state_30373;
var statearr_30381_31913 = state_30373__$1;
(statearr_30381_31913[(2)] = inst_30363);

(statearr_30381_31913[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (13))){
var state_30373__$1 = state_30373;
var statearr_30382_31914 = state_30373__$1;
(statearr_30382_31914[(2)] = null);

(statearr_30382_31914[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (6))){
var inst_30335 = (state_30373[(7)]);
var inst_30359 = (inst_30335 > (0));
var state_30373__$1 = state_30373;
if(cljs.core.truth_(inst_30359)){
var statearr_30383_31915 = state_30373__$1;
(statearr_30383_31915[(1)] = (12));

} else {
var statearr_30384_31916 = state_30373__$1;
(statearr_30384_31916[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (3))){
var inst_30371 = (state_30373[(2)]);
var state_30373__$1 = state_30373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30373__$1,inst_30371);
} else {
if((state_val_30374 === (12))){
var inst_30334 = (state_30373[(8)]);
var inst_30361 = cljs.core.vec(inst_30334);
var state_30373__$1 = state_30373;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30373__$1,(15),out,inst_30361);
} else {
if((state_val_30374 === (2))){
var state_30373__$1 = state_30373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30373__$1,(4),ch);
} else {
if((state_val_30374 === (11))){
var inst_30353 = (state_30373[(2)]);
var inst_30354 = (new Array(n));
var inst_30334 = inst_30354;
var inst_30335 = (0);
var state_30373__$1 = (function (){var statearr_30385 = state_30373;
(statearr_30385[(7)] = inst_30335);

(statearr_30385[(10)] = inst_30353);

(statearr_30385[(8)] = inst_30334);

return statearr_30385;
})();
var statearr_30386_31917 = state_30373__$1;
(statearr_30386_31917[(2)] = null);

(statearr_30386_31917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (9))){
var inst_30334 = (state_30373[(8)]);
var inst_30351 = cljs.core.vec(inst_30334);
var state_30373__$1 = state_30373;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30373__$1,(11),out,inst_30351);
} else {
if((state_val_30374 === (5))){
var inst_30335 = (state_30373[(7)]);
var inst_30338 = (state_30373[(9)]);
var inst_30346 = (state_30373[(11)]);
var inst_30334 = (state_30373[(8)]);
var inst_30345 = (inst_30334[inst_30335] = inst_30338);
var inst_30346__$1 = (inst_30335 + (1));
var inst_30347 = (inst_30346__$1 < n);
var state_30373__$1 = (function (){var statearr_30387 = state_30373;
(statearr_30387[(12)] = inst_30345);

(statearr_30387[(11)] = inst_30346__$1);

return statearr_30387;
})();
if(cljs.core.truth_(inst_30347)){
var statearr_30388_31918 = state_30373__$1;
(statearr_30388_31918[(1)] = (8));

} else {
var statearr_30391_31919 = state_30373__$1;
(statearr_30391_31919[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (14))){
var inst_30366 = (state_30373[(2)]);
var inst_30367 = cljs.core.async.close_BANG_(out);
var state_30373__$1 = (function (){var statearr_30393 = state_30373;
(statearr_30393[(13)] = inst_30366);

return statearr_30393;
})();
var statearr_30394_31920 = state_30373__$1;
(statearr_30394_31920[(2)] = inst_30367);

(statearr_30394_31920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (10))){
var inst_30357 = (state_30373[(2)]);
var state_30373__$1 = state_30373;
var statearr_30395_31921 = state_30373__$1;
(statearr_30395_31921[(2)] = inst_30357);

(statearr_30395_31921[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30374 === (8))){
var inst_30346 = (state_30373[(11)]);
var inst_30334 = (state_30373[(8)]);
var tmp30392 = inst_30334;
var inst_30334__$1 = tmp30392;
var inst_30335 = inst_30346;
var state_30373__$1 = (function (){var statearr_30397 = state_30373;
(statearr_30397[(7)] = inst_30335);

(statearr_30397[(8)] = inst_30334__$1);

return statearr_30397;
})();
var statearr_30398_31922 = state_30373__$1;
(statearr_30398_31922[(2)] = null);

(statearr_30398_31922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_30399 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30399[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_30399[(1)] = (1));

return statearr_30399;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_30373){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30373);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30400){var ex__28256__auto__ = e30400;
var statearr_30401_31923 = state_30373;
(statearr_30401_31923[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30373[(4)]))){
var statearr_30404_31924 = state_30373;
(statearr_30404_31924[(1)] = cljs.core.first((state_30373[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31925 = state_30373;
state_30373 = G__31925;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_30373){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_30373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30405 = f__28310__auto__();
(statearr_30405[(6)] = c__28309__auto___31908);

return statearr_30405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30410 = arguments.length;
switch (G__30410) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28309__auto___31927 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28310__auto__ = (function (){var switch__28252__auto__ = (function (state_30452){
var state_val_30453 = (state_30452[(1)]);
if((state_val_30453 === (7))){
var inst_30448 = (state_30452[(2)]);
var state_30452__$1 = state_30452;
var statearr_30454_31928 = state_30452__$1;
(statearr_30454_31928[(2)] = inst_30448);

(statearr_30454_31928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (1))){
var inst_30411 = [];
var inst_30412 = inst_30411;
var inst_30413 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30452__$1 = (function (){var statearr_30458 = state_30452;
(statearr_30458[(7)] = inst_30413);

(statearr_30458[(8)] = inst_30412);

return statearr_30458;
})();
var statearr_30460_31929 = state_30452__$1;
(statearr_30460_31929[(2)] = null);

(statearr_30460_31929[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (4))){
var inst_30416 = (state_30452[(9)]);
var inst_30416__$1 = (state_30452[(2)]);
var inst_30417 = (inst_30416__$1 == null);
var inst_30418 = cljs.core.not(inst_30417);
var state_30452__$1 = (function (){var statearr_30461 = state_30452;
(statearr_30461[(9)] = inst_30416__$1);

return statearr_30461;
})();
if(inst_30418){
var statearr_30462_31930 = state_30452__$1;
(statearr_30462_31930[(1)] = (5));

} else {
var statearr_30463_31931 = state_30452__$1;
(statearr_30463_31931[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (15))){
var inst_30442 = (state_30452[(2)]);
var state_30452__$1 = state_30452;
var statearr_30464_31932 = state_30452__$1;
(statearr_30464_31932[(2)] = inst_30442);

(statearr_30464_31932[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (13))){
var state_30452__$1 = state_30452;
var statearr_30465_31933 = state_30452__$1;
(statearr_30465_31933[(2)] = null);

(statearr_30465_31933[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (6))){
var inst_30412 = (state_30452[(8)]);
var inst_30437 = inst_30412.length;
var inst_30438 = (inst_30437 > (0));
var state_30452__$1 = state_30452;
if(cljs.core.truth_(inst_30438)){
var statearr_30466_31934 = state_30452__$1;
(statearr_30466_31934[(1)] = (12));

} else {
var statearr_30467_31935 = state_30452__$1;
(statearr_30467_31935[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (3))){
var inst_30450 = (state_30452[(2)]);
var state_30452__$1 = state_30452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30452__$1,inst_30450);
} else {
if((state_val_30453 === (12))){
var inst_30412 = (state_30452[(8)]);
var inst_30440 = cljs.core.vec(inst_30412);
var state_30452__$1 = state_30452;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30452__$1,(15),out,inst_30440);
} else {
if((state_val_30453 === (2))){
var state_30452__$1 = state_30452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30452__$1,(4),ch);
} else {
if((state_val_30453 === (11))){
var inst_30416 = (state_30452[(9)]);
var inst_30420 = (state_30452[(10)]);
var inst_30430 = (state_30452[(2)]);
var inst_30431 = [];
var inst_30432 = inst_30431.push(inst_30416);
var inst_30412 = inst_30431;
var inst_30413 = inst_30420;
var state_30452__$1 = (function (){var statearr_30468 = state_30452;
(statearr_30468[(7)] = inst_30413);

(statearr_30468[(11)] = inst_30430);

(statearr_30468[(12)] = inst_30432);

(statearr_30468[(8)] = inst_30412);

return statearr_30468;
})();
var statearr_30469_31936 = state_30452__$1;
(statearr_30469_31936[(2)] = null);

(statearr_30469_31936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (9))){
var inst_30412 = (state_30452[(8)]);
var inst_30428 = cljs.core.vec(inst_30412);
var state_30452__$1 = state_30452;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30452__$1,(11),out,inst_30428);
} else {
if((state_val_30453 === (5))){
var inst_30416 = (state_30452[(9)]);
var inst_30420 = (state_30452[(10)]);
var inst_30413 = (state_30452[(7)]);
var inst_30420__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30416) : f.call(null,inst_30416));
var inst_30421 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30420__$1,inst_30413);
var inst_30422 = cljs.core.keyword_identical_QMARK_(inst_30413,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30423 = ((inst_30421) || (inst_30422));
var state_30452__$1 = (function (){var statearr_30470 = state_30452;
(statearr_30470[(10)] = inst_30420__$1);

return statearr_30470;
})();
if(cljs.core.truth_(inst_30423)){
var statearr_30471_31937 = state_30452__$1;
(statearr_30471_31937[(1)] = (8));

} else {
var statearr_30472_31938 = state_30452__$1;
(statearr_30472_31938[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (14))){
var inst_30445 = (state_30452[(2)]);
var inst_30446 = cljs.core.async.close_BANG_(out);
var state_30452__$1 = (function (){var statearr_30474 = state_30452;
(statearr_30474[(13)] = inst_30445);

return statearr_30474;
})();
var statearr_30475_31939 = state_30452__$1;
(statearr_30475_31939[(2)] = inst_30446);

(statearr_30475_31939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (10))){
var inst_30435 = (state_30452[(2)]);
var state_30452__$1 = state_30452;
var statearr_30476_31940 = state_30452__$1;
(statearr_30476_31940[(2)] = inst_30435);

(statearr_30476_31940[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30453 === (8))){
var inst_30416 = (state_30452[(9)]);
var inst_30420 = (state_30452[(10)]);
var inst_30412 = (state_30452[(8)]);
var inst_30425 = inst_30412.push(inst_30416);
var tmp30473 = inst_30412;
var inst_30412__$1 = tmp30473;
var inst_30413 = inst_30420;
var state_30452__$1 = (function (){var statearr_30477 = state_30452;
(statearr_30477[(7)] = inst_30413);

(statearr_30477[(14)] = inst_30425);

(statearr_30477[(8)] = inst_30412__$1);

return statearr_30477;
})();
var statearr_30478_31941 = state_30452__$1;
(statearr_30478_31941[(2)] = null);

(statearr_30478_31941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28253__auto__ = null;
var cljs$core$async$state_machine__28253__auto____0 = (function (){
var statearr_30479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30479[(0)] = cljs$core$async$state_machine__28253__auto__);

(statearr_30479[(1)] = (1));

return statearr_30479;
});
var cljs$core$async$state_machine__28253__auto____1 = (function (state_30452){
while(true){
var ret_value__28254__auto__ = (function (){try{while(true){
var result__28255__auto__ = switch__28252__auto__(state_30452);
if(cljs.core.keyword_identical_QMARK_(result__28255__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28255__auto__;
}
break;
}
}catch (e30480){var ex__28256__auto__ = e30480;
var statearr_30481_31942 = state_30452;
(statearr_30481_31942[(2)] = ex__28256__auto__);


if(cljs.core.seq((state_30452[(4)]))){
var statearr_30488_31943 = state_30452;
(statearr_30488_31943[(1)] = cljs.core.first((state_30452[(4)])));

} else {
throw ex__28256__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28254__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31944 = state_30452;
state_30452 = G__31944;
continue;
} else {
return ret_value__28254__auto__;
}
break;
}
});
cljs$core$async$state_machine__28253__auto__ = function(state_30452){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28253__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28253__auto____1.call(this,state_30452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28253__auto____0;
cljs$core$async$state_machine__28253__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28253__auto____1;
return cljs$core$async$state_machine__28253__auto__;
})()
})();
var state__28311__auto__ = (function (){var statearr_30489 = f__28310__auto__();
(statearr_30489[(6)] = c__28309__auto___31927);

return statearr_30489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28311__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
