goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47538 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47538(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47541 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47541(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__46236 = coll;
var G__46237 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__46236,G__46237) : shadow.dom.lazy_native_coll_seq.call(null,G__46236,G__46237));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4160__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46263 = arguments.length;
switch (G__46263) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46275 = arguments.length;
switch (G__46275) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46283 = arguments.length;
switch (G__46283) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46293 = arguments.length;
switch (G__46293) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46311 = arguments.length;
switch (G__46311) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46326 = arguments.length;
switch (G__46326) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e46339){if((e46339 instanceof Object)){
var e = e46339;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46339;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4160__auto__ = (!((typeof document !== 'undefined')));
if(or__4160__auto__){
return or__4160__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46373 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__46374 = null;
var count__46375 = (0);
var i__46376 = (0);
while(true){
if((i__46376 < count__46375)){
var el = chunk__46374.cljs$core$IIndexed$_nth$arity$2(null,i__46376);
var handler_47641__$1 = ((function (seq__46373,chunk__46374,count__46375,i__46376,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46373,chunk__46374,count__46375,i__46376,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47641__$1);


var G__47642 = seq__46373;
var G__47643 = chunk__46374;
var G__47644 = count__46375;
var G__47645 = (i__46376 + (1));
seq__46373 = G__47642;
chunk__46374 = G__47643;
count__46375 = G__47644;
i__46376 = G__47645;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46373);
if(temp__5754__auto__){
var seq__46373__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46373__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46373__$1);
var G__47650 = cljs.core.chunk_rest(seq__46373__$1);
var G__47651 = c__4591__auto__;
var G__47652 = cljs.core.count(c__4591__auto__);
var G__47653 = (0);
seq__46373 = G__47650;
chunk__46374 = G__47651;
count__46375 = G__47652;
i__46376 = G__47653;
continue;
} else {
var el = cljs.core.first(seq__46373__$1);
var handler_47654__$1 = ((function (seq__46373,chunk__46374,count__46375,i__46376,el,seq__46373__$1,temp__5754__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46373,chunk__46374,count__46375,i__46376,el,seq__46373__$1,temp__5754__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47654__$1);


var G__47657 = cljs.core.next(seq__46373__$1);
var G__47658 = null;
var G__47659 = (0);
var G__47660 = (0);
seq__46373 = G__47657;
chunk__46374 = G__47658;
count__46375 = G__47659;
i__46376 = G__47660;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46399 = arguments.length;
switch (G__46399) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46406 = cljs.core.seq(events);
var chunk__46407 = null;
var count__46408 = (0);
var i__46409 = (0);
while(true){
if((i__46409 < count__46408)){
var vec__46421 = chunk__46407.cljs$core$IIndexed$_nth$arity$2(null,i__46409);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46421,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46421,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47677 = seq__46406;
var G__47678 = chunk__46407;
var G__47679 = count__46408;
var G__47680 = (i__46409 + (1));
seq__46406 = G__47677;
chunk__46407 = G__47678;
count__46408 = G__47679;
i__46409 = G__47680;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46406);
if(temp__5754__auto__){
var seq__46406__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46406__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46406__$1);
var G__47681 = cljs.core.chunk_rest(seq__46406__$1);
var G__47682 = c__4591__auto__;
var G__47683 = cljs.core.count(c__4591__auto__);
var G__47684 = (0);
seq__46406 = G__47681;
chunk__46407 = G__47682;
count__46408 = G__47683;
i__46409 = G__47684;
continue;
} else {
var vec__46426 = cljs.core.first(seq__46406__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46426,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46426,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47689 = cljs.core.next(seq__46406__$1);
var G__47690 = null;
var G__47691 = (0);
var G__47692 = (0);
seq__46406 = G__47689;
chunk__46407 = G__47690;
count__46408 = G__47691;
i__46409 = G__47692;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__46432 = cljs.core.seq(styles);
var chunk__46433 = null;
var count__46434 = (0);
var i__46435 = (0);
while(true){
if((i__46435 < count__46434)){
var vec__46447 = chunk__46433.cljs$core$IIndexed$_nth$arity$2(null,i__46435);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46447,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46447,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47696 = seq__46432;
var G__47697 = chunk__46433;
var G__47698 = count__46434;
var G__47699 = (i__46435 + (1));
seq__46432 = G__47696;
chunk__46433 = G__47697;
count__46434 = G__47698;
i__46435 = G__47699;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46432);
if(temp__5754__auto__){
var seq__46432__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46432__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46432__$1);
var G__47700 = cljs.core.chunk_rest(seq__46432__$1);
var G__47701 = c__4591__auto__;
var G__47702 = cljs.core.count(c__4591__auto__);
var G__47703 = (0);
seq__46432 = G__47700;
chunk__46433 = G__47701;
count__46434 = G__47702;
i__46435 = G__47703;
continue;
} else {
var vec__46452 = cljs.core.first(seq__46432__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46452,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46452,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47713 = cljs.core.next(seq__46432__$1);
var G__47714 = null;
var G__47715 = (0);
var G__47716 = (0);
seq__46432 = G__47713;
chunk__46433 = G__47714;
count__46434 = G__47715;
i__46435 = G__47716;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46461_47723 = key;
var G__46461_47724__$1 = (((G__46461_47723 instanceof cljs.core.Keyword))?G__46461_47723.fqn:null);
switch (G__46461_47724__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47734 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4160__auto__ = goog.string.startsWith(ks_47734,"data-");
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return goog.string.startsWith(ks_47734,"aria-");
}
})())){
el.setAttribute(ks_47734,value);
} else {
(el[ks_47734] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46497){
var map__46498 = p__46497;
var map__46498__$1 = cljs.core.__destructure_map(map__46498);
var props = map__46498__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46498__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46499 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46499,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46499,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46499,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__46502 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__46502,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46502;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46504 = arguments.length;
switch (G__46504) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5754__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5754__auto__)){
var n = temp__5754__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46522){
var vec__46524 = p__46522;
var seq__46525 = cljs.core.seq(vec__46524);
var first__46526 = cljs.core.first(seq__46525);
var seq__46525__$1 = cljs.core.next(seq__46525);
var nn = first__46526;
var first__46526__$1 = cljs.core.first(seq__46525__$1);
var seq__46525__$2 = cljs.core.next(seq__46525__$1);
var np = first__46526__$1;
var nc = seq__46525__$2;
var node = vec__46524;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46532 = nn;
var G__46533 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46532,G__46533) : create_fn.call(null,G__46532,G__46533));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46536 = nn;
var G__46537 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46536,G__46537) : create_fn.call(null,G__46536,G__46537));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46542 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46542,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46542,(1),null);
var seq__46545_47768 = cljs.core.seq(node_children);
var chunk__46546_47769 = null;
var count__46547_47770 = (0);
var i__46548_47771 = (0);
while(true){
if((i__46548_47771 < count__46547_47770)){
var child_struct_47773 = chunk__46546_47769.cljs$core$IIndexed$_nth$arity$2(null,i__46548_47771);
var children_47774 = shadow.dom.dom_node(child_struct_47773);
if(cljs.core.seq_QMARK_(children_47774)){
var seq__46596_47775 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47774));
var chunk__46598_47776 = null;
var count__46599_47777 = (0);
var i__46600_47778 = (0);
while(true){
if((i__46600_47778 < count__46599_47777)){
var child_47780 = chunk__46598_47776.cljs$core$IIndexed$_nth$arity$2(null,i__46600_47778);
if(cljs.core.truth_(child_47780)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47780);


var G__47781 = seq__46596_47775;
var G__47782 = chunk__46598_47776;
var G__47783 = count__46599_47777;
var G__47784 = (i__46600_47778 + (1));
seq__46596_47775 = G__47781;
chunk__46598_47776 = G__47782;
count__46599_47777 = G__47783;
i__46600_47778 = G__47784;
continue;
} else {
var G__47786 = seq__46596_47775;
var G__47787 = chunk__46598_47776;
var G__47788 = count__46599_47777;
var G__47789 = (i__46600_47778 + (1));
seq__46596_47775 = G__47786;
chunk__46598_47776 = G__47787;
count__46599_47777 = G__47788;
i__46600_47778 = G__47789;
continue;
}
} else {
var temp__5754__auto___47790 = cljs.core.seq(seq__46596_47775);
if(temp__5754__auto___47790){
var seq__46596_47791__$1 = temp__5754__auto___47790;
if(cljs.core.chunked_seq_QMARK_(seq__46596_47791__$1)){
var c__4591__auto___47792 = cljs.core.chunk_first(seq__46596_47791__$1);
var G__47793 = cljs.core.chunk_rest(seq__46596_47791__$1);
var G__47794 = c__4591__auto___47792;
var G__47795 = cljs.core.count(c__4591__auto___47792);
var G__47796 = (0);
seq__46596_47775 = G__47793;
chunk__46598_47776 = G__47794;
count__46599_47777 = G__47795;
i__46600_47778 = G__47796;
continue;
} else {
var child_47798 = cljs.core.first(seq__46596_47791__$1);
if(cljs.core.truth_(child_47798)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47798);


var G__47799 = cljs.core.next(seq__46596_47791__$1);
var G__47800 = null;
var G__47801 = (0);
var G__47802 = (0);
seq__46596_47775 = G__47799;
chunk__46598_47776 = G__47800;
count__46599_47777 = G__47801;
i__46600_47778 = G__47802;
continue;
} else {
var G__47804 = cljs.core.next(seq__46596_47791__$1);
var G__47805 = null;
var G__47806 = (0);
var G__47807 = (0);
seq__46596_47775 = G__47804;
chunk__46598_47776 = G__47805;
count__46599_47777 = G__47806;
i__46600_47778 = G__47807;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47774);
}


var G__47808 = seq__46545_47768;
var G__47809 = chunk__46546_47769;
var G__47810 = count__46547_47770;
var G__47811 = (i__46548_47771 + (1));
seq__46545_47768 = G__47808;
chunk__46546_47769 = G__47809;
count__46547_47770 = G__47810;
i__46548_47771 = G__47811;
continue;
} else {
var temp__5754__auto___47813 = cljs.core.seq(seq__46545_47768);
if(temp__5754__auto___47813){
var seq__46545_47814__$1 = temp__5754__auto___47813;
if(cljs.core.chunked_seq_QMARK_(seq__46545_47814__$1)){
var c__4591__auto___47816 = cljs.core.chunk_first(seq__46545_47814__$1);
var G__47817 = cljs.core.chunk_rest(seq__46545_47814__$1);
var G__47818 = c__4591__auto___47816;
var G__47819 = cljs.core.count(c__4591__auto___47816);
var G__47820 = (0);
seq__46545_47768 = G__47817;
chunk__46546_47769 = G__47818;
count__46547_47770 = G__47819;
i__46548_47771 = G__47820;
continue;
} else {
var child_struct_47822 = cljs.core.first(seq__46545_47814__$1);
var children_47823 = shadow.dom.dom_node(child_struct_47822);
if(cljs.core.seq_QMARK_(children_47823)){
var seq__46621_47824 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47823));
var chunk__46623_47825 = null;
var count__46624_47826 = (0);
var i__46625_47827 = (0);
while(true){
if((i__46625_47827 < count__46624_47826)){
var child_47828 = chunk__46623_47825.cljs$core$IIndexed$_nth$arity$2(null,i__46625_47827);
if(cljs.core.truth_(child_47828)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47828);


var G__47831 = seq__46621_47824;
var G__47832 = chunk__46623_47825;
var G__47833 = count__46624_47826;
var G__47834 = (i__46625_47827 + (1));
seq__46621_47824 = G__47831;
chunk__46623_47825 = G__47832;
count__46624_47826 = G__47833;
i__46625_47827 = G__47834;
continue;
} else {
var G__47836 = seq__46621_47824;
var G__47837 = chunk__46623_47825;
var G__47838 = count__46624_47826;
var G__47839 = (i__46625_47827 + (1));
seq__46621_47824 = G__47836;
chunk__46623_47825 = G__47837;
count__46624_47826 = G__47838;
i__46625_47827 = G__47839;
continue;
}
} else {
var temp__5754__auto___47841__$1 = cljs.core.seq(seq__46621_47824);
if(temp__5754__auto___47841__$1){
var seq__46621_47842__$1 = temp__5754__auto___47841__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46621_47842__$1)){
var c__4591__auto___47843 = cljs.core.chunk_first(seq__46621_47842__$1);
var G__47845 = cljs.core.chunk_rest(seq__46621_47842__$1);
var G__47846 = c__4591__auto___47843;
var G__47847 = cljs.core.count(c__4591__auto___47843);
var G__47848 = (0);
seq__46621_47824 = G__47845;
chunk__46623_47825 = G__47846;
count__46624_47826 = G__47847;
i__46625_47827 = G__47848;
continue;
} else {
var child_47850 = cljs.core.first(seq__46621_47842__$1);
if(cljs.core.truth_(child_47850)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47850);


var G__47851 = cljs.core.next(seq__46621_47842__$1);
var G__47852 = null;
var G__47853 = (0);
var G__47854 = (0);
seq__46621_47824 = G__47851;
chunk__46623_47825 = G__47852;
count__46624_47826 = G__47853;
i__46625_47827 = G__47854;
continue;
} else {
var G__47855 = cljs.core.next(seq__46621_47842__$1);
var G__47856 = null;
var G__47857 = (0);
var G__47858 = (0);
seq__46621_47824 = G__47855;
chunk__46623_47825 = G__47856;
count__46624_47826 = G__47857;
i__46625_47827 = G__47858;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47823);
}


var G__47859 = cljs.core.next(seq__46545_47814__$1);
var G__47860 = null;
var G__47861 = (0);
var G__47862 = (0);
seq__46545_47768 = G__47859;
chunk__46546_47769 = G__47860;
count__46547_47770 = G__47861;
i__46548_47771 = G__47862;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46668 = cljs.core.seq(node);
var chunk__46669 = null;
var count__46670 = (0);
var i__46671 = (0);
while(true){
if((i__46671 < count__46670)){
var n = chunk__46669.cljs$core$IIndexed$_nth$arity$2(null,i__46671);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47896 = seq__46668;
var G__47897 = chunk__46669;
var G__47898 = count__46670;
var G__47899 = (i__46671 + (1));
seq__46668 = G__47896;
chunk__46669 = G__47897;
count__46670 = G__47898;
i__46671 = G__47899;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46668);
if(temp__5754__auto__){
var seq__46668__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46668__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46668__$1);
var G__47901 = cljs.core.chunk_rest(seq__46668__$1);
var G__47902 = c__4591__auto__;
var G__47903 = cljs.core.count(c__4591__auto__);
var G__47904 = (0);
seq__46668 = G__47901;
chunk__46669 = G__47902;
count__46670 = G__47903;
i__46671 = G__47904;
continue;
} else {
var n = cljs.core.first(seq__46668__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47910 = cljs.core.next(seq__46668__$1);
var G__47911 = null;
var G__47912 = (0);
var G__47913 = (0);
seq__46668 = G__47910;
chunk__46669 = G__47911;
count__46670 = G__47912;
i__46671 = G__47913;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46689 = arguments.length;
switch (G__46689) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46698 = arguments.length;
switch (G__46698) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__46713 = arguments.length;
switch (G__46713) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4160__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4777__auto__ = [];
var len__4771__auto___47935 = arguments.length;
var i__4772__auto___47936 = (0);
while(true){
if((i__4772__auto___47936 < len__4771__auto___47935)){
args__4777__auto__.push((arguments[i__4772__auto___47936]));

var G__47937 = (i__4772__auto___47936 + (1));
i__4772__auto___47936 = G__47937;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__46738_47938 = cljs.core.seq(nodes);
var chunk__46739_47939 = null;
var count__46740_47940 = (0);
var i__46741_47941 = (0);
while(true){
if((i__46741_47941 < count__46740_47940)){
var node_47946 = chunk__46739_47939.cljs$core$IIndexed$_nth$arity$2(null,i__46741_47941);
fragment.appendChild(shadow.dom._to_dom(node_47946));


var G__47948 = seq__46738_47938;
var G__47949 = chunk__46739_47939;
var G__47950 = count__46740_47940;
var G__47951 = (i__46741_47941 + (1));
seq__46738_47938 = G__47948;
chunk__46739_47939 = G__47949;
count__46740_47940 = G__47950;
i__46741_47941 = G__47951;
continue;
} else {
var temp__5754__auto___47953 = cljs.core.seq(seq__46738_47938);
if(temp__5754__auto___47953){
var seq__46738_47954__$1 = temp__5754__auto___47953;
if(cljs.core.chunked_seq_QMARK_(seq__46738_47954__$1)){
var c__4591__auto___47955 = cljs.core.chunk_first(seq__46738_47954__$1);
var G__47956 = cljs.core.chunk_rest(seq__46738_47954__$1);
var G__47957 = c__4591__auto___47955;
var G__47958 = cljs.core.count(c__4591__auto___47955);
var G__47959 = (0);
seq__46738_47938 = G__47956;
chunk__46739_47939 = G__47957;
count__46740_47940 = G__47958;
i__46741_47941 = G__47959;
continue;
} else {
var node_47968 = cljs.core.first(seq__46738_47954__$1);
fragment.appendChild(shadow.dom._to_dom(node_47968));


var G__47976 = cljs.core.next(seq__46738_47954__$1);
var G__47977 = null;
var G__47978 = (0);
var G__47979 = (0);
seq__46738_47938 = G__47976;
chunk__46739_47939 = G__47977;
count__46740_47940 = G__47978;
i__46741_47941 = G__47979;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq46732){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq46732));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__46753_47992 = cljs.core.seq(scripts);
var chunk__46754_47993 = null;
var count__46755_47994 = (0);
var i__46756_47995 = (0);
while(true){
if((i__46756_47995 < count__46755_47994)){
var vec__46768_47997 = chunk__46754_47993.cljs$core$IIndexed$_nth$arity$2(null,i__46756_47995);
var script_tag_47998 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46768_47997,(0),null);
var script_body_47999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46768_47997,(1),null);
eval(script_body_47999);


var G__48000 = seq__46753_47992;
var G__48001 = chunk__46754_47993;
var G__48002 = count__46755_47994;
var G__48003 = (i__46756_47995 + (1));
seq__46753_47992 = G__48000;
chunk__46754_47993 = G__48001;
count__46755_47994 = G__48002;
i__46756_47995 = G__48003;
continue;
} else {
var temp__5754__auto___48006 = cljs.core.seq(seq__46753_47992);
if(temp__5754__auto___48006){
var seq__46753_48007__$1 = temp__5754__auto___48006;
if(cljs.core.chunked_seq_QMARK_(seq__46753_48007__$1)){
var c__4591__auto___48008 = cljs.core.chunk_first(seq__46753_48007__$1);
var G__48009 = cljs.core.chunk_rest(seq__46753_48007__$1);
var G__48010 = c__4591__auto___48008;
var G__48011 = cljs.core.count(c__4591__auto___48008);
var G__48012 = (0);
seq__46753_47992 = G__48009;
chunk__46754_47993 = G__48010;
count__46755_47994 = G__48011;
i__46756_47995 = G__48012;
continue;
} else {
var vec__46773_48025 = cljs.core.first(seq__46753_48007__$1);
var script_tag_48026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46773_48025,(0),null);
var script_body_48027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46773_48025,(1),null);
eval(script_body_48027);


var G__48035 = cljs.core.next(seq__46753_48007__$1);
var G__48036 = null;
var G__48037 = (0);
var G__48038 = (0);
seq__46753_47992 = G__48035;
chunk__46754_47993 = G__48036;
count__46755_47994 = G__48037;
i__46756_47995 = G__48038;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__46780){
var vec__46782 = p__46780;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46782,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46782,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__46806 = arguments.length;
switch (G__46806) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__46832 = cljs.core.seq(style_keys);
var chunk__46833 = null;
var count__46834 = (0);
var i__46835 = (0);
while(true){
if((i__46835 < count__46834)){
var it = chunk__46833.cljs$core$IIndexed$_nth$arity$2(null,i__46835);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48063 = seq__46832;
var G__48064 = chunk__46833;
var G__48065 = count__46834;
var G__48066 = (i__46835 + (1));
seq__46832 = G__48063;
chunk__46833 = G__48064;
count__46834 = G__48065;
i__46835 = G__48066;
continue;
} else {
var temp__5754__auto__ = cljs.core.seq(seq__46832);
if(temp__5754__auto__){
var seq__46832__$1 = temp__5754__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46832__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__46832__$1);
var G__48068 = cljs.core.chunk_rest(seq__46832__$1);
var G__48069 = c__4591__auto__;
var G__48070 = cljs.core.count(c__4591__auto__);
var G__48071 = (0);
seq__46832 = G__48068;
chunk__46833 = G__48069;
count__46834 = G__48070;
i__46835 = G__48071;
continue;
} else {
var it = cljs.core.first(seq__46832__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48073 = cljs.core.next(seq__46832__$1);
var G__48074 = null;
var G__48075 = (0);
var G__48076 = (0);
seq__46832 = G__48073;
chunk__46833 = G__48074;
count__46834 = G__48075;
i__46835 = G__48076;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k46848,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__46861 = k46848;
var G__46861__$1 = (((G__46861 instanceof cljs.core.Keyword))?G__46861.fqn:null);
switch (G__46861__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k46848,else__4418__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__46870){
var vec__46871 = p__46870;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46871,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46871,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__46847){
var self__ = this;
var G__46847__$1 = this;
return (new cljs.core.RecordIter((0),G__46847__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this46849,other46850){
var self__ = this;
var this46849__$1 = this;
return (((!((other46850 == null)))) && ((this46849__$1.constructor === other46850.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46849__$1.x,other46850.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46849__$1.y,other46850.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this46849__$1.__extmap,other46850.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__46847){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__46904 = cljs.core.keyword_identical_QMARK_;
var expr__46905 = k__4423__auto__;
if(cljs.core.truth_((pred__46904.cljs$core$IFn$_invoke$arity$2 ? pred__46904.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__46905) : pred__46904.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__46905)))){
return (new shadow.dom.Coordinate(G__46847,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__46904.cljs$core$IFn$_invoke$arity$2 ? pred__46904.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__46905) : pred__46904.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__46905)))){
return (new shadow.dom.Coordinate(self__.x,G__46847,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__46847),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__46847){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__46847,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__46852){
var extmap__4454__auto__ = (function (){var G__47046 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__46852,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__46852)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47046);
} else {
return G__47046;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__46852),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__46852),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k47057,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__47070 = k47057;
var G__47070__$1 = (((G__47070 instanceof cljs.core.Keyword))?G__47070.fqn:null);
switch (G__47070__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47057,else__4418__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__47074){
var vec__47076 = p__47074;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47076,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47076,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#shadow.dom.Size{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47056){
var self__ = this;
var G__47056__$1 = this;
return (new cljs.core.RecordIter((0),G__47056__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (coll__4412__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
})(this__4411__auto____$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47058,other47059){
var self__ = this;
var this47058__$1 = this;
return (((!((other47059 == null)))) && ((this47058__$1.constructor === other47059.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47058__$1.w,other47059.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47058__$1.h,other47059.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47058__$1.__extmap,other47059.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__47056){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__47094 = cljs.core.keyword_identical_QMARK_;
var expr__47095 = k__4423__auto__;
if(cljs.core.truth_((pred__47094.cljs$core$IFn$_invoke$arity$2 ? pred__47094.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__47095) : pred__47094.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__47095)))){
return (new shadow.dom.Size(G__47056,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47094.cljs$core$IFn$_invoke$arity$2 ? pred__47094.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__47095) : pred__47094.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__47095)))){
return (new shadow.dom.Size(self__.w,G__47056,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__47056),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__47056){
var self__ = this;
var this__4414__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__47056,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4421__auto__,(0)),cljs.core._nth(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__47061){
var extmap__4454__auto__ = (function (){var G__47125 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47061,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__47061)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47125);
} else {
return G__47125;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__47061),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__47061),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4645__auto__ = opts;
var l__4646__auto__ = a__4645__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4646__auto__)){
var G__48170 = (i + (1));
var G__48171 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__48170;
ret = G__48171;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__47162){
var vec__47163 = p__47162;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47163,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47163,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__47168 = arguments.length;
switch (G__47168) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5752__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5752__auto__)){
var child = temp__5752__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__48189 = ps;
var G__48190 = (i + (1));
el__$1 = G__48189;
i = G__48190;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__47200 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47200,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47200,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47200,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__47208_48200 = cljs.core.seq(props);
var chunk__47209_48201 = null;
var count__47210_48202 = (0);
var i__47211_48203 = (0);
while(true){
if((i__47211_48203 < count__47210_48202)){
var vec__47226_48207 = chunk__47209_48201.cljs$core$IIndexed$_nth$arity$2(null,i__47211_48203);
var k_48208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47226_48207,(0),null);
var v_48209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47226_48207,(1),null);
el.setAttributeNS((function (){var temp__5754__auto__ = cljs.core.namespace(k_48208);
if(cljs.core.truth_(temp__5754__auto__)){
var ns = temp__5754__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48208),v_48209);


var G__48210 = seq__47208_48200;
var G__48211 = chunk__47209_48201;
var G__48212 = count__47210_48202;
var G__48213 = (i__47211_48203 + (1));
seq__47208_48200 = G__48210;
chunk__47209_48201 = G__48211;
count__47210_48202 = G__48212;
i__47211_48203 = G__48213;
continue;
} else {
var temp__5754__auto___48214 = cljs.core.seq(seq__47208_48200);
if(temp__5754__auto___48214){
var seq__47208_48215__$1 = temp__5754__auto___48214;
if(cljs.core.chunked_seq_QMARK_(seq__47208_48215__$1)){
var c__4591__auto___48216 = cljs.core.chunk_first(seq__47208_48215__$1);
var G__48217 = cljs.core.chunk_rest(seq__47208_48215__$1);
var G__48218 = c__4591__auto___48216;
var G__48219 = cljs.core.count(c__4591__auto___48216);
var G__48220 = (0);
seq__47208_48200 = G__48217;
chunk__47209_48201 = G__48218;
count__47210_48202 = G__48219;
i__47211_48203 = G__48220;
continue;
} else {
var vec__47233_48221 = cljs.core.first(seq__47208_48215__$1);
var k_48222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47233_48221,(0),null);
var v_48223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47233_48221,(1),null);
el.setAttributeNS((function (){var temp__5754__auto____$1 = cljs.core.namespace(k_48222);
if(cljs.core.truth_(temp__5754__auto____$1)){
var ns = temp__5754__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48222),v_48223);


var G__48226 = cljs.core.next(seq__47208_48215__$1);
var G__48227 = null;
var G__48228 = (0);
var G__48229 = (0);
seq__47208_48200 = G__48226;
chunk__47209_48201 = G__48227;
count__47210_48202 = G__48228;
i__47211_48203 = G__48229;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__47252 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47252,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47252,(1),null);
var seq__47255_48234 = cljs.core.seq(node_children);
var chunk__47257_48235 = null;
var count__47258_48236 = (0);
var i__47259_48237 = (0);
while(true){
if((i__47259_48237 < count__47258_48236)){
var child_struct_48238 = chunk__47257_48235.cljs$core$IIndexed$_nth$arity$2(null,i__47259_48237);
if((!((child_struct_48238 == null)))){
if(typeof child_struct_48238 === 'string'){
var text_48239 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48239),child_struct_48238].join(''));
} else {
var children_48240 = shadow.dom.svg_node(child_struct_48238);
if(cljs.core.seq_QMARK_(children_48240)){
var seq__47335_48241 = cljs.core.seq(children_48240);
var chunk__47337_48242 = null;
var count__47338_48243 = (0);
var i__47339_48244 = (0);
while(true){
if((i__47339_48244 < count__47338_48243)){
var child_48245 = chunk__47337_48242.cljs$core$IIndexed$_nth$arity$2(null,i__47339_48244);
if(cljs.core.truth_(child_48245)){
node.appendChild(child_48245);


var G__48246 = seq__47335_48241;
var G__48247 = chunk__47337_48242;
var G__48248 = count__47338_48243;
var G__48249 = (i__47339_48244 + (1));
seq__47335_48241 = G__48246;
chunk__47337_48242 = G__48247;
count__47338_48243 = G__48248;
i__47339_48244 = G__48249;
continue;
} else {
var G__48250 = seq__47335_48241;
var G__48251 = chunk__47337_48242;
var G__48252 = count__47338_48243;
var G__48253 = (i__47339_48244 + (1));
seq__47335_48241 = G__48250;
chunk__47337_48242 = G__48251;
count__47338_48243 = G__48252;
i__47339_48244 = G__48253;
continue;
}
} else {
var temp__5754__auto___48254 = cljs.core.seq(seq__47335_48241);
if(temp__5754__auto___48254){
var seq__47335_48255__$1 = temp__5754__auto___48254;
if(cljs.core.chunked_seq_QMARK_(seq__47335_48255__$1)){
var c__4591__auto___48256 = cljs.core.chunk_first(seq__47335_48255__$1);
var G__48257 = cljs.core.chunk_rest(seq__47335_48255__$1);
var G__48258 = c__4591__auto___48256;
var G__48259 = cljs.core.count(c__4591__auto___48256);
var G__48260 = (0);
seq__47335_48241 = G__48257;
chunk__47337_48242 = G__48258;
count__47338_48243 = G__48259;
i__47339_48244 = G__48260;
continue;
} else {
var child_48261 = cljs.core.first(seq__47335_48255__$1);
if(cljs.core.truth_(child_48261)){
node.appendChild(child_48261);


var G__48262 = cljs.core.next(seq__47335_48255__$1);
var G__48263 = null;
var G__48264 = (0);
var G__48265 = (0);
seq__47335_48241 = G__48262;
chunk__47337_48242 = G__48263;
count__47338_48243 = G__48264;
i__47339_48244 = G__48265;
continue;
} else {
var G__48266 = cljs.core.next(seq__47335_48255__$1);
var G__48267 = null;
var G__48268 = (0);
var G__48269 = (0);
seq__47335_48241 = G__48266;
chunk__47337_48242 = G__48267;
count__47338_48243 = G__48268;
i__47339_48244 = G__48269;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48240);
}
}


var G__48270 = seq__47255_48234;
var G__48271 = chunk__47257_48235;
var G__48272 = count__47258_48236;
var G__48273 = (i__47259_48237 + (1));
seq__47255_48234 = G__48270;
chunk__47257_48235 = G__48271;
count__47258_48236 = G__48272;
i__47259_48237 = G__48273;
continue;
} else {
var G__48274 = seq__47255_48234;
var G__48275 = chunk__47257_48235;
var G__48276 = count__47258_48236;
var G__48277 = (i__47259_48237 + (1));
seq__47255_48234 = G__48274;
chunk__47257_48235 = G__48275;
count__47258_48236 = G__48276;
i__47259_48237 = G__48277;
continue;
}
} else {
var temp__5754__auto___48278 = cljs.core.seq(seq__47255_48234);
if(temp__5754__auto___48278){
var seq__47255_48279__$1 = temp__5754__auto___48278;
if(cljs.core.chunked_seq_QMARK_(seq__47255_48279__$1)){
var c__4591__auto___48280 = cljs.core.chunk_first(seq__47255_48279__$1);
var G__48281 = cljs.core.chunk_rest(seq__47255_48279__$1);
var G__48282 = c__4591__auto___48280;
var G__48283 = cljs.core.count(c__4591__auto___48280);
var G__48284 = (0);
seq__47255_48234 = G__48281;
chunk__47257_48235 = G__48282;
count__47258_48236 = G__48283;
i__47259_48237 = G__48284;
continue;
} else {
var child_struct_48285 = cljs.core.first(seq__47255_48279__$1);
if((!((child_struct_48285 == null)))){
if(typeof child_struct_48285 === 'string'){
var text_48286 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48286),child_struct_48285].join(''));
} else {
var children_48287 = shadow.dom.svg_node(child_struct_48285);
if(cljs.core.seq_QMARK_(children_48287)){
var seq__47376_48288 = cljs.core.seq(children_48287);
var chunk__47378_48289 = null;
var count__47379_48290 = (0);
var i__47380_48291 = (0);
while(true){
if((i__47380_48291 < count__47379_48290)){
var child_48293 = chunk__47378_48289.cljs$core$IIndexed$_nth$arity$2(null,i__47380_48291);
if(cljs.core.truth_(child_48293)){
node.appendChild(child_48293);


var G__48294 = seq__47376_48288;
var G__48295 = chunk__47378_48289;
var G__48296 = count__47379_48290;
var G__48297 = (i__47380_48291 + (1));
seq__47376_48288 = G__48294;
chunk__47378_48289 = G__48295;
count__47379_48290 = G__48296;
i__47380_48291 = G__48297;
continue;
} else {
var G__48300 = seq__47376_48288;
var G__48301 = chunk__47378_48289;
var G__48302 = count__47379_48290;
var G__48303 = (i__47380_48291 + (1));
seq__47376_48288 = G__48300;
chunk__47378_48289 = G__48301;
count__47379_48290 = G__48302;
i__47380_48291 = G__48303;
continue;
}
} else {
var temp__5754__auto___48304__$1 = cljs.core.seq(seq__47376_48288);
if(temp__5754__auto___48304__$1){
var seq__47376_48305__$1 = temp__5754__auto___48304__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47376_48305__$1)){
var c__4591__auto___48307 = cljs.core.chunk_first(seq__47376_48305__$1);
var G__48308 = cljs.core.chunk_rest(seq__47376_48305__$1);
var G__48309 = c__4591__auto___48307;
var G__48310 = cljs.core.count(c__4591__auto___48307);
var G__48311 = (0);
seq__47376_48288 = G__48308;
chunk__47378_48289 = G__48309;
count__47379_48290 = G__48310;
i__47380_48291 = G__48311;
continue;
} else {
var child_48312 = cljs.core.first(seq__47376_48305__$1);
if(cljs.core.truth_(child_48312)){
node.appendChild(child_48312);


var G__48313 = cljs.core.next(seq__47376_48305__$1);
var G__48314 = null;
var G__48315 = (0);
var G__48316 = (0);
seq__47376_48288 = G__48313;
chunk__47378_48289 = G__48314;
count__47379_48290 = G__48315;
i__47380_48291 = G__48316;
continue;
} else {
var G__48320 = cljs.core.next(seq__47376_48305__$1);
var G__48321 = null;
var G__48322 = (0);
var G__48323 = (0);
seq__47376_48288 = G__48320;
chunk__47378_48289 = G__48321;
count__47379_48290 = G__48322;
i__47380_48291 = G__48323;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48287);
}
}


var G__48324 = cljs.core.next(seq__47255_48279__$1);
var G__48325 = null;
var G__48326 = (0);
var G__48327 = (0);
seq__47255_48234 = G__48324;
chunk__47257_48235 = G__48325;
count__47258_48236 = G__48326;
i__47259_48237 = G__48327;
continue;
} else {
var G__48328 = cljs.core.next(seq__47255_48279__$1);
var G__48329 = null;
var G__48330 = (0);
var G__48331 = (0);
seq__47255_48234 = G__48328;
chunk__47257_48235 = G__48329;
count__47258_48236 = G__48330;
i__47259_48237 = G__48331;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4777__auto__ = [];
var len__4771__auto___48333 = arguments.length;
var i__4772__auto___48334 = (0);
while(true){
if((i__4772__auto___48334 < len__4771__auto___48333)){
args__4777__auto__.push((arguments[i__4772__auto___48334]));

var G__48335 = (i__4772__auto___48334 + (1));
i__4772__auto___48334 = G__48335;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47424){
var G__47425 = cljs.core.first(seq47424);
var seq47424__$1 = cljs.core.next(seq47424);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47425,seq47424__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47455 = arguments.length;
switch (G__47455) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4149__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4149__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4149__auto__;
}
})())){
var c__43458__auto___48356 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43459__auto__ = (function (){var switch__43204__auto__ = (function (state_47479){
var state_val_47480 = (state_47479[(1)]);
if((state_val_47480 === (1))){
var state_47479__$1 = state_47479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47479__$1,(2),once_or_cleanup);
} else {
if((state_val_47480 === (2))){
var inst_47476 = (state_47479[(2)]);
var inst_47477 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_47479__$1 = (function (){var statearr_47494 = state_47479;
(statearr_47494[(7)] = inst_47476);

return statearr_47494;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47479__$1,inst_47477);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43205__auto__ = null;
var shadow$dom$state_machine__43205__auto____0 = (function (){
var statearr_47501 = [null,null,null,null,null,null,null,null];
(statearr_47501[(0)] = shadow$dom$state_machine__43205__auto__);

(statearr_47501[(1)] = (1));

return statearr_47501;
});
var shadow$dom$state_machine__43205__auto____1 = (function (state_47479){
while(true){
var ret_value__43206__auto__ = (function (){try{while(true){
var result__43207__auto__ = switch__43204__auto__(state_47479);
if(cljs.core.keyword_identical_QMARK_(result__43207__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43207__auto__;
}
break;
}
}catch (e47505){var ex__43208__auto__ = e47505;
var statearr_47506_48365 = state_47479;
(statearr_47506_48365[(2)] = ex__43208__auto__);


if(cljs.core.seq((state_47479[(4)]))){
var statearr_47507_48369 = state_47479;
(statearr_47507_48369[(1)] = cljs.core.first((state_47479[(4)])));

} else {
throw ex__43208__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43206__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48374 = state_47479;
state_47479 = G__48374;
continue;
} else {
return ret_value__43206__auto__;
}
break;
}
});
shadow$dom$state_machine__43205__auto__ = function(state_47479){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43205__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43205__auto____1.call(this,state_47479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43205__auto____0;
shadow$dom$state_machine__43205__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43205__auto____1;
return shadow$dom$state_machine__43205__auto__;
})()
})();
var state__43460__auto__ = (function (){var statearr_47516 = f__43459__auto__();
(statearr_47516[(6)] = c__43458__auto___48356);

return statearr_47516;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43460__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
