goog.loadModule(function(exports) {
  "use strict";
  goog.module("goog.loader.activeModuleManager");
  goog.module.declareLegacyNamespace();
  var AbstractModuleManager = goog.require("goog.loader.AbstractModuleManager");
  var asserts = goog.require("goog.asserts");
  var moduleManager = null;
  var getDefault = null;
  function get() {
    if (!moduleManager && getDefault) {
      moduleManager = getDefault();
    }
    asserts.assert(moduleManager != null, "The module manager has not yet been set.");
    return moduleManager;
  }
  function set(newModuleManager) {
    asserts.assert(moduleManager == null, "The module manager cannot be redefined.");
    moduleManager = newModuleManager;
  }
  function setDefault(fn) {
    getDefault = fn;
  }
  var reset = function() {
    moduleManager = null;
  };
  exports = {get:get, set:set, setDefault:setDefault, reset:reset};
  return exports;
});

//# sourceMappingURL=goog.loader.activemodulemanager.js.map
