goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_50828 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_50828(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_50832 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_50832(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__50016 = coll;
var G__50017 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__50016,G__50017) : shadow.dom.lazy_native_coll_seq.call(null,G__50016,G__50017));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__50033 = arguments.length;
switch (G__50033) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__50041 = arguments.length;
switch (G__50041) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__50048 = arguments.length;
switch (G__50048) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__50060 = arguments.length;
switch (G__50060) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__50072 = arguments.length;
switch (G__50072) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__50081 = arguments.length;
switch (G__50081) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e50089){if((e50089 instanceof Object)){
var e = e50089;
return console.log("didnt support attachEvent",el,e);
} else {
throw e50089;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__50105 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__50106 = null;
var count__50107 = (0);
var i__50108 = (0);
while(true){
if((i__50108 < count__50107)){
var el = chunk__50106.cljs$core$IIndexed$_nth$arity$2(null,i__50108);
var handler_50896__$1 = ((function (seq__50105,chunk__50106,count__50107,i__50108,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__50105,chunk__50106,count__50107,i__50108,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_50896__$1);


var G__50898 = seq__50105;
var G__50899 = chunk__50106;
var G__50900 = count__50107;
var G__50901 = (i__50108 + (1));
seq__50105 = G__50898;
chunk__50106 = G__50899;
count__50107 = G__50900;
i__50108 = G__50901;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__50105);
if(temp__5720__auto__){
var seq__50105__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50105__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__50105__$1);
var G__50905 = cljs.core.chunk_rest(seq__50105__$1);
var G__50906 = c__4556__auto__;
var G__50907 = cljs.core.count(c__4556__auto__);
var G__50908 = (0);
seq__50105 = G__50905;
chunk__50106 = G__50906;
count__50107 = G__50907;
i__50108 = G__50908;
continue;
} else {
var el = cljs.core.first(seq__50105__$1);
var handler_50911__$1 = ((function (seq__50105,chunk__50106,count__50107,i__50108,el,seq__50105__$1,temp__5720__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__50105,chunk__50106,count__50107,i__50108,el,seq__50105__$1,temp__5720__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_50911__$1);


var G__50912 = cljs.core.next(seq__50105__$1);
var G__50913 = null;
var G__50914 = (0);
var G__50915 = (0);
seq__50105 = G__50912;
chunk__50106 = G__50913;
count__50107 = G__50914;
i__50108 = G__50915;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__50128 = arguments.length;
switch (G__50128) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__50140 = cljs.core.seq(events);
var chunk__50141 = null;
var count__50142 = (0);
var i__50143 = (0);
while(true){
if((i__50143 < count__50142)){
var vec__50157 = chunk__50141.cljs$core$IIndexed$_nth$arity$2(null,i__50143);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50157,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50157,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50917 = seq__50140;
var G__50918 = chunk__50141;
var G__50919 = count__50142;
var G__50920 = (i__50143 + (1));
seq__50140 = G__50917;
chunk__50141 = G__50918;
count__50142 = G__50919;
i__50143 = G__50920;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__50140);
if(temp__5720__auto__){
var seq__50140__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50140__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__50140__$1);
var G__50921 = cljs.core.chunk_rest(seq__50140__$1);
var G__50922 = c__4556__auto__;
var G__50923 = cljs.core.count(c__4556__auto__);
var G__50924 = (0);
seq__50140 = G__50921;
chunk__50141 = G__50922;
count__50142 = G__50923;
i__50143 = G__50924;
continue;
} else {
var vec__50165 = cljs.core.first(seq__50140__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50165,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50165,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50925 = cljs.core.next(seq__50140__$1);
var G__50926 = null;
var G__50927 = (0);
var G__50928 = (0);
seq__50140 = G__50925;
chunk__50141 = G__50926;
count__50142 = G__50927;
i__50143 = G__50928;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__50170 = cljs.core.seq(styles);
var chunk__50171 = null;
var count__50172 = (0);
var i__50173 = (0);
while(true){
if((i__50173 < count__50172)){
var vec__50189 = chunk__50171.cljs$core$IIndexed$_nth$arity$2(null,i__50173);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50189,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50189,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__50929 = seq__50170;
var G__50930 = chunk__50171;
var G__50931 = count__50172;
var G__50932 = (i__50173 + (1));
seq__50170 = G__50929;
chunk__50171 = G__50930;
count__50172 = G__50931;
i__50173 = G__50932;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__50170);
if(temp__5720__auto__){
var seq__50170__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50170__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__50170__$1);
var G__50935 = cljs.core.chunk_rest(seq__50170__$1);
var G__50936 = c__4556__auto__;
var G__50937 = cljs.core.count(c__4556__auto__);
var G__50938 = (0);
seq__50170 = G__50935;
chunk__50171 = G__50936;
count__50172 = G__50937;
i__50173 = G__50938;
continue;
} else {
var vec__50195 = cljs.core.first(seq__50170__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50195,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50195,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__50940 = cljs.core.next(seq__50170__$1);
var G__50941 = null;
var G__50942 = (0);
var G__50943 = (0);
seq__50170 = G__50940;
chunk__50171 = G__50941;
count__50172 = G__50942;
i__50173 = G__50943;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__50201_50944 = key;
var G__50201_50945__$1 = (((G__50201_50944 instanceof cljs.core.Keyword))?G__50201_50944.fqn:null);
switch (G__50201_50945__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_50947 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_50947,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_50947,"aria-");
}
})())){
el.setAttribute(ks_50947,value);
} else {
(el[ks_50947] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__50220){
var map__50221 = p__50220;
var map__50221__$1 = (((((!((map__50221 == null))))?(((((map__50221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50221.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__50221):map__50221);
var props = map__50221__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50221__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__50224 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50224,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50224,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50224,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__50232 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__50232,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__50232;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__50239 = arguments.length;
switch (G__50239) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5720__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5720__auto__)){
var n = temp__5720__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__50257){
var vec__50258 = p__50257;
var seq__50259 = cljs.core.seq(vec__50258);
var first__50260 = cljs.core.first(seq__50259);
var seq__50259__$1 = cljs.core.next(seq__50259);
var nn = first__50260;
var first__50260__$1 = cljs.core.first(seq__50259__$1);
var seq__50259__$2 = cljs.core.next(seq__50259__$1);
var np = first__50260__$1;
var nc = seq__50259__$2;
var node = vec__50258;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__50266 = nn;
var G__50267 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__50266,G__50267) : create_fn.call(null,G__50266,G__50267));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__50269 = nn;
var G__50270 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__50269,G__50270) : create_fn.call(null,G__50269,G__50270));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__50277 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50277,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50277,(1),null);
var seq__50280_50974 = cljs.core.seq(node_children);
var chunk__50281_50975 = null;
var count__50282_50976 = (0);
var i__50283_50977 = (0);
while(true){
if((i__50283_50977 < count__50282_50976)){
var child_struct_50979 = chunk__50281_50975.cljs$core$IIndexed$_nth$arity$2(null,i__50283_50977);
var children_50980 = shadow.dom.dom_node(child_struct_50979);
if(cljs.core.seq_QMARK_(children_50980)){
var seq__50310_50982 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50980));
var chunk__50312_50983 = null;
var count__50313_50984 = (0);
var i__50314_50985 = (0);
while(true){
if((i__50314_50985 < count__50313_50984)){
var child_50987 = chunk__50312_50983.cljs$core$IIndexed$_nth$arity$2(null,i__50314_50985);
if(cljs.core.truth_(child_50987)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50987);


var G__50988 = seq__50310_50982;
var G__50989 = chunk__50312_50983;
var G__50990 = count__50313_50984;
var G__50991 = (i__50314_50985 + (1));
seq__50310_50982 = G__50988;
chunk__50312_50983 = G__50989;
count__50313_50984 = G__50990;
i__50314_50985 = G__50991;
continue;
} else {
var G__50992 = seq__50310_50982;
var G__50993 = chunk__50312_50983;
var G__50994 = count__50313_50984;
var G__50995 = (i__50314_50985 + (1));
seq__50310_50982 = G__50992;
chunk__50312_50983 = G__50993;
count__50313_50984 = G__50994;
i__50314_50985 = G__50995;
continue;
}
} else {
var temp__5720__auto___50996 = cljs.core.seq(seq__50310_50982);
if(temp__5720__auto___50996){
var seq__50310_50998__$1 = temp__5720__auto___50996;
if(cljs.core.chunked_seq_QMARK_(seq__50310_50998__$1)){
var c__4556__auto___50999 = cljs.core.chunk_first(seq__50310_50998__$1);
var G__51000 = cljs.core.chunk_rest(seq__50310_50998__$1);
var G__51001 = c__4556__auto___50999;
var G__51002 = cljs.core.count(c__4556__auto___50999);
var G__51003 = (0);
seq__50310_50982 = G__51000;
chunk__50312_50983 = G__51001;
count__50313_50984 = G__51002;
i__50314_50985 = G__51003;
continue;
} else {
var child_51004 = cljs.core.first(seq__50310_50998__$1);
if(cljs.core.truth_(child_51004)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_51004);


var G__51006 = cljs.core.next(seq__50310_50998__$1);
var G__51007 = null;
var G__51008 = (0);
var G__51009 = (0);
seq__50310_50982 = G__51006;
chunk__50312_50983 = G__51007;
count__50313_50984 = G__51008;
i__50314_50985 = G__51009;
continue;
} else {
var G__51010 = cljs.core.next(seq__50310_50998__$1);
var G__51011 = null;
var G__51012 = (0);
var G__51013 = (0);
seq__50310_50982 = G__51010;
chunk__50312_50983 = G__51011;
count__50313_50984 = G__51012;
i__50314_50985 = G__51013;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50980);
}


var G__51014 = seq__50280_50974;
var G__51015 = chunk__50281_50975;
var G__51016 = count__50282_50976;
var G__51017 = (i__50283_50977 + (1));
seq__50280_50974 = G__51014;
chunk__50281_50975 = G__51015;
count__50282_50976 = G__51016;
i__50283_50977 = G__51017;
continue;
} else {
var temp__5720__auto___51019 = cljs.core.seq(seq__50280_50974);
if(temp__5720__auto___51019){
var seq__50280_51020__$1 = temp__5720__auto___51019;
if(cljs.core.chunked_seq_QMARK_(seq__50280_51020__$1)){
var c__4556__auto___51022 = cljs.core.chunk_first(seq__50280_51020__$1);
var G__51024 = cljs.core.chunk_rest(seq__50280_51020__$1);
var G__51025 = c__4556__auto___51022;
var G__51026 = cljs.core.count(c__4556__auto___51022);
var G__51027 = (0);
seq__50280_50974 = G__51024;
chunk__50281_50975 = G__51025;
count__50282_50976 = G__51026;
i__50283_50977 = G__51027;
continue;
} else {
var child_struct_51028 = cljs.core.first(seq__50280_51020__$1);
var children_51029 = shadow.dom.dom_node(child_struct_51028);
if(cljs.core.seq_QMARK_(children_51029)){
var seq__50322_51030 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_51029));
var chunk__50324_51031 = null;
var count__50325_51032 = (0);
var i__50326_51033 = (0);
while(true){
if((i__50326_51033 < count__50325_51032)){
var child_51034 = chunk__50324_51031.cljs$core$IIndexed$_nth$arity$2(null,i__50326_51033);
if(cljs.core.truth_(child_51034)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_51034);


var G__51035 = seq__50322_51030;
var G__51036 = chunk__50324_51031;
var G__51037 = count__50325_51032;
var G__51038 = (i__50326_51033 + (1));
seq__50322_51030 = G__51035;
chunk__50324_51031 = G__51036;
count__50325_51032 = G__51037;
i__50326_51033 = G__51038;
continue;
} else {
var G__51040 = seq__50322_51030;
var G__51041 = chunk__50324_51031;
var G__51042 = count__50325_51032;
var G__51043 = (i__50326_51033 + (1));
seq__50322_51030 = G__51040;
chunk__50324_51031 = G__51041;
count__50325_51032 = G__51042;
i__50326_51033 = G__51043;
continue;
}
} else {
var temp__5720__auto___51044__$1 = cljs.core.seq(seq__50322_51030);
if(temp__5720__auto___51044__$1){
var seq__50322_51046__$1 = temp__5720__auto___51044__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50322_51046__$1)){
var c__4556__auto___51048 = cljs.core.chunk_first(seq__50322_51046__$1);
var G__51049 = cljs.core.chunk_rest(seq__50322_51046__$1);
var G__51050 = c__4556__auto___51048;
var G__51051 = cljs.core.count(c__4556__auto___51048);
var G__51052 = (0);
seq__50322_51030 = G__51049;
chunk__50324_51031 = G__51050;
count__50325_51032 = G__51051;
i__50326_51033 = G__51052;
continue;
} else {
var child_51053 = cljs.core.first(seq__50322_51046__$1);
if(cljs.core.truth_(child_51053)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_51053);


var G__51055 = cljs.core.next(seq__50322_51046__$1);
var G__51056 = null;
var G__51057 = (0);
var G__51058 = (0);
seq__50322_51030 = G__51055;
chunk__50324_51031 = G__51056;
count__50325_51032 = G__51057;
i__50326_51033 = G__51058;
continue;
} else {
var G__51060 = cljs.core.next(seq__50322_51046__$1);
var G__51061 = null;
var G__51062 = (0);
var G__51063 = (0);
seq__50322_51030 = G__51060;
chunk__50324_51031 = G__51061;
count__50325_51032 = G__51062;
i__50326_51033 = G__51063;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_51029);
}


var G__51065 = cljs.core.next(seq__50280_51020__$1);
var G__51066 = null;
var G__51067 = (0);
var G__51068 = (0);
seq__50280_50974 = G__51065;
chunk__50281_50975 = G__51066;
count__50282_50976 = G__51067;
i__50283_50977 = G__51068;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__50360 = cljs.core.seq(node);
var chunk__50361 = null;
var count__50362 = (0);
var i__50363 = (0);
while(true){
if((i__50363 < count__50362)){
var n = chunk__50361.cljs$core$IIndexed$_nth$arity$2(null,i__50363);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__51073 = seq__50360;
var G__51074 = chunk__50361;
var G__51075 = count__50362;
var G__51076 = (i__50363 + (1));
seq__50360 = G__51073;
chunk__50361 = G__51074;
count__50362 = G__51075;
i__50363 = G__51076;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__50360);
if(temp__5720__auto__){
var seq__50360__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50360__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__50360__$1);
var G__51078 = cljs.core.chunk_rest(seq__50360__$1);
var G__51079 = c__4556__auto__;
var G__51080 = cljs.core.count(c__4556__auto__);
var G__51081 = (0);
seq__50360 = G__51078;
chunk__50361 = G__51079;
count__50362 = G__51080;
i__50363 = G__51081;
continue;
} else {
var n = cljs.core.first(seq__50360__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__51082 = cljs.core.next(seq__50360__$1);
var G__51083 = null;
var G__51084 = (0);
var G__51085 = (0);
seq__50360 = G__51082;
chunk__50361 = G__51083;
count__50362 = G__51084;
i__50363 = G__51085;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__50381 = arguments.length;
switch (G__50381) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__50384 = arguments.length;
switch (G__50384) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__50399 = arguments.length;
switch (G__50399) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___51105 = arguments.length;
var i__4737__auto___51106 = (0);
while(true){
if((i__4737__auto___51106 < len__4736__auto___51105)){
args__4742__auto__.push((arguments[i__4737__auto___51106]));

var G__51107 = (i__4737__auto___51106 + (1));
i__4737__auto___51106 = G__51107;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__50427_51108 = cljs.core.seq(nodes);
var chunk__50428_51109 = null;
var count__50429_51110 = (0);
var i__50430_51111 = (0);
while(true){
if((i__50430_51111 < count__50429_51110)){
var node_51113 = chunk__50428_51109.cljs$core$IIndexed$_nth$arity$2(null,i__50430_51111);
fragment.appendChild(shadow.dom._to_dom(node_51113));


var G__51116 = seq__50427_51108;
var G__51117 = chunk__50428_51109;
var G__51118 = count__50429_51110;
var G__51119 = (i__50430_51111 + (1));
seq__50427_51108 = G__51116;
chunk__50428_51109 = G__51117;
count__50429_51110 = G__51118;
i__50430_51111 = G__51119;
continue;
} else {
var temp__5720__auto___51120 = cljs.core.seq(seq__50427_51108);
if(temp__5720__auto___51120){
var seq__50427_51121__$1 = temp__5720__auto___51120;
if(cljs.core.chunked_seq_QMARK_(seq__50427_51121__$1)){
var c__4556__auto___51123 = cljs.core.chunk_first(seq__50427_51121__$1);
var G__51124 = cljs.core.chunk_rest(seq__50427_51121__$1);
var G__51125 = c__4556__auto___51123;
var G__51126 = cljs.core.count(c__4556__auto___51123);
var G__51127 = (0);
seq__50427_51108 = G__51124;
chunk__50428_51109 = G__51125;
count__50429_51110 = G__51126;
i__50430_51111 = G__51127;
continue;
} else {
var node_51128 = cljs.core.first(seq__50427_51121__$1);
fragment.appendChild(shadow.dom._to_dom(node_51128));


var G__51129 = cljs.core.next(seq__50427_51121__$1);
var G__51130 = null;
var G__51131 = (0);
var G__51132 = (0);
seq__50427_51108 = G__51129;
chunk__50428_51109 = G__51130;
count__50429_51110 = G__51131;
i__50430_51111 = G__51132;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq50424){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq50424));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__50437_51135 = cljs.core.seq(scripts);
var chunk__50438_51136 = null;
var count__50439_51137 = (0);
var i__50440_51138 = (0);
while(true){
if((i__50440_51138 < count__50439_51137)){
var vec__50454_51139 = chunk__50438_51136.cljs$core$IIndexed$_nth$arity$2(null,i__50440_51138);
var script_tag_51140 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50454_51139,(0),null);
var script_body_51141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50454_51139,(1),null);
eval(script_body_51141);


var G__51144 = seq__50437_51135;
var G__51145 = chunk__50438_51136;
var G__51146 = count__50439_51137;
var G__51147 = (i__50440_51138 + (1));
seq__50437_51135 = G__51144;
chunk__50438_51136 = G__51145;
count__50439_51137 = G__51146;
i__50440_51138 = G__51147;
continue;
} else {
var temp__5720__auto___51149 = cljs.core.seq(seq__50437_51135);
if(temp__5720__auto___51149){
var seq__50437_51151__$1 = temp__5720__auto___51149;
if(cljs.core.chunked_seq_QMARK_(seq__50437_51151__$1)){
var c__4556__auto___51152 = cljs.core.chunk_first(seq__50437_51151__$1);
var G__51153 = cljs.core.chunk_rest(seq__50437_51151__$1);
var G__51154 = c__4556__auto___51152;
var G__51155 = cljs.core.count(c__4556__auto___51152);
var G__51156 = (0);
seq__50437_51135 = G__51153;
chunk__50438_51136 = G__51154;
count__50439_51137 = G__51155;
i__50440_51138 = G__51156;
continue;
} else {
var vec__50462_51158 = cljs.core.first(seq__50437_51151__$1);
var script_tag_51159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50462_51158,(0),null);
var script_body_51160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50462_51158,(1),null);
eval(script_body_51160);


var G__51162 = cljs.core.next(seq__50437_51151__$1);
var G__51163 = null;
var G__51164 = (0);
var G__51165 = (0);
seq__50437_51135 = G__51162;
chunk__50438_51136 = G__51163;
count__50439_51137 = G__51164;
i__50440_51138 = G__51165;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__50465){
var vec__50466 = p__50465;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50466,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50466,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__50477 = arguments.length;
switch (G__50477) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__50504 = cljs.core.seq(style_keys);
var chunk__50505 = null;
var count__50506 = (0);
var i__50507 = (0);
while(true){
if((i__50507 < count__50506)){
var it = chunk__50505.cljs$core$IIndexed$_nth$arity$2(null,i__50507);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__51177 = seq__50504;
var G__51178 = chunk__50505;
var G__51179 = count__50506;
var G__51180 = (i__50507 + (1));
seq__50504 = G__51177;
chunk__50505 = G__51178;
count__50506 = G__51179;
i__50507 = G__51180;
continue;
} else {
var temp__5720__auto__ = cljs.core.seq(seq__50504);
if(temp__5720__auto__){
var seq__50504__$1 = temp__5720__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50504__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__50504__$1);
var G__51181 = cljs.core.chunk_rest(seq__50504__$1);
var G__51182 = c__4556__auto__;
var G__51183 = cljs.core.count(c__4556__auto__);
var G__51184 = (0);
seq__50504 = G__51181;
chunk__50505 = G__51182;
count__50506 = G__51183;
i__50507 = G__51184;
continue;
} else {
var it = cljs.core.first(seq__50504__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__51185 = cljs.core.next(seq__50504__$1);
var G__51186 = null;
var G__51187 = (0);
var G__51188 = (0);
seq__50504 = G__51185;
chunk__50505 = G__51186;
count__50506 = G__51187;
i__50507 = G__51188;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k50519,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__50539 = k50519;
var G__50539__$1 = (((G__50539 instanceof cljs.core.Keyword))?G__50539.fqn:null);
switch (G__50539__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k50519,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__50541){
var vec__50544 = p__50541;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50544,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50544,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50518){
var self__ = this;
var G__50518__$1 = this;
return (new cljs.core.RecordIter((0),G__50518__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this50520,other50521){
var self__ = this;
var this50520__$1 = this;
return (((!((other50521 == null)))) && ((this50520__$1.constructor === other50521.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50520__$1.x,other50521.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50520__$1.y,other50521.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50520__$1.__extmap,other50521.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__50518){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__50561 = cljs.core.keyword_identical_QMARK_;
var expr__50562 = k__4388__auto__;
if(cljs.core.truth_((pred__50561.cljs$core$IFn$_invoke$arity$2 ? pred__50561.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__50562) : pred__50561.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__50562)))){
return (new shadow.dom.Coordinate(G__50518,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__50561.cljs$core$IFn$_invoke$arity$2 ? pred__50561.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__50562) : pred__50561.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__50562)))){
return (new shadow.dom.Coordinate(self__.x,G__50518,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__50518),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__50518){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__50518,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__50530){
var extmap__4419__auto__ = (function (){var G__50567 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__50530,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__50530)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__50567);
} else {
return G__50567;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__50530),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__50530),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k50575,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__50580 = k50575;
var G__50580__$1 = (((G__50580 instanceof cljs.core.Keyword))?G__50580.fqn:null);
switch (G__50580__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k50575,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__50581){
var vec__50582 = p__50581;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50582,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50582,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50574){
var self__ = this;
var G__50574__$1 = this;
return (new cljs.core.RecordIter((0),G__50574__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this50576,other50577){
var self__ = this;
var this50576__$1 = this;
return (((!((other50577 == null)))) && ((this50576__$1.constructor === other50577.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50576__$1.w,other50577.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50576__$1.h,other50577.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50576__$1.__extmap,other50577.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__50574){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__50592 = cljs.core.keyword_identical_QMARK_;
var expr__50593 = k__4388__auto__;
if(cljs.core.truth_((pred__50592.cljs$core$IFn$_invoke$arity$2 ? pred__50592.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__50593) : pred__50592.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__50593)))){
return (new shadow.dom.Size(G__50574,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__50592.cljs$core$IFn$_invoke$arity$2 ? pred__50592.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__50593) : pred__50592.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__50593)))){
return (new shadow.dom.Size(self__.w,G__50574,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__50574),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__50574){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__50574,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__50578){
var extmap__4419__auto__ = (function (){var G__50605 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__50578,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__50578)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__50605);
} else {
return G__50605;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__50578),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__50578),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__51259 = (i + (1));
var G__51260 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__51259;
ret = G__51260;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__50638){
var vec__50640 = p__50638;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50640,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50640,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__50648 = arguments.length;
switch (G__50648) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5718__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5718__auto__)){
var child = temp__5718__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__51280 = ps;
var G__51281 = (i + (1));
el__$1 = G__51280;
i = G__51281;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__50673 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50673,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50673,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50673,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__50677_51294 = cljs.core.seq(props);
var chunk__50678_51295 = null;
var count__50679_51296 = (0);
var i__50680_51297 = (0);
while(true){
if((i__50680_51297 < count__50679_51296)){
var vec__50690_51304 = chunk__50678_51295.cljs$core$IIndexed$_nth$arity$2(null,i__50680_51297);
var k_51305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50690_51304,(0),null);
var v_51306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50690_51304,(1),null);
el.setAttributeNS((function (){var temp__5720__auto__ = cljs.core.namespace(k_51305);
if(cljs.core.truth_(temp__5720__auto__)){
var ns = temp__5720__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_51305),v_51306);


var G__51310 = seq__50677_51294;
var G__51311 = chunk__50678_51295;
var G__51312 = count__50679_51296;
var G__51313 = (i__50680_51297 + (1));
seq__50677_51294 = G__51310;
chunk__50678_51295 = G__51311;
count__50679_51296 = G__51312;
i__50680_51297 = G__51313;
continue;
} else {
var temp__5720__auto___51314 = cljs.core.seq(seq__50677_51294);
if(temp__5720__auto___51314){
var seq__50677_51315__$1 = temp__5720__auto___51314;
if(cljs.core.chunked_seq_QMARK_(seq__50677_51315__$1)){
var c__4556__auto___51316 = cljs.core.chunk_first(seq__50677_51315__$1);
var G__51317 = cljs.core.chunk_rest(seq__50677_51315__$1);
var G__51318 = c__4556__auto___51316;
var G__51319 = cljs.core.count(c__4556__auto___51316);
var G__51320 = (0);
seq__50677_51294 = G__51317;
chunk__50678_51295 = G__51318;
count__50679_51296 = G__51319;
i__50680_51297 = G__51320;
continue;
} else {
var vec__50694_51321 = cljs.core.first(seq__50677_51315__$1);
var k_51322 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50694_51321,(0),null);
var v_51323 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50694_51321,(1),null);
el.setAttributeNS((function (){var temp__5720__auto____$1 = cljs.core.namespace(k_51322);
if(cljs.core.truth_(temp__5720__auto____$1)){
var ns = temp__5720__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_51322),v_51323);


var G__51327 = cljs.core.next(seq__50677_51315__$1);
var G__51328 = null;
var G__51329 = (0);
var G__51330 = (0);
seq__50677_51294 = G__51327;
chunk__50678_51295 = G__51328;
count__50679_51296 = G__51329;
i__50680_51297 = G__51330;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__50699 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50699,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50699,(1),null);
var seq__50702_51334 = cljs.core.seq(node_children);
var chunk__50704_51335 = null;
var count__50705_51336 = (0);
var i__50706_51337 = (0);
while(true){
if((i__50706_51337 < count__50705_51336)){
var child_struct_51338 = chunk__50704_51335.cljs$core$IIndexed$_nth$arity$2(null,i__50706_51337);
if((!((child_struct_51338 == null)))){
if(typeof child_struct_51338 === 'string'){
var text_51339 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_51339),child_struct_51338].join(''));
} else {
var children_51340 = shadow.dom.svg_node(child_struct_51338);
if(cljs.core.seq_QMARK_(children_51340)){
var seq__50736_51345 = cljs.core.seq(children_51340);
var chunk__50738_51346 = null;
var count__50739_51347 = (0);
var i__50740_51348 = (0);
while(true){
if((i__50740_51348 < count__50739_51347)){
var child_51349 = chunk__50738_51346.cljs$core$IIndexed$_nth$arity$2(null,i__50740_51348);
if(cljs.core.truth_(child_51349)){
node.appendChild(child_51349);


var G__51350 = seq__50736_51345;
var G__51351 = chunk__50738_51346;
var G__51352 = count__50739_51347;
var G__51353 = (i__50740_51348 + (1));
seq__50736_51345 = G__51350;
chunk__50738_51346 = G__51351;
count__50739_51347 = G__51352;
i__50740_51348 = G__51353;
continue;
} else {
var G__51354 = seq__50736_51345;
var G__51355 = chunk__50738_51346;
var G__51356 = count__50739_51347;
var G__51357 = (i__50740_51348 + (1));
seq__50736_51345 = G__51354;
chunk__50738_51346 = G__51355;
count__50739_51347 = G__51356;
i__50740_51348 = G__51357;
continue;
}
} else {
var temp__5720__auto___51358 = cljs.core.seq(seq__50736_51345);
if(temp__5720__auto___51358){
var seq__50736_51359__$1 = temp__5720__auto___51358;
if(cljs.core.chunked_seq_QMARK_(seq__50736_51359__$1)){
var c__4556__auto___51360 = cljs.core.chunk_first(seq__50736_51359__$1);
var G__51361 = cljs.core.chunk_rest(seq__50736_51359__$1);
var G__51362 = c__4556__auto___51360;
var G__51363 = cljs.core.count(c__4556__auto___51360);
var G__51364 = (0);
seq__50736_51345 = G__51361;
chunk__50738_51346 = G__51362;
count__50739_51347 = G__51363;
i__50740_51348 = G__51364;
continue;
} else {
var child_51365 = cljs.core.first(seq__50736_51359__$1);
if(cljs.core.truth_(child_51365)){
node.appendChild(child_51365);


var G__51367 = cljs.core.next(seq__50736_51359__$1);
var G__51368 = null;
var G__51369 = (0);
var G__51370 = (0);
seq__50736_51345 = G__51367;
chunk__50738_51346 = G__51368;
count__50739_51347 = G__51369;
i__50740_51348 = G__51370;
continue;
} else {
var G__51374 = cljs.core.next(seq__50736_51359__$1);
var G__51375 = null;
var G__51376 = (0);
var G__51377 = (0);
seq__50736_51345 = G__51374;
chunk__50738_51346 = G__51375;
count__50739_51347 = G__51376;
i__50740_51348 = G__51377;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_51340);
}
}


var G__51378 = seq__50702_51334;
var G__51379 = chunk__50704_51335;
var G__51380 = count__50705_51336;
var G__51381 = (i__50706_51337 + (1));
seq__50702_51334 = G__51378;
chunk__50704_51335 = G__51379;
count__50705_51336 = G__51380;
i__50706_51337 = G__51381;
continue;
} else {
var G__51382 = seq__50702_51334;
var G__51383 = chunk__50704_51335;
var G__51384 = count__50705_51336;
var G__51385 = (i__50706_51337 + (1));
seq__50702_51334 = G__51382;
chunk__50704_51335 = G__51383;
count__50705_51336 = G__51384;
i__50706_51337 = G__51385;
continue;
}
} else {
var temp__5720__auto___51386 = cljs.core.seq(seq__50702_51334);
if(temp__5720__auto___51386){
var seq__50702_51387__$1 = temp__5720__auto___51386;
if(cljs.core.chunked_seq_QMARK_(seq__50702_51387__$1)){
var c__4556__auto___51388 = cljs.core.chunk_first(seq__50702_51387__$1);
var G__51389 = cljs.core.chunk_rest(seq__50702_51387__$1);
var G__51390 = c__4556__auto___51388;
var G__51391 = cljs.core.count(c__4556__auto___51388);
var G__51392 = (0);
seq__50702_51334 = G__51389;
chunk__50704_51335 = G__51390;
count__50705_51336 = G__51391;
i__50706_51337 = G__51392;
continue;
} else {
var child_struct_51393 = cljs.core.first(seq__50702_51387__$1);
if((!((child_struct_51393 == null)))){
if(typeof child_struct_51393 === 'string'){
var text_51394 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_51394),child_struct_51393].join(''));
} else {
var children_51395 = shadow.dom.svg_node(child_struct_51393);
if(cljs.core.seq_QMARK_(children_51395)){
var seq__50753_51396 = cljs.core.seq(children_51395);
var chunk__50755_51397 = null;
var count__50756_51398 = (0);
var i__50757_51399 = (0);
while(true){
if((i__50757_51399 < count__50756_51398)){
var child_51400 = chunk__50755_51397.cljs$core$IIndexed$_nth$arity$2(null,i__50757_51399);
if(cljs.core.truth_(child_51400)){
node.appendChild(child_51400);


var G__51401 = seq__50753_51396;
var G__51402 = chunk__50755_51397;
var G__51403 = count__50756_51398;
var G__51404 = (i__50757_51399 + (1));
seq__50753_51396 = G__51401;
chunk__50755_51397 = G__51402;
count__50756_51398 = G__51403;
i__50757_51399 = G__51404;
continue;
} else {
var G__51405 = seq__50753_51396;
var G__51406 = chunk__50755_51397;
var G__51407 = count__50756_51398;
var G__51408 = (i__50757_51399 + (1));
seq__50753_51396 = G__51405;
chunk__50755_51397 = G__51406;
count__50756_51398 = G__51407;
i__50757_51399 = G__51408;
continue;
}
} else {
var temp__5720__auto___51409__$1 = cljs.core.seq(seq__50753_51396);
if(temp__5720__auto___51409__$1){
var seq__50753_51410__$1 = temp__5720__auto___51409__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50753_51410__$1)){
var c__4556__auto___51411 = cljs.core.chunk_first(seq__50753_51410__$1);
var G__51412 = cljs.core.chunk_rest(seq__50753_51410__$1);
var G__51413 = c__4556__auto___51411;
var G__51414 = cljs.core.count(c__4556__auto___51411);
var G__51415 = (0);
seq__50753_51396 = G__51412;
chunk__50755_51397 = G__51413;
count__50756_51398 = G__51414;
i__50757_51399 = G__51415;
continue;
} else {
var child_51418 = cljs.core.first(seq__50753_51410__$1);
if(cljs.core.truth_(child_51418)){
node.appendChild(child_51418);


var G__51419 = cljs.core.next(seq__50753_51410__$1);
var G__51420 = null;
var G__51421 = (0);
var G__51422 = (0);
seq__50753_51396 = G__51419;
chunk__50755_51397 = G__51420;
count__50756_51398 = G__51421;
i__50757_51399 = G__51422;
continue;
} else {
var G__51423 = cljs.core.next(seq__50753_51410__$1);
var G__51424 = null;
var G__51425 = (0);
var G__51426 = (0);
seq__50753_51396 = G__51423;
chunk__50755_51397 = G__51424;
count__50756_51398 = G__51425;
i__50757_51399 = G__51426;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_51395);
}
}


var G__51432 = cljs.core.next(seq__50702_51387__$1);
var G__51433 = null;
var G__51434 = (0);
var G__51435 = (0);
seq__50702_51334 = G__51432;
chunk__50704_51335 = G__51433;
count__50705_51336 = G__51434;
i__50706_51337 = G__51435;
continue;
} else {
var G__51436 = cljs.core.next(seq__50702_51387__$1);
var G__51437 = null;
var G__51438 = (0);
var G__51439 = (0);
seq__50702_51334 = G__51436;
chunk__50704_51335 = G__51437;
count__50705_51336 = G__51438;
i__50706_51337 = G__51439;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___51470 = arguments.length;
var i__4737__auto___51471 = (0);
while(true){
if((i__4737__auto___51471 < len__4736__auto___51470)){
args__4742__auto__.push((arguments[i__4737__auto___51471]));

var G__51472 = (i__4737__auto___51471 + (1));
i__4737__auto___51471 = G__51472;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq50774){
var G__50775 = cljs.core.first(seq50774);
var seq50774__$1 = cljs.core.next(seq50774);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50775,seq50774__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__50795 = arguments.length;
switch (G__50795) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__41778__auto___51488 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_50805){
var state_val_50806 = (state_50805[(1)]);
if((state_val_50806 === (1))){
var state_50805__$1 = state_50805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50805__$1,(2),once_or_cleanup);
} else {
if((state_val_50806 === (2))){
var inst_50802 = (state_50805[(2)]);
var inst_50803 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_50805__$1 = (function (){var statearr_50810 = state_50805;
(statearr_50810[(7)] = inst_50802);

return statearr_50810;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50805__$1,inst_50803);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__41689__auto__ = null;
var shadow$dom$state_machine__41689__auto____0 = (function (){
var statearr_50811 = [null,null,null,null,null,null,null,null];
(statearr_50811[(0)] = shadow$dom$state_machine__41689__auto__);

(statearr_50811[(1)] = (1));

return statearr_50811;
});
var shadow$dom$state_machine__41689__auto____1 = (function (state_50805){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_50805);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e50814){if((e50814 instanceof Object)){
var ex__41692__auto__ = e50814;
var statearr_50815_51494 = state_50805;
(statearr_50815_51494[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50805);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e50814;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51495 = state_50805;
state_50805 = G__51495;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
shadow$dom$state_machine__41689__auto__ = function(state_50805){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__41689__auto____0.call(this);
case 1:
return shadow$dom$state_machine__41689__auto____1.call(this,state_50805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__41689__auto____0;
shadow$dom$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__41689__auto____1;
return shadow$dom$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_50817 = f__41779__auto__();
(statearr_50817[(6)] = c__41778__auto___51488);

return statearr_50817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
