goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__47761 = arguments.length;
switch (G__47761) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47766 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47766 = (function (f,blockable,meta47767){
this.f = f;
this.blockable = blockable;
this.meta47767 = meta47767;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47766.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47768,meta47767__$1){
var self__ = this;
var _47768__$1 = this;
return (new cljs.core.async.t_cljs$core$async47766(self__.f,self__.blockable,meta47767__$1));
}));

(cljs.core.async.t_cljs$core$async47766.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47768){
var self__ = this;
var _47768__$1 = this;
return self__.meta47767;
}));

(cljs.core.async.t_cljs$core$async47766.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47766.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47766.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async47766.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async47766.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta47767","meta47767",-608024469,null)], null);
}));

(cljs.core.async.t_cljs$core$async47766.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47766.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47766");

(cljs.core.async.t_cljs$core$async47766.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47766");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47766.
 */
cljs.core.async.__GT_t_cljs$core$async47766 = (function cljs$core$async$__GT_t_cljs$core$async47766(f__$1,blockable__$1,meta47767){
return (new cljs.core.async.t_cljs$core$async47766(f__$1,blockable__$1,meta47767));
});

}

return (new cljs.core.async.t_cljs$core$async47766(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__47789 = arguments.length;
switch (G__47789) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__47794 = arguments.length;
switch (G__47794) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__47817 = arguments.length;
switch (G__47817) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_49998 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49998) : fn1.call(null,val_49998));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49998) : fn1.call(null,val_49998));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__47827 = arguments.length;
switch (G__47827) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5718__auto__)){
var ret = temp__5718__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5718__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5718__auto__)){
var retb = temp__5718__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___50013 = n;
var x_50014 = (0);
while(true){
if((x_50014 < n__4613__auto___50013)){
(a[x_50014] = x_50014);

var G__50015 = (x_50014 + (1));
x_50014 = G__50015;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47839 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47839 = (function (flag,meta47840){
this.flag = flag;
this.meta47840 = meta47840;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47839.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47841,meta47840__$1){
var self__ = this;
var _47841__$1 = this;
return (new cljs.core.async.t_cljs$core$async47839(self__.flag,meta47840__$1));
}));

(cljs.core.async.t_cljs$core$async47839.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47841){
var self__ = this;
var _47841__$1 = this;
return self__.meta47840;
}));

(cljs.core.async.t_cljs$core$async47839.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47839.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47839.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47839.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async47839.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta47840","meta47840",-48915090,null)], null);
}));

(cljs.core.async.t_cljs$core$async47839.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47839.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47839");

(cljs.core.async.t_cljs$core$async47839.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47839");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47839.
 */
cljs.core.async.__GT_t_cljs$core$async47839 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async47839(flag__$1,meta47840){
return (new cljs.core.async.t_cljs$core$async47839(flag__$1,meta47840));
});

}

return (new cljs.core.async.t_cljs$core$async47839(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47843 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47843 = (function (flag,cb,meta47844){
this.flag = flag;
this.cb = cb;
this.meta47844 = meta47844;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47843.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47845,meta47844__$1){
var self__ = this;
var _47845__$1 = this;
return (new cljs.core.async.t_cljs$core$async47843(self__.flag,self__.cb,meta47844__$1));
}));

(cljs.core.async.t_cljs$core$async47843.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47845){
var self__ = this;
var _47845__$1 = this;
return self__.meta47844;
}));

(cljs.core.async.t_cljs$core$async47843.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47843.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47843.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47843.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async47843.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta47844","meta47844",1449625420,null)], null);
}));

(cljs.core.async.t_cljs$core$async47843.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47843.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47843");

(cljs.core.async.t_cljs$core$async47843.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47843");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47843.
 */
cljs.core.async.__GT_t_cljs$core$async47843 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async47843(flag__$1,cb__$1,meta47844){
return (new cljs.core.async.t_cljs$core$async47843(flag__$1,cb__$1,meta47844));
});

}

return (new cljs.core.async.t_cljs$core$async47843(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47847_SHARP_){
var G__47851 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47847_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47851) : fret.call(null,G__47851));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47848_SHARP_){
var G__47854 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47848_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47854) : fret.call(null,G__47854));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__50018 = (i + (1));
i = G__50018;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5720__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5720__auto__)){
var got = temp__5720__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50020 = arguments.length;
var i__4737__auto___50021 = (0);
while(true){
if((i__4737__auto___50021 < len__4736__auto___50020)){
args__4742__auto__.push((arguments[i__4737__auto___50021]));

var G__50022 = (i__4737__auto___50021 + (1));
i__4737__auto___50021 = G__50022;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__47859){
var map__47860 = p__47859;
var map__47860__$1 = (((((!((map__47860 == null))))?(((((map__47860.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47860.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47860):map__47860);
var opts = map__47860__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq47857){
var G__47858 = cljs.core.first(seq47857);
var seq47857__$1 = cljs.core.next(seq47857);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47858,seq47857__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__47864 = arguments.length;
switch (G__47864) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__41778__auto___50040 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_47896){
var state_val_47897 = (state_47896[(1)]);
if((state_val_47897 === (7))){
var inst_47892 = (state_47896[(2)]);
var state_47896__$1 = state_47896;
var statearr_47904_50042 = state_47896__$1;
(statearr_47904_50042[(2)] = inst_47892);

(statearr_47904_50042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (1))){
var state_47896__$1 = state_47896;
var statearr_47905_50043 = state_47896__$1;
(statearr_47905_50043[(2)] = null);

(statearr_47905_50043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (4))){
var inst_47872 = (state_47896[(7)]);
var inst_47872__$1 = (state_47896[(2)]);
var inst_47873 = (inst_47872__$1 == null);
var state_47896__$1 = (function (){var statearr_47906 = state_47896;
(statearr_47906[(7)] = inst_47872__$1);

return statearr_47906;
})();
if(cljs.core.truth_(inst_47873)){
var statearr_47907_50044 = state_47896__$1;
(statearr_47907_50044[(1)] = (5));

} else {
var statearr_47908_50045 = state_47896__$1;
(statearr_47908_50045[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (13))){
var state_47896__$1 = state_47896;
var statearr_47909_50047 = state_47896__$1;
(statearr_47909_50047[(2)] = null);

(statearr_47909_50047[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (6))){
var inst_47872 = (state_47896[(7)]);
var state_47896__$1 = state_47896;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47896__$1,(11),to,inst_47872);
} else {
if((state_val_47897 === (3))){
var inst_47894 = (state_47896[(2)]);
var state_47896__$1 = state_47896;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47896__$1,inst_47894);
} else {
if((state_val_47897 === (12))){
var state_47896__$1 = state_47896;
var statearr_47912_50049 = state_47896__$1;
(statearr_47912_50049[(2)] = null);

(statearr_47912_50049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (2))){
var state_47896__$1 = state_47896;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47896__$1,(4),from);
} else {
if((state_val_47897 === (11))){
var inst_47885 = (state_47896[(2)]);
var state_47896__$1 = state_47896;
if(cljs.core.truth_(inst_47885)){
var statearr_47913_50050 = state_47896__$1;
(statearr_47913_50050[(1)] = (12));

} else {
var statearr_47914_50051 = state_47896__$1;
(statearr_47914_50051[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (9))){
var state_47896__$1 = state_47896;
var statearr_47916_50052 = state_47896__$1;
(statearr_47916_50052[(2)] = null);

(statearr_47916_50052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (5))){
var state_47896__$1 = state_47896;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47919_50054 = state_47896__$1;
(statearr_47919_50054[(1)] = (8));

} else {
var statearr_47920_50059 = state_47896__$1;
(statearr_47920_50059[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (14))){
var inst_47890 = (state_47896[(2)]);
var state_47896__$1 = state_47896;
var statearr_47921_50061 = state_47896__$1;
(statearr_47921_50061[(2)] = inst_47890);

(statearr_47921_50061[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (10))){
var inst_47879 = (state_47896[(2)]);
var state_47896__$1 = state_47896;
var statearr_47923_50063 = state_47896__$1;
(statearr_47923_50063[(2)] = inst_47879);

(statearr_47923_50063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47897 === (8))){
var inst_47876 = cljs.core.async.close_BANG_(to);
var state_47896__$1 = state_47896;
var statearr_47924_50068 = state_47896__$1;
(statearr_47924_50068[(2)] = inst_47876);

(statearr_47924_50068[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_47925 = [null,null,null,null,null,null,null,null];
(statearr_47925[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_47925[(1)] = (1));

return statearr_47925;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_47896){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_47896);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e47926){if((e47926 instanceof Object)){
var ex__41692__auto__ = e47926;
var statearr_47927_50069 = state_47896;
(statearr_47927_50069[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47896);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47926;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50070 = state_47896;
state_47896 = G__50070;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_47896){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_47896);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_47929 = f__41779__auto__();
(statearr_47929[(6)] = c__41778__auto___50040);

return statearr_47929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__47938){
var vec__47939 = p__47938;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47939,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47939,(1),null);
var job = vec__47939;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__41778__auto___50073 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_47946){
var state_val_47947 = (state_47946[(1)]);
if((state_val_47947 === (1))){
var state_47946__$1 = state_47946;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47946__$1,(2),res,v);
} else {
if((state_val_47947 === (2))){
var inst_47943 = (state_47946[(2)]);
var inst_47944 = cljs.core.async.close_BANG_(res);
var state_47946__$1 = (function (){var statearr_47948 = state_47946;
(statearr_47948[(7)] = inst_47943);

return statearr_47948;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47946__$1,inst_47944);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0 = (function (){
var statearr_47949 = [null,null,null,null,null,null,null,null];
(statearr_47949[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__);

(statearr_47949[(1)] = (1));

return statearr_47949;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1 = (function (state_47946){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_47946);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e47950){if((e47950 instanceof Object)){
var ex__41692__auto__ = e47950;
var statearr_47952_50078 = state_47946;
(statearr_47952_50078[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47946);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47950;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50080 = state_47946;
state_47946 = G__50080;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = function(state_47946){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1.call(this,state_47946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_47954 = f__41779__auto__();
(statearr_47954[(6)] = c__41778__auto___50073);

return statearr_47954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__47956){
var vec__47958 = p__47956;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47958,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47958,(1),null);
var job = vec__47958;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___50082 = n;
var __50083 = (0);
while(true){
if((__50083 < n__4613__auto___50082)){
var G__47962_50084 = type;
var G__47962_50085__$1 = (((G__47962_50084 instanceof cljs.core.Keyword))?G__47962_50084.fqn:null);
switch (G__47962_50085__$1) {
case "compute":
var c__41778__auto___50087 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__50083,c__41778__auto___50087,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async){
return (function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = ((function (__50083,c__41778__auto___50087,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async){
return (function (state_47976){
var state_val_47977 = (state_47976[(1)]);
if((state_val_47977 === (1))){
var state_47976__$1 = state_47976;
var statearr_47981_50088 = state_47976__$1;
(statearr_47981_50088[(2)] = null);

(statearr_47981_50088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47977 === (2))){
var state_47976__$1 = state_47976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47976__$1,(4),jobs);
} else {
if((state_val_47977 === (3))){
var inst_47974 = (state_47976[(2)]);
var state_47976__$1 = state_47976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47976__$1,inst_47974);
} else {
if((state_val_47977 === (4))){
var inst_47966 = (state_47976[(2)]);
var inst_47967 = process(inst_47966);
var state_47976__$1 = state_47976;
if(cljs.core.truth_(inst_47967)){
var statearr_47987_50094 = state_47976__$1;
(statearr_47987_50094[(1)] = (5));

} else {
var statearr_47988_50095 = state_47976__$1;
(statearr_47988_50095[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47977 === (5))){
var state_47976__$1 = state_47976;
var statearr_47992_50096 = state_47976__$1;
(statearr_47992_50096[(2)] = null);

(statearr_47992_50096[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47977 === (6))){
var state_47976__$1 = state_47976;
var statearr_47993_50098 = state_47976__$1;
(statearr_47993_50098[(2)] = null);

(statearr_47993_50098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47977 === (7))){
var inst_47972 = (state_47976[(2)]);
var state_47976__$1 = state_47976;
var statearr_47997_50103 = state_47976__$1;
(statearr_47997_50103[(2)] = inst_47972);

(statearr_47997_50103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__50083,c__41778__auto___50087,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async))
;
return ((function (__50083,switch__41688__auto__,c__41778__auto___50087,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0 = (function (){
var statearr_48000 = [null,null,null,null,null,null,null];
(statearr_48000[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__);

(statearr_48000[(1)] = (1));

return statearr_48000;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1 = (function (state_47976){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_47976);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48001){if((e48001 instanceof Object)){
var ex__41692__auto__ = e48001;
var statearr_48002_50104 = state_47976;
(statearr_48002_50104[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_47976);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48001;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50109 = state_47976;
state_47976 = G__50109;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = function(state_47976){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1.call(this,state_47976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__;
})()
;})(__50083,switch__41688__auto__,c__41778__auto___50087,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async))
})();
var state__41780__auto__ = (function (){var statearr_48003 = f__41779__auto__();
(statearr_48003[(6)] = c__41778__auto___50087);

return statearr_48003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
});})(__50083,c__41778__auto___50087,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async))
);


break;
case "async":
var c__41778__auto___50110 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__50083,c__41778__auto___50110,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async){
return (function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = ((function (__50083,c__41778__auto___50110,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async){
return (function (state_48017){
var state_val_48018 = (state_48017[(1)]);
if((state_val_48018 === (1))){
var state_48017__$1 = state_48017;
var statearr_48021_50112 = state_48017__$1;
(statearr_48021_50112[(2)] = null);

(statearr_48021_50112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48018 === (2))){
var state_48017__$1 = state_48017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48017__$1,(4),jobs);
} else {
if((state_val_48018 === (3))){
var inst_48015 = (state_48017[(2)]);
var state_48017__$1 = state_48017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48017__$1,inst_48015);
} else {
if((state_val_48018 === (4))){
var inst_48007 = (state_48017[(2)]);
var inst_48008 = async(inst_48007);
var state_48017__$1 = state_48017;
if(cljs.core.truth_(inst_48008)){
var statearr_48023_50116 = state_48017__$1;
(statearr_48023_50116[(1)] = (5));

} else {
var statearr_48024_50117 = state_48017__$1;
(statearr_48024_50117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48018 === (5))){
var state_48017__$1 = state_48017;
var statearr_48026_50119 = state_48017__$1;
(statearr_48026_50119[(2)] = null);

(statearr_48026_50119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48018 === (6))){
var state_48017__$1 = state_48017;
var statearr_48027_50124 = state_48017__$1;
(statearr_48027_50124[(2)] = null);

(statearr_48027_50124[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48018 === (7))){
var inst_48013 = (state_48017[(2)]);
var state_48017__$1 = state_48017;
var statearr_48028_50125 = state_48017__$1;
(statearr_48028_50125[(2)] = inst_48013);

(statearr_48028_50125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__50083,c__41778__auto___50110,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async))
;
return ((function (__50083,switch__41688__auto__,c__41778__auto___50110,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0 = (function (){
var statearr_48029 = [null,null,null,null,null,null,null];
(statearr_48029[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__);

(statearr_48029[(1)] = (1));

return statearr_48029;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1 = (function (state_48017){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48017);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48030){if((e48030 instanceof Object)){
var ex__41692__auto__ = e48030;
var statearr_48031_50127 = state_48017;
(statearr_48031_50127[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48030;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50129 = state_48017;
state_48017 = G__50129;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = function(state_48017){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1.call(this,state_48017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__;
})()
;})(__50083,switch__41688__auto__,c__41778__auto___50110,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async))
})();
var state__41780__auto__ = (function (){var statearr_48032 = f__41779__auto__();
(statearr_48032[(6)] = c__41778__auto___50110);

return statearr_48032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
});})(__50083,c__41778__auto___50110,G__47962_50084,G__47962_50085__$1,n__4613__auto___50082,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47962_50085__$1)].join('')));

}

var G__50132 = (__50083 + (1));
__50083 = G__50132;
continue;
} else {
}
break;
}

var c__41778__auto___50133 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_48054){
var state_val_48055 = (state_48054[(1)]);
if((state_val_48055 === (7))){
var inst_48050 = (state_48054[(2)]);
var state_48054__$1 = state_48054;
var statearr_48058_50136 = state_48054__$1;
(statearr_48058_50136[(2)] = inst_48050);

(statearr_48058_50136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48055 === (1))){
var state_48054__$1 = state_48054;
var statearr_48059_50137 = state_48054__$1;
(statearr_48059_50137[(2)] = null);

(statearr_48059_50137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48055 === (4))){
var inst_48035 = (state_48054[(7)]);
var inst_48035__$1 = (state_48054[(2)]);
var inst_48036 = (inst_48035__$1 == null);
var state_48054__$1 = (function (){var statearr_48061 = state_48054;
(statearr_48061[(7)] = inst_48035__$1);

return statearr_48061;
})();
if(cljs.core.truth_(inst_48036)){
var statearr_48062_50138 = state_48054__$1;
(statearr_48062_50138[(1)] = (5));

} else {
var statearr_48063_50139 = state_48054__$1;
(statearr_48063_50139[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48055 === (6))){
var inst_48035 = (state_48054[(7)]);
var inst_48040 = (state_48054[(8)]);
var inst_48040__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_48041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48042 = [inst_48035,inst_48040__$1];
var inst_48043 = (new cljs.core.PersistentVector(null,2,(5),inst_48041,inst_48042,null));
var state_48054__$1 = (function (){var statearr_48064 = state_48054;
(statearr_48064[(8)] = inst_48040__$1);

return statearr_48064;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48054__$1,(8),jobs,inst_48043);
} else {
if((state_val_48055 === (3))){
var inst_48052 = (state_48054[(2)]);
var state_48054__$1 = state_48054;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48054__$1,inst_48052);
} else {
if((state_val_48055 === (2))){
var state_48054__$1 = state_48054;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48054__$1,(4),from);
} else {
if((state_val_48055 === (9))){
var inst_48047 = (state_48054[(2)]);
var state_48054__$1 = (function (){var statearr_48065 = state_48054;
(statearr_48065[(9)] = inst_48047);

return statearr_48065;
})();
var statearr_48067_50152 = state_48054__$1;
(statearr_48067_50152[(2)] = null);

(statearr_48067_50152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48055 === (5))){
var inst_48038 = cljs.core.async.close_BANG_(jobs);
var state_48054__$1 = state_48054;
var statearr_48069_50153 = state_48054__$1;
(statearr_48069_50153[(2)] = inst_48038);

(statearr_48069_50153[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48055 === (8))){
var inst_48040 = (state_48054[(8)]);
var inst_48045 = (state_48054[(2)]);
var state_48054__$1 = (function (){var statearr_48074 = state_48054;
(statearr_48074[(10)] = inst_48045);

return statearr_48074;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48054__$1,(9),results,inst_48040);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0 = (function (){
var statearr_48075 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48075[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__);

(statearr_48075[(1)] = (1));

return statearr_48075;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1 = (function (state_48054){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48054);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48076){if((e48076 instanceof Object)){
var ex__41692__auto__ = e48076;
var statearr_48077_50164 = state_48054;
(statearr_48077_50164[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48054);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48076;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50168 = state_48054;
state_48054 = G__50168;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = function(state_48054){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1.call(this,state_48054);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_48080 = f__41779__auto__();
(statearr_48080[(6)] = c__41778__auto___50133);

return statearr_48080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


var c__41778__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_48120){
var state_val_48121 = (state_48120[(1)]);
if((state_val_48121 === (7))){
var inst_48116 = (state_48120[(2)]);
var state_48120__$1 = state_48120;
var statearr_48123_50169 = state_48120__$1;
(statearr_48123_50169[(2)] = inst_48116);

(statearr_48123_50169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (20))){
var state_48120__$1 = state_48120;
var statearr_48125_50174 = state_48120__$1;
(statearr_48125_50174[(2)] = null);

(statearr_48125_50174[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (1))){
var state_48120__$1 = state_48120;
var statearr_48127_50178 = state_48120__$1;
(statearr_48127_50178[(2)] = null);

(statearr_48127_50178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (4))){
var inst_48083 = (state_48120[(7)]);
var inst_48083__$1 = (state_48120[(2)]);
var inst_48084 = (inst_48083__$1 == null);
var state_48120__$1 = (function (){var statearr_48129 = state_48120;
(statearr_48129[(7)] = inst_48083__$1);

return statearr_48129;
})();
if(cljs.core.truth_(inst_48084)){
var statearr_48130_50180 = state_48120__$1;
(statearr_48130_50180[(1)] = (5));

} else {
var statearr_48131_50181 = state_48120__$1;
(statearr_48131_50181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (15))){
var inst_48096 = (state_48120[(8)]);
var state_48120__$1 = state_48120;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48120__$1,(18),to,inst_48096);
} else {
if((state_val_48121 === (21))){
var inst_48111 = (state_48120[(2)]);
var state_48120__$1 = state_48120;
var statearr_48134_50188 = state_48120__$1;
(statearr_48134_50188[(2)] = inst_48111);

(statearr_48134_50188[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (13))){
var inst_48113 = (state_48120[(2)]);
var state_48120__$1 = (function (){var statearr_48135 = state_48120;
(statearr_48135[(9)] = inst_48113);

return statearr_48135;
})();
var statearr_48136_50192 = state_48120__$1;
(statearr_48136_50192[(2)] = null);

(statearr_48136_50192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (6))){
var inst_48083 = (state_48120[(7)]);
var state_48120__$1 = state_48120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48120__$1,(11),inst_48083);
} else {
if((state_val_48121 === (17))){
var inst_48106 = (state_48120[(2)]);
var state_48120__$1 = state_48120;
if(cljs.core.truth_(inst_48106)){
var statearr_48137_50193 = state_48120__$1;
(statearr_48137_50193[(1)] = (19));

} else {
var statearr_48138_50194 = state_48120__$1;
(statearr_48138_50194[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (3))){
var inst_48118 = (state_48120[(2)]);
var state_48120__$1 = state_48120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48120__$1,inst_48118);
} else {
if((state_val_48121 === (12))){
var inst_48093 = (state_48120[(10)]);
var state_48120__$1 = state_48120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48120__$1,(14),inst_48093);
} else {
if((state_val_48121 === (2))){
var state_48120__$1 = state_48120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48120__$1,(4),results);
} else {
if((state_val_48121 === (19))){
var state_48120__$1 = state_48120;
var statearr_48140_50198 = state_48120__$1;
(statearr_48140_50198[(2)] = null);

(statearr_48140_50198[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (11))){
var inst_48093 = (state_48120[(2)]);
var state_48120__$1 = (function (){var statearr_48142 = state_48120;
(statearr_48142[(10)] = inst_48093);

return statearr_48142;
})();
var statearr_48144_50199 = state_48120__$1;
(statearr_48144_50199[(2)] = null);

(statearr_48144_50199[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (9))){
var state_48120__$1 = state_48120;
var statearr_48145_50200 = state_48120__$1;
(statearr_48145_50200[(2)] = null);

(statearr_48145_50200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (5))){
var state_48120__$1 = state_48120;
if(cljs.core.truth_(close_QMARK_)){
var statearr_48146_50202 = state_48120__$1;
(statearr_48146_50202[(1)] = (8));

} else {
var statearr_48147_50203 = state_48120__$1;
(statearr_48147_50203[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (14))){
var inst_48096 = (state_48120[(8)]);
var inst_48096__$1 = (state_48120[(2)]);
var inst_48099 = (inst_48096__$1 == null);
var inst_48100 = cljs.core.not(inst_48099);
var state_48120__$1 = (function (){var statearr_48154 = state_48120;
(statearr_48154[(8)] = inst_48096__$1);

return statearr_48154;
})();
if(inst_48100){
var statearr_48155_50204 = state_48120__$1;
(statearr_48155_50204[(1)] = (15));

} else {
var statearr_48156_50205 = state_48120__$1;
(statearr_48156_50205[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (16))){
var state_48120__$1 = state_48120;
var statearr_48157_50206 = state_48120__$1;
(statearr_48157_50206[(2)] = false);

(statearr_48157_50206[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (10))){
var inst_48090 = (state_48120[(2)]);
var state_48120__$1 = state_48120;
var statearr_48164_50207 = state_48120__$1;
(statearr_48164_50207[(2)] = inst_48090);

(statearr_48164_50207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (18))){
var inst_48103 = (state_48120[(2)]);
var state_48120__$1 = state_48120;
var statearr_48168_50208 = state_48120__$1;
(statearr_48168_50208[(2)] = inst_48103);

(statearr_48168_50208[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48121 === (8))){
var inst_48087 = cljs.core.async.close_BANG_(to);
var state_48120__$1 = state_48120;
var statearr_48193_50210 = state_48120__$1;
(statearr_48193_50210[(2)] = inst_48087);

(statearr_48193_50210[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0 = (function (){
var statearr_48194 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48194[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__);

(statearr_48194[(1)] = (1));

return statearr_48194;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1 = (function (state_48120){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48120);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48195){if((e48195 instanceof Object)){
var ex__41692__auto__ = e48195;
var statearr_48196_50211 = state_48120;
(statearr_48196_50211[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48195;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50212 = state_48120;
state_48120 = G__50212;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__ = function(state_48120){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1.call(this,state_48120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41689__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_48198 = f__41779__auto__();
(statearr_48198[(6)] = c__41778__auto__);

return statearr_48198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

return c__41778__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__48203 = arguments.length;
switch (G__48203) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__48213 = arguments.length;
switch (G__48213) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__48225 = arguments.length;
switch (G__48225) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__41778__auto___50231 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_48257){
var state_val_48258 = (state_48257[(1)]);
if((state_val_48258 === (7))){
var inst_48253 = (state_48257[(2)]);
var state_48257__$1 = state_48257;
var statearr_48260_50233 = state_48257__$1;
(statearr_48260_50233[(2)] = inst_48253);

(statearr_48260_50233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (1))){
var state_48257__$1 = state_48257;
var statearr_48261_50234 = state_48257__$1;
(statearr_48261_50234[(2)] = null);

(statearr_48261_50234[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (4))){
var inst_48233 = (state_48257[(7)]);
var inst_48233__$1 = (state_48257[(2)]);
var inst_48235 = (inst_48233__$1 == null);
var state_48257__$1 = (function (){var statearr_48266 = state_48257;
(statearr_48266[(7)] = inst_48233__$1);

return statearr_48266;
})();
if(cljs.core.truth_(inst_48235)){
var statearr_48267_50240 = state_48257__$1;
(statearr_48267_50240[(1)] = (5));

} else {
var statearr_48268_50241 = state_48257__$1;
(statearr_48268_50241[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (13))){
var state_48257__$1 = state_48257;
var statearr_48272_50245 = state_48257__$1;
(statearr_48272_50245[(2)] = null);

(statearr_48272_50245[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (6))){
var inst_48233 = (state_48257[(7)]);
var inst_48240 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_48233) : p.call(null,inst_48233));
var state_48257__$1 = state_48257;
if(cljs.core.truth_(inst_48240)){
var statearr_48273_50246 = state_48257__$1;
(statearr_48273_50246[(1)] = (9));

} else {
var statearr_48274_50247 = state_48257__$1;
(statearr_48274_50247[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (3))){
var inst_48255 = (state_48257[(2)]);
var state_48257__$1 = state_48257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48257__$1,inst_48255);
} else {
if((state_val_48258 === (12))){
var state_48257__$1 = state_48257;
var statearr_48275_50252 = state_48257__$1;
(statearr_48275_50252[(2)] = null);

(statearr_48275_50252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (2))){
var state_48257__$1 = state_48257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48257__$1,(4),ch);
} else {
if((state_val_48258 === (11))){
var inst_48233 = (state_48257[(7)]);
var inst_48244 = (state_48257[(2)]);
var state_48257__$1 = state_48257;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48257__$1,(8),inst_48244,inst_48233);
} else {
if((state_val_48258 === (9))){
var state_48257__$1 = state_48257;
var statearr_48282_50256 = state_48257__$1;
(statearr_48282_50256[(2)] = tc);

(statearr_48282_50256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (5))){
var inst_48237 = cljs.core.async.close_BANG_(tc);
var inst_48238 = cljs.core.async.close_BANG_(fc);
var state_48257__$1 = (function (){var statearr_48283 = state_48257;
(statearr_48283[(8)] = inst_48237);

return statearr_48283;
})();
var statearr_48286_50261 = state_48257__$1;
(statearr_48286_50261[(2)] = inst_48238);

(statearr_48286_50261[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (14))){
var inst_48251 = (state_48257[(2)]);
var state_48257__$1 = state_48257;
var statearr_48292_50265 = state_48257__$1;
(statearr_48292_50265[(2)] = inst_48251);

(statearr_48292_50265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (10))){
var state_48257__$1 = state_48257;
var statearr_48294_50268 = state_48257__$1;
(statearr_48294_50268[(2)] = fc);

(statearr_48294_50268[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48258 === (8))){
var inst_48246 = (state_48257[(2)]);
var state_48257__$1 = state_48257;
if(cljs.core.truth_(inst_48246)){
var statearr_48295_50275 = state_48257__$1;
(statearr_48295_50275[(1)] = (12));

} else {
var statearr_48296_50276 = state_48257__$1;
(statearr_48296_50276[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_48297 = [null,null,null,null,null,null,null,null,null];
(statearr_48297[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_48297[(1)] = (1));

return statearr_48297;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_48257){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48257);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48299){if((e48299 instanceof Object)){
var ex__41692__auto__ = e48299;
var statearr_48300_50284 = state_48257;
(statearr_48300_50284[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48257);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48299;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50291 = state_48257;
state_48257 = G__50291;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_48257){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_48257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_48305 = f__41779__auto__();
(statearr_48305[(6)] = c__41778__auto___50231);

return statearr_48305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__41778__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_48329){
var state_val_48330 = (state_48329[(1)]);
if((state_val_48330 === (7))){
var inst_48325 = (state_48329[(2)]);
var state_48329__$1 = state_48329;
var statearr_48332_50292 = state_48329__$1;
(statearr_48332_50292[(2)] = inst_48325);

(statearr_48332_50292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48330 === (1))){
var inst_48309 = init;
var state_48329__$1 = (function (){var statearr_48334 = state_48329;
(statearr_48334[(7)] = inst_48309);

return statearr_48334;
})();
var statearr_48335_50293 = state_48329__$1;
(statearr_48335_50293[(2)] = null);

(statearr_48335_50293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48330 === (4))){
var inst_48312 = (state_48329[(8)]);
var inst_48312__$1 = (state_48329[(2)]);
var inst_48313 = (inst_48312__$1 == null);
var state_48329__$1 = (function (){var statearr_48336 = state_48329;
(statearr_48336[(8)] = inst_48312__$1);

return statearr_48336;
})();
if(cljs.core.truth_(inst_48313)){
var statearr_48338_50294 = state_48329__$1;
(statearr_48338_50294[(1)] = (5));

} else {
var statearr_48339_50295 = state_48329__$1;
(statearr_48339_50295[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48330 === (6))){
var inst_48309 = (state_48329[(7)]);
var inst_48316 = (state_48329[(9)]);
var inst_48312 = (state_48329[(8)]);
var inst_48316__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_48309,inst_48312) : f.call(null,inst_48309,inst_48312));
var inst_48317 = cljs.core.reduced_QMARK_(inst_48316__$1);
var state_48329__$1 = (function (){var statearr_48340 = state_48329;
(statearr_48340[(9)] = inst_48316__$1);

return statearr_48340;
})();
if(inst_48317){
var statearr_48341_50296 = state_48329__$1;
(statearr_48341_50296[(1)] = (8));

} else {
var statearr_48342_50297 = state_48329__$1;
(statearr_48342_50297[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48330 === (3))){
var inst_48327 = (state_48329[(2)]);
var state_48329__$1 = state_48329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48329__$1,inst_48327);
} else {
if((state_val_48330 === (2))){
var state_48329__$1 = state_48329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48329__$1,(4),ch);
} else {
if((state_val_48330 === (9))){
var inst_48316 = (state_48329[(9)]);
var inst_48309 = inst_48316;
var state_48329__$1 = (function (){var statearr_48346 = state_48329;
(statearr_48346[(7)] = inst_48309);

return statearr_48346;
})();
var statearr_48347_50304 = state_48329__$1;
(statearr_48347_50304[(2)] = null);

(statearr_48347_50304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48330 === (5))){
var inst_48309 = (state_48329[(7)]);
var state_48329__$1 = state_48329;
var statearr_48351_50305 = state_48329__$1;
(statearr_48351_50305[(2)] = inst_48309);

(statearr_48351_50305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48330 === (10))){
var inst_48323 = (state_48329[(2)]);
var state_48329__$1 = state_48329;
var statearr_48353_50306 = state_48329__$1;
(statearr_48353_50306[(2)] = inst_48323);

(statearr_48353_50306[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48330 === (8))){
var inst_48316 = (state_48329[(9)]);
var inst_48319 = cljs.core.deref(inst_48316);
var state_48329__$1 = state_48329;
var statearr_48354_50307 = state_48329__$1;
(statearr_48354_50307[(2)] = inst_48319);

(statearr_48354_50307[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__41689__auto__ = null;
var cljs$core$async$reduce_$_state_machine__41689__auto____0 = (function (){
var statearr_48355 = [null,null,null,null,null,null,null,null,null,null];
(statearr_48355[(0)] = cljs$core$async$reduce_$_state_machine__41689__auto__);

(statearr_48355[(1)] = (1));

return statearr_48355;
});
var cljs$core$async$reduce_$_state_machine__41689__auto____1 = (function (state_48329){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48329);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48356){if((e48356 instanceof Object)){
var ex__41692__auto__ = e48356;
var statearr_48357_50308 = state_48329;
(statearr_48357_50308[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48329);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48356;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50309 = state_48329;
state_48329 = G__50309;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__41689__auto__ = function(state_48329){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__41689__auto____1.call(this,state_48329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__41689__auto____0;
cljs$core$async$reduce_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__41689__auto____1;
return cljs$core$async$reduce_$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_48358 = f__41779__auto__();
(statearr_48358[(6)] = c__41778__auto__);

return statearr_48358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

return c__41778__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__41778__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_48365){
var state_val_48366 = (state_48365[(1)]);
if((state_val_48366 === (1))){
var inst_48360 = cljs.core.async.reduce(f__$1,init,ch);
var state_48365__$1 = state_48365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48365__$1,(2),inst_48360);
} else {
if((state_val_48366 === (2))){
var inst_48362 = (state_48365[(2)]);
var inst_48363 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_48362) : f__$1.call(null,inst_48362));
var state_48365__$1 = state_48365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48365__$1,inst_48363);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__41689__auto__ = null;
var cljs$core$async$transduce_$_state_machine__41689__auto____0 = (function (){
var statearr_48372 = [null,null,null,null,null,null,null];
(statearr_48372[(0)] = cljs$core$async$transduce_$_state_machine__41689__auto__);

(statearr_48372[(1)] = (1));

return statearr_48372;
});
var cljs$core$async$transduce_$_state_machine__41689__auto____1 = (function (state_48365){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48365);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48373){if((e48373 instanceof Object)){
var ex__41692__auto__ = e48373;
var statearr_48374_50316 = state_48365;
(statearr_48374_50316[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48365);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48373;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50317 = state_48365;
state_48365 = G__50317;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__41689__auto__ = function(state_48365){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__41689__auto____1.call(this,state_48365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__41689__auto____0;
cljs$core$async$transduce_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__41689__auto____1;
return cljs$core$async$transduce_$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_48375 = f__41779__auto__();
(statearr_48375[(6)] = c__41778__auto__);

return statearr_48375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

return c__41778__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__48380 = arguments.length;
switch (G__48380) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__41778__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_48409){
var state_val_48410 = (state_48409[(1)]);
if((state_val_48410 === (7))){
var inst_48390 = (state_48409[(2)]);
var state_48409__$1 = state_48409;
var statearr_48416_50328 = state_48409__$1;
(statearr_48416_50328[(2)] = inst_48390);

(statearr_48416_50328[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (1))){
var inst_48384 = cljs.core.seq(coll);
var inst_48385 = inst_48384;
var state_48409__$1 = (function (){var statearr_48419 = state_48409;
(statearr_48419[(7)] = inst_48385);

return statearr_48419;
})();
var statearr_48420_50332 = state_48409__$1;
(statearr_48420_50332[(2)] = null);

(statearr_48420_50332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (4))){
var inst_48385 = (state_48409[(7)]);
var inst_48388 = cljs.core.first(inst_48385);
var state_48409__$1 = state_48409;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48409__$1,(7),ch,inst_48388);
} else {
if((state_val_48410 === (13))){
var inst_48403 = (state_48409[(2)]);
var state_48409__$1 = state_48409;
var statearr_48423_50333 = state_48409__$1;
(statearr_48423_50333[(2)] = inst_48403);

(statearr_48423_50333[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (6))){
var inst_48393 = (state_48409[(2)]);
var state_48409__$1 = state_48409;
if(cljs.core.truth_(inst_48393)){
var statearr_48425_50334 = state_48409__$1;
(statearr_48425_50334[(1)] = (8));

} else {
var statearr_48429_50335 = state_48409__$1;
(statearr_48429_50335[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (3))){
var inst_48407 = (state_48409[(2)]);
var state_48409__$1 = state_48409;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48409__$1,inst_48407);
} else {
if((state_val_48410 === (12))){
var state_48409__$1 = state_48409;
var statearr_48431_50336 = state_48409__$1;
(statearr_48431_50336[(2)] = null);

(statearr_48431_50336[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (2))){
var inst_48385 = (state_48409[(7)]);
var state_48409__$1 = state_48409;
if(cljs.core.truth_(inst_48385)){
var statearr_48432_50337 = state_48409__$1;
(statearr_48432_50337[(1)] = (4));

} else {
var statearr_48433_50338 = state_48409__$1;
(statearr_48433_50338[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (11))){
var inst_48400 = cljs.core.async.close_BANG_(ch);
var state_48409__$1 = state_48409;
var statearr_48435_50341 = state_48409__$1;
(statearr_48435_50341[(2)] = inst_48400);

(statearr_48435_50341[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (9))){
var state_48409__$1 = state_48409;
if(cljs.core.truth_(close_QMARK_)){
var statearr_48436_50343 = state_48409__$1;
(statearr_48436_50343[(1)] = (11));

} else {
var statearr_48437_50344 = state_48409__$1;
(statearr_48437_50344[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (5))){
var inst_48385 = (state_48409[(7)]);
var state_48409__$1 = state_48409;
var statearr_48438_50345 = state_48409__$1;
(statearr_48438_50345[(2)] = inst_48385);

(statearr_48438_50345[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (10))){
var inst_48405 = (state_48409[(2)]);
var state_48409__$1 = state_48409;
var statearr_48439_50349 = state_48409__$1;
(statearr_48439_50349[(2)] = inst_48405);

(statearr_48439_50349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48410 === (8))){
var inst_48385 = (state_48409[(7)]);
var inst_48395 = cljs.core.next(inst_48385);
var inst_48385__$1 = inst_48395;
var state_48409__$1 = (function (){var statearr_48440 = state_48409;
(statearr_48440[(7)] = inst_48385__$1);

return statearr_48440;
})();
var statearr_48441_50350 = state_48409__$1;
(statearr_48441_50350[(2)] = null);

(statearr_48441_50350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_48444 = [null,null,null,null,null,null,null,null];
(statearr_48444[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_48444[(1)] = (1));

return statearr_48444;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_48409){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48409);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48448){if((e48448 instanceof Object)){
var ex__41692__auto__ = e48448;
var statearr_48449_50351 = state_48409;
(statearr_48449_50351[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48409);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48448;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50352 = state_48409;
state_48409 = G__50352;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_48409){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_48409);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_48455 = f__41779__auto__();
(statearr_48455[(6)] = c__41778__auto__);

return statearr_48455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

return c__41778__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_50359 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_50359(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_50366 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_50366(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_50371 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_50371(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_50379 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_50379(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48485 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48485 = (function (ch,cs,meta48486){
this.ch = ch;
this.cs = cs;
this.meta48486 = meta48486;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48487,meta48486__$1){
var self__ = this;
var _48487__$1 = this;
return (new cljs.core.async.t_cljs$core$async48485(self__.ch,self__.cs,meta48486__$1));
}));

(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48487){
var self__ = this;
var _48487__$1 = this;
return self__.meta48486;
}));

(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async48485.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async48485.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta48486","meta48486",-1708498606,null)], null);
}));

(cljs.core.async.t_cljs$core$async48485.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48485.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48485");

(cljs.core.async.t_cljs$core$async48485.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48485");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48485.
 */
cljs.core.async.__GT_t_cljs$core$async48485 = (function cljs$core$async$mult_$___GT_t_cljs$core$async48485(ch__$1,cs__$1,meta48486){
return (new cljs.core.async.t_cljs$core$async48485(ch__$1,cs__$1,meta48486));
});

}

return (new cljs.core.async.t_cljs$core$async48485(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__41778__auto___50387 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_48636){
var state_val_48637 = (state_48636[(1)]);
if((state_val_48637 === (7))){
var inst_48632 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48640_50389 = state_48636__$1;
(statearr_48640_50389[(2)] = inst_48632);

(statearr_48640_50389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (20))){
var inst_48530 = (state_48636[(7)]);
var inst_48543 = cljs.core.first(inst_48530);
var inst_48544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48543,(0),null);
var inst_48545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48543,(1),null);
var state_48636__$1 = (function (){var statearr_48643 = state_48636;
(statearr_48643[(8)] = inst_48544);

return statearr_48643;
})();
if(cljs.core.truth_(inst_48545)){
var statearr_48644_50392 = state_48636__$1;
(statearr_48644_50392[(1)] = (22));

} else {
var statearr_48645_50396 = state_48636__$1;
(statearr_48645_50396[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (27))){
var inst_48575 = (state_48636[(9)]);
var inst_48573 = (state_48636[(10)]);
var inst_48581 = (state_48636[(11)]);
var inst_48499 = (state_48636[(12)]);
var inst_48581__$1 = cljs.core._nth(inst_48573,inst_48575);
var inst_48582 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_48581__$1,inst_48499,done);
var state_48636__$1 = (function (){var statearr_48650 = state_48636;
(statearr_48650[(11)] = inst_48581__$1);

return statearr_48650;
})();
if(cljs.core.truth_(inst_48582)){
var statearr_48651_50402 = state_48636__$1;
(statearr_48651_50402[(1)] = (30));

} else {
var statearr_48653_50403 = state_48636__$1;
(statearr_48653_50403[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (1))){
var state_48636__$1 = state_48636;
var statearr_48654_50404 = state_48636__$1;
(statearr_48654_50404[(2)] = null);

(statearr_48654_50404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (24))){
var inst_48530 = (state_48636[(7)]);
var inst_48550 = (state_48636[(2)]);
var inst_48551 = cljs.core.next(inst_48530);
var inst_48508 = inst_48551;
var inst_48509 = null;
var inst_48510 = (0);
var inst_48511 = (0);
var state_48636__$1 = (function (){var statearr_48655 = state_48636;
(statearr_48655[(13)] = inst_48510);

(statearr_48655[(14)] = inst_48509);

(statearr_48655[(15)] = inst_48508);

(statearr_48655[(16)] = inst_48511);

(statearr_48655[(17)] = inst_48550);

return statearr_48655;
})();
var statearr_48656_50408 = state_48636__$1;
(statearr_48656_50408[(2)] = null);

(statearr_48656_50408[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (39))){
var state_48636__$1 = state_48636;
var statearr_48664_50409 = state_48636__$1;
(statearr_48664_50409[(2)] = null);

(statearr_48664_50409[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (4))){
var inst_48499 = (state_48636[(12)]);
var inst_48499__$1 = (state_48636[(2)]);
var inst_48500 = (inst_48499__$1 == null);
var state_48636__$1 = (function (){var statearr_48665 = state_48636;
(statearr_48665[(12)] = inst_48499__$1);

return statearr_48665;
})();
if(cljs.core.truth_(inst_48500)){
var statearr_48666_50411 = state_48636__$1;
(statearr_48666_50411[(1)] = (5));

} else {
var statearr_48667_50412 = state_48636__$1;
(statearr_48667_50412[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (15))){
var inst_48510 = (state_48636[(13)]);
var inst_48509 = (state_48636[(14)]);
var inst_48508 = (state_48636[(15)]);
var inst_48511 = (state_48636[(16)]);
var inst_48526 = (state_48636[(2)]);
var inst_48527 = (inst_48511 + (1));
var tmp48660 = inst_48510;
var tmp48661 = inst_48509;
var tmp48662 = inst_48508;
var inst_48508__$1 = tmp48662;
var inst_48509__$1 = tmp48661;
var inst_48510__$1 = tmp48660;
var inst_48511__$1 = inst_48527;
var state_48636__$1 = (function (){var statearr_48668 = state_48636;
(statearr_48668[(13)] = inst_48510__$1);

(statearr_48668[(18)] = inst_48526);

(statearr_48668[(14)] = inst_48509__$1);

(statearr_48668[(15)] = inst_48508__$1);

(statearr_48668[(16)] = inst_48511__$1);

return statearr_48668;
})();
var statearr_48672_50420 = state_48636__$1;
(statearr_48672_50420[(2)] = null);

(statearr_48672_50420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (21))){
var inst_48554 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48677_50421 = state_48636__$1;
(statearr_48677_50421[(2)] = inst_48554);

(statearr_48677_50421[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (31))){
var inst_48581 = (state_48636[(11)]);
var inst_48585 = done(null);
var inst_48586 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_48581);
var state_48636__$1 = (function (){var statearr_48682 = state_48636;
(statearr_48682[(19)] = inst_48585);

return statearr_48682;
})();
var statearr_48683_50426 = state_48636__$1;
(statearr_48683_50426[(2)] = inst_48586);

(statearr_48683_50426[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (32))){
var inst_48575 = (state_48636[(9)]);
var inst_48573 = (state_48636[(10)]);
var inst_48572 = (state_48636[(20)]);
var inst_48574 = (state_48636[(21)]);
var inst_48588 = (state_48636[(2)]);
var inst_48589 = (inst_48575 + (1));
var tmp48673 = inst_48573;
var tmp48674 = inst_48572;
var tmp48675 = inst_48574;
var inst_48572__$1 = tmp48674;
var inst_48573__$1 = tmp48673;
var inst_48574__$1 = tmp48675;
var inst_48575__$1 = inst_48589;
var state_48636__$1 = (function (){var statearr_48687 = state_48636;
(statearr_48687[(9)] = inst_48575__$1);

(statearr_48687[(10)] = inst_48573__$1);

(statearr_48687[(20)] = inst_48572__$1);

(statearr_48687[(22)] = inst_48588);

(statearr_48687[(21)] = inst_48574__$1);

return statearr_48687;
})();
var statearr_48688_50434 = state_48636__$1;
(statearr_48688_50434[(2)] = null);

(statearr_48688_50434[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (40))){
var inst_48604 = (state_48636[(23)]);
var inst_48608 = done(null);
var inst_48609 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_48604);
var state_48636__$1 = (function (){var statearr_48689 = state_48636;
(statearr_48689[(24)] = inst_48608);

return statearr_48689;
})();
var statearr_48690_50435 = state_48636__$1;
(statearr_48690_50435[(2)] = inst_48609);

(statearr_48690_50435[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (33))){
var inst_48592 = (state_48636[(25)]);
var inst_48594 = cljs.core.chunked_seq_QMARK_(inst_48592);
var state_48636__$1 = state_48636;
if(inst_48594){
var statearr_48691_50436 = state_48636__$1;
(statearr_48691_50436[(1)] = (36));

} else {
var statearr_48692_50441 = state_48636__$1;
(statearr_48692_50441[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (13))){
var inst_48520 = (state_48636[(26)]);
var inst_48523 = cljs.core.async.close_BANG_(inst_48520);
var state_48636__$1 = state_48636;
var statearr_48703_50447 = state_48636__$1;
(statearr_48703_50447[(2)] = inst_48523);

(statearr_48703_50447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (22))){
var inst_48544 = (state_48636[(8)]);
var inst_48547 = cljs.core.async.close_BANG_(inst_48544);
var state_48636__$1 = state_48636;
var statearr_48707_50453 = state_48636__$1;
(statearr_48707_50453[(2)] = inst_48547);

(statearr_48707_50453[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (36))){
var inst_48592 = (state_48636[(25)]);
var inst_48596 = cljs.core.chunk_first(inst_48592);
var inst_48597 = cljs.core.chunk_rest(inst_48592);
var inst_48598 = cljs.core.count(inst_48596);
var inst_48572 = inst_48597;
var inst_48573 = inst_48596;
var inst_48574 = inst_48598;
var inst_48575 = (0);
var state_48636__$1 = (function (){var statearr_48711 = state_48636;
(statearr_48711[(9)] = inst_48575);

(statearr_48711[(10)] = inst_48573);

(statearr_48711[(20)] = inst_48572);

(statearr_48711[(21)] = inst_48574);

return statearr_48711;
})();
var statearr_48712_50461 = state_48636__$1;
(statearr_48712_50461[(2)] = null);

(statearr_48712_50461[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (41))){
var inst_48592 = (state_48636[(25)]);
var inst_48611 = (state_48636[(2)]);
var inst_48612 = cljs.core.next(inst_48592);
var inst_48572 = inst_48612;
var inst_48573 = null;
var inst_48574 = (0);
var inst_48575 = (0);
var state_48636__$1 = (function (){var statearr_48719 = state_48636;
(statearr_48719[(9)] = inst_48575);

(statearr_48719[(27)] = inst_48611);

(statearr_48719[(10)] = inst_48573);

(statearr_48719[(20)] = inst_48572);

(statearr_48719[(21)] = inst_48574);

return statearr_48719;
})();
var statearr_48720_50469 = state_48636__$1;
(statearr_48720_50469[(2)] = null);

(statearr_48720_50469[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (43))){
var state_48636__$1 = state_48636;
var statearr_48721_50470 = state_48636__$1;
(statearr_48721_50470[(2)] = null);

(statearr_48721_50470[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (29))){
var inst_48620 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48723_50471 = state_48636__$1;
(statearr_48723_50471[(2)] = inst_48620);

(statearr_48723_50471[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (44))){
var inst_48629 = (state_48636[(2)]);
var state_48636__$1 = (function (){var statearr_48724 = state_48636;
(statearr_48724[(28)] = inst_48629);

return statearr_48724;
})();
var statearr_48725_50472 = state_48636__$1;
(statearr_48725_50472[(2)] = null);

(statearr_48725_50472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (6))){
var inst_48564 = (state_48636[(29)]);
var inst_48563 = cljs.core.deref(cs);
var inst_48564__$1 = cljs.core.keys(inst_48563);
var inst_48565 = cljs.core.count(inst_48564__$1);
var inst_48566 = cljs.core.reset_BANG_(dctr,inst_48565);
var inst_48571 = cljs.core.seq(inst_48564__$1);
var inst_48572 = inst_48571;
var inst_48573 = null;
var inst_48574 = (0);
var inst_48575 = (0);
var state_48636__$1 = (function (){var statearr_48727 = state_48636;
(statearr_48727[(9)] = inst_48575);

(statearr_48727[(10)] = inst_48573);

(statearr_48727[(20)] = inst_48572);

(statearr_48727[(21)] = inst_48574);

(statearr_48727[(30)] = inst_48566);

(statearr_48727[(29)] = inst_48564__$1);

return statearr_48727;
})();
var statearr_48729_50473 = state_48636__$1;
(statearr_48729_50473[(2)] = null);

(statearr_48729_50473[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (28))){
var inst_48572 = (state_48636[(20)]);
var inst_48592 = (state_48636[(25)]);
var inst_48592__$1 = cljs.core.seq(inst_48572);
var state_48636__$1 = (function (){var statearr_48730 = state_48636;
(statearr_48730[(25)] = inst_48592__$1);

return statearr_48730;
})();
if(inst_48592__$1){
var statearr_48731_50479 = state_48636__$1;
(statearr_48731_50479[(1)] = (33));

} else {
var statearr_48732_50480 = state_48636__$1;
(statearr_48732_50480[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (25))){
var inst_48575 = (state_48636[(9)]);
var inst_48574 = (state_48636[(21)]);
var inst_48577 = (inst_48575 < inst_48574);
var inst_48578 = inst_48577;
var state_48636__$1 = state_48636;
if(cljs.core.truth_(inst_48578)){
var statearr_48734_50481 = state_48636__$1;
(statearr_48734_50481[(1)] = (27));

} else {
var statearr_48736_50482 = state_48636__$1;
(statearr_48736_50482[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (34))){
var state_48636__$1 = state_48636;
var statearr_48738_50483 = state_48636__$1;
(statearr_48738_50483[(2)] = null);

(statearr_48738_50483[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (17))){
var state_48636__$1 = state_48636;
var statearr_48739_50484 = state_48636__$1;
(statearr_48739_50484[(2)] = null);

(statearr_48739_50484[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (3))){
var inst_48634 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48636__$1,inst_48634);
} else {
if((state_val_48637 === (12))){
var inst_48559 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48743_50488 = state_48636__$1;
(statearr_48743_50488[(2)] = inst_48559);

(statearr_48743_50488[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (2))){
var state_48636__$1 = state_48636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48636__$1,(4),ch);
} else {
if((state_val_48637 === (23))){
var state_48636__$1 = state_48636;
var statearr_48744_50490 = state_48636__$1;
(statearr_48744_50490[(2)] = null);

(statearr_48744_50490[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (35))){
var inst_48618 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48745_50493 = state_48636__$1;
(statearr_48745_50493[(2)] = inst_48618);

(statearr_48745_50493[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (19))){
var inst_48530 = (state_48636[(7)]);
var inst_48534 = cljs.core.chunk_first(inst_48530);
var inst_48535 = cljs.core.chunk_rest(inst_48530);
var inst_48536 = cljs.core.count(inst_48534);
var inst_48508 = inst_48535;
var inst_48509 = inst_48534;
var inst_48510 = inst_48536;
var inst_48511 = (0);
var state_48636__$1 = (function (){var statearr_48747 = state_48636;
(statearr_48747[(13)] = inst_48510);

(statearr_48747[(14)] = inst_48509);

(statearr_48747[(15)] = inst_48508);

(statearr_48747[(16)] = inst_48511);

return statearr_48747;
})();
var statearr_48749_50494 = state_48636__$1;
(statearr_48749_50494[(2)] = null);

(statearr_48749_50494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (11))){
var inst_48530 = (state_48636[(7)]);
var inst_48508 = (state_48636[(15)]);
var inst_48530__$1 = cljs.core.seq(inst_48508);
var state_48636__$1 = (function (){var statearr_48750 = state_48636;
(statearr_48750[(7)] = inst_48530__$1);

return statearr_48750;
})();
if(inst_48530__$1){
var statearr_48751_50498 = state_48636__$1;
(statearr_48751_50498[(1)] = (16));

} else {
var statearr_48752_50499 = state_48636__$1;
(statearr_48752_50499[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (9))){
var inst_48561 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48753_50501 = state_48636__$1;
(statearr_48753_50501[(2)] = inst_48561);

(statearr_48753_50501[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (5))){
var inst_48506 = cljs.core.deref(cs);
var inst_48507 = cljs.core.seq(inst_48506);
var inst_48508 = inst_48507;
var inst_48509 = null;
var inst_48510 = (0);
var inst_48511 = (0);
var state_48636__$1 = (function (){var statearr_48754 = state_48636;
(statearr_48754[(13)] = inst_48510);

(statearr_48754[(14)] = inst_48509);

(statearr_48754[(15)] = inst_48508);

(statearr_48754[(16)] = inst_48511);

return statearr_48754;
})();
var statearr_48755_50508 = state_48636__$1;
(statearr_48755_50508[(2)] = null);

(statearr_48755_50508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (14))){
var state_48636__$1 = state_48636;
var statearr_48756_50509 = state_48636__$1;
(statearr_48756_50509[(2)] = null);

(statearr_48756_50509[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (45))){
var inst_48626 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48757_50510 = state_48636__$1;
(statearr_48757_50510[(2)] = inst_48626);

(statearr_48757_50510[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (26))){
var inst_48564 = (state_48636[(29)]);
var inst_48622 = (state_48636[(2)]);
var inst_48623 = cljs.core.seq(inst_48564);
var state_48636__$1 = (function (){var statearr_48758 = state_48636;
(statearr_48758[(31)] = inst_48622);

return statearr_48758;
})();
if(inst_48623){
var statearr_48759_50511 = state_48636__$1;
(statearr_48759_50511[(1)] = (42));

} else {
var statearr_48760_50513 = state_48636__$1;
(statearr_48760_50513[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (16))){
var inst_48530 = (state_48636[(7)]);
var inst_48532 = cljs.core.chunked_seq_QMARK_(inst_48530);
var state_48636__$1 = state_48636;
if(inst_48532){
var statearr_48764_50516 = state_48636__$1;
(statearr_48764_50516[(1)] = (19));

} else {
var statearr_48765_50517 = state_48636__$1;
(statearr_48765_50517[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (38))){
var inst_48615 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48766_50526 = state_48636__$1;
(statearr_48766_50526[(2)] = inst_48615);

(statearr_48766_50526[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (30))){
var state_48636__$1 = state_48636;
var statearr_48767_50531 = state_48636__$1;
(statearr_48767_50531[(2)] = null);

(statearr_48767_50531[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (10))){
var inst_48509 = (state_48636[(14)]);
var inst_48511 = (state_48636[(16)]);
var inst_48519 = cljs.core._nth(inst_48509,inst_48511);
var inst_48520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48519,(0),null);
var inst_48521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48519,(1),null);
var state_48636__$1 = (function (){var statearr_48768 = state_48636;
(statearr_48768[(26)] = inst_48520);

return statearr_48768;
})();
if(cljs.core.truth_(inst_48521)){
var statearr_48769_50537 = state_48636__$1;
(statearr_48769_50537[(1)] = (13));

} else {
var statearr_48770_50538 = state_48636__$1;
(statearr_48770_50538[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (18))){
var inst_48557 = (state_48636[(2)]);
var state_48636__$1 = state_48636;
var statearr_48777_50540 = state_48636__$1;
(statearr_48777_50540[(2)] = inst_48557);

(statearr_48777_50540[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (42))){
var state_48636__$1 = state_48636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48636__$1,(45),dchan);
} else {
if((state_val_48637 === (37))){
var inst_48604 = (state_48636[(23)]);
var inst_48592 = (state_48636[(25)]);
var inst_48499 = (state_48636[(12)]);
var inst_48604__$1 = cljs.core.first(inst_48592);
var inst_48605 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_48604__$1,inst_48499,done);
var state_48636__$1 = (function (){var statearr_48782 = state_48636;
(statearr_48782[(23)] = inst_48604__$1);

return statearr_48782;
})();
if(cljs.core.truth_(inst_48605)){
var statearr_48783_50542 = state_48636__$1;
(statearr_48783_50542[(1)] = (39));

} else {
var statearr_48784_50547 = state_48636__$1;
(statearr_48784_50547[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48637 === (8))){
var inst_48510 = (state_48636[(13)]);
var inst_48511 = (state_48636[(16)]);
var inst_48513 = (inst_48511 < inst_48510);
var inst_48514 = inst_48513;
var state_48636__$1 = state_48636;
if(cljs.core.truth_(inst_48514)){
var statearr_48788_50548 = state_48636__$1;
(statearr_48788_50548[(1)] = (10));

} else {
var statearr_48789_50549 = state_48636__$1;
(statearr_48789_50549[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__41689__auto__ = null;
var cljs$core$async$mult_$_state_machine__41689__auto____0 = (function (){
var statearr_48790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48790[(0)] = cljs$core$async$mult_$_state_machine__41689__auto__);

(statearr_48790[(1)] = (1));

return statearr_48790;
});
var cljs$core$async$mult_$_state_machine__41689__auto____1 = (function (state_48636){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_48636);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e48791){if((e48791 instanceof Object)){
var ex__41692__auto__ = e48791;
var statearr_48792_50551 = state_48636;
(statearr_48792_50551[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_48636);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48791;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50552 = state_48636;
state_48636 = G__50552;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__41689__auto__ = function(state_48636){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__41689__auto____1.call(this,state_48636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__41689__auto____0;
cljs$core$async$mult_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__41689__auto____1;
return cljs$core$async$mult_$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_48793 = f__41779__auto__();
(statearr_48793[(6)] = c__41778__auto___50387);

return statearr_48793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__48801 = arguments.length;
switch (G__48801) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_50559 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_50559(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_50560 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_50560(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_50564 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_50564(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_50565 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_50565(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_50566 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_50566(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50568 = arguments.length;
var i__4737__auto___50569 = (0);
while(true){
if((i__4737__auto___50569 < len__4736__auto___50568)){
args__4742__auto__.push((arguments[i__4737__auto___50569]));

var G__50570 = (i__4737__auto___50569 + (1));
i__4737__auto___50569 = G__50570;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__48813){
var map__48814 = p__48813;
var map__48814__$1 = (((((!((map__48814 == null))))?(((((map__48814.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48814.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__48814):map__48814);
var opts = map__48814__$1;
var statearr_48819_50571 = state;
(statearr_48819_50571[(1)] = cont_block);


var temp__5720__auto__ = cljs.core.async.do_alts((function (val){
var statearr_48820_50572 = state;
(statearr_48820_50572[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5720__auto__)){
var cb = temp__5720__auto__;
var statearr_48821_50573 = state;
(statearr_48821_50573[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq48809){
var G__48810 = cljs.core.first(seq48809);
var seq48809__$1 = cljs.core.next(seq48809);
var G__48811 = cljs.core.first(seq48809__$1);
var seq48809__$2 = cljs.core.next(seq48809__$1);
var G__48812 = cljs.core.first(seq48809__$2);
var seq48809__$3 = cljs.core.next(seq48809__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48810,G__48811,G__48812,seq48809__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48881 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48881 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta48882){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta48882 = meta48882;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48883,meta48882__$1){
var self__ = this;
var _48883__$1 = this;
return (new cljs.core.async.t_cljs$core$async48881(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta48882__$1));
}));

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48883){
var self__ = this;
var _48883__$1 = this;
return self__.meta48882;
}));

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48881.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48881.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta48882","meta48882",-580845379,null)], null);
}));

(cljs.core.async.t_cljs$core$async48881.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48881.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48881");

(cljs.core.async.t_cljs$core$async48881.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48881");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48881.
 */
cljs.core.async.__GT_t_cljs$core$async48881 = (function cljs$core$async$mix_$___GT_t_cljs$core$async48881(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48882){
return (new cljs.core.async.t_cljs$core$async48881(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48882));
});

}

return (new cljs.core.async.t_cljs$core$async48881(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41778__auto___50586 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49002){
var state_val_49003 = (state_49002[(1)]);
if((state_val_49003 === (7))){
var inst_48917 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
var statearr_49004_50587 = state_49002__$1;
(statearr_49004_50587[(2)] = inst_48917);

(statearr_49004_50587[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (20))){
var inst_48929 = (state_49002[(7)]);
var state_49002__$1 = state_49002;
var statearr_49005_50590 = state_49002__$1;
(statearr_49005_50590[(2)] = inst_48929);

(statearr_49005_50590[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (27))){
var state_49002__$1 = state_49002;
var statearr_49006_50591 = state_49002__$1;
(statearr_49006_50591[(2)] = null);

(statearr_49006_50591[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (1))){
var inst_48904 = (state_49002[(8)]);
var inst_48904__$1 = calc_state();
var inst_48906 = (inst_48904__$1 == null);
var inst_48907 = cljs.core.not(inst_48906);
var state_49002__$1 = (function (){var statearr_49007 = state_49002;
(statearr_49007[(8)] = inst_48904__$1);

return statearr_49007;
})();
if(inst_48907){
var statearr_49008_50595 = state_49002__$1;
(statearr_49008_50595[(1)] = (2));

} else {
var statearr_49009_50596 = state_49002__$1;
(statearr_49009_50596[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (24))){
var inst_48962 = (state_49002[(9)]);
var inst_48976 = (state_49002[(10)]);
var inst_48953 = (state_49002[(11)]);
var inst_48976__$1 = (inst_48953.cljs$core$IFn$_invoke$arity$1 ? inst_48953.cljs$core$IFn$_invoke$arity$1(inst_48962) : inst_48953.call(null,inst_48962));
var state_49002__$1 = (function (){var statearr_49010 = state_49002;
(statearr_49010[(10)] = inst_48976__$1);

return statearr_49010;
})();
if(cljs.core.truth_(inst_48976__$1)){
var statearr_49011_50597 = state_49002__$1;
(statearr_49011_50597[(1)] = (29));

} else {
var statearr_49012_50598 = state_49002__$1;
(statearr_49012_50598[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (4))){
var inst_48920 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
if(cljs.core.truth_(inst_48920)){
var statearr_49013_50599 = state_49002__$1;
(statearr_49013_50599[(1)] = (8));

} else {
var statearr_49014_50600 = state_49002__$1;
(statearr_49014_50600[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (15))){
var inst_48947 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
if(cljs.core.truth_(inst_48947)){
var statearr_49015_50601 = state_49002__$1;
(statearr_49015_50601[(1)] = (19));

} else {
var statearr_49016_50602 = state_49002__$1;
(statearr_49016_50602[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (21))){
var inst_48952 = (state_49002[(12)]);
var inst_48952__$1 = (state_49002[(2)]);
var inst_48953 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48952__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48952__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48952__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_49002__$1 = (function (){var statearr_49017 = state_49002;
(statearr_49017[(13)] = inst_48954);

(statearr_49017[(12)] = inst_48952__$1);

(statearr_49017[(11)] = inst_48953);

return statearr_49017;
})();
return cljs.core.async.ioc_alts_BANG_(state_49002__$1,(22),inst_48955);
} else {
if((state_val_49003 === (31))){
var inst_48984 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
if(cljs.core.truth_(inst_48984)){
var statearr_49018_50603 = state_49002__$1;
(statearr_49018_50603[(1)] = (32));

} else {
var statearr_49019_50604 = state_49002__$1;
(statearr_49019_50604[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (32))){
var inst_48961 = (state_49002[(14)]);
var state_49002__$1 = state_49002;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49002__$1,(35),out,inst_48961);
} else {
if((state_val_49003 === (33))){
var inst_48952 = (state_49002[(12)]);
var inst_48929 = inst_48952;
var state_49002__$1 = (function (){var statearr_49026 = state_49002;
(statearr_49026[(7)] = inst_48929);

return statearr_49026;
})();
var statearr_49027_50607 = state_49002__$1;
(statearr_49027_50607[(2)] = null);

(statearr_49027_50607[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (13))){
var inst_48929 = (state_49002[(7)]);
var inst_48936 = inst_48929.cljs$lang$protocol_mask$partition0$;
var inst_48937 = (inst_48936 & (64));
var inst_48938 = inst_48929.cljs$core$ISeq$;
var inst_48939 = (cljs.core.PROTOCOL_SENTINEL === inst_48938);
var inst_48940 = ((inst_48937) || (inst_48939));
var state_49002__$1 = state_49002;
if(cljs.core.truth_(inst_48940)){
var statearr_49028_50608 = state_49002__$1;
(statearr_49028_50608[(1)] = (16));

} else {
var statearr_49029_50610 = state_49002__$1;
(statearr_49029_50610[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (22))){
var inst_48961 = (state_49002[(14)]);
var inst_48962 = (state_49002[(9)]);
var inst_48960 = (state_49002[(2)]);
var inst_48961__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48960,(0),null);
var inst_48962__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48960,(1),null);
var inst_48963 = (inst_48961__$1 == null);
var inst_48964 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48962__$1,change);
var inst_48965 = ((inst_48963) || (inst_48964));
var state_49002__$1 = (function (){var statearr_49030 = state_49002;
(statearr_49030[(14)] = inst_48961__$1);

(statearr_49030[(9)] = inst_48962__$1);

return statearr_49030;
})();
if(cljs.core.truth_(inst_48965)){
var statearr_49031_50611 = state_49002__$1;
(statearr_49031_50611[(1)] = (23));

} else {
var statearr_49032_50612 = state_49002__$1;
(statearr_49032_50612[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (36))){
var inst_48952 = (state_49002[(12)]);
var inst_48929 = inst_48952;
var state_49002__$1 = (function (){var statearr_49033 = state_49002;
(statearr_49033[(7)] = inst_48929);

return statearr_49033;
})();
var statearr_49034_50613 = state_49002__$1;
(statearr_49034_50613[(2)] = null);

(statearr_49034_50613[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (29))){
var inst_48976 = (state_49002[(10)]);
var state_49002__$1 = state_49002;
var statearr_49044_50614 = state_49002__$1;
(statearr_49044_50614[(2)] = inst_48976);

(statearr_49044_50614[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (6))){
var state_49002__$1 = state_49002;
var statearr_49045_50615 = state_49002__$1;
(statearr_49045_50615[(2)] = false);

(statearr_49045_50615[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (28))){
var inst_48972 = (state_49002[(2)]);
var inst_48973 = calc_state();
var inst_48929 = inst_48973;
var state_49002__$1 = (function (){var statearr_49046 = state_49002;
(statearr_49046[(15)] = inst_48972);

(statearr_49046[(7)] = inst_48929);

return statearr_49046;
})();
var statearr_49047_50616 = state_49002__$1;
(statearr_49047_50616[(2)] = null);

(statearr_49047_50616[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (25))){
var inst_48998 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
var statearr_49048_50621 = state_49002__$1;
(statearr_49048_50621[(2)] = inst_48998);

(statearr_49048_50621[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (34))){
var inst_48996 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
var statearr_49049_50626 = state_49002__$1;
(statearr_49049_50626[(2)] = inst_48996);

(statearr_49049_50626[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (17))){
var state_49002__$1 = state_49002;
var statearr_49050_50631 = state_49002__$1;
(statearr_49050_50631[(2)] = false);

(statearr_49050_50631[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (3))){
var state_49002__$1 = state_49002;
var statearr_49051_50633 = state_49002__$1;
(statearr_49051_50633[(2)] = false);

(statearr_49051_50633[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (12))){
var inst_49000 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49002__$1,inst_49000);
} else {
if((state_val_49003 === (2))){
var inst_48904 = (state_49002[(8)]);
var inst_48909 = inst_48904.cljs$lang$protocol_mask$partition0$;
var inst_48910 = (inst_48909 & (64));
var inst_48911 = inst_48904.cljs$core$ISeq$;
var inst_48912 = (cljs.core.PROTOCOL_SENTINEL === inst_48911);
var inst_48913 = ((inst_48910) || (inst_48912));
var state_49002__$1 = state_49002;
if(cljs.core.truth_(inst_48913)){
var statearr_49052_50637 = state_49002__$1;
(statearr_49052_50637[(1)] = (5));

} else {
var statearr_49056_50639 = state_49002__$1;
(statearr_49056_50639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (23))){
var inst_48961 = (state_49002[(14)]);
var inst_48967 = (inst_48961 == null);
var state_49002__$1 = state_49002;
if(cljs.core.truth_(inst_48967)){
var statearr_49057_50643 = state_49002__$1;
(statearr_49057_50643[(1)] = (26));

} else {
var statearr_49058_50644 = state_49002__$1;
(statearr_49058_50644[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (35))){
var inst_48987 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
if(cljs.core.truth_(inst_48987)){
var statearr_49059_50645 = state_49002__$1;
(statearr_49059_50645[(1)] = (36));

} else {
var statearr_49060_50647 = state_49002__$1;
(statearr_49060_50647[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (19))){
var inst_48929 = (state_49002[(7)]);
var inst_48949 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_48929);
var state_49002__$1 = state_49002;
var statearr_49061_50649 = state_49002__$1;
(statearr_49061_50649[(2)] = inst_48949);

(statearr_49061_50649[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (11))){
var inst_48929 = (state_49002[(7)]);
var inst_48933 = (inst_48929 == null);
var inst_48934 = cljs.core.not(inst_48933);
var state_49002__$1 = state_49002;
if(inst_48934){
var statearr_49065_50650 = state_49002__$1;
(statearr_49065_50650[(1)] = (13));

} else {
var statearr_49066_50651 = state_49002__$1;
(statearr_49066_50651[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (9))){
var inst_48904 = (state_49002[(8)]);
var state_49002__$1 = state_49002;
var statearr_49067_50652 = state_49002__$1;
(statearr_49067_50652[(2)] = inst_48904);

(statearr_49067_50652[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (5))){
var state_49002__$1 = state_49002;
var statearr_49068_50653 = state_49002__$1;
(statearr_49068_50653[(2)] = true);

(statearr_49068_50653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (14))){
var state_49002__$1 = state_49002;
var statearr_49072_50654 = state_49002__$1;
(statearr_49072_50654[(2)] = false);

(statearr_49072_50654[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (26))){
var inst_48962 = (state_49002[(9)]);
var inst_48969 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_48962);
var state_49002__$1 = state_49002;
var statearr_49073_50655 = state_49002__$1;
(statearr_49073_50655[(2)] = inst_48969);

(statearr_49073_50655[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (16))){
var state_49002__$1 = state_49002;
var statearr_49074_50656 = state_49002__$1;
(statearr_49074_50656[(2)] = true);

(statearr_49074_50656[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (38))){
var inst_48992 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
var statearr_49075_50657 = state_49002__$1;
(statearr_49075_50657[(2)] = inst_48992);

(statearr_49075_50657[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (30))){
var inst_48954 = (state_49002[(13)]);
var inst_48962 = (state_49002[(9)]);
var inst_48953 = (state_49002[(11)]);
var inst_48979 = cljs.core.empty_QMARK_(inst_48953);
var inst_48980 = (inst_48954.cljs$core$IFn$_invoke$arity$1 ? inst_48954.cljs$core$IFn$_invoke$arity$1(inst_48962) : inst_48954.call(null,inst_48962));
var inst_48981 = cljs.core.not(inst_48980);
var inst_48982 = ((inst_48979) && (inst_48981));
var state_49002__$1 = state_49002;
var statearr_49082_50658 = state_49002__$1;
(statearr_49082_50658[(2)] = inst_48982);

(statearr_49082_50658[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (10))){
var inst_48904 = (state_49002[(8)]);
var inst_48925 = (state_49002[(2)]);
var inst_48926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48925,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48927 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48925,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48928 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48925,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_48929 = inst_48904;
var state_49002__$1 = (function (){var statearr_49083 = state_49002;
(statearr_49083[(7)] = inst_48929);

(statearr_49083[(16)] = inst_48926);

(statearr_49083[(17)] = inst_48927);

(statearr_49083[(18)] = inst_48928);

return statearr_49083;
})();
var statearr_49084_50660 = state_49002__$1;
(statearr_49084_50660[(2)] = null);

(statearr_49084_50660[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (18))){
var inst_48944 = (state_49002[(2)]);
var state_49002__$1 = state_49002;
var statearr_49085_50661 = state_49002__$1;
(statearr_49085_50661[(2)] = inst_48944);

(statearr_49085_50661[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (37))){
var state_49002__$1 = state_49002;
var statearr_49086_50662 = state_49002__$1;
(statearr_49086_50662[(2)] = null);

(statearr_49086_50662[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49003 === (8))){
var inst_48904 = (state_49002[(8)]);
var inst_48922 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_48904);
var state_49002__$1 = state_49002;
var statearr_49087_50669 = state_49002__$1;
(statearr_49087_50669[(2)] = inst_48922);

(statearr_49087_50669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__41689__auto__ = null;
var cljs$core$async$mix_$_state_machine__41689__auto____0 = (function (){
var statearr_49088 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49088[(0)] = cljs$core$async$mix_$_state_machine__41689__auto__);

(statearr_49088[(1)] = (1));

return statearr_49088;
});
var cljs$core$async$mix_$_state_machine__41689__auto____1 = (function (state_49002){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49002);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49089){if((e49089 instanceof Object)){
var ex__41692__auto__ = e49089;
var statearr_49090_50670 = state_49002;
(statearr_49090_50670[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49002);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49089;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50671 = state_49002;
state_49002 = G__50671;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__41689__auto__ = function(state_49002){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__41689__auto____1.call(this,state_49002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__41689__auto____0;
cljs$core$async$mix_$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__41689__auto____1;
return cljs$core$async$mix_$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49091 = f__41779__auto__();
(statearr_49091[(6)] = c__41778__auto___50586);

return statearr_49091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_50672 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_50672(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_50676 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_50676(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_50684 = (function() {
var G__50685 = null;
var G__50685__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__50685__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__50685 = function(p,v){
switch(arguments.length){
case 1:
return G__50685__1.call(this,p);
case 2:
return G__50685__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__50685.cljs$core$IFn$_invoke$arity$1 = G__50685__1;
G__50685.cljs$core$IFn$_invoke$arity$2 = G__50685__2;
return G__50685;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__49102 = arguments.length;
switch (G__49102) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50684(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50684(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__49105 = arguments.length;
switch (G__49105) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__49103_SHARP_){
if(cljs.core.truth_((p1__49103_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__49103_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__49103_SHARP_.call(null,topic)))){
return p1__49103_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__49103_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49106 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49106 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta49107){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta49107 = meta49107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49108,meta49107__$1){
var self__ = this;
var _49108__$1 = this;
return (new cljs.core.async.t_cljs$core$async49106(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta49107__$1));
}));

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49108){
var self__ = this;
var _49108__$1 = this;
return self__.meta49107;
}));

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5720__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5720__auto__)){
var m = temp__5720__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async49106.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async49106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta49107","meta49107",1241110375,null)], null);
}));

(cljs.core.async.t_cljs$core$async49106.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49106.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49106");

(cljs.core.async.t_cljs$core$async49106.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49106");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49106.
 */
cljs.core.async.__GT_t_cljs$core$async49106 = (function cljs$core$async$__GT_t_cljs$core$async49106(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta49107){
return (new cljs.core.async.t_cljs$core$async49106(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta49107));
});

}

return (new cljs.core.async.t_cljs$core$async49106(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41778__auto___50714 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49189){
var state_val_49190 = (state_49189[(1)]);
if((state_val_49190 === (7))){
var inst_49185 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
var statearr_49196_50715 = state_49189__$1;
(statearr_49196_50715[(2)] = inst_49185);

(statearr_49196_50715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (20))){
var state_49189__$1 = state_49189;
var statearr_49197_50716 = state_49189__$1;
(statearr_49197_50716[(2)] = null);

(statearr_49197_50716[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (1))){
var state_49189__$1 = state_49189;
var statearr_49198_50717 = state_49189__$1;
(statearr_49198_50717[(2)] = null);

(statearr_49198_50717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (24))){
var inst_49168 = (state_49189[(7)]);
var inst_49177 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_49168);
var state_49189__$1 = state_49189;
var statearr_49199_50718 = state_49189__$1;
(statearr_49199_50718[(2)] = inst_49177);

(statearr_49199_50718[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (4))){
var inst_49120 = (state_49189[(8)]);
var inst_49120__$1 = (state_49189[(2)]);
var inst_49121 = (inst_49120__$1 == null);
var state_49189__$1 = (function (){var statearr_49205 = state_49189;
(statearr_49205[(8)] = inst_49120__$1);

return statearr_49205;
})();
if(cljs.core.truth_(inst_49121)){
var statearr_49206_50719 = state_49189__$1;
(statearr_49206_50719[(1)] = (5));

} else {
var statearr_49207_50720 = state_49189__$1;
(statearr_49207_50720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (15))){
var inst_49162 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
var statearr_49208_50721 = state_49189__$1;
(statearr_49208_50721[(2)] = inst_49162);

(statearr_49208_50721[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (21))){
var inst_49182 = (state_49189[(2)]);
var state_49189__$1 = (function (){var statearr_49209 = state_49189;
(statearr_49209[(9)] = inst_49182);

return statearr_49209;
})();
var statearr_49210_50728 = state_49189__$1;
(statearr_49210_50728[(2)] = null);

(statearr_49210_50728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (13))){
var inst_49144 = (state_49189[(10)]);
var inst_49146 = cljs.core.chunked_seq_QMARK_(inst_49144);
var state_49189__$1 = state_49189;
if(inst_49146){
var statearr_49211_50729 = state_49189__$1;
(statearr_49211_50729[(1)] = (16));

} else {
var statearr_49212_50730 = state_49189__$1;
(statearr_49212_50730[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (22))){
var inst_49174 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
if(cljs.core.truth_(inst_49174)){
var statearr_49213_50731 = state_49189__$1;
(statearr_49213_50731[(1)] = (23));

} else {
var statearr_49214_50732 = state_49189__$1;
(statearr_49214_50732[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (6))){
var inst_49120 = (state_49189[(8)]);
var inst_49168 = (state_49189[(7)]);
var inst_49170 = (state_49189[(11)]);
var inst_49168__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_49120) : topic_fn.call(null,inst_49120));
var inst_49169 = cljs.core.deref(mults);
var inst_49170__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49169,inst_49168__$1);
var state_49189__$1 = (function (){var statearr_49227 = state_49189;
(statearr_49227[(7)] = inst_49168__$1);

(statearr_49227[(11)] = inst_49170__$1);

return statearr_49227;
})();
if(cljs.core.truth_(inst_49170__$1)){
var statearr_49228_50733 = state_49189__$1;
(statearr_49228_50733[(1)] = (19));

} else {
var statearr_49229_50734 = state_49189__$1;
(statearr_49229_50734[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (25))){
var inst_49179 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
var statearr_49230_50735 = state_49189__$1;
(statearr_49230_50735[(2)] = inst_49179);

(statearr_49230_50735[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (17))){
var inst_49144 = (state_49189[(10)]);
var inst_49153 = cljs.core.first(inst_49144);
var inst_49154 = cljs.core.async.muxch_STAR_(inst_49153);
var inst_49155 = cljs.core.async.close_BANG_(inst_49154);
var inst_49156 = cljs.core.next(inst_49144);
var inst_49130 = inst_49156;
var inst_49131 = null;
var inst_49132 = (0);
var inst_49133 = (0);
var state_49189__$1 = (function (){var statearr_49231 = state_49189;
(statearr_49231[(12)] = inst_49155);

(statearr_49231[(13)] = inst_49131);

(statearr_49231[(14)] = inst_49132);

(statearr_49231[(15)] = inst_49130);

(statearr_49231[(16)] = inst_49133);

return statearr_49231;
})();
var statearr_49232_50742 = state_49189__$1;
(statearr_49232_50742[(2)] = null);

(statearr_49232_50742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (3))){
var inst_49187 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49189__$1,inst_49187);
} else {
if((state_val_49190 === (12))){
var inst_49164 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
var statearr_49233_50743 = state_49189__$1;
(statearr_49233_50743[(2)] = inst_49164);

(statearr_49233_50743[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (2))){
var state_49189__$1 = state_49189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49189__$1,(4),ch);
} else {
if((state_val_49190 === (23))){
var state_49189__$1 = state_49189;
var statearr_49234_50744 = state_49189__$1;
(statearr_49234_50744[(2)] = null);

(statearr_49234_50744[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (19))){
var inst_49120 = (state_49189[(8)]);
var inst_49170 = (state_49189[(11)]);
var inst_49172 = cljs.core.async.muxch_STAR_(inst_49170);
var state_49189__$1 = state_49189;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49189__$1,(22),inst_49172,inst_49120);
} else {
if((state_val_49190 === (11))){
var inst_49144 = (state_49189[(10)]);
var inst_49130 = (state_49189[(15)]);
var inst_49144__$1 = cljs.core.seq(inst_49130);
var state_49189__$1 = (function (){var statearr_49235 = state_49189;
(statearr_49235[(10)] = inst_49144__$1);

return statearr_49235;
})();
if(inst_49144__$1){
var statearr_49236_50745 = state_49189__$1;
(statearr_49236_50745[(1)] = (13));

} else {
var statearr_49237_50746 = state_49189__$1;
(statearr_49237_50746[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (9))){
var inst_49166 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
var statearr_49238_50747 = state_49189__$1;
(statearr_49238_50747[(2)] = inst_49166);

(statearr_49238_50747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (5))){
var inst_49127 = cljs.core.deref(mults);
var inst_49128 = cljs.core.vals(inst_49127);
var inst_49129 = cljs.core.seq(inst_49128);
var inst_49130 = inst_49129;
var inst_49131 = null;
var inst_49132 = (0);
var inst_49133 = (0);
var state_49189__$1 = (function (){var statearr_49239 = state_49189;
(statearr_49239[(13)] = inst_49131);

(statearr_49239[(14)] = inst_49132);

(statearr_49239[(15)] = inst_49130);

(statearr_49239[(16)] = inst_49133);

return statearr_49239;
})();
var statearr_49240_50752 = state_49189__$1;
(statearr_49240_50752[(2)] = null);

(statearr_49240_50752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (14))){
var state_49189__$1 = state_49189;
var statearr_49244_50759 = state_49189__$1;
(statearr_49244_50759[(2)] = null);

(statearr_49244_50759[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (16))){
var inst_49144 = (state_49189[(10)]);
var inst_49148 = cljs.core.chunk_first(inst_49144);
var inst_49149 = cljs.core.chunk_rest(inst_49144);
var inst_49150 = cljs.core.count(inst_49148);
var inst_49130 = inst_49149;
var inst_49131 = inst_49148;
var inst_49132 = inst_49150;
var inst_49133 = (0);
var state_49189__$1 = (function (){var statearr_49245 = state_49189;
(statearr_49245[(13)] = inst_49131);

(statearr_49245[(14)] = inst_49132);

(statearr_49245[(15)] = inst_49130);

(statearr_49245[(16)] = inst_49133);

return statearr_49245;
})();
var statearr_49246_50762 = state_49189__$1;
(statearr_49246_50762[(2)] = null);

(statearr_49246_50762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (10))){
var inst_49131 = (state_49189[(13)]);
var inst_49132 = (state_49189[(14)]);
var inst_49130 = (state_49189[(15)]);
var inst_49133 = (state_49189[(16)]);
var inst_49138 = cljs.core._nth(inst_49131,inst_49133);
var inst_49139 = cljs.core.async.muxch_STAR_(inst_49138);
var inst_49140 = cljs.core.async.close_BANG_(inst_49139);
var inst_49141 = (inst_49133 + (1));
var tmp49241 = inst_49131;
var tmp49242 = inst_49132;
var tmp49243 = inst_49130;
var inst_49130__$1 = tmp49243;
var inst_49131__$1 = tmp49241;
var inst_49132__$1 = tmp49242;
var inst_49133__$1 = inst_49141;
var state_49189__$1 = (function (){var statearr_49247 = state_49189;
(statearr_49247[(13)] = inst_49131__$1);

(statearr_49247[(17)] = inst_49140);

(statearr_49247[(14)] = inst_49132__$1);

(statearr_49247[(15)] = inst_49130__$1);

(statearr_49247[(16)] = inst_49133__$1);

return statearr_49247;
})();
var statearr_49248_50763 = state_49189__$1;
(statearr_49248_50763[(2)] = null);

(statearr_49248_50763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (18))){
var inst_49159 = (state_49189[(2)]);
var state_49189__$1 = state_49189;
var statearr_49252_50764 = state_49189__$1;
(statearr_49252_50764[(2)] = inst_49159);

(statearr_49252_50764[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49190 === (8))){
var inst_49132 = (state_49189[(14)]);
var inst_49133 = (state_49189[(16)]);
var inst_49135 = (inst_49133 < inst_49132);
var inst_49136 = inst_49135;
var state_49189__$1 = state_49189;
if(cljs.core.truth_(inst_49136)){
var statearr_49253_50766 = state_49189__$1;
(statearr_49253_50766[(1)] = (10));

} else {
var statearr_49254_50768 = state_49189__$1;
(statearr_49254_50768[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49258 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49258[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49258[(1)] = (1));

return statearr_49258;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49189){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49189);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49259){if((e49259 instanceof Object)){
var ex__41692__auto__ = e49259;
var statearr_49260_50771 = state_49189;
(statearr_49260_50771[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49259;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50772 = state_49189;
state_49189 = G__50772;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49189){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49261 = f__41779__auto__();
(statearr_49261[(6)] = c__41778__auto___50714);

return statearr_49261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__49263 = arguments.length;
switch (G__49263) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__49271 = arguments.length;
switch (G__49271) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__49273 = arguments.length;
switch (G__49273) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__41778__auto___50796 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49315){
var state_val_49316 = (state_49315[(1)]);
if((state_val_49316 === (7))){
var state_49315__$1 = state_49315;
var statearr_49317_50797 = state_49315__$1;
(statearr_49317_50797[(2)] = null);

(statearr_49317_50797[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (1))){
var state_49315__$1 = state_49315;
var statearr_49318_50798 = state_49315__$1;
(statearr_49318_50798[(2)] = null);

(statearr_49318_50798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (4))){
var inst_49276 = (state_49315[(7)]);
var inst_49278 = (inst_49276 < cnt);
var state_49315__$1 = state_49315;
if(cljs.core.truth_(inst_49278)){
var statearr_49322_50799 = state_49315__$1;
(statearr_49322_50799[(1)] = (6));

} else {
var statearr_49323_50800 = state_49315__$1;
(statearr_49323_50800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (15))){
var inst_49311 = (state_49315[(2)]);
var state_49315__$1 = state_49315;
var statearr_49324_50807 = state_49315__$1;
(statearr_49324_50807[(2)] = inst_49311);

(statearr_49324_50807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (13))){
var inst_49301 = cljs.core.async.close_BANG_(out);
var state_49315__$1 = state_49315;
var statearr_49325_50808 = state_49315__$1;
(statearr_49325_50808[(2)] = inst_49301);

(statearr_49325_50808[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (6))){
var state_49315__$1 = state_49315;
var statearr_49326_50809 = state_49315__$1;
(statearr_49326_50809[(2)] = null);

(statearr_49326_50809[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (3))){
var inst_49313 = (state_49315[(2)]);
var state_49315__$1 = state_49315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49315__$1,inst_49313);
} else {
if((state_val_49316 === (12))){
var inst_49298 = (state_49315[(8)]);
var inst_49298__$1 = (state_49315[(2)]);
var inst_49299 = cljs.core.some(cljs.core.nil_QMARK_,inst_49298__$1);
var state_49315__$1 = (function (){var statearr_49327 = state_49315;
(statearr_49327[(8)] = inst_49298__$1);

return statearr_49327;
})();
if(cljs.core.truth_(inst_49299)){
var statearr_49331_50812 = state_49315__$1;
(statearr_49331_50812[(1)] = (13));

} else {
var statearr_49332_50813 = state_49315__$1;
(statearr_49332_50813[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (2))){
var inst_49275 = cljs.core.reset_BANG_(dctr,cnt);
var inst_49276 = (0);
var state_49315__$1 = (function (){var statearr_49333 = state_49315;
(statearr_49333[(9)] = inst_49275);

(statearr_49333[(7)] = inst_49276);

return statearr_49333;
})();
var statearr_49334_50816 = state_49315__$1;
(statearr_49334_50816[(2)] = null);

(statearr_49334_50816[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (11))){
var inst_49276 = (state_49315[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_49315,(10),Object,null,(9));
var inst_49285 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_49276) : chs__$1.call(null,inst_49276));
var inst_49286 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_49276) : done.call(null,inst_49276));
var inst_49287 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_49285,inst_49286);
var state_49315__$1 = state_49315;
var statearr_49335_50819 = state_49315__$1;
(statearr_49335_50819[(2)] = inst_49287);


cljs.core.async.impl.ioc_helpers.process_exception(state_49315__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (9))){
var inst_49276 = (state_49315[(7)]);
var inst_49289 = (state_49315[(2)]);
var inst_49290 = (inst_49276 + (1));
var inst_49276__$1 = inst_49290;
var state_49315__$1 = (function (){var statearr_49336 = state_49315;
(statearr_49336[(10)] = inst_49289);

(statearr_49336[(7)] = inst_49276__$1);

return statearr_49336;
})();
var statearr_49337_50820 = state_49315__$1;
(statearr_49337_50820[(2)] = null);

(statearr_49337_50820[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (5))){
var inst_49296 = (state_49315[(2)]);
var state_49315__$1 = (function (){var statearr_49338 = state_49315;
(statearr_49338[(11)] = inst_49296);

return statearr_49338;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49315__$1,(12),dchan);
} else {
if((state_val_49316 === (14))){
var inst_49298 = (state_49315[(8)]);
var inst_49306 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_49298);
var state_49315__$1 = state_49315;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49315__$1,(16),out,inst_49306);
} else {
if((state_val_49316 === (16))){
var inst_49308 = (state_49315[(2)]);
var state_49315__$1 = (function (){var statearr_49342 = state_49315;
(statearr_49342[(12)] = inst_49308);

return statearr_49342;
})();
var statearr_49343_50822 = state_49315__$1;
(statearr_49343_50822[(2)] = null);

(statearr_49343_50822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (10))){
var inst_49280 = (state_49315[(2)]);
var inst_49281 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_49315__$1 = (function (){var statearr_49344 = state_49315;
(statearr_49344[(13)] = inst_49280);

return statearr_49344;
})();
var statearr_49345_50824 = state_49315__$1;
(statearr_49345_50824[(2)] = inst_49281);


cljs.core.async.impl.ioc_helpers.process_exception(state_49315__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49316 === (8))){
var inst_49294 = (state_49315[(2)]);
var state_49315__$1 = state_49315;
var statearr_49346_50827 = state_49315__$1;
(statearr_49346_50827[(2)] = inst_49294);

(statearr_49346_50827[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49347 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49347[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49347[(1)] = (1));

return statearr_49347;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49315){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49315);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49348){if((e49348 instanceof Object)){
var ex__41692__auto__ = e49348;
var statearr_49349_50829 = state_49315;
(statearr_49349_50829[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49315);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49348;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50831 = state_49315;
state_49315 = G__50831;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49315){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49350 = f__41779__auto__();
(statearr_49350[(6)] = c__41778__auto___50796);

return statearr_49350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__49355 = arguments.length;
switch (G__49355) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41778__auto___50834 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49388){
var state_val_49389 = (state_49388[(1)]);
if((state_val_49389 === (7))){
var inst_49367 = (state_49388[(7)]);
var inst_49368 = (state_49388[(8)]);
var inst_49367__$1 = (state_49388[(2)]);
var inst_49368__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49367__$1,(0),null);
var inst_49369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49367__$1,(1),null);
var inst_49370 = (inst_49368__$1 == null);
var state_49388__$1 = (function (){var statearr_49390 = state_49388;
(statearr_49390[(9)] = inst_49369);

(statearr_49390[(7)] = inst_49367__$1);

(statearr_49390[(8)] = inst_49368__$1);

return statearr_49390;
})();
if(cljs.core.truth_(inst_49370)){
var statearr_49391_50836 = state_49388__$1;
(statearr_49391_50836[(1)] = (8));

} else {
var statearr_49392_50839 = state_49388__$1;
(statearr_49392_50839[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49389 === (1))){
var inst_49357 = cljs.core.vec(chs);
var inst_49358 = inst_49357;
var state_49388__$1 = (function (){var statearr_49393 = state_49388;
(statearr_49393[(10)] = inst_49358);

return statearr_49393;
})();
var statearr_49394_50840 = state_49388__$1;
(statearr_49394_50840[(2)] = null);

(statearr_49394_50840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49389 === (4))){
var inst_49358 = (state_49388[(10)]);
var state_49388__$1 = state_49388;
return cljs.core.async.ioc_alts_BANG_(state_49388__$1,(7),inst_49358);
} else {
if((state_val_49389 === (6))){
var inst_49384 = (state_49388[(2)]);
var state_49388__$1 = state_49388;
var statearr_49395_50846 = state_49388__$1;
(statearr_49395_50846[(2)] = inst_49384);

(statearr_49395_50846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49389 === (3))){
var inst_49386 = (state_49388[(2)]);
var state_49388__$1 = state_49388;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49388__$1,inst_49386);
} else {
if((state_val_49389 === (2))){
var inst_49358 = (state_49388[(10)]);
var inst_49360 = cljs.core.count(inst_49358);
var inst_49361 = (inst_49360 > (0));
var state_49388__$1 = state_49388;
if(cljs.core.truth_(inst_49361)){
var statearr_49400_50852 = state_49388__$1;
(statearr_49400_50852[(1)] = (4));

} else {
var statearr_49401_50855 = state_49388__$1;
(statearr_49401_50855[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49389 === (11))){
var inst_49358 = (state_49388[(10)]);
var inst_49377 = (state_49388[(2)]);
var tmp49396 = inst_49358;
var inst_49358__$1 = tmp49396;
var state_49388__$1 = (function (){var statearr_49406 = state_49388;
(statearr_49406[(10)] = inst_49358__$1);

(statearr_49406[(11)] = inst_49377);

return statearr_49406;
})();
var statearr_49407_50863 = state_49388__$1;
(statearr_49407_50863[(2)] = null);

(statearr_49407_50863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49389 === (9))){
var inst_49368 = (state_49388[(8)]);
var state_49388__$1 = state_49388;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49388__$1,(11),out,inst_49368);
} else {
if((state_val_49389 === (5))){
var inst_49382 = cljs.core.async.close_BANG_(out);
var state_49388__$1 = state_49388;
var statearr_49408_50870 = state_49388__$1;
(statearr_49408_50870[(2)] = inst_49382);

(statearr_49408_50870[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49389 === (10))){
var inst_49380 = (state_49388[(2)]);
var state_49388__$1 = state_49388;
var statearr_49409_50871 = state_49388__$1;
(statearr_49409_50871[(2)] = inst_49380);

(statearr_49409_50871[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49389 === (8))){
var inst_49369 = (state_49388[(9)]);
var inst_49358 = (state_49388[(10)]);
var inst_49367 = (state_49388[(7)]);
var inst_49368 = (state_49388[(8)]);
var inst_49372 = (function (){var cs = inst_49358;
var vec__49363 = inst_49367;
var v = inst_49368;
var c = inst_49369;
return (function (p1__49351_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__49351_SHARP_);
});
})();
var inst_49373 = cljs.core.filterv(inst_49372,inst_49358);
var inst_49358__$1 = inst_49373;
var state_49388__$1 = (function (){var statearr_49410 = state_49388;
(statearr_49410[(10)] = inst_49358__$1);

return statearr_49410;
})();
var statearr_49411_50873 = state_49388__$1;
(statearr_49411_50873[(2)] = null);

(statearr_49411_50873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49418 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49418[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49418[(1)] = (1));

return statearr_49418;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49388){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49388);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49428){if((e49428 instanceof Object)){
var ex__41692__auto__ = e49428;
var statearr_49435_50876 = state_49388;
(statearr_49435_50876[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49388);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49428;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50877 = state_49388;
state_49388 = G__50877;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49388){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49448 = f__41779__auto__();
(statearr_49448[(6)] = c__41778__auto___50834);

return statearr_49448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__49456 = arguments.length;
switch (G__49456) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41778__auto___50881 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49483){
var state_val_49484 = (state_49483[(1)]);
if((state_val_49484 === (7))){
var inst_49465 = (state_49483[(7)]);
var inst_49465__$1 = (state_49483[(2)]);
var inst_49466 = (inst_49465__$1 == null);
var inst_49467 = cljs.core.not(inst_49466);
var state_49483__$1 = (function (){var statearr_49485 = state_49483;
(statearr_49485[(7)] = inst_49465__$1);

return statearr_49485;
})();
if(inst_49467){
var statearr_49486_50882 = state_49483__$1;
(statearr_49486_50882[(1)] = (8));

} else {
var statearr_49487_50883 = state_49483__$1;
(statearr_49487_50883[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (1))){
var inst_49460 = (0);
var state_49483__$1 = (function (){var statearr_49488 = state_49483;
(statearr_49488[(8)] = inst_49460);

return statearr_49488;
})();
var statearr_49489_50885 = state_49483__$1;
(statearr_49489_50885[(2)] = null);

(statearr_49489_50885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (4))){
var state_49483__$1 = state_49483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49483__$1,(7),ch);
} else {
if((state_val_49484 === (6))){
var inst_49478 = (state_49483[(2)]);
var state_49483__$1 = state_49483;
var statearr_49490_50887 = state_49483__$1;
(statearr_49490_50887[(2)] = inst_49478);

(statearr_49490_50887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (3))){
var inst_49480 = (state_49483[(2)]);
var inst_49481 = cljs.core.async.close_BANG_(out);
var state_49483__$1 = (function (){var statearr_49491 = state_49483;
(statearr_49491[(9)] = inst_49480);

return statearr_49491;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49483__$1,inst_49481);
} else {
if((state_val_49484 === (2))){
var inst_49460 = (state_49483[(8)]);
var inst_49462 = (inst_49460 < n);
var state_49483__$1 = state_49483;
if(cljs.core.truth_(inst_49462)){
var statearr_49492_50888 = state_49483__$1;
(statearr_49492_50888[(1)] = (4));

} else {
var statearr_49493_50889 = state_49483__$1;
(statearr_49493_50889[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (11))){
var inst_49460 = (state_49483[(8)]);
var inst_49470 = (state_49483[(2)]);
var inst_49471 = (inst_49460 + (1));
var inst_49460__$1 = inst_49471;
var state_49483__$1 = (function (){var statearr_49494 = state_49483;
(statearr_49494[(10)] = inst_49470);

(statearr_49494[(8)] = inst_49460__$1);

return statearr_49494;
})();
var statearr_49495_50890 = state_49483__$1;
(statearr_49495_50890[(2)] = null);

(statearr_49495_50890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (9))){
var state_49483__$1 = state_49483;
var statearr_49496_50891 = state_49483__$1;
(statearr_49496_50891[(2)] = null);

(statearr_49496_50891[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (5))){
var state_49483__$1 = state_49483;
var statearr_49497_50892 = state_49483__$1;
(statearr_49497_50892[(2)] = null);

(statearr_49497_50892[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (10))){
var inst_49475 = (state_49483[(2)]);
var state_49483__$1 = state_49483;
var statearr_49498_50895 = state_49483__$1;
(statearr_49498_50895[(2)] = inst_49475);

(statearr_49498_50895[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49484 === (8))){
var inst_49465 = (state_49483[(7)]);
var state_49483__$1 = state_49483;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49483__$1,(11),out,inst_49465);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49499 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49499[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49499[(1)] = (1));

return statearr_49499;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49483){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49483);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49503){if((e49503 instanceof Object)){
var ex__41692__auto__ = e49503;
var statearr_49504_50897 = state_49483;
(statearr_49504_50897[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49483);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49503;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50902 = state_49483;
state_49483 = G__50902;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49483){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49505 = f__41779__auto__();
(statearr_49505[(6)] = c__41778__auto___50881);

return statearr_49505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49507 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49507 = (function (f,ch,meta49508){
this.f = f;
this.ch = ch;
this.meta49508 = meta49508;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49509,meta49508__$1){
var self__ = this;
var _49509__$1 = this;
return (new cljs.core.async.t_cljs$core$async49507(self__.f,self__.ch,meta49508__$1));
}));

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49509){
var self__ = this;
var _49509__$1 = this;
return self__.meta49508;
}));

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49510 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49510 = (function (f,ch,meta49508,_,fn1,meta49511){
this.f = f;
this.ch = ch;
this.meta49508 = meta49508;
this._ = _;
this.fn1 = fn1;
this.meta49511 = meta49511;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49510.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49512,meta49511__$1){
var self__ = this;
var _49512__$1 = this;
return (new cljs.core.async.t_cljs$core$async49510(self__.f,self__.ch,self__.meta49508,self__._,self__.fn1,meta49511__$1));
}));

(cljs.core.async.t_cljs$core$async49510.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49512){
var self__ = this;
var _49512__$1 = this;
return self__.meta49511;
}));

(cljs.core.async.t_cljs$core$async49510.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49510.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async49510.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async49510.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__49506_SHARP_){
var G__49513 = (((p1__49506_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__49506_SHARP_) : self__.f.call(null,p1__49506_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__49513) : f1.call(null,G__49513));
});
}));

(cljs.core.async.t_cljs$core$async49510.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49508","meta49508",51894526,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async49507","cljs.core.async/t_cljs$core$async49507",-576107069,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta49511","meta49511",-1299404282,null)], null);
}));

(cljs.core.async.t_cljs$core$async49510.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49510.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49510");

(cljs.core.async.t_cljs$core$async49510.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49510");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49510.
 */
cljs.core.async.__GT_t_cljs$core$async49510 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async49510(f__$1,ch__$1,meta49508__$1,___$2,fn1__$1,meta49511){
return (new cljs.core.async.t_cljs$core$async49510(f__$1,ch__$1,meta49508__$1,___$2,fn1__$1,meta49511));
});

}

return (new cljs.core.async.t_cljs$core$async49510(self__.f,self__.ch,self__.meta49508,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__49514 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__49514) : self__.f.call(null,G__49514));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49507.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async49507.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49508","meta49508",51894526,null)], null);
}));

(cljs.core.async.t_cljs$core$async49507.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49507.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49507");

(cljs.core.async.t_cljs$core$async49507.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49507");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49507.
 */
cljs.core.async.__GT_t_cljs$core$async49507 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async49507(f__$1,ch__$1,meta49508){
return (new cljs.core.async.t_cljs$core$async49507(f__$1,ch__$1,meta49508));
});

}

return (new cljs.core.async.t_cljs$core$async49507(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49524 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49524 = (function (f,ch,meta49525){
this.f = f;
this.ch = ch;
this.meta49525 = meta49525;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49526,meta49525__$1){
var self__ = this;
var _49526__$1 = this;
return (new cljs.core.async.t_cljs$core$async49524(self__.f,self__.ch,meta49525__$1));
}));

(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49526){
var self__ = this;
var _49526__$1 = this;
return self__.meta49525;
}));

(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49524.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async49524.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49525","meta49525",-1349977318,null)], null);
}));

(cljs.core.async.t_cljs$core$async49524.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49524.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49524");

(cljs.core.async.t_cljs$core$async49524.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49524");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49524.
 */
cljs.core.async.__GT_t_cljs$core$async49524 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async49524(f__$1,ch__$1,meta49525){
return (new cljs.core.async.t_cljs$core$async49524(f__$1,ch__$1,meta49525));
});

}

return (new cljs.core.async.t_cljs$core$async49524(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49527 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49527 = (function (p,ch,meta49528){
this.p = p;
this.ch = ch;
this.meta49528 = meta49528;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49529,meta49528__$1){
var self__ = this;
var _49529__$1 = this;
return (new cljs.core.async.t_cljs$core$async49527(self__.p,self__.ch,meta49528__$1));
}));

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49529){
var self__ = this;
var _49529__$1 = this;
return self__.meta49528;
}));

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49527.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async49527.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49528","meta49528",1534198761,null)], null);
}));

(cljs.core.async.t_cljs$core$async49527.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49527.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49527");

(cljs.core.async.t_cljs$core$async49527.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49527");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49527.
 */
cljs.core.async.__GT_t_cljs$core$async49527 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async49527(p__$1,ch__$1,meta49528){
return (new cljs.core.async.t_cljs$core$async49527(p__$1,ch__$1,meta49528));
});

}

return (new cljs.core.async.t_cljs$core$async49527(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__49537 = arguments.length;
switch (G__49537) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41778__auto___50955 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49562){
var state_val_49563 = (state_49562[(1)]);
if((state_val_49563 === (7))){
var inst_49558 = (state_49562[(2)]);
var state_49562__$1 = state_49562;
var statearr_49564_50958 = state_49562__$1;
(statearr_49564_50958[(2)] = inst_49558);

(statearr_49564_50958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (1))){
var state_49562__$1 = state_49562;
var statearr_49565_50960 = state_49562__$1;
(statearr_49565_50960[(2)] = null);

(statearr_49565_50960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (4))){
var inst_49544 = (state_49562[(7)]);
var inst_49544__$1 = (state_49562[(2)]);
var inst_49545 = (inst_49544__$1 == null);
var state_49562__$1 = (function (){var statearr_49566 = state_49562;
(statearr_49566[(7)] = inst_49544__$1);

return statearr_49566;
})();
if(cljs.core.truth_(inst_49545)){
var statearr_49567_50961 = state_49562__$1;
(statearr_49567_50961[(1)] = (5));

} else {
var statearr_49569_50963 = state_49562__$1;
(statearr_49569_50963[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (6))){
var inst_49544 = (state_49562[(7)]);
var inst_49549 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_49544) : p.call(null,inst_49544));
var state_49562__$1 = state_49562;
if(cljs.core.truth_(inst_49549)){
var statearr_49573_50966 = state_49562__$1;
(statearr_49573_50966[(1)] = (8));

} else {
var statearr_49574_50967 = state_49562__$1;
(statearr_49574_50967[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (3))){
var inst_49560 = (state_49562[(2)]);
var state_49562__$1 = state_49562;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49562__$1,inst_49560);
} else {
if((state_val_49563 === (2))){
var state_49562__$1 = state_49562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49562__$1,(4),ch);
} else {
if((state_val_49563 === (11))){
var inst_49552 = (state_49562[(2)]);
var state_49562__$1 = state_49562;
var statearr_49575_50968 = state_49562__$1;
(statearr_49575_50968[(2)] = inst_49552);

(statearr_49575_50968[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (9))){
var state_49562__$1 = state_49562;
var statearr_49576_50969 = state_49562__$1;
(statearr_49576_50969[(2)] = null);

(statearr_49576_50969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (5))){
var inst_49547 = cljs.core.async.close_BANG_(out);
var state_49562__$1 = state_49562;
var statearr_49577_50970 = state_49562__$1;
(statearr_49577_50970[(2)] = inst_49547);

(statearr_49577_50970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (10))){
var inst_49555 = (state_49562[(2)]);
var state_49562__$1 = (function (){var statearr_49578 = state_49562;
(statearr_49578[(8)] = inst_49555);

return statearr_49578;
})();
var statearr_49579_50971 = state_49562__$1;
(statearr_49579_50971[(2)] = null);

(statearr_49579_50971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (8))){
var inst_49544 = (state_49562[(7)]);
var state_49562__$1 = state_49562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49562__$1,(11),out,inst_49544);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49584 = [null,null,null,null,null,null,null,null,null];
(statearr_49584[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49584[(1)] = (1));

return statearr_49584;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49562){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49562);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49585){if((e49585 instanceof Object)){
var ex__41692__auto__ = e49585;
var statearr_49586_50981 = state_49562;
(statearr_49586_50981[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49562);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49585;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50986 = state_49562;
state_49562 = G__50986;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49562){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49587 = f__41779__auto__();
(statearr_49587[(6)] = c__41778__auto___50955);

return statearr_49587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__49589 = arguments.length;
switch (G__49589) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__41778__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49656){
var state_val_49657 = (state_49656[(1)]);
if((state_val_49657 === (7))){
var inst_49652 = (state_49656[(2)]);
var state_49656__$1 = state_49656;
var statearr_49662_51023 = state_49656__$1;
(statearr_49662_51023[(2)] = inst_49652);

(statearr_49662_51023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (20))){
var inst_49622 = (state_49656[(7)]);
var inst_49633 = (state_49656[(2)]);
var inst_49634 = cljs.core.next(inst_49622);
var inst_49608 = inst_49634;
var inst_49609 = null;
var inst_49610 = (0);
var inst_49611 = (0);
var state_49656__$1 = (function (){var statearr_49663 = state_49656;
(statearr_49663[(8)] = inst_49610);

(statearr_49663[(9)] = inst_49609);

(statearr_49663[(10)] = inst_49611);

(statearr_49663[(11)] = inst_49633);

(statearr_49663[(12)] = inst_49608);

return statearr_49663;
})();
var statearr_49664_51039 = state_49656__$1;
(statearr_49664_51039[(2)] = null);

(statearr_49664_51039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (1))){
var state_49656__$1 = state_49656;
var statearr_49671_51045 = state_49656__$1;
(statearr_49671_51045[(2)] = null);

(statearr_49671_51045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (4))){
var inst_49597 = (state_49656[(13)]);
var inst_49597__$1 = (state_49656[(2)]);
var inst_49598 = (inst_49597__$1 == null);
var state_49656__$1 = (function (){var statearr_49672 = state_49656;
(statearr_49672[(13)] = inst_49597__$1);

return statearr_49672;
})();
if(cljs.core.truth_(inst_49598)){
var statearr_49679_51054 = state_49656__$1;
(statearr_49679_51054[(1)] = (5));

} else {
var statearr_49680_51059 = state_49656__$1;
(statearr_49680_51059[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (15))){
var state_49656__$1 = state_49656;
var statearr_49684_51064 = state_49656__$1;
(statearr_49684_51064[(2)] = null);

(statearr_49684_51064[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (21))){
var state_49656__$1 = state_49656;
var statearr_49685_51069 = state_49656__$1;
(statearr_49685_51069[(2)] = null);

(statearr_49685_51069[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (13))){
var inst_49610 = (state_49656[(8)]);
var inst_49609 = (state_49656[(9)]);
var inst_49611 = (state_49656[(10)]);
var inst_49608 = (state_49656[(12)]);
var inst_49618 = (state_49656[(2)]);
var inst_49619 = (inst_49611 + (1));
var tmp49681 = inst_49610;
var tmp49682 = inst_49609;
var tmp49683 = inst_49608;
var inst_49608__$1 = tmp49683;
var inst_49609__$1 = tmp49682;
var inst_49610__$1 = tmp49681;
var inst_49611__$1 = inst_49619;
var state_49656__$1 = (function (){var statearr_49686 = state_49656;
(statearr_49686[(8)] = inst_49610__$1);

(statearr_49686[(9)] = inst_49609__$1);

(statearr_49686[(10)] = inst_49611__$1);

(statearr_49686[(14)] = inst_49618);

(statearr_49686[(12)] = inst_49608__$1);

return statearr_49686;
})();
var statearr_49687_51071 = state_49656__$1;
(statearr_49687_51071[(2)] = null);

(statearr_49687_51071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (22))){
var state_49656__$1 = state_49656;
var statearr_49688_51072 = state_49656__$1;
(statearr_49688_51072[(2)] = null);

(statearr_49688_51072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (6))){
var inst_49597 = (state_49656[(13)]);
var inst_49606 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_49597) : f.call(null,inst_49597));
var inst_49607 = cljs.core.seq(inst_49606);
var inst_49608 = inst_49607;
var inst_49609 = null;
var inst_49610 = (0);
var inst_49611 = (0);
var state_49656__$1 = (function (){var statearr_49701 = state_49656;
(statearr_49701[(8)] = inst_49610);

(statearr_49701[(9)] = inst_49609);

(statearr_49701[(10)] = inst_49611);

(statearr_49701[(12)] = inst_49608);

return statearr_49701;
})();
var statearr_49702_51077 = state_49656__$1;
(statearr_49702_51077[(2)] = null);

(statearr_49702_51077[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (17))){
var inst_49622 = (state_49656[(7)]);
var inst_49626 = cljs.core.chunk_first(inst_49622);
var inst_49627 = cljs.core.chunk_rest(inst_49622);
var inst_49628 = cljs.core.count(inst_49626);
var inst_49608 = inst_49627;
var inst_49609 = inst_49626;
var inst_49610 = inst_49628;
var inst_49611 = (0);
var state_49656__$1 = (function (){var statearr_49704 = state_49656;
(statearr_49704[(8)] = inst_49610);

(statearr_49704[(9)] = inst_49609);

(statearr_49704[(10)] = inst_49611);

(statearr_49704[(12)] = inst_49608);

return statearr_49704;
})();
var statearr_49705_51086 = state_49656__$1;
(statearr_49705_51086[(2)] = null);

(statearr_49705_51086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (3))){
var inst_49654 = (state_49656[(2)]);
var state_49656__$1 = state_49656;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49656__$1,inst_49654);
} else {
if((state_val_49657 === (12))){
var inst_49642 = (state_49656[(2)]);
var state_49656__$1 = state_49656;
var statearr_49706_51088 = state_49656__$1;
(statearr_49706_51088[(2)] = inst_49642);

(statearr_49706_51088[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (2))){
var state_49656__$1 = state_49656;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49656__$1,(4),in$);
} else {
if((state_val_49657 === (23))){
var inst_49650 = (state_49656[(2)]);
var state_49656__$1 = state_49656;
var statearr_49707_51090 = state_49656__$1;
(statearr_49707_51090[(2)] = inst_49650);

(statearr_49707_51090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (19))){
var inst_49637 = (state_49656[(2)]);
var state_49656__$1 = state_49656;
var statearr_49708_51092 = state_49656__$1;
(statearr_49708_51092[(2)] = inst_49637);

(statearr_49708_51092[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (11))){
var inst_49608 = (state_49656[(12)]);
var inst_49622 = (state_49656[(7)]);
var inst_49622__$1 = cljs.core.seq(inst_49608);
var state_49656__$1 = (function (){var statearr_49709 = state_49656;
(statearr_49709[(7)] = inst_49622__$1);

return statearr_49709;
})();
if(inst_49622__$1){
var statearr_49710_51093 = state_49656__$1;
(statearr_49710_51093[(1)] = (14));

} else {
var statearr_49711_51094 = state_49656__$1;
(statearr_49711_51094[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (9))){
var inst_49644 = (state_49656[(2)]);
var inst_49645 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_49656__$1 = (function (){var statearr_49712 = state_49656;
(statearr_49712[(15)] = inst_49644);

return statearr_49712;
})();
if(cljs.core.truth_(inst_49645)){
var statearr_49713_51096 = state_49656__$1;
(statearr_49713_51096[(1)] = (21));

} else {
var statearr_49714_51097 = state_49656__$1;
(statearr_49714_51097[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (5))){
var inst_49600 = cljs.core.async.close_BANG_(out);
var state_49656__$1 = state_49656;
var statearr_49715_51099 = state_49656__$1;
(statearr_49715_51099[(2)] = inst_49600);

(statearr_49715_51099[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (14))){
var inst_49622 = (state_49656[(7)]);
var inst_49624 = cljs.core.chunked_seq_QMARK_(inst_49622);
var state_49656__$1 = state_49656;
if(inst_49624){
var statearr_49716_51102 = state_49656__$1;
(statearr_49716_51102[(1)] = (17));

} else {
var statearr_49717_51103 = state_49656__$1;
(statearr_49717_51103[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (16))){
var inst_49640 = (state_49656[(2)]);
var state_49656__$1 = state_49656;
var statearr_49718_51104 = state_49656__$1;
(statearr_49718_51104[(2)] = inst_49640);

(statearr_49718_51104[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49657 === (10))){
var inst_49609 = (state_49656[(9)]);
var inst_49611 = (state_49656[(10)]);
var inst_49616 = cljs.core._nth(inst_49609,inst_49611);
var state_49656__$1 = state_49656;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49656__$1,(13),out,inst_49616);
} else {
if((state_val_49657 === (18))){
var inst_49622 = (state_49656[(7)]);
var inst_49631 = cljs.core.first(inst_49622);
var state_49656__$1 = state_49656;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49656__$1,(20),out,inst_49631);
} else {
if((state_val_49657 === (8))){
var inst_49610 = (state_49656[(8)]);
var inst_49611 = (state_49656[(10)]);
var inst_49613 = (inst_49611 < inst_49610);
var inst_49614 = inst_49613;
var state_49656__$1 = state_49656;
if(cljs.core.truth_(inst_49614)){
var statearr_49722_51112 = state_49656__$1;
(statearr_49722_51112[(1)] = (10));

} else {
var statearr_49723_51114 = state_49656__$1;
(statearr_49723_51114[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__41689__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__41689__auto____0 = (function (){
var statearr_49724 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49724[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__41689__auto__);

(statearr_49724[(1)] = (1));

return statearr_49724;
});
var cljs$core$async$mapcat_STAR__$_state_machine__41689__auto____1 = (function (state_49656){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49656);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49725){if((e49725 instanceof Object)){
var ex__41692__auto__ = e49725;
var statearr_49726_51133 = state_49656;
(statearr_49726_51133[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49656);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49725;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51134 = state_49656;
state_49656 = G__51134;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__41689__auto__ = function(state_49656){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__41689__auto____1.call(this,state_49656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__41689__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__41689__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49727 = f__41779__auto__();
(statearr_49727[(6)] = c__41778__auto__);

return statearr_49727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));

return c__41778__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__49729 = arguments.length;
switch (G__49729) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__49741 = arguments.length;
switch (G__49741) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__49743 = arguments.length;
switch (G__49743) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41778__auto___51171 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49770){
var state_val_49771 = (state_49770[(1)]);
if((state_val_49771 === (7))){
var inst_49764 = (state_49770[(2)]);
var state_49770__$1 = state_49770;
var statearr_49775_51172 = state_49770__$1;
(statearr_49775_51172[(2)] = inst_49764);

(statearr_49775_51172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49771 === (1))){
var inst_49746 = null;
var state_49770__$1 = (function (){var statearr_49776 = state_49770;
(statearr_49776[(7)] = inst_49746);

return statearr_49776;
})();
var statearr_49777_51173 = state_49770__$1;
(statearr_49777_51173[(2)] = null);

(statearr_49777_51173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49771 === (4))){
var inst_49749 = (state_49770[(8)]);
var inst_49749__$1 = (state_49770[(2)]);
var inst_49750 = (inst_49749__$1 == null);
var inst_49751 = cljs.core.not(inst_49750);
var state_49770__$1 = (function (){var statearr_49778 = state_49770;
(statearr_49778[(8)] = inst_49749__$1);

return statearr_49778;
})();
if(inst_49751){
var statearr_49779_51174 = state_49770__$1;
(statearr_49779_51174[(1)] = (5));

} else {
var statearr_49780_51175 = state_49770__$1;
(statearr_49780_51175[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49771 === (6))){
var state_49770__$1 = state_49770;
var statearr_49781_51176 = state_49770__$1;
(statearr_49781_51176[(2)] = null);

(statearr_49781_51176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49771 === (3))){
var inst_49766 = (state_49770[(2)]);
var inst_49767 = cljs.core.async.close_BANG_(out);
var state_49770__$1 = (function (){var statearr_49782 = state_49770;
(statearr_49782[(9)] = inst_49766);

return statearr_49782;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49770__$1,inst_49767);
} else {
if((state_val_49771 === (2))){
var state_49770__$1 = state_49770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49770__$1,(4),ch);
} else {
if((state_val_49771 === (11))){
var inst_49749 = (state_49770[(8)]);
var inst_49758 = (state_49770[(2)]);
var inst_49746 = inst_49749;
var state_49770__$1 = (function (){var statearr_49783 = state_49770;
(statearr_49783[(7)] = inst_49746);

(statearr_49783[(10)] = inst_49758);

return statearr_49783;
})();
var statearr_49784_51189 = state_49770__$1;
(statearr_49784_51189[(2)] = null);

(statearr_49784_51189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49771 === (9))){
var inst_49749 = (state_49770[(8)]);
var state_49770__$1 = state_49770;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49770__$1,(11),out,inst_49749);
} else {
if((state_val_49771 === (5))){
var inst_49749 = (state_49770[(8)]);
var inst_49746 = (state_49770[(7)]);
var inst_49753 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49749,inst_49746);
var state_49770__$1 = state_49770;
if(inst_49753){
var statearr_49787_51190 = state_49770__$1;
(statearr_49787_51190[(1)] = (8));

} else {
var statearr_49789_51192 = state_49770__$1;
(statearr_49789_51192[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49771 === (10))){
var inst_49761 = (state_49770[(2)]);
var state_49770__$1 = state_49770;
var statearr_49790_51193 = state_49770__$1;
(statearr_49790_51193[(2)] = inst_49761);

(statearr_49790_51193[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49771 === (8))){
var inst_49746 = (state_49770[(7)]);
var tmp49785 = inst_49746;
var inst_49746__$1 = tmp49785;
var state_49770__$1 = (function (){var statearr_49791 = state_49770;
(statearr_49791[(7)] = inst_49746__$1);

return statearr_49791;
})();
var statearr_49792_51197 = state_49770__$1;
(statearr_49792_51197[(2)] = null);

(statearr_49792_51197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49793 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49793[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49793[(1)] = (1));

return statearr_49793;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49770){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49770);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49796){if((e49796 instanceof Object)){
var ex__41692__auto__ = e49796;
var statearr_49797_51198 = state_49770;
(statearr_49797_51198[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49770);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49796;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51199 = state_49770;
state_49770 = G__51199;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49770){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49798 = f__41779__auto__();
(statearr_49798[(6)] = c__41778__auto___51171);

return statearr_49798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__49806 = arguments.length;
switch (G__49806) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41778__auto___51205 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49845){
var state_val_49846 = (state_49845[(1)]);
if((state_val_49846 === (7))){
var inst_49841 = (state_49845[(2)]);
var state_49845__$1 = state_49845;
var statearr_49847_51206 = state_49845__$1;
(statearr_49847_51206[(2)] = inst_49841);

(statearr_49847_51206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (1))){
var inst_49807 = (new Array(n));
var inst_49808 = inst_49807;
var inst_49809 = (0);
var state_49845__$1 = (function (){var statearr_49852 = state_49845;
(statearr_49852[(7)] = inst_49809);

(statearr_49852[(8)] = inst_49808);

return statearr_49852;
})();
var statearr_49854_51207 = state_49845__$1;
(statearr_49854_51207[(2)] = null);

(statearr_49854_51207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (4))){
var inst_49812 = (state_49845[(9)]);
var inst_49812__$1 = (state_49845[(2)]);
var inst_49813 = (inst_49812__$1 == null);
var inst_49814 = cljs.core.not(inst_49813);
var state_49845__$1 = (function (){var statearr_49855 = state_49845;
(statearr_49855[(9)] = inst_49812__$1);

return statearr_49855;
})();
if(inst_49814){
var statearr_49856_51208 = state_49845__$1;
(statearr_49856_51208[(1)] = (5));

} else {
var statearr_49857_51209 = state_49845__$1;
(statearr_49857_51209[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (15))){
var inst_49835 = (state_49845[(2)]);
var state_49845__$1 = state_49845;
var statearr_49858_51210 = state_49845__$1;
(statearr_49858_51210[(2)] = inst_49835);

(statearr_49858_51210[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (13))){
var state_49845__$1 = state_49845;
var statearr_49859_51211 = state_49845__$1;
(statearr_49859_51211[(2)] = null);

(statearr_49859_51211[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (6))){
var inst_49809 = (state_49845[(7)]);
var inst_49831 = (inst_49809 > (0));
var state_49845__$1 = state_49845;
if(cljs.core.truth_(inst_49831)){
var statearr_49860_51212 = state_49845__$1;
(statearr_49860_51212[(1)] = (12));

} else {
var statearr_49861_51213 = state_49845__$1;
(statearr_49861_51213[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (3))){
var inst_49843 = (state_49845[(2)]);
var state_49845__$1 = state_49845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49845__$1,inst_49843);
} else {
if((state_val_49846 === (12))){
var inst_49808 = (state_49845[(8)]);
var inst_49833 = cljs.core.vec(inst_49808);
var state_49845__$1 = state_49845;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49845__$1,(15),out,inst_49833);
} else {
if((state_val_49846 === (2))){
var state_49845__$1 = state_49845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49845__$1,(4),ch);
} else {
if((state_val_49846 === (11))){
var inst_49824 = (state_49845[(2)]);
var inst_49826 = (new Array(n));
var inst_49808 = inst_49826;
var inst_49809 = (0);
var state_49845__$1 = (function (){var statearr_49867 = state_49845;
(statearr_49867[(10)] = inst_49824);

(statearr_49867[(7)] = inst_49809);

(statearr_49867[(8)] = inst_49808);

return statearr_49867;
})();
var statearr_49868_51214 = state_49845__$1;
(statearr_49868_51214[(2)] = null);

(statearr_49868_51214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (9))){
var inst_49808 = (state_49845[(8)]);
var inst_49822 = cljs.core.vec(inst_49808);
var state_49845__$1 = state_49845;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49845__$1,(11),out,inst_49822);
} else {
if((state_val_49846 === (5))){
var inst_49809 = (state_49845[(7)]);
var inst_49812 = (state_49845[(9)]);
var inst_49808 = (state_49845[(8)]);
var inst_49817 = (state_49845[(11)]);
var inst_49816 = (inst_49808[inst_49809] = inst_49812);
var inst_49817__$1 = (inst_49809 + (1));
var inst_49818 = (inst_49817__$1 < n);
var state_49845__$1 = (function (){var statearr_49869 = state_49845;
(statearr_49869[(11)] = inst_49817__$1);

(statearr_49869[(12)] = inst_49816);

return statearr_49869;
})();
if(cljs.core.truth_(inst_49818)){
var statearr_49870_51219 = state_49845__$1;
(statearr_49870_51219[(1)] = (8));

} else {
var statearr_49871_51221 = state_49845__$1;
(statearr_49871_51221[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (14))){
var inst_49838 = (state_49845[(2)]);
var inst_49839 = cljs.core.async.close_BANG_(out);
var state_49845__$1 = (function (){var statearr_49873 = state_49845;
(statearr_49873[(13)] = inst_49838);

return statearr_49873;
})();
var statearr_49874_51222 = state_49845__$1;
(statearr_49874_51222[(2)] = inst_49839);

(statearr_49874_51222[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (10))){
var inst_49829 = (state_49845[(2)]);
var state_49845__$1 = state_49845;
var statearr_49878_51223 = state_49845__$1;
(statearr_49878_51223[(2)] = inst_49829);

(statearr_49878_51223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49846 === (8))){
var inst_49808 = (state_49845[(8)]);
var inst_49817 = (state_49845[(11)]);
var tmp49872 = inst_49808;
var inst_49808__$1 = tmp49872;
var inst_49809 = inst_49817;
var state_49845__$1 = (function (){var statearr_49879 = state_49845;
(statearr_49879[(7)] = inst_49809);

(statearr_49879[(8)] = inst_49808__$1);

return statearr_49879;
})();
var statearr_49880_51224 = state_49845__$1;
(statearr_49880_51224[(2)] = null);

(statearr_49880_51224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49882 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49882[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49882[(1)] = (1));

return statearr_49882;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49845){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49845);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49883){if((e49883 instanceof Object)){
var ex__41692__auto__ = e49883;
var statearr_49884_51231 = state_49845;
(statearr_49884_51231[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49845);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49883;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51232 = state_49845;
state_49845 = G__51232;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49845){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49889 = f__41779__auto__();
(statearr_49889[(6)] = c__41778__auto___51205);

return statearr_49889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__49896 = arguments.length;
switch (G__49896) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__41778__auto___51238 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__41779__auto__ = (function (){var switch__41688__auto__ = (function (state_49938){
var state_val_49939 = (state_49938[(1)]);
if((state_val_49939 === (7))){
var inst_49934 = (state_49938[(2)]);
var state_49938__$1 = state_49938;
var statearr_49940_51239 = state_49938__$1;
(statearr_49940_51239[(2)] = inst_49934);

(statearr_49940_51239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (1))){
var inst_49897 = [];
var inst_49898 = inst_49897;
var inst_49899 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_49938__$1 = (function (){var statearr_49941 = state_49938;
(statearr_49941[(7)] = inst_49898);

(statearr_49941[(8)] = inst_49899);

return statearr_49941;
})();
var statearr_49942_51240 = state_49938__$1;
(statearr_49942_51240[(2)] = null);

(statearr_49942_51240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (4))){
var inst_49902 = (state_49938[(9)]);
var inst_49902__$1 = (state_49938[(2)]);
var inst_49903 = (inst_49902__$1 == null);
var inst_49904 = cljs.core.not(inst_49903);
var state_49938__$1 = (function (){var statearr_49943 = state_49938;
(statearr_49943[(9)] = inst_49902__$1);

return statearr_49943;
})();
if(inst_49904){
var statearr_49944_51241 = state_49938__$1;
(statearr_49944_51241[(1)] = (5));

} else {
var statearr_49945_51242 = state_49938__$1;
(statearr_49945_51242[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (15))){
var inst_49928 = (state_49938[(2)]);
var state_49938__$1 = state_49938;
var statearr_49950_51243 = state_49938__$1;
(statearr_49950_51243[(2)] = inst_49928);

(statearr_49950_51243[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (13))){
var state_49938__$1 = state_49938;
var statearr_49951_51244 = state_49938__$1;
(statearr_49951_51244[(2)] = null);

(statearr_49951_51244[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (6))){
var inst_49898 = (state_49938[(7)]);
var inst_49923 = inst_49898.length;
var inst_49924 = (inst_49923 > (0));
var state_49938__$1 = state_49938;
if(cljs.core.truth_(inst_49924)){
var statearr_49953_51250 = state_49938__$1;
(statearr_49953_51250[(1)] = (12));

} else {
var statearr_49954_51253 = state_49938__$1;
(statearr_49954_51253[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (3))){
var inst_49936 = (state_49938[(2)]);
var state_49938__$1 = state_49938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49938__$1,inst_49936);
} else {
if((state_val_49939 === (12))){
var inst_49898 = (state_49938[(7)]);
var inst_49926 = cljs.core.vec(inst_49898);
var state_49938__$1 = state_49938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49938__$1,(15),out,inst_49926);
} else {
if((state_val_49939 === (2))){
var state_49938__$1 = state_49938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49938__$1,(4),ch);
} else {
if((state_val_49939 === (11))){
var inst_49906 = (state_49938[(10)]);
var inst_49902 = (state_49938[(9)]);
var inst_49916 = (state_49938[(2)]);
var inst_49917 = [];
var inst_49918 = inst_49917.push(inst_49902);
var inst_49898 = inst_49917;
var inst_49899 = inst_49906;
var state_49938__$1 = (function (){var statearr_49957 = state_49938;
(statearr_49957[(11)] = inst_49916);

(statearr_49957[(7)] = inst_49898);

(statearr_49957[(12)] = inst_49918);

(statearr_49957[(8)] = inst_49899);

return statearr_49957;
})();
var statearr_49958_51258 = state_49938__$1;
(statearr_49958_51258[(2)] = null);

(statearr_49958_51258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (9))){
var inst_49898 = (state_49938[(7)]);
var inst_49914 = cljs.core.vec(inst_49898);
var state_49938__$1 = state_49938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49938__$1,(11),out,inst_49914);
} else {
if((state_val_49939 === (5))){
var inst_49906 = (state_49938[(10)]);
var inst_49902 = (state_49938[(9)]);
var inst_49899 = (state_49938[(8)]);
var inst_49906__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_49902) : f.call(null,inst_49902));
var inst_49907 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49906__$1,inst_49899);
var inst_49908 = cljs.core.keyword_identical_QMARK_(inst_49899,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_49909 = ((inst_49907) || (inst_49908));
var state_49938__$1 = (function (){var statearr_49959 = state_49938;
(statearr_49959[(10)] = inst_49906__$1);

return statearr_49959;
})();
if(cljs.core.truth_(inst_49909)){
var statearr_49960_51264 = state_49938__$1;
(statearr_49960_51264[(1)] = (8));

} else {
var statearr_49961_51265 = state_49938__$1;
(statearr_49961_51265[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (14))){
var inst_49931 = (state_49938[(2)]);
var inst_49932 = cljs.core.async.close_BANG_(out);
var state_49938__$1 = (function (){var statearr_49964 = state_49938;
(statearr_49964[(13)] = inst_49931);

return statearr_49964;
})();
var statearr_49965_51266 = state_49938__$1;
(statearr_49965_51266[(2)] = inst_49932);

(statearr_49965_51266[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (10))){
var inst_49921 = (state_49938[(2)]);
var state_49938__$1 = state_49938;
var statearr_49966_51267 = state_49938__$1;
(statearr_49966_51267[(2)] = inst_49921);

(statearr_49966_51267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49939 === (8))){
var inst_49898 = (state_49938[(7)]);
var inst_49906 = (state_49938[(10)]);
var inst_49902 = (state_49938[(9)]);
var inst_49911 = inst_49898.push(inst_49902);
var tmp49962 = inst_49898;
var inst_49898__$1 = tmp49962;
var inst_49899 = inst_49906;
var state_49938__$1 = (function (){var statearr_49967 = state_49938;
(statearr_49967[(7)] = inst_49898__$1);

(statearr_49967[(14)] = inst_49911);

(statearr_49967[(8)] = inst_49899);

return statearr_49967;
})();
var statearr_49968_51274 = state_49938__$1;
(statearr_49968_51274[(2)] = null);

(statearr_49968_51274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__41689__auto__ = null;
var cljs$core$async$state_machine__41689__auto____0 = (function (){
var statearr_49969 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49969[(0)] = cljs$core$async$state_machine__41689__auto__);

(statearr_49969[(1)] = (1));

return statearr_49969;
});
var cljs$core$async$state_machine__41689__auto____1 = (function (state_49938){
while(true){
var ret_value__41690__auto__ = (function (){try{while(true){
var result__41691__auto__ = switch__41688__auto__(state_49938);
if(cljs.core.keyword_identical_QMARK_(result__41691__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41691__auto__;
}
break;
}
}catch (e49971){if((e49971 instanceof Object)){
var ex__41692__auto__ = e49971;
var statearr_49972_51278 = state_49938;
(statearr_49972_51278[(5)] = ex__41692__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_49938);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e49971;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__41690__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51279 = state_49938;
state_49938 = G__51279;
continue;
} else {
return ret_value__41690__auto__;
}
break;
}
});
cljs$core$async$state_machine__41689__auto__ = function(state_49938){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41689__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41689__auto____1.call(this,state_49938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41689__auto____0;
cljs$core$async$state_machine__41689__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41689__auto____1;
return cljs$core$async$state_machine__41689__auto__;
})()
})();
var state__41780__auto__ = (function (){var statearr_49973 = f__41779__auto__();
(statearr_49973[(6)] = c__41778__auto___51238);

return statearr_49973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__41780__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
