/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import ru.qatools.gridrouter.sessions.StatsCounter;

@Configuration
@EnableScheduling
public class SessionStorageEvictionScheduler {
    @Value(value="${grid.router.evict.sessions.timeout.seconds}")
    private int timeout;
    @Autowired
    private StatsCounter statsCounter;

    @Scheduled(cron="${grid.router.evict.sessions.cron}")
    public void expireOldSessions() {
        this.statsCounter.expireSessionsOlderThan(Duration.ofSeconds(this.timeout));
    }
}

