/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import ru.qatools.gridrouter.ConfigRepository;
import ru.qatools.gridrouter.RequestUtils;
import ru.qatools.gridrouter.SpringHttpServlet;
import ru.qatools.gridrouter.caps.CapabilityProcessorFactory;
import ru.qatools.gridrouter.config.Host;
import ru.qatools.gridrouter.config.HostSelectionStrategy;
import ru.qatools.gridrouter.config.Region;
import ru.qatools.gridrouter.config.Version;
import ru.qatools.gridrouter.config.WithCopy;
import ru.qatools.gridrouter.json.JsonCapabilities;
import ru.qatools.gridrouter.json.JsonMessage;
import ru.qatools.gridrouter.json.JsonMessageFactory;
import ru.qatools.gridrouter.sessions.AvailableBrowserCheckExeption;
import ru.qatools.gridrouter.sessions.AvailableBrowsersChecker;
import ru.qatools.gridrouter.sessions.StatsCounter;

@WebServlet(urlPatterns={"/wd/hub/session"}, asyncSupported=true)
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user"}))
public class RouteServlet
extends SpringHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteServlet.class);
    private static final String ROUTE_TIMEOUT_CAPABILITY = "grid.router.route.timeout.seconds";
    private static final int MAX_ROUTE_TIMEOUT_SECONDS = 300;
    @Autowired
    private transient ConfigRepository config;
    @Autowired
    private transient HostSelectionStrategy hostSelectionStrategy;
    @Autowired
    private transient StatsCounter statsCounter;
    @Autowired
    private transient CapabilityProcessorFactory capabilityProcessorFactory;
    @Autowired
    private transient AvailableBrowsersChecker avblBrowsersChecker;
    @Value(value="${grid.router.route.timeout.seconds:120}")
    private int routeTimeout;
    private AtomicLong requestCounter = new AtomicLong();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
        JsonMessage message = JsonMessageFactory.from((InputStream)request.getInputStream());
        long requestId = this.requestCounter.getAndIncrement();
        int routeTimeout = this.getRouteTimeout(request.getRemoteUser(), message);
        AtomicBoolean terminated = new AtomicBoolean(false);
        executor.submit(this.getRouteCallable(request, message, response, requestId, routeTimeout, terminated));
        executor.shutdown();
        try {
            executor.awaitTermination(routeTimeout, TimeUnit.SECONDS);
            terminated.set(true);
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
        }
        this.replyWithError("Timed out when searching for valid host", response);
    }

    private Callable<Object> getRouteCallable(HttpServletRequest request, JsonMessage message, HttpServletResponse response, long requestId, int routeTimeout, AtomicBoolean terminated) {
        return () -> {
            this.route(request, message, response, requestId, routeTimeout, terminated);
            return null;
        };
    }

    private int getRouteTimeout(String user, JsonMessage message) {
        JsonCapabilities caps = message.getDesiredCapabilities();
        try {
            if (caps.any().containsKey(ROUTE_TIMEOUT_CAPABILITY)) {
                Integer desiredRouteTimeout = Integer.valueOf(String.valueOf(caps.any().get(ROUTE_TIMEOUT_CAPABILITY)));
                this.routeTimeout = desiredRouteTimeout < 300 ? desiredRouteTimeout : 300;
                LOGGER.warn("[{}] [INVALID_ROUTE_TIMEOUT] [{}]", (Object)user, (Object)desiredRouteTimeout);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.routeTimeout;
    }

    private void route(HttpServletRequest request, JsonMessage message, HttpServletResponse response, long requestId, int routeTimeout, AtomicBoolean terminated) throws IOException {
        long initialSeconds = Instant.now().getEpochSecond();
        JsonCapabilities caps = message.getDesiredCapabilities();
        String user = request.getRemoteUser();
        String remoteHost = RequestUtils.getRemoteHost(request);
        String browser = caps.describe();
        Version actualVersion = this.config.findVersion(user, caps);
        if (actualVersion == null) {
            LOGGER.warn("[{}] [UNSUPPORTED_BROWSER] [{}] [{}] [{}]", new Object[]{requestId, user, remoteHost, browser});
            this.replyWithError(String.format("Cannot find %s capabilities on any available node", caps.describe()), response);
            return;
        }
        caps.setVersion(actualVersion.getNumber());
        this.capabilityProcessorFactory.getProcessor(caps).process(caps);
        List allRegions = actualVersion.getRegions().stream().map(WithCopy::copy).collect(Collectors.toList());
        ArrayList unvisitedRegions = new ArrayList(allRegions);
        int attempt = 0;
        JsonMessage hubMessage = null;
        try (CloseableHttpClient client = this.newHttpClient(routeTimeout * 1000);){
            if (actualVersion.getPermittedCount() != null) {
                this.avblBrowsersChecker.ensureFreeBrowsersAvailable(user, remoteHost, browser, actualVersion);
            }
            while (!allRegions.isEmpty() && !terminated.get()) {
                String route;
                Host host;
                Region currentRegion;
                block27: {
                    ++attempt;
                    currentRegion = this.hostSelectionStrategy.selectRegion(allRegions, unvisitedRegions);
                    host = this.hostSelectionStrategy.selectHost(currentRegion.getHosts());
                    route = host.getRoute();
                    LOGGER.info("[{}] [SESSION_ATTEMPTED] [{}] [{}] [{}] [{}] [{}]", new Object[]{requestId, user, remoteHost, browser, route, attempt});
                    String target = route + request.getRequestURI();
                    CloseableHttpResponse hubResponse = client.execute((HttpUriRequest)this.post(target, message));
                    hubMessage = JsonMessageFactory.from(hubResponse.getEntity().getContent());
                    if (hubResponse.getStatusLine().getStatusCode() != 200) break block27;
                    String sessionId = hubMessage.getSessionId();
                    hubMessage.setSessionId(host.getRouteId() + sessionId);
                    this.replyWithOk(hubMessage, response);
                    long createdDurationSeconds = Instant.now().getEpochSecond() - initialSeconds;
                    LOGGER.info("[{}] [{}] [SESSION_CREATED] [{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{requestId, createdDurationSeconds, user, remoteHost, browser, route, sessionId, attempt});
                    this.statsCounter.startSession(hubMessage.getSessionId(), user, caps.getBrowserName(), actualVersion.getNumber(), route);
                    return;
                }
                try {
                    LOGGER.warn("[{}] [SESSION_FAILED] [{}] [{}] [{}] [{}] - {}", new Object[]{requestId, user, remoteHost, browser, route, hubMessage.getErrorMessage()});
                }
                catch (JsonProcessingException exception) {
                    LOGGER.error("[{}] [BAD_HUB_JSON] [{}] [{}] [{}] [{}] - {}", new Object[]{"", requestId, user, remoteHost, browser, route, exception.getMessage()});
                }
                catch (IOException exception) {
                    LOGGER.error("[{}] [HUB_COMMUNICATION_FAILURE] [{}] [{}] [{}] - {}", new Object[]{requestId, user, remoteHost, browser, route, exception.getMessage()});
                }
                currentRegion.getHosts().remove(host);
                if (currentRegion.getHosts().isEmpty()) {
                    allRegions.remove(currentRegion);
                }
                unvisitedRegions.remove(currentRegion);
                if (!unvisitedRegions.isEmpty()) continue;
                unvisitedRegions = new ArrayList(allRegions);
            }
        }
        catch (AvailableBrowserCheckExeption e) {
            LOGGER.error("[{}] [AVAILABLE_BROWSER_CHECK_ERROR] [{}] [{}] [{}] - {}", new Object[]{requestId, user, remoteHost, browser, e.getMessage()});
        }
        LOGGER.error("[{}] [SESSION_NOT_CREATED] [{}] [{}] [{}]", new Object[]{requestId, user, remoteHost, browser});
        if (hubMessage == null) {
            this.replyWithError("Cannot create session on any available node", response);
        } else {
            this.replyWithError(hubMessage, response);
        }
    }

    protected void replyWithOk(JsonMessage message, HttpServletResponse response) throws IOException {
        this.reply(200, message, response);
    }

    protected void replyWithError(String errorMessage, HttpServletResponse response) throws IOException {
        this.replyWithError(JsonMessageFactory.error(13, errorMessage), response);
    }

    protected void replyWithError(JsonMessage message, HttpServletResponse response) throws IOException {
        this.reply(500, message, response);
    }

    protected void reply(int code, JsonMessage message, HttpServletResponse response) throws IOException {
        response.setStatus(code);
        response.setContentType(ContentType.APPLICATION_JSON.toString());
        String messageRaw = message.toJson();
        response.setContentLength(messageRaw.getBytes(StandardCharsets.UTF_8).length);
        try (ServletOutputStream output = response.getOutputStream();){
            IOUtils.write((String)messageRaw, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
    }

    protected HttpPost post(String target, JsonMessage message) throws IOException {
        HttpPost method = new HttpPost(target);
        StringEntity entity = new StringEntity(message.toJson(), ContentType.APPLICATION_JSON);
        method.setEntity((HttpEntity)entity);
        method.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        return method;
    }

    protected CloseableHttpClient newHttpClient(int maxTimeout) {
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(maxTimeout).build()).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).disableAutomaticRetries().build();
    }
}

