/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import ru.qatools.gridrouter.ConfigRepository;
import ru.qatools.gridrouter.JsonWireUtils;
import ru.qatools.gridrouter.RequestUtils;
import ru.qatools.gridrouter.json.JsonMessage;
import ru.qatools.gridrouter.json.JsonMessageFactory;
import ru.qatools.gridrouter.sessions.StatsCounter;

@WebServlet(urlPatterns={"/wd/hub/session/*"}, asyncSupported=true, initParams={@WebInitParam(name="timeout", value="300000"), @WebInitParam(name="idleTimeout", value="300000")})
public class ProxyServlet
extends org.eclipse.jetty.proxy.ProxyServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServlet.class);
    @Autowired
    private transient ConfigRepository config;
    @Autowired
    private transient StatsCounter statsCounter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)((Object)this), (ServletContext)config.getServletContext());
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        try {
            Request request = this.getRequestWithoutSessionId(clientRequest, proxyRequest);
            super.sendProxyRequest(clientRequest, proxyResponse, request);
        }
        catch (Exception exception) {
            LOGGER.error("[REQUEST_READ_FAILURE] [{}] - could not read client request, proxying request as is", (Object)clientRequest.getRemoteHost(), (Object)exception);
            super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
        }
    }

    protected String rewriteTarget(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String remoteHost = RequestUtils.getRemoteHost(request);
        if (!JsonWireUtils.isUriValid(uri)) {
            LOGGER.warn("[INVALID_SESSION_HASH] [{}] - request uri is {}", (Object)remoteHost, (Object)uri);
            return null;
        }
        String route = this.config.getRoute(JsonWireUtils.getSessionHash(uri));
        String command = JsonWireUtils.getCommand(uri);
        if (route == null) {
            LOGGER.error("[ROUTE_NOT_FOUND] [{}] - request uri is {}", (Object)remoteHost, (Object)uri);
            return null;
        }
        if (JsonWireUtils.isSessionDeleteRequest(request, command)) {
            LOGGER.info("[SESSION_DELETED] [{}] [{}] [{}]", new Object[]{remoteHost, route, command});
            this.statsCounter.deleteSession(JsonWireUtils.getFullSessionId(uri), route);
        } else {
            this.statsCounter.updateSession(JsonWireUtils.getFullSessionId(uri), route);
        }
        try {
            return JsonWireUtils.redirectionUrl(route, command);
        }
        catch (Exception exception) {
            LOGGER.error("[REDIRECTION_URL_ERROR] [{}] - error building redirection uri because of {}\n    request uri:    {}\n    parsed route:   {}\n    parsed command: {}", new Object[]{remoteHost, exception.toString(), uri, route, command});
            return null;
        }
    }

    protected Request getRequestWithoutSessionId(HttpServletRequest clientRequest, Request proxyRequest) throws IOException {
        String content = IOUtils.toString((InputStream)clientRequest.getInputStream(), (Charset)StandardCharsets.UTF_8);
        if (!content.isEmpty()) {
            String remoteHost = RequestUtils.getRemoteHost(clientRequest);
            content = this.removeSessionIdSafe(content, remoteHost);
        }
        return proxyRequest.content((ContentProvider)new StringContentProvider(clientRequest.getContentType(), content, StandardCharsets.UTF_8));
    }

    private String removeSessionIdSafe(String content, String remoteHost) {
        try {
            JsonMessage message = JsonMessageFactory.from(content);
            message.setSessionId(null);
            return message.toJson();
        }
        catch (IOException exception) {
            LOGGER.error("[UNABLE_TO_REMOVE_SESSION_ID] [{}] - could not create proxy request without session id, proxying request as is. Request content is: {}", new Object[]{remoteHost, content, exception});
            return content;
        }
    }
}

