/*
 * Decompiled with CFR 0.152.
 */
package junitparams;

import java.lang.annotation.Annotation;
import java.util.List;
import junitparams.ParameterisedTestClassRunner;
import junitparams.TestMethod;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JUnitParamsRunner
extends BlockJUnit4ClassRunner {
    private ParameterisedTestClassRunner parameterisedRunner = new ParameterisedTestClassRunner();

    public JUnitParamsRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.computeTestMethods();
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.handleIgnored(method, notifier)) {
            return;
        }
        if (!this.parameterisedRunner.runParameterisedTest(new TestMethod(method), this.methodBlock(method), notifier)) {
            super.runChild(method, notifier);
        }
    }

    private boolean handleIgnored(FrameworkMethod method, RunNotifier notifier) {
        TestMethod testMethod = new TestMethod(method);
        boolean ignored = false;
        if (method.getAnnotation(Ignore.class) != null) {
            if (this.parameterisedRunner.isParameterised(testMethod)) {
                Description ignoredMethod = this.parameterisedRunner.describeParameterisedMethod(testMethod);
                for (Description child : ignoredMethod.getChildren()) {
                    notifier.fireTestIgnored(child);
                    ignored = true;
                }
            } else {
                notifier.fireTestIgnored(this.describeMethod(method));
                ignored = true;
            }
        }
        return ignored;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return this.parameterisedRunner.computeTestMethods(TestMethod.listFrom(this.getTestClass().getAnnotatedMethods(Test.class)), false);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        Statement methodInvoker = this.parameterisedRunner.parameterisedMethodInvoker(new TestMethod(method), test);
        if (methodInvoker == null) {
            methodInvoker = super.methodInvoker(method, test);
        }
        return methodInvoker;
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.getTestClass().getAnnotations());
        List<FrameworkMethod> resultMethods = this.parameterisedRunner.computeTestMethods(TestMethod.listFrom(this.getTestClass().getAnnotatedMethods(Test.class)), true);
        for (FrameworkMethod method : resultMethods) {
            description.addChild(this.describeMethod(method));
        }
        return description;
    }

    private Description describeMethod(FrameworkMethod method) {
        Description child = this.parameterisedRunner.describeParameterisedMethod(new TestMethod(method));
        if (child == null) {
            child = this.describeChild(method);
        }
        return child;
    }

    public static Object[] $(Object ... params) {
        return params;
    }
}

