/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class ObjectLargeArray
extends LargeArray {
    private static final long serialVersionUID = -4096759496772248522L;
    private Object[] data;
    private ShortLargeArray objectLengths;
    private int maxObjectLength;
    private long size;
    private byte[] byteArray;

    public ObjectLargeArray(long length) {
        this(length, 1024);
    }

    public ObjectLargeArray(long length, int maxObjectLength) {
        this(length, maxObjectLength, true);
    }

    public ObjectLargeArray(long length, int maxObjectLength, boolean zeroNativeMemory) {
        this.type = LargeArrayType.OBJECT;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value.");
        }
        if (maxObjectLength <= 0) {
            throw new IllegalArgumentException(maxObjectLength + " is not a positive int value.");
        }
        this.length = length;
        this.size = length * (long)maxObjectLength;
        this.maxObjectLength = maxObjectLength;
        if (length > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.size * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(this.size);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.sizeof));
            MemoryCounter.increaseCounter(this.size * this.sizeof);
            this.objectLengths = new ShortLargeArray(length);
            this.byteArray = new byte[maxObjectLength];
        } else {
            this.data = new Object[(int)length];
        }
    }

    public ObjectLargeArray(long length, Object constantValue) {
        this.type = LargeArrayType.OBJECT;
        this.sizeof = 1L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new Object[]{constantValue};
    }

    public ObjectLargeArray(Object[] data) {
        this.type = LargeArrayType.OBJECT;
        this.sizeof = 1L;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public ObjectLargeArray clone() {
        if (this.isConstant()) {
            return new ObjectLargeArray(this.length, this.get(0L));
        }
        ObjectLargeArray v = new ObjectLargeArray(this.length, Math.max(1, this.maxObjectLength), false);
        Utilities.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ObjectLargeArray la = (ObjectLargeArray)o;
            return this.maxObjectLength == la.maxObjectLength && this.data == la.data && this.objectLengths.equals(la.objectLengths);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
        hash = 29 * hash + (this.maxObjectLength ^ this.maxObjectLength >>> 16);
        return 29 * hash + (this.objectLengths != null ? this.objectLengths.hashCode() : 0);
    }

    @Override
    public Object get(long i) {
        if (this.ptr != 0L) {
            int objLen = this.objectLengths.getShort(i);
            if (objLen < 0) {
                return null;
            }
            long offset = this.sizeof * i * (long)this.maxObjectLength;
            for (int j = 0; j < objLen; ++j) {
                this.byteArray[j] = Utilities.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j);
            }
            return ObjectLargeArray.fromByteArray(this.byteArray);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public Object getFromNative(long i) {
        int objLen = this.objectLengths.getShort(i);
        if (objLen < 0) {
            return null;
        }
        long offset = this.sizeof * i * (long)this.maxObjectLength;
        for (int j = 0; j < objLen; ++j) {
            this.byteArray[j] = Utilities.UNSAFE.getByte(this.ptr + offset + this.sizeof * (long)j);
        }
        return ObjectLargeArray.fromByteArray(this.byteArray);
    }

    @Override
    public boolean getBoolean(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public byte getByte(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public short getShort(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public int getInt(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public long getLong(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public float getFloat(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public double getDouble(long i) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public Object[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)ObjectLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            Object[] out = new Object[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        return this.data;
    }

    @Override
    public boolean[] getBooleanData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public byte[] getByteData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public short[] getShortData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public short[] getShortData(short[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public int[] getIntData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public int[] getIntData(int[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public long[] getLongData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public long[] getLongData(long[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public float[] getFloatData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public double[] getDoubleData() {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void setToNative(long i, Object value) {
        if (value == null) {
            this.objectLengths.setShort(i, (short)-1);
        } else {
            byte[] ba = ObjectLargeArray.toByteArray(value);
            if (ba.length > this.maxObjectLength) {
                throw new IllegalArgumentException("Object  " + value + " is too long.");
            }
            int objLen = ba.length;
            if (objLen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Object  " + value + " is too long.");
            }
            this.objectLengths.setShort(i, (short)objLen);
            long offset = this.sizeof * i * (long)this.maxObjectLength;
            for (int j = 0; j < objLen; ++j) {
                Utilities.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j, ba[j]);
            }
        }
    }

    @Override
    public void set(long i, Object o) {
        if (o == null) {
            if (this.ptr != 0L) {
                this.objectLengths.setShort(i, (short)-1);
            } else {
                if (this.isConstant()) {
                    throw new IllegalAccessError("Constant arrays cannot be modified.");
                }
                this.data[(int)i] = null;
            }
        } else if (this.ptr != 0L) {
            byte[] ba = ObjectLargeArray.toByteArray(o);
            if (ba.length > this.maxObjectLength) {
                throw new IllegalArgumentException("Object  " + o + " is too long.");
            }
            int objLen = ba.length;
            if (objLen > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Object  " + o + " is too long.");
            }
            this.objectLengths.setShort(i, (short)objLen);
            long offset = this.sizeof * i * (long)this.maxObjectLength;
            for (int j = 0; j < objLen; ++j) {
                Utilities.UNSAFE.putByte(this.ptr + offset + this.sizeof * (long)j, ba[j]);
            }
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = o;
        }
    }

    @Override
    public void set_safe(long i, Object value) {
        if (i < 0L || i >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(i));
        }
        this.set(i, value);
    }

    @Override
    public void setBoolean(long i, boolean value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void setByte(long i, byte value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void setShort(long i, short value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void setInt(long i, int value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void setLong(long i, long value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void setFloat(long i, float value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Override
    public void setDouble(long i, double value) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public static byte[] toByteArray(Object obj) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return baos.toByteArray();
    }

    public static Object fromByteArray(byte[] objectData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        ObjectInputStream ois = null;
        try {
            Object obj;
            ois = new ObjectInputStream(bais);
            Object object = obj = ois.readObject();
            return object;
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public int getMaxObjectLength() {
        return this.maxObjectLength;
    }
}

