/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class FloatLargeArray
extends LargeArray {
    private static final long serialVersionUID = -8342458159338079576L;
    private float[] data;

    public FloatLargeArray(long length) {
        this(length, true);
    }

    public FloatLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.FLOAT;
        this.sizeof = 4L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        if (length > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(length);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new float[(int)length];
        }
    }

    public FloatLargeArray(long length, float constantValue) {
        this.type = LargeArrayType.FLOAT;
        this.sizeof = 4L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new float[]{constantValue};
    }

    public FloatLargeArray(float[] data) {
        this.type = LargeArrayType.FLOAT;
        this.sizeof = 4L;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public FloatLargeArray clone() {
        if (this.isConstant()) {
            return new FloatLargeArray(this.length, this.getFloat(0L));
        }
        FloatLargeArray v = new FloatLargeArray(this.length, false);
        Utilities.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            FloatLargeArray la = (FloatLargeArray)o;
            return this.data == la.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
    }

    @Override
    public Float get(long i) {
        return Float.valueOf(this.getFloat(i));
    }

    @Override
    public Float getFromNative(long i) {
        return Float.valueOf(Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i));
    }

    @Override
    public boolean getBoolean(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i) != 0.0f;
        }
        if (this.isConstant()) {
            return this.data[0] != 0.0f;
        }
        return this.data[(int)i] != 0.0f;
    }

    @Override
    public byte getByte(long i) {
        if (this.ptr != 0L) {
            return (byte)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
        }
        if (this.isConstant()) {
            return (byte)this.data[0];
        }
        return (byte)this.data[(int)i];
    }

    @Override
    public short getShort(long i) {
        if (this.ptr != 0L) {
            return (short)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
        }
        if (this.isConstant()) {
            return (short)this.data[0];
        }
        return (short)this.data[(int)i];
    }

    @Override
    public int getInt(long i) {
        if (this.ptr != 0L) {
            return (int)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
        }
        if (this.isConstant()) {
            return (int)this.data[0];
        }
        return (int)this.data[(int)i];
    }

    @Override
    public long getLong(long i) {
        if (this.ptr != 0L) {
            return (long)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
        }
        if (this.isConstant()) {
            return (long)this.data[0];
        }
        return (long)this.data[(int)i];
    }

    @Override
    public float getFloat(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    @Override
    public double getDouble(long i) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
        }
        if (this.isConstant()) {
            return this.data[0];
        }
        return this.data[(int)i];
    }

    public float[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            float[] out = new float[(int)this.length];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = this.data[0];
                ++i;
            }
            return out;
        }
        return this.data;
    }

    @Override
    public boolean[] getBooleanData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            boolean[] out = new boolean[(int)this.length];
            boolean elem = this.data[0] != 0.0f;
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        boolean[] res = new boolean[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = this.data[i] != 0.0f;
            ++i;
        }
        return res;
    }

    @Override
    public boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        boolean[] out = a != null && (long)a.length >= len ? a : new boolean[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                float v = Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
                out[idx++] = v != 0.0f;
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0] != 0.0f;
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                float v = this.data[(int)i];
                out[idx++] = v != 0.0f;
            }
        }
        return out;
    }

    @Override
    public byte[] getByteData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            byte[] out = new byte[(int)this.length];
            byte elem = (byte)this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        byte[] res = new byte[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = (byte)this.data[i];
            ++i;
        }
        return res;
    }

    @Override
    public byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        byte[] out = a != null && (long)a.length >= len ? a : new byte[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (byte)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public short[] getShortData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            short[] out = new short[(int)this.length];
            short elem = (short)this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        short[] res = new short[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = (short)this.data[i];
            ++i;
        }
        return res;
    }

    @Override
    public short[] getShortData(short[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        short[] out = a != null && (long)a.length >= len ? a : new short[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (short)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public int[] getIntData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            int[] out = new int[(int)this.length];
            int elem = (int)this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        int[] res = new int[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = (int)this.data[i];
            ++i;
        }
        return res;
    }

    @Override
    public int[] getIntData(int[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        int[] out = a != null && (long)a.length >= len ? a : new int[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (int)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public long[] getLongData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            long[] out = new long[(int)this.length];
            long elem = (long)this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        long[] res = new long[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = (long)this.data[i];
            ++i;
        }
        return res;
    }

    @Override
    public long[] getLongData(long[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        long[] out = a != null && (long)a.length >= len ? a : new long[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = (long)this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public float[] getFloatData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            float[] out = new float[(int)this.length];
            float elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        return (float[])this.data.clone();
    }

    @Override
    public float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public double[] getDoubleData() {
        if (this.ptr != 0L) {
            return null;
        }
        if (this.isConstant()) {
            if (this.length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
                return null;
            }
            double[] out = new double[(int)this.length];
            double elem = this.data[0];
            int i = 0;
            while ((long)i < this.length) {
                out[i] = elem;
                ++i;
            }
            return out;
        }
        double[] res = new double[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            res[i] = this.data[i];
            ++i;
        }
        return res;
    }

    @Override
    public double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        double[] out = a != null && (long)a.length >= len ? a : new double[(int)len];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = Utilities.UNSAFE.getFloat(this.ptr + this.sizeof * i);
            }
        } else if (this.isConstant()) {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i = startPos; i < endPos; i += step) {
                out[idx++] = this.data[(int)i];
            }
        }
        return out;
    }

    @Override
    public void setToNative(long i, Object value) {
        Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, ((Float)value).floatValue());
    }

    @Override
    public void setBoolean(long i, boolean value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, value ? 1.0f : 0.0f);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value ? 1.0f : 0.0f;
        }
    }

    @Override
    public void setByte(long i, byte value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public void setShort(long i, short value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public void setInt(long i, int value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public void setLong(long i, long value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public void setFloat(long i, float value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = value;
        }
    }

    @Override
    public void setDouble(long i, double value) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putFloat(this.ptr + this.sizeof * i, (float)value);
        } else {
            if (this.isConstant()) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i] = (float)value;
        }
    }
}

