// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.persistence.model.value.Bundle;
import pl.decerto.hyperon.persistence.model.value.CollectionProperty;
import pl.decerto.hyperon.persistence.model.value.EntityProperty;
import pl.decerto.hyperon.persistence.model.value.Property;
import pl.decerto.hyperon.persistence.model.value.RefProperty;

/**
 * @author przemek hertel
 */
public class SyncData {
	/**
	 * entities identified by id
	 */
	private final Map<Long, EntityProperty> entityMap = new HashMap<>();
	/**
	 * all entities
	 */
	private final List<EntityProperty> entities = new ArrayList<>();
	/**
	 * all refs
	 */
	private final LinkedList<RefProperty> refs = new LinkedList<>();

	public SyncData(Bundle bundle) {
		if (bundle != null) {
			scanEntity(bundle, false);
		}
	}

	public EntityProperty getEntity(long id) {
		return entityMap.get(id);
	}

	public boolean hasEntity(long id) {
		return entityMap.containsKey(id);
	}

	public List<RefProperty> getRefs() {
		return refs;
	}

	private void scanEntity(EntityProperty prop) {
		scanEntity(prop, true);
	}

	private void scanEntity(EntityProperty prop, boolean register) {
		// register entity
		if (register) {
			// add to all entites
			entities.add(prop);
			// add to identified entities
			if (prop.getId() > 0) {
				entityMap.put(prop.getId(), prop);
			}
		}
		// follow the white rabbit
		for (Property p : prop.getFields().values()) {
			if (p instanceof EntityProperty) {
				scanEntity((EntityProperty) p);
			} else if (p instanceof CollectionProperty) {
				scanCollection((CollectionProperty) p);
			} else if (p instanceof RefProperty) {
				scanRef((RefProperty) p);
			}
		}
	}

	private void scanCollection(CollectionProperty prop) {
		// scan all collection elements
		for (Property element : prop.getList()) {
			if (element instanceof EntityProperty) {
				scanEntity((EntityProperty) element);
			}
		}
	}

	private void scanRef(RefProperty prop) {
		refs.add(prop);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("SyncData[");
		if (!entities.isEmpty()) {
			sb.append(Printer.print(entities, "all entities"));
		}
		if (!entityMap.isEmpty()) {
			sb.append(Printer.print(entityMap.entrySet(), "entityMap"));
		}
		sb.append(']');
		return sb.toString();
	}

	/**
	 * all entities
	 */
	@java.lang.SuppressWarnings("all")
	public List<EntityProperty> getEntities() {
		return this.entities;
	}
}
