package pl.decerto.hyperon.persistence.marshaller;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

/**
 * This class represents entry as json element for gmo.
 *
 * @author przemek hertel
 */
public class ExpFragment {

	/**
	 * entity id.
	 * exposed as json "id"
	 */
	protected long id;

	/**
	 * entity type.
	 * exposed as json "t"
	 */
	protected String type;

	/**
	 * parent id (ownerId).
	 * exposed as json "p"
	 */
	protected long pid;

	/**
	 * owner property name.
	 * exposed as json "n"
	 */
	protected String name;

	/**
	 * exported field map.
	 * exposed as json "f"
	 */
	protected Map<String, String> simpleFields = new TreeMap<>();

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	/**
	 * expose in json as propety 'n'
	 * @return owner property name
	 */
	public String getN() {
		return name;
	}

	/**
	 * setter for json 'n' (owner property name)
	 * @param name owner property name to set
	 */
	public void setN(String name) {
		this.name = name;
	}

	/**
	 * expose in json as propety 'f'
	 * @return map containing mapping from field name to value
	 */
	public Map<String, String> getF() {
		return simpleFields;
	}

	public void addSimpleField(String name, String value) {
		simpleFields.put(name, value);
	}

	/**
	 * expose in json as property 'p'
	 * @return parent id
	 */
	public long getP() {
		return pid;
	}

	public void setP(long parentId) {
		this.pid = parentId;
	}

	/**
	 * expose in json as property 't'
	 * @return owner property type
	 */
	public String getT() {
		return type;
	}

	public void setT(String type) {
		this.type = type;
	}

	@JsonIgnore
	public boolean isNotEmpty() {
		return !getF().isEmpty();
	}

	@JsonIgnore
	public String getName() {
		return getN();
	}

	@JsonIgnore
	public long getPid() {
		return getP();
	}

	@JsonIgnore
	public String getType() {
		return getT();
	}

	@JsonIgnore
	public void setName(String name) {
		setN(name);
	}

	@JsonIgnore
	public void setPid(long pid) {
		setP(pid);
	}

	@JsonIgnore
	public void setType(String type) {
		setT(type);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder("ExpFragment#");
		sb.append(id);
		sb.append(": name=").append(name);
		sb.append(", pid=").append(pid);
		sb.append(", type=").append(type);
		sb.append(", f=[ ");
		for (Map.Entry<String, String> e : simpleFields.entrySet()) {
			sb.append(e.getKey()).append(':').append(e.getValue()).append(' ');
		}
		sb.append(']');
		return sb.toString();
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof ExpFragment)) {
			return false;
		}

		ExpFragment that = (ExpFragment) o;

		return id == that.id
			&& pid == that.pid
			&& Objects.equals(name, that.name)
			&& Objects.equals(getF(), that.getF())
			&& Objects.equals(getT(), that.getT());
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, pid, name, type, simpleFields);
	}
}
