package pl.decerto.hyperon.persistence.cache.metadata;

import java.util.Optional;

import pl.decerto.hyperon.persistence.cache.Invalidable;

/**
 * @author Maciej Główka on 11.05.2020
 */
public interface MetadataCache extends Invalidable {
	/** saves given table metadata with profile code in cache
	 *
	 * @param profileCode that table metadata corresponds to
	 * @param tableMetadataDto hyperon persistence's table metadata to save
	 */
	void put(String profileCode, BundleTableMetadataDto tableMetadataDto);

	/** get column metadata from cache if present
	 *
	 * @param profileCode that table metadata corresponds to
	 * @param tableName to get its column metadata
	 * @return column metadata if entry exists in cache, {@link Optional#empty()} otherwise
	 */
	Optional<ColumnMetadataDto> get(String profileCode, String tableName);
}
