/*
 * Decompiled with CFR 0.152.
 */
package pl.coreorb.selectiondialogs.utils;

import android.content.Context;
import android.support.annotation.ArrayRes;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import pl.coreorb.selectiondialogs.data.SelectableColor;
import pl.coreorb.selectiondialogs.data.SelectableIcon;
import pl.coreorb.selectiondialogs.data.SelectableItemNameComparator;

public class Utils {
    private static final String LOG_TAG = Utils.class.getSimpleName();

    public static ArrayList<SelectableColor> convertResourceArraysToColorsArrayList(Context context, boolean sortByName, @ArrayRes int idsArray, @ArrayRes int namesArray, @ArrayRes int colorsArray) {
        String[] ids = context.getResources().getStringArray(idsArray);
        int[] colors = context.getResources().getIntArray(colorsArray);
        String[] names = context.getResources().getStringArray(namesArray);
        if (ids.length != colors.length && ids.length != names.length) {
            Log.e((String)LOG_TAG, (String)"convertResourceArraysToColorsArrayList(): Arrays must have equals lengths!");
            return null;
        }
        ArrayList<SelectableColor> result = new ArrayList<SelectableColor>();
        for (int i = 0; i < ids.length; ++i) {
            result.add(new SelectableColor(ids[i], names[i], colors[i]));
        }
        if (sortByName) {
            Collections.sort(result, new SelectableItemNameComparator());
        }
        return result;
    }

    public static ArrayList<SelectableIcon> convertResourceArraysToIconsArrayList(Context context, boolean sortByName, @ArrayRes int idsArray, @ArrayRes int namesArray, @ArrayRes int drawablesArray) {
        String[] ids = context.getResources().getStringArray(idsArray);
        int[] drawables = context.getResources().getIntArray(drawablesArray);
        String[] names = context.getResources().getStringArray(namesArray);
        if (ids.length != drawables.length && ids.length != names.length) {
            Log.e((String)LOG_TAG, (String)"convertResourceArraysToIconsArrayList(): Arrays must have equals lengths!");
            return null;
        }
        ArrayList<SelectableIcon> result = new ArrayList<SelectableIcon>();
        for (int i = 0; i < ids.length; ++i) {
            result.add(new SelectableIcon(ids[i], names[i], drawables[i]));
        }
        if (sortByName) {
            Collections.sort(result, new SelectableItemNameComparator());
        }
        return result;
    }
}

