/*
 * Decompiled with CFR 0.152.
 */
package pl.coreorb.selectiondialogs.dialogs;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.Collections;
import pl.coreorb.selectiondialogs.R;
import pl.coreorb.selectiondialogs.data.SelectableIcon;
import pl.coreorb.selectiondialogs.data.SelectableItemNameComparator;
import pl.coreorb.selectiondialogs.dialogs.adapters.IconListAdapter;
import pl.coreorb.selectiondialogs.utils.Utils;

public class IconSelectDialog
extends DialogFragment {
    private static final String LOG_TAG = IconSelectDialog.class.getSimpleName();
    private static final String ARG_TITLE = "arg_title";
    private static final String ARG_ITEMS = "arg_items";
    private static final String ARG_SORT_BY_NAME = "arg_sort_by_name";
    private CharSequence mTitle;
    private ArrayList<SelectableIcon> mSelectionDialogsItems;
    private boolean mSortByName;
    private OnIconSelectedListener mListener;

    public void setOnIconSelectedListener(OnIconSelectedListener listener) {
        this.mListener = listener;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mTitle = args != null && args.containsKey(ARG_TITLE) ? args.getCharSequence(ARG_TITLE) : this.getString(R.string.selectiondialogs_color_dialog_title);
        if (args != null && args.containsKey(ARG_ITEMS)) {
            this.mSelectionDialogsItems = args.getParcelableArrayList(ARG_ITEMS);
        } else {
            Log.w((String)LOG_TAG, (String)"No items provided! Creating default");
            this.mSelectionDialogsItems = new ArrayList();
            this.mSelectionDialogsItems.add(this.createDefaultItem());
        }
        if (args != null && args.containsKey(ARG_SORT_BY_NAME)) {
            this.mSortByName = args.getBoolean(ARG_SORT_BY_NAME);
            if (this.mSortByName) {
                Collections.sort(this.mSelectionDialogsItems, new SelectableItemNameComparator());
            }
        } else {
            this.mSortByName = false;
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle(this.mTitle);
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        this.setUpListAdapter(builder);
        return builder.create();
    }

    private SelectableIcon createDefaultItem() {
        return new SelectableIcon("default", this.getText(R.string.selectiondialogs_undefined).toString(), R.drawable.selectiondialogs_default_item_icon);
    }

    private void setUpListAdapter(AlertDialog.Builder builder) {
        IconListAdapter adapter = new IconListAdapter(this.getContext(), this.mSelectionDialogsItems);
        builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (IconSelectDialog.this.mListener != null) {
                    IconSelectDialog.this.mListener.onIconSelected((SelectableIcon)IconSelectDialog.this.mSelectionDialogsItems.get(which));
                }
            }
        });
    }

    public static interface OnIconSelectedListener {
        public void onIconSelected(SelectableIcon var1);
    }

    public static class Builder {
        private Context context;
        private Bundle bundle;
        private OnIconSelectedListener listener;

        public Builder(Context context) {
            this.context = context;
            this.bundle = new Bundle();
        }

        public Builder setTitle(CharSequence title) {
            this.bundle.putCharSequence(IconSelectDialog.ARG_TITLE, title);
            return this;
        }

        public Builder setTitle(@StringRes int titleResId) {
            this.bundle.putCharSequence(IconSelectDialog.ARG_TITLE, (CharSequence)this.context.getString(titleResId));
            return this;
        }

        public Builder setSortIconsByName(boolean sort) {
            this.bundle.putBoolean(IconSelectDialog.ARG_SORT_BY_NAME, sort);
            return this;
        }

        public Builder setOnIconSelectedListener(OnIconSelectedListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setIcons(ArrayList<SelectableIcon> items) {
            this.bundle.putParcelableArrayList(IconSelectDialog.ARG_ITEMS, items);
            return this;
        }

        public Builder setIcons(@ArrayRes int idsArray, @ArrayRes int namesArray, @ArrayRes int drawablesArray) {
            return this.setIcons(Utils.convertResourceArraysToIconsArrayList(this.context, false, idsArray, namesArray, drawablesArray));
        }

        public IconSelectDialog build() {
            IconSelectDialog dialog = new IconSelectDialog();
            dialog.setArguments(this.bundle);
            dialog.setOnIconSelectedListener(this.listener);
            return dialog;
        }
    }
}

