/*
 * Decompiled with CFR 0.152.
 */
package pl.coreorb.selectiondialogs.dialogs;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.Collections;
import pl.coreorb.selectiondialogs.R;
import pl.coreorb.selectiondialogs.data.SelectableColor;
import pl.coreorb.selectiondialogs.data.SelectableItemNameComparator;
import pl.coreorb.selectiondialogs.dialogs.adapters.ColorListAdapter;
import pl.coreorb.selectiondialogs.utils.Utils;

public class ColorSelectDialog
extends DialogFragment {
    private static final String LOG_TAG = ColorSelectDialog.class.getSimpleName();
    private static final String ARG_TITLE = "arg_title";
    private static final String ARG_ITEMS = "arg_items";
    private static final String ARG_SORT_BY_NAME = "arg_sort_by_name";
    private CharSequence mTitle;
    private ArrayList<SelectableColor> mSelectionDialogsItems;
    private boolean mSortByName;
    private OnColorSelectedListener mListener;

    public void setOnColorSelectedListener(OnColorSelectedListener listener) {
        this.mListener = listener;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        this.mTitle = args != null && args.containsKey(ARG_TITLE) ? args.getCharSequence(ARG_TITLE) : this.getString(R.string.selectiondialogs_color_dialog_title);
        if (args != null && args.containsKey(ARG_ITEMS)) {
            this.mSelectionDialogsItems = args.getParcelableArrayList(ARG_ITEMS);
        } else {
            Log.w((String)LOG_TAG, (String)"No items provided! Creating default");
            this.mSelectionDialogsItems = new ArrayList();
            this.mSelectionDialogsItems.add(this.createDefaultItem());
        }
        if (args != null && args.containsKey(ARG_SORT_BY_NAME)) {
            this.mSortByName = args.getBoolean(ARG_SORT_BY_NAME);
            if (this.mSortByName) {
                Collections.sort(this.mSelectionDialogsItems, new SelectableItemNameComparator());
            }
        } else {
            this.mSortByName = false;
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle(this.mTitle);
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        this.setUpListAdapter(builder);
        return builder.create();
    }

    private SelectableColor createDefaultItem() {
        return new SelectableColor(this.getContext().getString(R.string.selectiondialogs_undefined), this.getContext().getString(R.string.selectiondialogs_undefined), ContextCompat.getColor((Context)this.getContext(), (int)R.color.selectiondialogs_textSecondary));
    }

    private void setUpListAdapter(AlertDialog.Builder builder) {
        ColorListAdapter adapter = new ColorListAdapter(this.getContext(), this.mSelectionDialogsItems);
        builder.setAdapter((ListAdapter)adapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (ColorSelectDialog.this.mListener != null) {
                    ColorSelectDialog.this.mListener.onColorSelected((SelectableColor)ColorSelectDialog.this.mSelectionDialogsItems.get(which));
                }
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mListener = null;
    }

    public static interface OnColorSelectedListener {
        public void onColorSelected(SelectableColor var1);
    }

    public static class Builder {
        private Context context;
        private Bundle bundle;
        private OnColorSelectedListener listener;

        public Builder(Context context) {
            this.context = context;
            this.bundle = new Bundle();
        }

        public Builder setTitle(CharSequence title) {
            this.bundle.putCharSequence(ColorSelectDialog.ARG_TITLE, title);
            return this;
        }

        public Builder setTitle(@StringRes int titleResId) {
            this.bundle.putCharSequence(ColorSelectDialog.ARG_TITLE, (CharSequence)this.context.getString(titleResId));
            return this;
        }

        public Builder setSortColorsByName(boolean sort) {
            this.bundle.putBoolean(ColorSelectDialog.ARG_SORT_BY_NAME, sort);
            return this;
        }

        public Builder setOnColorSelectedListener(OnColorSelectedListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setColors(ArrayList<SelectableColor> items) {
            this.bundle.putParcelableArrayList(ColorSelectDialog.ARG_ITEMS, items);
            return this;
        }

        public Builder setColors(@ArrayRes int idsArray, @ArrayRes int namesArray, @ArrayRes int colorsArray) {
            return this.setColors(Utils.convertResourceArraysToColorsArrayList(this.context, false, idsArray, namesArray, colorsArray));
        }

        public ColorSelectDialog build() {
            ColorSelectDialog dialog = new ColorSelectDialog();
            dialog.setArguments(this.bundle);
            dialog.setOnColorSelectedListener(this.listener);
            return dialog;
        }
    }
}

