/*
 * Decompiled with CFR 0.152.
 */
package pl.coreorb.selectiondialogs.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.concurrent.locks.Condition;
import pl.coreorb.selectiondialogs.R;
import pl.coreorb.selectiondialogs.data.PrimitiveSelectionDialogsItem;

public abstract class PrimitiveSelectedItemView<T extends PrimitiveSelectionDialogsItem>
extends LinearLayout {
    private static String TAG = PrimitiveSelectedItemView.class.getSimpleName();
    private TextView hintTV;
    private RelativeLayout buttonRL;
    protected TextView textTV;
    protected ImageView iconIV;
    protected T currentItem;

    public PrimitiveSelectedItemView(Context context) {
        this(context, null);
    }

    public PrimitiveSelectedItemView(Context context, int id2) {
        this(context, null, id2);
    }

    public PrimitiveSelectedItemView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public PrimitiveSelectedItemView(Context context, AttributeSet attrs, Integer id2) {
        super(context, attrs);
        if (id2 != null) {
            this.setId(id2);
        }
        Log.d((String)TAG, (String)("SelectedItemView() [id: " + this.getId() + "]"));
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PrimitiveSelectedItemView, 0, 0);
        String hint = a.getString(R.styleable.PrimitiveSelectedItemView_hint);
        int icon = a.getResourceId(R.styleable.PrimitiveSelectedItemView_buttonIcon, -1);
        int tint = a.getInt(R.styleable.PrimitiveSelectedItemView_buttonIconTint, -1);
        String text = a.getString(R.styleable.PrimitiveSelectedItemView_buttonText);
        a.recycle();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View rootView = inflater.inflate(R.layout.selectiondialogs_selected_item_view, (ViewGroup)this, true);
        this.hintTV = (TextView)rootView.findViewById(R.id.selectiondialogs_hint_tv);
        this.buttonRL = (RelativeLayout)rootView.findViewById(R.id.selectiondialogs_button_ll);
        this.textTV = (TextView)rootView.findViewById(R.id.selectiondialogs_text_tv);
        this.iconIV = (ImageView)rootView.findViewById(R.id.selectiondialogs_icon_iv);
        if (hint != null) {
            this.hintTV.setText((CharSequence)hint);
        }
        if (icon != -1) {
            this.iconIV.setImageResource(icon);
        }
        if (tint != -1) {
            this.iconIV.setColorFilter(tint);
        }
        if (text != null) {
            this.textTV.setText((CharSequence)text);
        }
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.buttonRL.setOnClickListener(onClickListener);
    }

    public abstract void setItem(T var1);

    public T getItem() {
        return this.currentItem;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Log.d((String)TAG, (String)("onSaveInstanceState() [id: " + this.getId() + "]"));
        SavedState ss = new SavedState(superState);
        ss.stateToSave = this.currentItem;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        Log.d((String)TAG, (String)("onRestoreInstanceState() [id: " + this.getId() + "]"));
        SavedState ss = (SavedState)state;
        if (ss.stateToSave != null) {
            this.setItem(ss.stateToSave);
        }
        super.onRestoreInstanceState(ss.getSuperState());
    }

    static class SavedState<T extends PrimitiveSelectionDialogsItem>
    extends View.BaseSavedState {
        T stateToSave;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.stateToSave = (PrimitiveSelectionDialogsItem)in.readParcelable(Condition.class.getClassLoader());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeParcelable(this.stateToSave, flags);
        }
    }
}

