/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation.observables.geocode;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import com.google.android.gms.maps.model.LatLngBounds;
import java.io.IOException;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public class GeocodeObservable
implements Observable.OnSubscribe<List<Address>> {
    private final Context ctx;
    private final String locationName;
    private final int maxResults;
    private final LatLngBounds bounds;

    public static Observable<List<Address>> createObservable(Context ctx, String locationName, int maxResults, LatLngBounds bounds) {
        return Observable.create((Observable.OnSubscribe)new GeocodeObservable(ctx, locationName, maxResults, bounds));
    }

    private GeocodeObservable(Context ctx, String locationName, int maxResults, LatLngBounds bounds) {
        this.ctx = ctx;
        this.locationName = locationName;
        this.maxResults = maxResults;
        this.bounds = bounds;
    }

    public void call(Subscriber<? super List<Address>> subscriber) {
        block3: {
            Geocoder geocoder = new Geocoder(this.ctx);
            try {
                List result = this.bounds != null ? geocoder.getFromLocationName(this.locationName, this.maxResults, this.bounds.southwest.latitude, this.bounds.southwest.longitude, this.bounds.northeast.latitude, this.bounds.northeast.longitude) : geocoder.getFromLocationName(this.locationName, this.maxResults);
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)result);
                    subscriber.onCompleted();
                }
            }
            catch (IOException e) {
                if (subscriber.isUnsubscribed()) break block3;
                subscriber.onError((Throwable)e);
            }
        }
    }
}

