/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain;

import axion.com.github.zafarkhaja.semver.Version;
import java.util.Optional;
import pl.allegro.tech.build.axion.release.domain.VersionContext;
import pl.allegro.tech.build.axion.release.domain.VersionService;
import pl.allegro.tech.build.axion.release.domain.hooks.ReleaseHooksRunner;
import pl.allegro.tech.build.axion.release.domain.logging.ReleaseLogger;
import pl.allegro.tech.build.axion.release.domain.properties.Properties;
import pl.allegro.tech.build.axion.release.domain.scm.ScmPushResult;
import pl.allegro.tech.build.axion.release.domain.scm.ScmService;

public class Releaser {
    private final ReleaseLogger logger = ReleaseLogger.Factory.logger(Releaser.class);
    private final VersionService versionService;
    private final ScmService repository;
    private final ReleaseHooksRunner hooksRunner;

    public Releaser(VersionService versionService, ScmService repository, ReleaseHooksRunner hooksRunner) {
        this.versionService = versionService;
        this.repository = repository;
        this.hooksRunner = hooksRunner;
    }

    public Optional<String> release(Properties properties) {
        VersionContext versionContext = this.versionService.currentVersion(properties.getVersion(), properties.getTag(), properties.getNextVersion());
        Version version = versionContext.getVersion();
        if (versionContext.isSnapshot()) {
            String tagName = properties.getTag().getSerialize().apply(properties.getTag(), version.toString());
            this.hooksRunner.runPreReleaseHooks(properties.getHooks(), properties, versionContext, version);
            this.logger.quiet("Creating tag: " + tagName);
            this.repository.tag(tagName);
            this.hooksRunner.runPostReleaseHooks(properties.getHooks(), properties, versionContext, version);
            return Optional.of(tagName);
        }
        this.logger.quiet("Working on released version " + version + ", nothing to release");
        return Optional.empty();
    }

    public ScmPushResult releaseAndPush(Properties rules) {
        Optional<String> releasedTagName = this.release(rules);
        ScmPushResult result = this.pushRelease();
        if (!result.isSuccess()) {
            releasedTagName.ifPresent(this::rollbackRelease);
        }
        return result;
    }

    public ScmPushResult pushRelease() {
        return this.repository.push();
    }

    private void rollbackRelease(String tagName) {
        this.logger.quiet("Removing tag: " + tagName);
        this.repository.dropTag(tagName);
        this.logger.quiet("Tag " + tagName + " removed");
    }
}

