/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.treewalk.filter;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.errors.StopWalkException;
import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.treewalk.TreeWalk;
import axion.org.eclipse.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.text.MessageFormat;

public class TreeFilterMarker {
    private final TreeFilter[] filters;

    public TreeFilterMarker(TreeFilter[] markTreeFilters) {
        if (markTreeFilters.length > 32) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().treeFilterMarkerTooManyFilters, 32, markTreeFilters.length));
        }
        this.filters = new TreeFilter[markTreeFilters.length];
        System.arraycopy(markTreeFilters, 0, this.filters, 0, markTreeFilters.length);
    }

    public int getMarks(TreeWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int marks = 0;
        int index = 0;
        while (index < this.filters.length) {
            TreeFilter filter = this.filters[index];
            if (filter != null) {
                try {
                    boolean marked = filter.include(walk);
                    if (marked) {
                        marks |= 1 << index;
                    }
                }
                catch (StopWalkException e) {
                    this.filters[index] = null;
                }
            }
            ++index;
        }
        return marks;
    }
}

