/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.transport;

import axion.org.eclipse.jgit.lib.Constants;
import axion.org.eclipse.jgit.util.RawParseUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketLineOut {
    private static final Logger log = LoggerFactory.getLogger(PacketLineOut.class);
    private final OutputStream out;
    private final byte[] lenbuffer;
    private final boolean logEnabled;
    private boolean flushOnEnd;
    private boolean usingSideband;
    private static final byte[] hexchar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public PacketLineOut(OutputStream outputStream) {
        this(outputStream, true);
    }

    public PacketLineOut(OutputStream outputStream, boolean enableLogging) {
        this.out = outputStream;
        this.lenbuffer = new byte[5];
        this.flushOnEnd = true;
        this.logEnabled = enableLogging;
    }

    public void setFlushOnEnd(boolean flushOnEnd) {
        this.flushOnEnd = flushOnEnd;
    }

    public boolean isUsingSideband() {
        return this.usingSideband;
    }

    public void setUsingSideband(boolean value) {
        this.usingSideband = value;
    }

    public void writeString(String s) throws IOException {
        this.writePacket(Constants.encode(s));
    }

    public void writePacket(byte[] packet) throws IOException {
        this.writePacket(packet, 0, packet.length);
    }

    public void writePacket(byte[] buf, int pos, int len) throws IOException {
        if (this.usingSideband) {
            this.formatLength(len + 5);
            this.out.write(this.lenbuffer, 0, 4);
            this.out.write(1);
        } else {
            this.formatLength(len + 4);
            this.out.write(this.lenbuffer, 0, 4);
        }
        this.out.write(buf, pos, len);
        if (this.logEnabled && log.isDebugEnabled()) {
            if (len > 0 && buf[pos + len - 1] == 10) {
                log.debug("git> " + RawParseUtils.decode(StandardCharsets.UTF_8, buf, pos, len - 1) + "\\n");
            } else {
                log.debug("git> " + RawParseUtils.decode(StandardCharsets.UTF_8, buf, pos, len));
            }
        }
    }

    public void writeDelim() throws IOException {
        this.formatLength(1);
        this.out.write(this.lenbuffer, 0, 4);
        if (this.logEnabled && log.isDebugEnabled()) {
            log.debug("git> 0001");
        }
    }

    public void end() throws IOException {
        this.formatLength(0);
        this.out.write(this.lenbuffer, 0, 4);
        if (this.logEnabled && log.isDebugEnabled()) {
            log.debug("git> 0000");
        }
        if (this.flushOnEnd) {
            this.flush();
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private void formatLength(int w) {
        PacketLineOut.formatLength(this.lenbuffer, w);
    }

    static void formatLength(byte[] lenbuffer, int w) {
        int o = 3;
        while (o >= 0 && w != 0) {
            lenbuffer[o--] = hexchar[w & 0xF];
            w >>>= 4;
        }
        while (o >= 0) {
            lenbuffer[o--] = 48;
        }
    }
}

