/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.revwalk;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.internal.JGitText;
import axion.org.eclipse.jgit.lib.NullProgressMonitor;
import axion.org.eclipse.jgit.lib.ProgressMonitor;
import axion.org.eclipse.jgit.lib.Ref;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevObject;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.find(walk, start, end).size();
    }

    public static List<RevCommit> find(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        walk.reset();
        walk.markStart(start);
        if (end != null) {
            walk.markUninteresting(end);
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RevCommit c : walk) {
            commits.add(c);
        }
        return commits;
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.findBranchesReachableFrom(commit, revWalk, refs, NullProgressMonitor.INSTANCE);
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs, ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        commit = revWalk.parseCommit(commit.getId());
        revWalk.reset();
        ArrayList<Ref> filteredRefs = new ArrayList<Ref>();
        monitor.beginTask(JGitText.get().searchForReachableBranches, refs.size());
        int SKEW = 86400;
        for (Ref ref : refs) {
            RevCommit headCommit;
            RevObject maybehead = revWalk.parseAny(ref.getObjectId());
            if (!(maybehead instanceof RevCommit) || (headCommit = (RevCommit)maybehead).getCommitTime() + 86400 < commit.getCommitTime()) continue;
            filteredRefs.add(ref);
        }
        List<Ref> result = revWalk.getMergedInto(commit, filteredRefs, monitor);
        monitor.endTask();
        return result;
    }
}

