/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.revwalk;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.revwalk.AbstractRevQueue;
import axion.org.eclipse.jgit.revwalk.Generator;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import java.io.IOException;

abstract class BlockRevQueue
extends AbstractRevQueue {
    protected BlockFreeList free = new BlockFreeList();

    protected BlockRevQueue(boolean firstParent) {
        super(firstParent);
    }

    BlockRevQueue(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s.firstParent);
        RevCommit c;
        this.outputType = s.outputType();
        s.shareFreeList(this);
        while ((c = s.next()) != null) {
            this.add(c);
        }
    }

    @Override
    public void shareFreeList(BlockRevQueue q) {
        this.free = q.free;
    }

    static final class Block {
        static final int BLOCK_SIZE = 256;
        Block next;
        final RevCommit[] commits = new RevCommit[256];
        int headIndex;
        int tailIndex;

        Block() {
        }

        boolean isFull() {
            return this.tailIndex == 256;
        }

        boolean isEmpty() {
            return this.headIndex == this.tailIndex;
        }

        boolean canUnpop() {
            return this.headIndex > 0;
        }

        void add(RevCommit c) {
            this.commits[this.tailIndex++] = c;
        }

        void unpop(RevCommit c) {
            this.commits[--this.headIndex] = c;
        }

        RevCommit pop() {
            return this.commits[this.headIndex++];
        }

        RevCommit peek() {
            return this.commits[this.headIndex];
        }

        void clear() {
            this.next = null;
            this.headIndex = 0;
            this.tailIndex = 0;
        }

        void resetToMiddle() {
            this.tailIndex = 128;
            this.headIndex = 128;
        }

        void resetToEnd() {
            this.tailIndex = 256;
            this.headIndex = 256;
        }
    }

    static final class BlockFreeList {
        private Block next;

        BlockFreeList() {
        }

        Block newBlock() {
            Block b = this.next;
            if (b == null) {
                return new Block();
            }
            this.next = b.next;
            b.clear();
            return b;
        }

        void freeBlock(Block b) {
            b.next = this.next;
            this.next = b;
        }

        void clear() {
            this.next = null;
        }
    }
}

