/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.internal.transport.sshd;

import axion.org.apache.sshd.client.config.hosts.HostConfigEntry;
import axion.org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import axion.org.apache.sshd.common.AttributeRepository;
import axion.org.apache.sshd.common.util.net.SshdSocketAddress;
import axion.org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import axion.org.eclipse.jgit.internal.transport.sshd.JGitHostConfigEntry;
import axion.org.eclipse.jgit.transport.SshConfigStore;
import axion.org.eclipse.jgit.transport.SshSessionFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.TreeMap;

public class JGitSshConfig
implements HostConfigEntryResolver {
    private final SshConfigStore configFile;

    public JGitSshConfig(SshConfigStore store) {
        this.configFile = store;
    }

    @Override
    public HostConfigEntry resolveEffectiveHost(String host, int port, SocketAddress localAddress, String username, String proxyJump, AttributeRepository attributes) throws IOException {
        String user;
        SshConfigStore.HostConfig entry = this.configFile == null ? SshConfigStore.EMPTY_CONFIG : this.configFile.lookup(host, port, username);
        JGitHostConfigEntry config = new JGitHostConfigEntry();
        TreeMap<String, String> allOptions = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        allOptions.putAll(entry.getOptions());
        entry.getMultiValuedOptions().entrySet().stream().forEach(e -> {
            String string = allOptions.put((String)e.getKey(), String.join((CharSequence)",", (Iterable)e.getValue()));
        });
        config.setProperties(allOptions);
        config.setMultiValuedOptions(entry.getMultiValuedOptions());
        String hostName = entry.getValue("HostName");
        if (hostName == null || hostName.isEmpty()) {
            hostName = host;
        }
        config.setHostName(hostName);
        config.setProperty("HostName", hostName);
        config.setHost(SshdSocketAddress.isIPv6Address(hostName) ? "" : hostName);
        String string = user = username != null && !username.isEmpty() ? username : entry.getValue("User");
        if (user == null || user.isEmpty()) {
            user = SshSessionFactory.getLocalUserName();
        }
        config.setUsername(user);
        config.setProperty("User", user);
        int p = port >= 0 ? port : OpenSshConfigFile.positive(entry.getValue("Port"));
        config.setPort(p >= 0 ? p : 22);
        config.setProperty("Port", Integer.toString(config.getPort()));
        config.setIdentities(entry.getValues("IdentityFile"));
        config.setIdentitiesOnly(OpenSshConfigFile.flag(entry.getValue("IdentitiesOnly")));
        return config;
    }
}

