/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.gpg.bc.internal;

import axion.org.bouncycastle.bcpg.sig.IssuerFingerprint;
import axion.org.bouncycastle.jce.provider.BouncyCastleProvider;
import axion.org.bouncycastle.openpgp.PGPCompressedData;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.PGPPublicKey;
import axion.org.bouncycastle.openpgp.PGPSignature;
import axion.org.bouncycastle.openpgp.PGPSignatureList;
import axion.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import axion.org.bouncycastle.openpgp.PGPUtil;
import axion.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import axion.org.bouncycastle.util.encoders.Hex;
import axion.org.eclipse.jgit.annotations.NonNull;
import axion.org.eclipse.jgit.annotations.Nullable;
import axion.org.eclipse.jgit.api.errors.JGitInternalException;
import axion.org.eclipse.jgit.gpg.bc.internal.BCText;
import axion.org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgKeyLocator;
import axion.org.eclipse.jgit.gpg.bc.internal.BouncyCastleGpgSigner;
import axion.org.eclipse.jgit.lib.GpgConfig;
import axion.org.eclipse.jgit.lib.GpgSignatureVerifier;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevObject;
import axion.org.eclipse.jgit.revwalk.RevTag;
import axion.org.eclipse.jgit.util.LRUMap;
import axion.org.eclipse.jgit.util.RawParseUtils;
import axion.org.eclipse.jgit.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public class BouncyCastleGpgSignatureVerifier
implements GpgSignatureVerifier {
    private static final Object NO_KEY = new Object();
    private LRUMap<String, Object> byFingerprint = new LRUMap(16, 200);
    private LRUMap<String, Object> bySigner = new LRUMap(16, 200);

    private static void registerBouncyCastleProviderIfNecessary() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public BouncyCastleGpgSignatureVerifier() {
        BouncyCastleGpgSignatureVerifier.registerBouncyCastleProviderIfNecessary();
    }

    @Override
    public String getName() {
        return "bc";
    }

    @Override
    @Nullable
    public GpgSignatureVerifier.SignatureVerification verifySignature(@NonNull RevObject object, @NonNull GpgConfig config) throws IOException {
        if (object instanceof RevCommit) {
            RevCommit commit = (RevCommit)object;
            byte[] signatureData = commit.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = commit.getRawBuffer();
            byte[] header = new byte[]{103, 112, 103, 115, 105, 103};
            int start = RawParseUtils.headerStart(header, raw, 0);
            if (start < 0) {
                return null;
            }
            int end = RawParseUtils.headerEnd(raw, start);
            start -= header.length + 1;
            if (end < raw.length) {
                ++end;
            }
            byte[] data = new byte[raw.length - (end - start)];
            System.arraycopy(raw, 0, data, 0, start);
            System.arraycopy(raw, end, data, start, raw.length - end);
            return this.verify(data, signatureData);
        }
        if (object instanceof RevTag) {
            RevTag tag = (RevTag)object;
            byte[] signatureData = tag.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = tag.getRawBuffer();
            byte[] data = Arrays.copyOfRange(raw, 0, raw.length - signatureData.length);
            return this.verify(data, signatureData);
        }
        return null;
    }

    static PGPSignature parseSignature(InputStream in) throws IOException, PGPException {
        InputStream sigIn;
        block11: {
            PGPSignature pGPSignature;
            block12: {
                Throwable throwable = null;
                Object var2_3 = null;
                sigIn = PGPUtil.getDecoderStream(in);
                try {
                    JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory(sigIn);
                    Object obj = pgpFactory.nextObject();
                    if (obj instanceof PGPCompressedData) {
                        obj = new JcaPGPObjectFactory(((PGPCompressedData)obj).getDataStream()).nextObject();
                    }
                    if (!(obj instanceof PGPSignatureList)) break block11;
                    pGPSignature = ((PGPSignatureList)obj).get(0);
                    if (sigIn == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        if (sigIn != null) {
                            sigIn.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                sigIn.close();
            }
            return pGPSignature;
        }
        if (sigIn != null) {
            sigIn.close();
        }
        return null;
    }

    @Override
    public GpgSignatureVerifier.SignatureVerification verify(byte[] data, byte[] signatureData) throws IOException {
        String keyId;
        String signer;
        String fingerprint;
        PGPSignature signature;
        block36: {
            signature = null;
            fingerprint = null;
            signer = null;
            keyId = null;
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (ByteArrayInputStream sigIn = new ByteArrayInputStream(signatureData);){
                    signature = BouncyCastleGpgSignatureVerifier.parseSignature(sigIn);
                    if (signature != null) {
                        if (signature.hasSubpackets()) {
                            PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
                            IssuerFingerprint fingerprintPacket = packets.getIssuerFingerprint();
                            if (fingerprintPacket != null) {
                                fingerprint = Hex.toHexString(fingerprintPacket.getFingerprint()).toLowerCase(Locale.ROOT);
                            }
                            if ((signer = packets.getSignerUserID()) != null) {
                                signer = BouncyCastleGpgSigner.extractSignerId(signer);
                            }
                        }
                        keyId = Long.toUnsignedString(signature.getKeyID(), 16).toLowerCase(Locale.ROOT);
                        break block36;
                    }
                    throw new JGitInternalException(BCText.get().nonSignatureError);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (PGPException e) {
                throw new JGitInternalException(BCText.get().signatureParseError, e);
            }
        }
        Date signatureCreatedAt = signature.getCreationTime();
        if (fingerprint == null && signer == null && keyId == null) {
            return new VerificationResult(signatureCreatedAt, null, null, null, false, false, GpgSignatureVerifier.TrustLevel.UNKNOWN, BCText.get().signatureNoKeyInfo);
        }
        if (fingerprint != null && keyId != null && !fingerprint.endsWith(keyId)) {
            return new VerificationResult(signatureCreatedAt, signer, fingerprint, null, false, false, GpgSignatureVerifier.TrustLevel.UNKNOWN, MessageFormat.format(BCText.get().signatureInconsistent, keyId, fingerprint));
        }
        if (fingerprint == null && keyId != null) {
            fingerprint = keyId;
        }
        String keySpec = String.valueOf('<') + signer + '>';
        Object cached = null;
        PGPPublicKey publicKey = null;
        try {
            cached = this.byFingerprint.get(fingerprint);
            if (cached != null) {
                if (cached instanceof PGPPublicKey) {
                    publicKey = cached;
                }
            } else if (!StringUtils.isEmptyOrNull(signer) && (cached = this.bySigner.get(signer)) != null && cached instanceof PGPPublicKey) {
                publicKey = cached;
            }
            if (cached == null) {
                publicKey = BouncyCastleGpgKeyLocator.findPublicKey(fingerprint, keySpec);
            }
        }
        catch (PGPException | IOException e) {
            throw new JGitInternalException(BCText.get().signatureKeyLookupError, e);
        }
        if (publicKey == null) {
            if (cached == null) {
                this.byFingerprint.put(fingerprint, NO_KEY);
                this.byFingerprint.put(keyId, NO_KEY);
                if (signer != null) {
                    this.bySigner.put(signer, NO_KEY);
                }
            }
            return new VerificationResult(signatureCreatedAt, signer, fingerprint, null, false, false, GpgSignatureVerifier.TrustLevel.UNKNOWN, BCText.get().signatureNoPublicKey);
        }
        if (cached == null) {
            this.byFingerprint.put(fingerprint, publicKey);
            this.byFingerprint.put(keyId, publicKey);
            if (signer != null) {
                this.bySigner.put(signer, publicKey);
            }
        }
        String user = null;
        Iterator<String> userIds = publicKey.getUserIDs();
        if (!StringUtils.isEmptyOrNull(signer)) {
            while (userIds.hasNext()) {
                String userId = userIds.next();
                if (!BouncyCastleGpgKeyLocator.containsSigningKey(userId, keySpec)) continue;
                user = userId;
                break;
            }
        }
        if (user == null && (userIds = publicKey.getUserIDs()).hasNext()) {
            user = userIds.next();
        }
        boolean expired = false;
        long validFor = publicKey.getValidSeconds();
        if (validFor > 0L && signatureCreatedAt != null) {
            Instant expiredAt = publicKey.getCreationTime().toInstant().plusSeconds(validFor);
            expired = expiredAt.isBefore(signatureCreatedAt.toInstant());
        }
        byte[] trustData = publicKey.getTrustData();
        GpgSignatureVerifier.TrustLevel trust = this.parseGpgTrustPacket(trustData);
        boolean verified = false;
        try {
            signature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), publicKey);
            signature.update(data);
            verified = signature.verify();
        }
        catch (PGPException e) {
            throw new JGitInternalException(BCText.get().signatureVerificationError, e);
        }
        return new VerificationResult(signatureCreatedAt, signer, fingerprint, user, verified, expired, trust, null);
    }

    private GpgSignatureVerifier.TrustLevel parseGpgTrustPacket(byte[] packet) {
        if (packet == null || packet.length < 6) {
            return GpgSignatureVerifier.TrustLevel.UNKNOWN;
        }
        if (packet[2] != 103 || packet[3] != 112 || packet[4] != 103) {
            return GpgSignatureVerifier.TrustLevel.UNKNOWN;
        }
        int trust = packet[0] & 0xF;
        switch (trust) {
            case 0: 
            case 1: 
            case 2: {
                return GpgSignatureVerifier.TrustLevel.UNKNOWN;
            }
            case 3: {
                return GpgSignatureVerifier.TrustLevel.NEVER;
            }
            case 4: {
                return GpgSignatureVerifier.TrustLevel.MARGINAL;
            }
            case 5: {
                return GpgSignatureVerifier.TrustLevel.FULL;
            }
            case 6: {
                return GpgSignatureVerifier.TrustLevel.ULTIMATE;
            }
        }
        return GpgSignatureVerifier.TrustLevel.UNKNOWN;
    }

    @Override
    public void clear() {
        this.byFingerprint.clear();
        this.bySigner.clear();
    }

    private static class VerificationResult
    implements GpgSignatureVerifier.SignatureVerification {
        private final Date creationDate;
        private final String signer;
        private final String keyUser;
        private final String fingerprint;
        private final boolean verified;
        private final boolean expired;
        @NonNull
        private final GpgSignatureVerifier.TrustLevel trustLevel;
        private final String message;

        public VerificationResult(Date creationDate, String signer, String fingerprint, String user, boolean verified, boolean expired, @NonNull GpgSignatureVerifier.TrustLevel trust, String message) {
            this.creationDate = creationDate;
            this.signer = signer;
            this.fingerprint = fingerprint;
            this.keyUser = user;
            this.verified = verified;
            this.expired = expired;
            this.trustLevel = trust;
            this.message = message;
        }

        @Override
        public Date getCreationDate() {
            return this.creationDate;
        }

        @Override
        public String getSigner() {
            return this.signer;
        }

        @Override
        public String getKeyUser() {
            return this.keyUser;
        }

        @Override
        public String getKeyFingerprint() {
            return this.fingerprint;
        }

        @Override
        public boolean isExpired() {
            return this.expired;
        }

        @Override
        public GpgSignatureVerifier.TrustLevel getTrustLevel() {
            return this.trustLevel;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public boolean getVerified() {
            return this.verified;
        }
    }
}

