/*
 * Decompiled with CFR 0.152.
 */
package axion.org.eclipse.jgit.blame;

import axion.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import axion.org.eclipse.jgit.errors.MissingObjectException;
import axion.org.eclipse.jgit.lib.AnyObjectId;
import axion.org.eclipse.jgit.lib.Repository;
import axion.org.eclipse.jgit.revwalk.RevCommit;
import axion.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;

final class ReverseWalk
extends RevWalk {
    ReverseWalk(Repository repo) {
        super(repo);
    }

    @Override
    public ReverseCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ReverseCommit c = (ReverseCommit)super.next();
        if (c == null) {
            return null;
        }
        int pIdx = 0;
        while (pIdx < c.getParentCount()) {
            ((ReverseCommit)c.getParent(pIdx)).addChild(c);
            ++pIdx;
        }
        return c;
    }

    @Override
    protected RevCommit createCommit(AnyObjectId id) {
        return new ReverseCommit(id);
    }

    static final class ReverseCommit
    extends RevCommit {
        private static final ReverseCommit[] NO_CHILDREN = new ReverseCommit[0];
        private ReverseCommit[] children = NO_CHILDREN;

        ReverseCommit(AnyObjectId id) {
            super(id);
        }

        void addChild(ReverseCommit c) {
            int cnt = this.children.length;
            switch (cnt) {
                case 0: {
                    this.children = new ReverseCommit[]{c};
                    break;
                }
                case 1: {
                    this.children = new ReverseCommit[]{c, this.children[0]};
                    break;
                }
                default: {
                    ReverseCommit[] n = new ReverseCommit[1 + cnt];
                    n[0] = c;
                    System.arraycopy(this.children, 0, n, 1, cnt);
                    this.children = n;
                }
            }
        }

        int getChildCount() {
            return this.children.length;
        }

        ReverseCommit getChild(int nth) {
            return this.children[nth];
        }
    }
}

