/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.operator.bc;

import axion.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import axion.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import axion.org.bouncycastle.asn1.x9.X9ECParameters;
import axion.org.bouncycastle.crypto.BlockCipher;
import axion.org.bouncycastle.crypto.BufferedBlockCipher;
import axion.org.bouncycastle.crypto.ec.CustomNamedCurves;
import axion.org.bouncycastle.crypto.io.CipherInputStream;
import axion.org.bouncycastle.crypto.modes.CFBBlockCipher;
import axion.org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import axion.org.bouncycastle.crypto.params.KeyParameter;
import axion.org.bouncycastle.crypto.params.ParametersWithIV;
import axion.org.bouncycastle.math.ec.ECCurve;
import axion.org.bouncycastle.math.ec.ECPoint;
import axion.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import axion.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import axion.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import axion.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

class BcUtil {
    BcUtil() {
    }

    static BufferedBlockCipher createStreamCipher(boolean bl, BlockCipher blockCipher, boolean bl2, byte[] byArray) {
        BufferedBlockCipher bufferedBlockCipher = bl2 ? new BufferedBlockCipher(new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8)) : new BufferedBlockCipher(new OpenPGPCFBBlockCipher(blockCipher));
        KeyParameter keyParameter = new KeyParameter(byArray);
        if (bl2) {
            bufferedBlockCipher.init(bl, new ParametersWithIV(keyParameter, new byte[blockCipher.getBlockSize()]));
        } else {
            bufferedBlockCipher.init(bl, keyParameter);
        }
        return bufferedBlockCipher;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean bl, BlockCipher blockCipher, byte[] byArray) {
        final BufferedBlockCipher bufferedBlockCipher = BcUtil.createStreamCipher(false, blockCipher, bl, byArray);
        return new PGPDataDecryptor(){

            public InputStream getInputStream(InputStream inputStream) {
                return new CipherInputStream(inputStream, bufferedBlockCipher);
            }

            public int getBlockSize() {
                return bufferedBlockCipher.getBlockSize();
            }

            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static BufferedBlockCipher createSymmetricKeyWrapper(boolean bl, BlockCipher blockCipher, byte[] byArray, byte[] byArray2) {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(new CFBBlockCipher(blockCipher, blockCipher.getBlockSize() * 8));
        bufferedBlockCipher.init(bl, new ParametersWithIV(new KeyParameter(byArray), byArray2));
        return bufferedBlockCipher;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = CustomNamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = ECNamedCurveTable.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    static ECPoint decodePoint(BigInteger bigInteger, ECCurve eCCurve) throws IOException {
        return eCCurve.decodePoint(BigIntegers.asUnsignedByteArray(bigInteger));
    }
}

