/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.operator.bc;

import axion.org.bouncycastle.crypto.Signer;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.PGPPublicKey;
import axion.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import axion.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import axion.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import axion.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import axion.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import axion.org.bouncycastle.openpgp.operator.bc.SignerOutputStream;
import java.io.OutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new BcPGPContentVerifierBuilder(n, n2);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm);
            signer.init(false, BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey));
            return new PGPContentVerifier(){

                public int getHashAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                public int getKeyAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    return signer.verifySignature(byArray);
                }

                public OutputStream getOutputStream() {
                    return new SignerOutputStream(signer);
                }
            };
        }
    }
}

