/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.openpgp.examples;

import axion.org.bouncycastle.bcpg.ArmoredOutputStream;
import axion.org.bouncycastle.jce.provider.BouncyCastleProvider;
import axion.org.bouncycastle.openpgp.PGPCompressedData;
import axion.org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import axion.org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import axion.org.bouncycastle.openpgp.PGPEncryptedDataList;
import axion.org.bouncycastle.openpgp.PGPException;
import axion.org.bouncycastle.openpgp.PGPLiteralData;
import axion.org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import axion.org.bouncycastle.openpgp.PGPPBEEncryptedData;
import axion.org.bouncycastle.openpgp.PGPUtil;
import axion.org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import axion.org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import axion.org.bouncycastle.util.encoders.Hex;
import axion.org.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;

public class ByteArrayHandler {
    public static byte[] decrypt(byte[] byArray, char[] cArray) throws IOException, PGPException, NoSuchProviderException {
        InputStream inputStream = new ByteArrayInputStream(byArray);
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream = PGPUtil.getDecoderStream(inputStream));
        Object object = jcaPGPObjectFactory.nextObject();
        PGPEncryptedDataList pGPEncryptedDataList = object instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object : (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream2 = pGPPBEEncryptedData.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray));
        JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(inputStream2);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory2.nextObject();
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory2.nextObject();
        return Streams.readAll(pGPLiteralData.getInputStream());
    }

    public static byte[] encrypt(byte[] byArray, char[] cArray, String string, int n, boolean bl) throws IOException, PGPException, NoSuchProviderException {
        if (string == null) {
            string = "_CONSOLE";
        }
        byte[] byArray2 = ByteArrayHandler.compress(byArray, string, 1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = byteArrayOutputStream;
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(n).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(cArray).setProvider("BC"));
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, byArray2.length);
        outputStream2.write(byArray2);
        outputStream2.close();
        if (bl) {
            outputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] compress(byte[] byArray, String string, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
        OutputStream outputStream = pGPCompressedDataGenerator.open(byteArrayOutputStream);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, 'b', string, byArray.length, new Date());
        outputStream2.write(byArray);
        outputStream2.close();
        pGPCompressedDataGenerator.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        String string = "Dick Beck";
        char[] cArray = string.toCharArray();
        byte[] byArray = "Hello world".getBytes();
        System.out.println("Starting PGP test");
        byte[] byArray2 = ByteArrayHandler.encrypt(byArray, cArray, "iway", 3, true);
        System.out.println("\nencrypted data = '" + new String(byArray2) + "'");
        byte[] byArray3 = ByteArrayHandler.decrypt(byArray2, cArray);
        System.out.println("\ndecrypted data = '" + new String(byArray3) + "'");
        byArray2 = ByteArrayHandler.encrypt(byArray, cArray, "iway", 9, false);
        System.out.println("\nencrypted data = '" + new String(Hex.encode(byArray2)) + "'");
        byArray3 = ByteArrayHandler.decrypt(byArray2, cArray);
        System.out.println("\ndecrypted data = '" + new String(byArray3) + "'");
    }
}

