/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.crypto.generators;

import axion.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import axion.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import axion.org.bouncycastle.crypto.KeyGenerationParameters;
import axion.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import axion.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import java.security.SecureRandom;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

