/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.cms;

import axion.org.bouncycastle.asn1.cms.OriginatorInfo;
import axion.org.bouncycastle.cert.X509CertificateHolder;
import axion.org.bouncycastle.cms.CMSException;
import axion.org.bouncycastle.cms.CMSUtils;
import axion.org.bouncycastle.cms.OriginatorInformation;
import axion.org.bouncycastle.util.Store;
import java.util.ArrayList;
import java.util.List;

public class OriginatorInfoGenerator {
    private final List origCerts;
    private final List origCRLs;

    public OriginatorInfoGenerator(X509CertificateHolder x509CertificateHolder) {
        this.origCerts = new ArrayList(1);
        this.origCRLs = null;
        this.origCerts.add(x509CertificateHolder.toASN1Structure());
    }

    public OriginatorInfoGenerator(Store store) throws CMSException {
        this(store, null);
    }

    public OriginatorInfoGenerator(Store store, Store store2) throws CMSException {
        this.origCerts = CMSUtils.getCertificatesFromStore(store);
        this.origCRLs = store2 != null ? CMSUtils.getCRLsFromStore(store2) : null;
    }

    public OriginatorInformation generate() {
        if (this.origCRLs != null) {
            return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), CMSUtils.createDerSetFromList(this.origCRLs)));
        }
        return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), null));
    }
}

