/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.cert.crmf.jcajce;

import axion.org.bouncycastle.asn1.crmf.EncryptedValue;
import axion.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import axion.org.bouncycastle.cert.crmf.CRMFException;
import axion.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import axion.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import axion.org.bouncycastle.operator.KeyWrapper;
import axion.org.bouncycastle.operator.OutputEncryptor;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaEncryptedValueBuilder
extends EncryptedValueBuilder {
    public JcaEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(PrivateKey privateKey) throws CertificateEncodingException, CRMFException {
        return this.build(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

