/*
 * Decompiled with CFR 0.152.
 */
package axion.org.bouncycastle.bcpg.attr;

import axion.org.bouncycastle.bcpg.UserAttributeSubpacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ImageAttribute
extends UserAttributeSubpacket {
    public static final int JPEG = 1;
    private static final byte[] ZEROES = new byte[12];
    private int hdrLength;
    private int version;
    private int encoding;
    private byte[] imageData;

    public ImageAttribute(byte[] byArray) {
        this(false, byArray);
    }

    public ImageAttribute(boolean bl, byte[] byArray) {
        super(1, bl, byArray);
        this.hdrLength = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        this.version = byArray[2] & 0xFF;
        this.encoding = byArray[3] & 0xFF;
        this.imageData = new byte[byArray.length - this.hdrLength];
        System.arraycopy(byArray, this.hdrLength, this.imageData, 0, this.imageData.length);
    }

    public ImageAttribute(int n, byte[] byArray) {
        this(ImageAttribute.toByteArray(n, byArray));
    }

    private static byte[] toByteArray(int n, byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(16);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(1);
            byteArrayOutputStream.write(n);
            byteArrayOutputStream.write(ZEROES);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to encode to byte array!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int version() {
        return this.version;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public byte[] getImageData() {
        return this.imageData;
    }
}

