/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.common.extensions;

import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import axion.org.apache.sshd.sftp.common.extensions.AbstractParser;
import java.util.Collection;

public class Supported2Parser
extends AbstractParser<Supported2> {
    public static final Supported2Parser INSTANCE = new Supported2Parser();

    public Supported2Parser() {
        super("supported2");
    }

    @Override
    public Supported2 parse(byte[] input, int offset, int len) {
        return this.parse(new ByteArrayBuffer(input, offset, len));
    }

    public Supported2 parse(Buffer buffer) {
        Supported2 sup2 = new Supported2();
        sup2.supportedAttributeMask = buffer.getInt();
        sup2.supportedAttributeBits = buffer.getInt();
        sup2.supportedOpenFlags = buffer.getInt();
        sup2.supportedAccessMask = buffer.getInt();
        sup2.maxReadSize = buffer.getInt();
        sup2.supportedOpenBlockVector = buffer.getShort();
        sup2.supportedBlock = buffer.getShort();
        sup2.attribExtensionNames = buffer.getStringList(true);
        sup2.extensionNames = buffer.getStringList(true);
        return sup2;
    }

    public static class Supported2 {
        public int supportedAttributeMask;
        public int supportedAttributeBits;
        public int supportedOpenFlags;
        public int supportedAccessMask;
        public int maxReadSize;
        public short supportedOpenBlockVector;
        public short supportedBlock;
        public Collection<String> attribExtensionNames;
        public Collection<String> extensionNames;

        public String toString() {
            return "attrsMask=0x" + Integer.toHexString(this.supportedAttributeMask) + ",attrsBits=0x" + Integer.toHexString(this.supportedAttributeBits) + ",openFlags=0x" + Integer.toHexString(this.supportedOpenFlags) + ",accessMask=0x" + Integer.toHexString(this.supportedAccessMask) + ",maxRead=" + this.maxReadSize + ",openBlock=0x" + Integer.toHexString(this.supportedOpenBlockVector & 0xFFFF) + ",block=" + Integer.toHexString(this.supportedBlock & 0xFFFF) + ",attribs=" + this.attribExtensionNames + ",exts=" + this.extensionNames;
        }
    }
}

