/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.client.impl;

import axion.org.apache.sshd.client.ClientFactoryManager;
import axion.org.apache.sshd.client.SshClient;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import axion.org.apache.sshd.sftp.client.SftpClient;
import axion.org.apache.sshd.sftp.client.SftpClientFactory;
import axion.org.apache.sshd.sftp.client.SftpVersionSelector;
import axion.org.apache.sshd.sftp.client.fs.SftpFileSystem;
import axion.org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import axion.org.apache.sshd.sftp.client.impl.DefaultSftpClient;
import java.io.IOException;

public class DefaultSftpClientFactory
extends AbstractLoggingBean
implements SftpClientFactory {
    public static final DefaultSftpClientFactory INSTANCE = new DefaultSftpClientFactory();

    @Override
    public SftpClient createSftpClient(ClientSession session, SftpVersionSelector selector) throws IOException {
        DefaultSftpClient client = this.createDefaultSftpClient(session, selector);
        try {
            client.negotiateVersion(selector);
        }
        catch (IOException | Error | RuntimeException e) {
            this.debug("createSftpClient({}) failed ({}) to negotiate version: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
            client.close();
            throw e;
        }
        return client;
    }

    protected DefaultSftpClient createDefaultSftpClient(ClientSession session, SftpVersionSelector selector) throws IOException {
        return new DefaultSftpClient(session, selector);
    }

    @Override
    public SftpFileSystem createSftpFileSystem(ClientSession session, SftpVersionSelector selector, int readBufferSize, int writeBufferSize) throws IOException {
        ClientFactoryManager manager = session.getFactoryManager();
        SftpFileSystemProvider provider = new SftpFileSystemProvider((SshClient)manager, selector);
        SftpFileSystem fs = provider.newFileSystem(session);
        if (readBufferSize > 0) {
            fs.setReadBufferSize(readBufferSize);
        }
        if (writeBufferSize > 0) {
            fs.setWriteBufferSize(writeBufferSize);
        }
        return fs;
    }
}

