/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.sftp.client.fs;

import axion.org.apache.sshd.client.SshClient;
import axion.org.apache.sshd.client.future.ConnectFuture;
import axion.org.apache.sshd.client.session.ClientSession;
import axion.org.apache.sshd.common.auth.BasicCredentialsProvider;
import axion.org.apache.sshd.sftp.client.SftpVersionSelector;
import axion.org.apache.sshd.sftp.client.fs.SftpFileSystem;
import axion.org.apache.sshd.sftp.client.fs.SftpFileSystemInitializationContext;
import axion.org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import java.io.IOException;

public interface SftpFileSystemClientSessionInitializer {
    public static final SftpFileSystemClientSessionInitializer DEFAULT = new SftpFileSystemClientSessionInitializer(){

        public String toString() {
            return SftpFileSystemClientSessionInitializer.class.getSimpleName() + "[DEFAULT]";
        }
    };

    default public ClientSession createClientSession(SftpFileSystemProvider provider, SftpFileSystemInitializationContext context) throws IOException {
        BasicCredentialsProvider user = context.getCredentials();
        SshClient client = provider.getClientInstance();
        return (ClientSession)((ConnectFuture)client.connect(user.getUsername(), context.getHost(), context.getPort()).verify(context.getMaxConnectTime())).getSession();
    }

    default public void authenticateClientSession(SftpFileSystemProvider provider, SftpFileSystemInitializationContext context, ClientSession session) throws IOException {
        BasicCredentialsProvider passwordHolder = context.getCredentials();
        String password = passwordHolder.getPassword();
        if (password != null) {
            session.addPasswordIdentity(password);
        }
        session.auth().verify(context.getMaxAuthTime());
    }

    default public SftpFileSystem createSftpFileSystem(SftpFileSystemProvider provider, SftpFileSystemInitializationContext context, ClientSession session, SftpVersionSelector selector) throws IOException {
        return new SftpFileSystem(provider, context.getId(), session, provider.getSftpClientFactory(), selector);
    }
}

