/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.io.resource;

import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.io.resource.AbstractIoResource;
import axion.org.apache.sshd.common.util.threads.ThreadUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;

public class ClassLoaderResource
extends AbstractIoResource<ClassLoader> {
    private final String resourceName;

    public ClassLoaderResource(ClassLoader loader, String resourceName) {
        super(ClassLoader.class, loader == null ? ThreadUtils.resolveDefaultClassLoader(ClassLoaderResource.class) : loader);
        this.resourceName = ValidateUtils.checkNotNullAndNotEmpty(resourceName, "No resource name provided");
    }

    public ClassLoader getResourceLoader() {
        return (ClassLoader)this.getResourceValue();
    }

    @Override
    public String getName() {
        return this.resourceName;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        String name = this.getName();
        ClassLoader cl = this.getResourceLoader();
        if (cl == null) {
            throw new StreamCorruptedException("No resource loader for " + name);
        }
        InputStream input = cl.getResourceAsStream(name);
        if (input == null) {
            throw new FileNotFoundException("Cannot find resource " + name);
        }
        return input;
    }
}

