/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.io.der;

import axion.org.apache.sshd.common.util.GenericUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ASN1Class {
    UNIVERSAL(0),
    APPLICATION(1),
    CONTEXT(2),
    PRIVATE(3);

    public static final List<ASN1Class> VALUES;
    private final byte byteValue;

    private ASN1Class(byte classValue) {
        this.byteValue = classValue;
    }

    public byte getClassValue() {
        return this.byteValue;
    }

    public static ASN1Class fromName(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        for (ASN1Class c : VALUES) {
            if (!s.equalsIgnoreCase(c.name())) continue;
            return c;
        }
        return null;
    }

    public static ASN1Class fromDERValue(int value) {
        return ASN1Class.fromTypeValue(value >> 6 & 3);
    }

    public static ASN1Class fromTypeValue(int value) {
        if (value < 0 || value >= VALUES.size()) {
            return null;
        }
        return VALUES.get(value);
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(ASN1Class.values()));
    }
}

