/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.buffer.keys;

import axion.org.apache.sshd.common.cipher.ECCurves;
import axion.org.apache.sshd.common.u2f.SkEcdsaPublicKey;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import axion.org.apache.sshd.common.util.buffer.keys.ECBufferPublicKeyParser;
import java.security.GeneralSecurityException;
import java.security.interfaces.ECPublicKey;

public class SkECBufferPublicKeyParser
extends AbstractBufferPublicKeyParser<SkEcdsaPublicKey> {
    public static final SkECBufferPublicKeyParser INSTANCE = new SkECBufferPublicKeyParser();

    public SkECBufferPublicKeyParser() {
        super(SkEcdsaPublicKey.class, "sk-ecdsa-sha2-nistp256@openssh.com");
    }

    @Override
    public SkEcdsaPublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ECPublicKey ecPublicKey = ECBufferPublicKeyParser.INSTANCE.getRawPublicKey(ECCurves.nistp256.getKeyType(), buffer);
        String appName = buffer.getString();
        return new SkEcdsaPublicKey(appName, false, ecPublicKey);
    }
}

