/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.util.buffer.keys;

import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;

public class DSSBufferPublicKeyParser
extends AbstractBufferPublicKeyParser<DSAPublicKey> {
    public static final DSSBufferPublicKeyParser INSTANCE = new DSSBufferPublicKeyParser();

    public DSSBufferPublicKeyParser() {
        super(DSAPublicKey.class, "ssh-dss");
    }

    @Override
    public DSAPublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(keyType), "Unsupported key type: %s", (Object)keyType);
        BigInteger p = buffer.getMPInt();
        BigInteger q = buffer.getMPInt();
        BigInteger g = buffer.getMPInt();
        BigInteger y = buffer.getMPInt();
        return (DSAPublicKey)this.generatePublicKey("DSA", new DSAPublicKeySpec(y, p, q, g));
    }
}

