/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.signature;

import axion.org.apache.sshd.common.NamedFactory;
import axion.org.apache.sshd.common.signature.BuiltinSignatures;
import axion.org.apache.sshd.common.signature.Signature;
import axion.org.apache.sshd.common.signature.SignatureFactoriesHolder;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface SignatureFactoriesManager
extends SignatureFactoriesHolder {
    public void setSignatureFactories(List<NamedFactory<Signature>> var1);

    default public void setSignatureFactoriesNameList(String names) {
        this.setSignatureFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setSignatureFactoriesNames(String ... names) {
        this.setSignatureFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setSignatureFactoriesNames(Collection<String> names) {
        BuiltinSignatures.ParseResult result = BuiltinSignatures.parseSignatureList(names);
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported signature factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported signature factories found: %s", unsupported);
        this.setSignatureFactories(factories);
    }

    public static List<NamedFactory<Signature>> resolveSignatureFactories(SignatureFactoriesManager primary, SignatureFactoriesManager secondary) {
        List<NamedFactory<Signature>> factories = SignatureFactoriesManager.getSignatureFactories(primary);
        return GenericUtils.isEmpty(factories) ? SignatureFactoriesManager.getSignatureFactories(secondary) : factories;
    }

    public static List<NamedFactory<Signature>> getSignatureFactories(SignatureFactoriesManager manager) {
        return manager == null ? null : manager.getSignatureFactories();
    }
}

