/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.session.helpers;

import axion.org.apache.sshd.common.AttributeRepository;
import axion.org.apache.sshd.common.FactoryManager;
import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.PropertyResolver;
import axion.org.apache.sshd.common.RuntimeSshException;
import axion.org.apache.sshd.common.SshConstants;
import axion.org.apache.sshd.common.SshException;
import axion.org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import axion.org.apache.sshd.common.digest.Digest;
import axion.org.apache.sshd.common.forward.Forwarder;
import axion.org.apache.sshd.common.future.DefaultSshFuture;
import axion.org.apache.sshd.common.io.IoSession;
import axion.org.apache.sshd.common.io.IoWriteFuture;
import axion.org.apache.sshd.common.kex.AbstractKexFactoryManager;
import axion.org.apache.sshd.common.kex.KexProposalOption;
import axion.org.apache.sshd.common.random.Random;
import axion.org.apache.sshd.common.session.ConnectionService;
import axion.org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.session.SessionDisconnectHandler;
import axion.org.apache.sshd.common.session.SessionListener;
import axion.org.apache.sshd.common.session.UnknownChannelReferenceHandler;
import axion.org.apache.sshd.common.session.helpers.ReservedSessionMessagesHandlerAdapter;
import axion.org.apache.sshd.common.session.helpers.TimeoutIndicator;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.Invoker;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.BufferUtils;
import axion.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import axion.org.apache.sshd.common.util.closeable.AbstractCloseable;
import axion.org.apache.sshd.common.util.net.SshdSocketAddress;
import axion.org.apache.sshd.core.CoreModuleProperties;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public abstract class SessionHelper
extends AbstractKexFactoryManager
implements Session {
    protected final Object sessionLock = new Object();
    protected Instant authStart = Instant.now();
    protected Instant idleStart = Instant.now();
    private final boolean serverSession;
    private final IoSession ioSession;
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Map<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();
    private final AtomicReference<TimeoutIndicator> timeoutStatus = new AtomicReference<TimeoutIndicator>(TimeoutIndicator.NONE);
    private ReservedSessionMessagesHandler reservedSessionMessagesHandler;
    private SessionDisconnectHandler sessionDisconnectHandler;
    private UnknownChannelReferenceHandler unknownChannelReferenceHandler;
    private ChannelStreamWriterResolver channelStreamPacketWriterResolver;
    private volatile String username;
    private volatile boolean authed;

    protected SessionHelper(boolean serverSession, FactoryManager factoryManager, IoSession ioSession) {
        super(Objects.requireNonNull(factoryManager, "No factory manager provided"));
        this.serverSession = serverSession;
        this.ioSession = Objects.requireNonNull(ioSession, "No IoSession provided");
    }

    @Override
    public IoSession getIoSession() {
        return this.ioSession;
    }

    @Override
    public boolean isServerSession() {
        return this.serverSession;
    }

    @Override
    public FactoryManager getFactoryManager() {
        return (FactoryManager)this.getDelegate();
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.getFactoryManager();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.get(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    @Override
    public <T> T computeAttributeIfAbsent(AttributeRepository.AttributeKey<T> key, Function<? super AttributeRepository.AttributeKey<T>, ? extends T> resolver) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(key, "No key"), resolver);
    }

    @Override
    public <T> T setAttribute(AttributeRepository.AttributeKey<T> key, T value) {
        return (T)this.attributes.put(Objects.requireNonNull(key, "No key"), Objects.requireNonNull(value, "No value"));
    }

    @Override
    public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key) {
        return (T)this.attributes.remove(Objects.requireNonNull(key, "No key"));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authed;
    }

    @Override
    public void setAuthenticated() throws IOException {
        this.authed = true;
        this.signalSessionEvent(SessionListener.Event.Authenticated);
    }

    protected TimeoutIndicator checkForTimeouts() throws IOException {
        TimeoutIndicator.TimeoutStatus status;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!this.isOpen() || this.isClosing() || this.isClosed()) {
            if (debugEnabled) {
                this.log.debug("checkForTimeouts({}) session closing", (Object)this);
            }
            return TimeoutIndicator.NONE;
        }
        TimeoutIndicator result = this.timeoutStatus.get();
        TimeoutIndicator.TimeoutStatus timeoutStatus = status = result == null ? TimeoutIndicator.TimeoutStatus.NoTimeout : result.getStatus();
        if (status != null && status != TimeoutIndicator.TimeoutStatus.NoTimeout) {
            if (debugEnabled) {
                this.log.debug("checkForTimeouts({}) already detected {}", (Object)this, (Object)result);
            }
            return result;
        }
        Instant now = Instant.now();
        result = this.checkAuthenticationTimeout(now, this.getAuthTimeout());
        if (result == null) {
            result = this.checkIdleTimeout(now, this.getIdleTimeout());
        }
        TimeoutIndicator.TimeoutStatus timeoutStatus2 = status = result == null ? TimeoutIndicator.TimeoutStatus.NoTimeout : result.getStatus();
        if (status == null || TimeoutIndicator.TimeoutStatus.NoTimeout.equals((Object)status)) {
            return TimeoutIndicator.NONE;
        }
        boolean resetTimeout = false;
        try {
            SessionDisconnectHandler handler = this.getSessionDisconnectHandler();
            resetTimeout = handler != null && handler.handleTimeoutDisconnectReason(this, result);
        }
        catch (IOException | RuntimeException e) {
            this.warn("checkForTimeouts({}) failed ({}) to invoke disconnect handler to handle {}: {}", this, e.getClass().getSimpleName(), result, e.getMessage(), e);
        }
        if (resetTimeout) {
            if (debugEnabled) {
                this.log.debug("checkForTimeouts({}) cancel {} due to handler intervention", (Object)this, (Object)result);
            }
            switch (status) {
                case AuthTimeout: {
                    this.resetAuthTimeout();
                    break;
                }
                case IdleTimeout: {
                    this.resetIdleTimeout();
                    break;
                }
            }
            return TimeoutIndicator.NONE;
        }
        if (debugEnabled) {
            this.log.debug("checkForTimeouts({}) disconnect - reason={}", (Object)this, (Object)result);
        }
        this.timeoutStatus.set(result);
        this.disconnect(2, "Detected " + (Object)((Object)status) + " after " + result.getExpiredValue() + "/" + result.getThresholdValue() + " ms.");
        return result;
    }

    @Override
    public Instant getAuthTimeoutStart() {
        return this.authStart;
    }

    @Override
    public Instant resetAuthTimeout() {
        Instant value = this.getAuthTimeoutStart();
        this.authStart = Instant.now();
        return value;
    }

    protected TimeoutIndicator checkAuthenticationTimeout(Instant now, Duration authTimeout) {
        Duration d = Duration.between(this.authStart, now);
        if (!this.isAuthenticated() && GenericUtils.isPositive(authTimeout) && d.compareTo(authTimeout) > 0) {
            return new TimeoutIndicator(TimeoutIndicator.TimeoutStatus.AuthTimeout, authTimeout, d);
        }
        return null;
    }

    @Override
    public Instant getIdleTimeoutStart() {
        return this.idleStart;
    }

    protected TimeoutIndicator checkIdleTimeout(Instant now, Duration idleTimeout) {
        Duration d = Duration.between(this.idleStart, now);
        if (this.isAuthenticated() && GenericUtils.isPositive(idleTimeout) && d.compareTo(idleTimeout) > 0) {
            return new TimeoutIndicator(TimeoutIndicator.TimeoutStatus.IdleTimeout, idleTimeout, d);
        }
        return null;
    }

    @Override
    public Instant resetIdleTimeout() {
        Instant value = this.getIdleTimeoutStart();
        this.idleStart = Instant.now();
        return value;
    }

    @Override
    public TimeoutIndicator getTimeoutStatus() {
        return this.timeoutStatus.get();
    }

    @Override
    public ReservedSessionMessagesHandler getReservedSessionMessagesHandler() {
        return this.resolveEffectiveProvider(ReservedSessionMessagesHandler.class, this.reservedSessionMessagesHandler, this.getFactoryManager().getReservedSessionMessagesHandler());
    }

    @Override
    public void setReservedSessionMessagesHandler(ReservedSessionMessagesHandler handler) {
        this.reservedSessionMessagesHandler = handler;
    }

    @Override
    public SessionDisconnectHandler getSessionDisconnectHandler() {
        return this.resolveEffectiveProvider(SessionDisconnectHandler.class, this.sessionDisconnectHandler, this.getFactoryManager().getSessionDisconnectHandler());
    }

    @Override
    public void setSessionDisconnectHandler(SessionDisconnectHandler sessionDisconnectHandler) {
        this.sessionDisconnectHandler = sessionDisconnectHandler;
    }

    protected void handleIgnore(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(byte[].class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleIgnore({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        this.doInvokeIgnoreMessageHandler(buffer);
    }

    protected void doInvokeIgnoreMessageHandler(Buffer buffer) throws Exception {
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleIgnoreMessage(this, buffer);
    }

    protected IoWriteFuture sendNotImplemented(long seqNoValue) throws IOException {
        Buffer buffer = this.createBuffer((byte)3, 8);
        buffer.putInt(seqNoValue);
        return this.writePacket(buffer);
    }

    protected void handleUnimplemented(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(Integer.TYPE)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleUnimplemented({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        this.doInvokeUnimplementedMessageHandler(3, buffer);
    }

    protected boolean doInvokeUnimplementedMessageHandler(int cmd, Buffer buffer) throws Exception {
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        return handler.handleUnimplementedMessage(this, cmd, buffer);
    }

    @Override
    public IoWriteFuture sendDebugMessage(boolean display, Object msg, String lang) throws IOException {
        String text = Objects.toString(msg, "");
        lang = lang == null ? "" : lang;
        Buffer buffer = this.createBuffer((byte)4, text.length() + lang.length() + 32);
        buffer.putBoolean(display);
        buffer.putString(text);
        buffer.putString(lang);
        return this.writePacket(buffer);
    }

    protected void handleDebug(Buffer buffer) throws Exception {
        if (!buffer.isValidMessageStructure(Boolean.TYPE, String.class, String.class)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("handleDebug({}) ignore malformed message", (Object)this);
            }
            return;
        }
        this.resetIdleTimeout();
        this.doInvokeDebugMessageHandler(buffer);
    }

    protected void doInvokeDebugMessageHandler(Buffer buffer) throws Exception {
        ReservedSessionMessagesHandler handler = this.resolveReservedSessionMessagesHandler();
        handler.handleDebugMessage(this, buffer);
    }

    protected ReservedSessionMessagesHandler resolveReservedSessionMessagesHandler() {
        ReservedSessionMessagesHandler handler = this.getReservedSessionMessagesHandler();
        return handler == null ? ReservedSessionMessagesHandlerAdapter.DEFAULT : handler;
    }

    @Override
    public UnknownChannelReferenceHandler getUnknownChannelReferenceHandler() {
        return this.unknownChannelReferenceHandler;
    }

    @Override
    public void setUnknownChannelReferenceHandler(UnknownChannelReferenceHandler unknownChannelReferenceHandler) {
        this.unknownChannelReferenceHandler = unknownChannelReferenceHandler;
    }

    @Override
    public UnknownChannelReferenceHandler resolveUnknownChannelReferenceHandler() {
        UnknownChannelReferenceHandler handler = this.getUnknownChannelReferenceHandler();
        if (handler != null) {
            return handler;
        }
        FactoryManager mgr = this.getFactoryManager();
        return mgr == null ? null : mgr.resolveUnknownChannelReferenceHandler();
    }

    @Override
    public ChannelStreamWriterResolver getChannelStreamWriterResolver() {
        return this.channelStreamPacketWriterResolver;
    }

    @Override
    public void setChannelStreamWriterResolver(ChannelStreamWriterResolver resolver) {
        this.channelStreamPacketWriterResolver = resolver;
    }

    @Override
    public ChannelStreamWriterResolver resolveChannelStreamWriterResolver() {
        ChannelStreamWriterResolver resolver = this.getChannelStreamWriterResolver();
        if (resolver != null) {
            return resolver;
        }
        FactoryManager manager = this.getFactoryManager();
        return manager.resolveChannelStreamWriterResolver();
    }

    @Override
    public IoWriteFuture sendIgnoreMessage(byte ... data) throws IOException {
        data = data == null ? GenericUtils.EMPTY_BYTE_ARRAY : data;
        Buffer buffer = this.createBuffer((byte)2, data.length + 8);
        buffer.putBytes(data);
        return this.writePacket(buffer);
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        IoWriteFuture writeFuture = this.writePacket(buffer);
        DefaultSshFuture future = (DefaultSshFuture)((Object)writeFuture);
        FactoryManager factoryManager = this.getFactoryManager();
        ScheduledExecutorService executor = factoryManager.getScheduledExecutorService();
        ScheduledFuture<?> sched = executor.schedule(() -> {
            TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)t.getMessage());
            }
            future.setValue(t);
        }, timeout, unit);
        future.addListener(f -> sched.cancel(false));
        return writeFuture;
    }

    protected void signalSessionEstablished(IoSession ioSession) throws Exception {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionEstablished((SessionListener)l);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            this.debug("Failed ({}) to announce session={} established: {}", e.getClass().getSimpleName(), ioSession, e.getMessage(), e);
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void signalSessionEstablished(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionEstablished(this);
    }

    protected void signalSessionCreated(IoSession ioSession) throws Exception {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionCreated((SessionListener)l);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            this.debug("Failed ({}) to announce session={} created: {}", e.getClass().getSimpleName(), ioSession, e.getMessage(), e);
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void signalSessionCreated(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionCreated(this);
    }

    protected void signalPeerIdentificationReceived(String version, List<String> extraLines) throws Exception {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalPeerIdentificationReceived((SessionListener)l, version, extraLines);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            this.debug("signalPeerIdentificationReceived({}) Failed ({}) to announce peer={}: {}", this, e.getClass().getSimpleName(), version, e.getMessage(), e);
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    protected void signalPeerIdentificationReceived(SessionListener listener, String version, List<String> extraLines) {
        if (listener == null) {
            return;
        }
        listener.sessionPeerIdentificationReceived(this, version, extraLines);
    }

    protected void signalSessionEvent(SessionListener.Event event) throws IOException {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionEvent((SessionListener)l, event);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable t = GenericUtils.peelException(err);
            this.debug("sendSessionEvent({})[{}] failed ({}) to inform listeners: {}", this, (Object)event, t.getClass().getSimpleName(), t.getMessage(), t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to send session event: " + t.getMessage(), t);
        }
    }

    protected void signalSessionEvent(SessionListener listener, SessionListener.Event event) throws IOException {
        if (listener == null) {
            return;
        }
        listener.sessionEvent(this, event);
    }

    protected void invokeSessionSignaller(Invoker<SessionListener, Void> invoker) throws Throwable {
        FactoryManager manager = this.getFactoryManager();
        SessionListener[] listeners = new SessionListener[]{manager == null ? null : manager.getSessionListenerProxy(), this.getSessionListenerProxy()};
        Throwable err = null;
        for (SessionListener l : listeners) {
            if (l == null) continue;
            try {
                invoker.invoke(l);
            }
            catch (Throwable t) {
                err = GenericUtils.accumulateException(err, t);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    protected byte[] resizeKey(byte[] e, int kdfSize, Digest hash, byte[] k, byte[] h) throws Exception {
        Buffer buffer = null;
        while (kdfSize > e.length) {
            if (buffer == null) {
                buffer = new ByteArrayBuffer();
            }
            buffer.putMPInt(k);
            buffer.putRawBytes(h);
            buffer.putRawBytes(e);
            hash.update(buffer.array(), 0, buffer.available());
            byte[] foo = hash.digest();
            byte[] bar = new byte[e.length + foo.length];
            System.arraycopy(e, 0, bar, 0, e.length);
            System.arraycopy(foo, 0, bar, e.length, foo.length);
            e = bar;
            buffer = BufferUtils.clear(buffer);
        }
        return e;
    }

    protected SocketAddress resolvePeerAddress(SocketAddress knownAddress) {
        if (knownAddress != null) {
            return knownAddress;
        }
        IoSession s = this.getIoSession();
        return s == null ? null : s.getRemoteAddress();
    }

    protected long calculateNextIgnorePacketCount(Random r, long freq, int variance) {
        long count;
        if (freq <= 0L || variance < 0) {
            return -1L;
        }
        if (variance == 0) {
            return freq;
        }
        int extra = r.random(variance < 0 ? 0 - variance : variance);
        long l = count = variance < 0 ? freq - (long)extra : freq + (long)extra;
        if (this.log.isTraceEnabled()) {
            this.log.trace("calculateNextIgnorePacketCount({}) count={}", (Object)this, (Object)count);
        }
        return count;
    }

    protected String resolveIdentificationString(String configPropName) {
        FactoryManager manager = this.getFactoryManager();
        String ident = manager.getString(configPropName);
        return "SSH-2.0-" + (GenericUtils.isEmpty(ident) ? manager.getVersion() : ident);
    }

    protected IoWriteFuture sendIdentification(String ident) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendIdentification({}): {}", (Object)this, (Object)ident.replace('\r', '|').replace('\n', '|'));
        }
        IoSession networkSession = this.getIoSession();
        byte[] data = (ident + "\r\n").getBytes(StandardCharsets.UTF_8);
        return networkSession.writeBuffer(new ByteArrayBuffer(data));
    }

    protected List<String> doReadIdentification(Buffer buffer, boolean server) throws IOException {
        int maxIdentSize = CoreModuleProperties.MAX_IDENTIFICATION_SIZE.getRequired(this);
        ArrayList<String> ident = null;
        int rpos = buffer.rpos();
        boolean debugEnabled = this.log.isDebugEnabled();
        byte[] data = new byte[256];
        do {
            int pos = 0;
            boolean needLf = false;
            while (true) {
                if (buffer.available() == 0) {
                    buffer.rpos(rpos);
                    return null;
                }
                byte b = buffer.getByte();
                if (b == 0) {
                    throw new StreamCorruptedException("Incorrect identification (null characters not allowed) -  at line " + (GenericUtils.size(ident) + 1) + " character #" + (pos + 1) + " after '" + new String(data, 0, pos, StandardCharsets.UTF_8) + "'");
                }
                if (b == 13) {
                    needLf = true;
                    continue;
                }
                if (b == 10) break;
                if (needLf) {
                    throw new StreamCorruptedException("Incorrect identification (bad line ending)  at line " + (GenericUtils.size(ident) + 1) + ": " + new String(data, 0, pos, StandardCharsets.UTF_8));
                }
                if (pos >= data.length) {
                    throw new StreamCorruptedException("Incorrect identification (line too long):  at line " + (GenericUtils.size(ident) + 1) + ": " + new String(data, 0, pos, StandardCharsets.UTF_8));
                }
                data[pos++] = b;
            }
            String str = new String(data, 0, pos, StandardCharsets.UTF_8);
            if (debugEnabled) {
                this.log.debug("doReadIdentification({}) line='{}'", (Object)this, (Object)str);
            }
            if (ident == null) {
                ident = new ArrayList<String>();
            }
            ident.add(str);
            if (!server && !str.startsWith("SSH-")) continue;
            return ident;
        } while (buffer.rpos() <= maxIdentSize);
        throw new StreamCorruptedException("Incorrect identification (too many header lines): size > " + maxIdentSize);
    }

    protected String resolveSessionKexProposal(String hostKeyTypes) throws IOException {
        return NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getKeyExchangeFactories(), "No KEX factories", new Object[0]));
    }

    protected Map<KexProposalOption, String> createProposal(String hostKeyTypes) throws IOException {
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        String kexProposal = this.resolveSessionKexProposal(hostKeyTypes);
        proposal.put(KexProposalOption.ALGORITHMS, kexProposal);
        proposal.put(KexProposalOption.SERVERKEYS, hostKeyTypes);
        String ciphers = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCipherFactories(), "No cipher factories", new Object[0]));
        proposal.put(KexProposalOption.S2CENC, ciphers);
        proposal.put(KexProposalOption.C2SENC, ciphers);
        String macs = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getMacFactories(), "No MAC factories", new Object[0]));
        proposal.put(KexProposalOption.S2CMAC, macs);
        proposal.put(KexProposalOption.C2SMAC, macs);
        String compressions = NamedResource.getNames(ValidateUtils.checkNotNullAndNotEmpty(this.getCompressionFactories(), "No compression factories", new Object[0]));
        proposal.put(KexProposalOption.S2CCOMP, compressions);
        proposal.put(KexProposalOption.C2SCOMP, compressions);
        proposal.put(KexProposalOption.S2CLANG, "");
        proposal.put(KexProposalOption.C2SLANG, "");
        return proposal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> mergeProposals(Map<KexProposalOption, String> current, Map<KexProposalOption, String> proposal) {
        if (current == proposal) {
            return proposal;
        }
        Map<KexProposalOption, String> map = current;
        synchronized (map) {
            if (!current.isEmpty()) {
                current.clear();
            }
            if (GenericUtils.isEmpty(proposal)) {
                return proposal;
            }
            current.putAll(proposal);
        }
        return proposal;
    }

    protected void signalNegotiationStart(Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalNegotiationStart((SessionListener)l, c2sOptions, s2cOptions);
                return null;
            });
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof Error) {
                throw (Error)err;
            }
            throw new RuntimeException(err);
        }
    }

    protected void signalNegotiationStart(SessionListener listener, Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions) {
        if (listener == null) {
            return;
        }
        listener.sessionNegotiationStart(this, c2sOptions, s2cOptions);
    }

    protected void signalNegotiationEnd(Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions, Map<KexProposalOption, String> negotiatedGuess, Throwable reason) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalNegotiationEnd((SessionListener)l, c2sOptions, s2cOptions, negotiatedGuess, reason);
                return null;
            });
        }
        catch (Throwable err) {
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof Error) {
                throw (Error)err;
            }
            throw new RuntimeException(err);
        }
    }

    protected void signalNegotiationEnd(SessionListener listener, Map<KexProposalOption, String> c2sOptions, Map<KexProposalOption, String> s2cOptions, Map<KexProposalOption, String> negotiatedGuess, Throwable reason) {
        if (listener == null) {
            return;
        }
        listener.sessionNegotiationEnd(this, c2sOptions, s2cOptions, negotiatedGuess, null);
    }

    protected Buffer preProcessEncodeBuffer(int cmd, Buffer buffer) throws IOException {
        int curPos = buffer.rpos();
        if (curPos >= 5) {
            return buffer;
        }
        this.log.warn("preProcessEncodeBuffer({}) command={}[{}] performance cost: available buffer packet header length ({}) below min. required ({})", new Object[]{this, cmd, SshConstants.getCommandMessageName(cmd), curPos, 5});
        ByteArrayBuffer nb = new ByteArrayBuffer(buffer.available() + 64, false);
        ((Buffer)nb).wpos(5);
        nb.putBuffer(buffer);
        return nb;
    }

    @Override
    public void disconnect(int reason, String msg) throws IOException {
        this.log.info("Disconnecting({}): {} - {}", new Object[]{this, SshConstants.getDisconnectReasonName(reason), msg});
        String languageTag = "";
        this.signalDisconnect(reason, msg, languageTag, true);
        Buffer buffer = this.createBuffer((byte)1, msg.length() + 16);
        buffer.putInt(reason);
        buffer.putString(msg);
        buffer.putString("");
        Duration disconnectTimeout = CoreModuleProperties.DISCONNECT_TIMEOUT.getRequired(this);
        IoWriteFuture packetFuture = this.writePacket(buffer, disconnectTimeout);
        packetFuture.addListener(future -> {
            Throwable t = future.getException();
            boolean debugEnabled = this.log.isDebugEnabled();
            if (t == null) {
                if (debugEnabled) {
                    this.log.debug("disconnect({}) operation successfully completed for reason={} [{}]", new Object[]{this, SshConstants.getDisconnectReasonName(reason), msg});
                }
            } else if (debugEnabled) {
                this.debug("disconnect({}) operation failed ({}) for reason={} [{}]: {}", this, t.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(reason), msg, t.getMessage(), t);
            }
            this.close(true);
        });
    }

    protected void handleDisconnect(Buffer buffer) throws Exception {
        int code = buffer.getInt();
        String message = buffer.getString();
        String languageTag = buffer.available() > 0 ? buffer.getString() : "";
        this.handleDisconnect(code, message, languageTag, buffer);
    }

    protected void handleDisconnect(int code, String msg, String lang, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDisconnect({}) SSH_MSG_DISCONNECT reason={}, [lang={}] msg={}", new Object[]{this, SshConstants.getDisconnectReasonName(code), lang, msg});
        }
        this.signalDisconnect(code, msg, lang, false);
        this.close(true);
    }

    protected void signalDisconnect(int code, String msg, String lang, boolean initiator) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalDisconnect((SessionListener)l, code, msg, lang, initiator);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            this.debug("signalDisconnect({}) {}: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    protected void signalDisconnect(SessionListener listener, int code, String msg, String lang, boolean initiator) {
        if (listener == null) {
            return;
        }
        listener.sessionDisconnect(this, code, msg, lang, initiator);
    }

    @Override
    public void exceptionCaught(Throwable t) {
        int code;
        AbstractCloseable.State curState = (AbstractCloseable.State)((Object)this.state.get());
        if (!AbstractCloseable.State.Opened.equals((Object)curState) && !AbstractCloseable.State.Graceful.equals((Object)curState)) {
            this.debug("exceptionCaught({}) ignore {} due to state={}, message='{}'", this, t.getClass().getSimpleName(), (Object)curState, t.getMessage(), t);
            return;
        }
        this.warn("exceptionCaught({})[state={}] {}: {}", this, (Object)curState, t.getClass().getSimpleName(), t.getMessage(), t);
        this.signalExceptionCaught(t);
        if (AbstractCloseable.State.Opened.equals((Object)curState) && t instanceof SshException && (code = ((SshException)t).getDisconnectCode()) > 0) {
            try {
                this.disconnect(code, t.getMessage());
            }
            catch (Throwable t2) {
                this.debug("exceptionCaught({}) {} while disconnect with code={}: {}", this, t2.getClass().getSimpleName(), SshConstants.getDisconnectReasonName(code), t2.getMessage(), t2);
            }
            return;
        }
        this.close(true);
    }

    protected void signalExceptionCaught(Throwable t) {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalExceptionCaught((SessionListener)l, t);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            this.debug("signalExceptionCaught({}) {}: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    protected void signalExceptionCaught(SessionListener listener, Throwable t) {
        if (listener == null) {
            return;
        }
        listener.sessionException(this, t);
    }

    protected void signalSessionClosed() {
        try {
            this.invokeSessionSignaller(l -> {
                this.signalSessionClosed((SessionListener)l);
                return null;
            });
        }
        catch (Throwable err) {
            Throwable e = GenericUtils.peelException(err);
            this.debug("signalSessionClosed({}) {} while signal session closed: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    protected void signalSessionClosed(SessionListener listener) {
        if (listener == null) {
            return;
        }
        listener.sessionClosed(this);
    }

    protected abstract ConnectionService getConnectionService();

    protected Forwarder getForwarder() {
        ConnectionService service = this.getConnectionService();
        return service == null ? null : service.getForwarder();
    }

    @Override
    public List<Map.Entry<SshdSocketAddress, SshdSocketAddress>> getLocalForwardsBindings() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getLocalForwardsBindings();
    }

    @Override
    public boolean isLocalPortForwardingStartedForPort(int port) {
        Forwarder forwarder = this.getForwarder();
        return forwarder != null && forwarder.isLocalPortForwardingStartedForPort(port);
    }

    @Override
    public List<SshdSocketAddress> getStartedLocalPortForwards() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getStartedLocalPortForwards();
    }

    @Override
    public List<SshdSocketAddress> getBoundLocalPortForwards(int port) {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getBoundLocalPortForwards(port);
    }

    @Override
    public List<Map.Entry<Integer, SshdSocketAddress>> getRemoteForwardsBindings() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyList() : forwarder.getRemoteForwardsBindings();
    }

    @Override
    public boolean isRemotePortForwardingStartedForPort(int port) {
        Forwarder forwarder = this.getForwarder();
        return forwarder != null && forwarder.isRemotePortForwardingStartedForPort(port);
    }

    @Override
    public NavigableSet<Integer> getStartedRemotePortForwards() {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? Collections.emptyNavigableSet() : forwarder.getStartedRemotePortForwards();
    }

    @Override
    public SshdSocketAddress getBoundRemotePortForward(int port) {
        Forwarder forwarder = this.getForwarder();
        return forwarder == null ? null : forwarder.getBoundRemotePortForward(port);
    }

    @Override
    public Duration getAuthTimeout() {
        return CoreModuleProperties.AUTH_TIMEOUT.getRequired(this);
    }

    @Override
    public Duration getIdleTimeout() {
        return CoreModuleProperties.IDLE_TIMEOUT.getRequired(this);
    }

    public String toString() {
        IoSession networkSession = this.getIoSession();
        SocketAddress peerAddress = networkSession == null ? null : networkSession.getRemoteAddress();
        return this.getClass().getSimpleName() + "[" + this.getUsername() + "@" + peerAddress + "]";
    }
}

