/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.keyprovider;

import axion.org.apache.sshd.common.config.keys.OpenSshCertificate;
import axion.org.apache.sshd.common.config.keys.PublicKeyEntry;
import axion.org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FileHostKeyCertificateProvider
extends AbstractLoggingBean
implements HostKeyCertificateProvider {
    private final Collection<? extends Path> files;

    public FileHostKeyCertificateProvider(Path path) {
        this(path == null ? Collections.emptyList() : Collections.singletonList(path));
    }

    public FileHostKeyCertificateProvider(Path ... files) {
        this(GenericUtils.isEmpty(files) ? Collections.emptyList() : Arrays.asList(files));
    }

    public FileHostKeyCertificateProvider(Collection<? extends Path> files) {
        this.files = ValidateUtils.checkNotNullAndNotEmpty(files, "No paths provided", new Object[0]);
    }

    public Collection<? extends Path> getPaths() {
        return this.files;
    }

    @Override
    public Iterable<OpenSshCertificate> loadCertificates(SessionContext session) throws IOException, GeneralSecurityException {
        Collection<? extends Path> keyPaths = this.getPaths();
        ArrayList<OpenSshCertificate> certificates = new ArrayList<OpenSshCertificate>();
        boolean debugEnabled = this.log.isDebugEnabled();
        for (Path path : keyPaths) {
            if (debugEnabled) {
                this.log.debug("loadCertificates({}) loading file {}", (Object)session, (Object)path);
            }
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            for (String line : lines) {
                PublicKey publicKey;
                PublicKeyEntry publicKeyEntry;
                if (GenericUtils.isEmpty(line = GenericUtils.replaceWhitespaceAndTrim(line)) || line.charAt(0) == '#' || (publicKeyEntry = PublicKeyEntry.parsePublicKeyEntry(line)) == null || (publicKey = publicKeyEntry.resolvePublicKey(session, null, null)) == null) continue;
                if (!(publicKey instanceof OpenSshCertificate)) {
                    throw new InvalidKeyException("Got unexpected key type in " + path + ". Expected OpenSSHCertificate.");
                }
                certificates.add((OpenSshCertificate)publicKey);
            }
        }
        return certificates;
    }
}

