/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.kex;

import axion.org.apache.sshd.common.util.GenericUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum KexProposalOption {
    ALGORITHMS(0, "kex algorithms"),
    SERVERKEYS(1, "server host key algorithms"),
    C2SENC(2, "encryption algorithms (client to server)"),
    S2CENC(3, "encryption algorithms (server to client)"),
    C2SMAC(4, "mac algorithms (client to server)"),
    S2CMAC(5, "mac algorithms (server to client)"),
    C2SCOMP(6, "compression algorithms (client to server)"),
    S2CCOMP(7, "compression algorithms (server to client)"),
    C2SLANG(8, "languages (client to server)"),
    S2CLANG(9, "languages (server to client)");

    public static final Set<KexProposalOption> CIPHER_PROPOSALS;
    public static final Set<KexProposalOption> MAC_PROPOSALS;
    public static final Set<KexProposalOption> COMPRESSION_PROPOSALS;
    public static final Set<KexProposalOption> LANGUAGE_PROPOSALS;
    public static final Set<KexProposalOption> FIRST_KEX_PACKET_GUESS_MATCHES;
    public static final Comparator<KexProposalOption> BY_PROPOSAL_INDEX;
    public static final List<KexProposalOption> VALUES;
    public static final int PROPOSAL_MAX;
    private final int proposalIndex;
    private final String description;

    private KexProposalOption(int index, String desc) {
        this.proposalIndex = index;
        this.description = desc;
    }

    public final int getProposalIndex() {
        return this.proposalIndex;
    }

    public final String getDescription() {
        return this.description;
    }

    public static KexProposalOption fromName(String n) {
        if (GenericUtils.isEmpty(n)) {
            return null;
        }
        for (KexProposalOption o : VALUES) {
            if (!n.equalsIgnoreCase(o.name())) continue;
            return o;
        }
        return null;
    }

    public static KexProposalOption fromProposalIndex(int index) {
        if (index < 0 || index >= VALUES.size()) {
            return null;
        }
        return VALUES.get(index);
    }

    static {
        CIPHER_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SENC, S2CENC));
        MAC_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SMAC, S2CMAC));
        COMPRESSION_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SCOMP, S2CCOMP));
        LANGUAGE_PROPOSALS = Collections.unmodifiableSet(EnumSet.of(C2SLANG, S2CLANG));
        FIRST_KEX_PACKET_GUESS_MATCHES = Collections.unmodifiableSet(EnumSet.of(ALGORITHMS, SERVERKEYS));
        BY_PROPOSAL_INDEX = Comparator.comparingInt(KexProposalOption::getProposalIndex);
        VALUES = Collections.unmodifiableList(EnumSet.allOf(KexProposalOption.class).stream().sorted(BY_PROPOSAL_INDEX).collect(Collectors.toList()));
        PROPOSAL_MAX = VALUES.size();
    }

    public static final class Constants {
        public static final int PROPOSAL_KEX_ALGS = 0;
        public static final int PROPOSAL_SERVER_HOST_KEY_ALGS = 1;
        public static final int PROPOSAL_ENC_ALGS_CTOS = 2;
        public static final int PROPOSAL_ENC_ALGS_STOC = 3;
        public static final int PROPOSAL_MAC_ALGS_CTOS = 4;
        public static final int PROPOSAL_MAC_ALGS_STOC = 5;
        public static final int PROPOSAL_COMP_ALGS_CTOS = 6;
        public static final int PROPOSAL_COMP_ALGS_STOC = 7;
        public static final int PROPOSAL_LANG_CTOS = 8;
        public static final int PROPOSAL_LANG_STOC = 9;

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

