/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.common.config.keys.loader;

import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.config.keys.FilePasswordProvider;
import axion.org.apache.sshd.common.config.keys.loader.KeyPairResourceLoader;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.io.IoUtils;
import axion.org.apache.sshd.common.util.io.ModifiableFileWatcher;
import axion.org.apache.sshd.common.util.io.resource.PathResource;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class FileWatcherKeyPairResourceLoader
extends ModifiableFileWatcher
implements KeyPairResourceLoader {
    protected final AtomicReference<Collection<KeyPair>> keysHolder = new AtomicReference(Collections.emptyList());
    private KeyPairResourceLoader delegateLoader;

    public FileWatcherKeyPairResourceLoader(Path file, KeyPairResourceLoader delegateLoader) {
        this(file, delegateLoader, IoUtils.getLinkOptions(true));
    }

    public FileWatcherKeyPairResourceLoader(Path file, KeyPairResourceLoader delegateLoader, LinkOption ... options) {
        super(file, options);
        this.delegateLoader = Objects.requireNonNull(delegateLoader, "No delegate loader provided");
    }

    public KeyPairResourceLoader getKeyPairResourceLoader() {
        return this.delegateLoader;
    }

    public void setKeyPairResourceLoader(KeyPairResourceLoader loader) {
        this.delegateLoader = Objects.requireNonNull(loader, "No delegate loader provided");
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        Collection<KeyPair> ids = this.keysHolder.get();
        if (GenericUtils.isEmpty(ids) || this.checkReloadRequired()) {
            this.keysHolder.set(Collections.emptyList());
            if (!this.exists()) {
                return this.keysHolder.get();
            }
            Path path = this.getPath();
            ids = this.reloadKeyPairs(session, new PathResource(path), passwordProvider, lines);
            int numKeys = GenericUtils.size(ids);
            if (this.log.isDebugEnabled()) {
                this.log.debug("loadKeyPairs({})[{}] reloaded {} keys from {}", new Object[]{session, resourceKey, numKeys, path});
            }
            if (numKeys > 0) {
                this.keysHolder.set(ids);
                this.updateReloadAttributes();
            }
        }
        return ids;
    }

    protected Collection<KeyPair> reloadKeyPairs(SessionContext session, NamedResource resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        KeyPairResourceLoader loader = ValidateUtils.checkNotNull(this.getKeyPairResourceLoader(), "No resource loader for %s", (Object)resourceKey.getName());
        return loader.loadKeyPairs(session, resourceKey, passwordProvider, lines);
    }
}

