/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.global;

import axion.org.apache.sshd.common.channel.RequestHandler;
import axion.org.apache.sshd.common.global.AbstractOpenSshHostKeysHandler;
import axion.org.apache.sshd.common.session.Session;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import axion.org.apache.sshd.common.util.buffer.Buffer;
import axion.org.apache.sshd.common.util.buffer.keys.BufferPublicKeyParser;
import java.security.PublicKey;
import java.util.Collection;

public class OpenSshHostKeysHandler
extends AbstractOpenSshHostKeysHandler {
    public static final String REQUEST = "hostkeys-00@openssh.com";
    public static final OpenSshHostKeysHandler INSTANCE = new OpenSshHostKeysHandler();

    public OpenSshHostKeysHandler() {
        super(REQUEST);
    }

    public OpenSshHostKeysHandler(BufferPublicKeyParser<? extends PublicKey> parser) {
        super(REQUEST, parser);
    }

    @Override
    protected RequestHandler.Result handleHostKeys(Session session, Collection<? extends PublicKey> keys, boolean wantReply, Buffer buffer) throws Exception {
        ValidateUtils.checkTrue(!wantReply, "Unexpected reply required for the host keys of %s", (Object)session);
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleHostKeys({})[want-reply={}] received {} keys", new Object[]{session, wantReply, GenericUtils.size(keys)});
        }
        return RequestHandler.Result.Replied;
    }
}

