/*
 * Decompiled with CFR 0.152.
 */
package axion.org.apache.sshd.client.auth.pubkey;

import axion.org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import axion.org.apache.sshd.common.NamedFactory;
import axion.org.apache.sshd.common.NamedResource;
import axion.org.apache.sshd.common.config.keys.KeyUtils;
import axion.org.apache.sshd.common.session.SessionContext;
import axion.org.apache.sshd.common.signature.Signature;
import axion.org.apache.sshd.common.signature.SignatureFactoriesHolder;
import axion.org.apache.sshd.common.signature.SignatureFactoriesManager;
import axion.org.apache.sshd.common.signature.SignatureFactory;
import axion.org.apache.sshd.common.util.GenericUtils;
import axion.org.apache.sshd.common.util.ValidateUtils;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeyPairIdentity
implements PublicKeyIdentity,
SignatureFactoriesHolder {
    protected final KeyPair pair;
    private final List<NamedFactory<Signature>> signatureFactories;

    public KeyPairIdentity(SignatureFactoriesManager primary, SignatureFactoriesManager secondary, KeyPair pair) {
        this.signatureFactories = Collections.unmodifiableList(ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(primary, secondary), "No available signature factories", new Object[0]));
        this.pair = Objects.requireNonNull(pair, "No key pair");
    }

    @Override
    public PublicKey getPublicKey() {
        return this.pair.getPublic();
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.signatureFactories;
    }

    @Override
    public Map.Entry<String, byte[]> sign(SessionContext session, String algo, byte[] data) throws Exception {
        NamedFactory<Signature> factory;
        if (GenericUtils.isEmpty(algo)) {
            algo = KeyUtils.getKeyType(this.getPublicKey());
            factory = SignatureFactory.resolveSignatureFactory(algo, this.getSignatureFactories());
        } else {
            factory = NamedResource.findByName(algo, String.CASE_INSENSITIVE_ORDER, this.getSignatureFactories());
        }
        Signature verifier = factory == null ? null : (Signature)factory.create();
        ValidateUtils.checkNotNull(verifier, "No signer could be located for key type=%s", (Object)algo);
        verifier.initSigner(session, this.pair.getPrivate());
        verifier.update(session, data);
        byte[] signature = verifier.sign(session);
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(factory.getName(), signature);
    }

    public String toString() {
        PublicKey pubKey = this.getPublicKey();
        return this.getClass().getSimpleName() + " type=" + KeyUtils.getKeyType(pubKey) + ", factories=" + this.getSignatureFactoriesNameList() + ", fingerprint=" + KeyUtils.getFingerPrint(pubKey);
    }
}

